/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.facade.utils;

import com.bizvane.customized.facade.enums.ClearPointKeepYearEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class ClearPointConvertDateUtils {
    public Date convertDate(int type, String dateStr) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-");
            String nowFormarStr = dateFormat.format(new Date());
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
            Date date = dateFormat2.parse(nowFormarStr + dateStr);
            Calendar keepSearchCalendar = Calendar.getInstance();
            keepSearchCalendar.setTime(date);
            if (ClearPointKeepYearEnum.THE_YEAR_BEFORE_LAST.getCode().equals(type)) {
                keepSearchCalendar.add(1, -2);
            } else if (ClearPointKeepYearEnum.LAST_YEAR.getCode().equals(type)) {
                keepSearchCalendar.add(1, -1);
            } else if (ClearPointKeepYearEnum.THIS_YEAR.getCode().equals(type)) {
                // empty if block
            }
            Date keepSearchDate = keepSearchCalendar.getTime();
            return keepSearchDate;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Date newCreateTaskConvertDate(int type, String dateStr) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-");
            String nowFormarStr = dateFormat.format(new Date());
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
            Date date = dateFormat2.parse(nowFormarStr + dateStr);
            Calendar keepSearchCalendar = Calendar.getInstance();
            keepSearchCalendar.setTime(date);
            if (ClearPointKeepYearEnum.THE_YEAR_BEFORE_LAST.getCode().equals(type)) {
                keepSearchCalendar.add(1, -2);
            } else if (ClearPointKeepYearEnum.LAST_YEAR.getCode().equals(type)) {
                keepSearchCalendar.add(1, -1);
            } else if (ClearPointKeepYearEnum.THIS_YEAR.getCode().equals(type)) {
                // empty if block
            }
            keepSearchCalendar.add(1, 1);
            Date keepSearchDate = keepSearchCalendar.getTime();
            return keepSearchDate;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Date getStartDate(Date date) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = dateFormat2.format(date);
            return dateFormat.parse(dateStr + " 00:00:00");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Date getEndDate(Date date) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = dateFormat2.format(date);
            return dateFormat.parse(dateStr + " 23:59:59");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

