package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.po.CusUrMbrIntegralResetPO;
import com.bizvane.customized.facade.models.vo.CusUrMbrIntegralResetVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 积分清零计划feign
 */
@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/ur/integralResetRpc")
@Api(value = "积分清零计划feign", tags = {"积分清零计划feign"})
public interface IntegralResetServiceFeign {

	@ApiOperation(value = "积分清零计划查询", notes = "积分清零计划查询")
	@PostMapping("/selectByVo")
	ResponseData<List<CusUrMbrIntegralResetPO>> selectByVo(@RequestBody CusUrMbrIntegralResetVO vo);

}
