package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.vo.MemberCaseDetailVo;
import com.bizvane.customized.facade.models.vo.MemberCaseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.IOException;
import java.util.List;

@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/memberCase")
@Api(tags = {"哥弟病人病例接口"})
public interface CusMembersCaseServiceFeign {

    /**
     *  病人病例列表接口
     * @param phone
     * @return
     */
    @GetMapping("/queryCaseList")
    ResponseData<List<MemberCaseVo>> queryCaseList(@RequestParam String memberCode,@RequestParam Long brandId) throws IOException ;

    /**
     * 病人病例详情接口
     * @param id
     * @param phone
     * @return
     */
    @GetMapping("/queryCaseDetail")
    ResponseData<MemberCaseDetailVo> queryCaseDetail(@RequestParam String id, @RequestParam String phone) throws IOException ;
}
