package com.bizvane.customized.facade.utils;

import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.stereotype.Component;

import java.io.IOException;

@Slf4j
@Component
public class OkHttpUtils {

    public String getRequest(String url) throws IOException {
        log.info("请求信息url---->{}",url);
        OkHttpClient client = new OkHttpClient().newBuilder()
                .build();
        Request request = new Request.Builder()
                .url(url)
                .method("GET", null)
                .addHeader("Cookie", "PHPSESSID=d2a5a9a779916e0053ff3520c6763759")
                .build();
        Response response = client.newCall(request).execute();
        String result = null;
        if(response != null){
            if(response.body() != null){
                result = new String(response.body().bytes());
                response.body().close();
            }
            response.close();
        }
        log.info("result---->{}",result);
        return result;
    }
}
