package com.bizvane.customized.facade.enums;

/**
 * 会员冻结类型枚举
 */
public enum MbrFrozenEnum {


    /**
     * 冻结类型下拉框为10种；1全部2会员卡档案冻结3.单周累计积分4.单周消费次数5.单周单区域累计积分6.单周单区域消费次数7.单月累计积分8.单月消费次数9.单月单区域累计积分10单月单区域消费次数
     */

    ALL_IN(0,"全部"),
    MANUAL_FROZEN(1,"手工冻结"),
    MANUAL_THAW(10,"手工解冻"),


    /**
     *  2 - 9  由大数据计算
     */
    WEEK_INTEGRAL(2,"每周单店累计积分"),
    WEEK_CONSUME(3,"每周单店消费次数"),

    WEEK_AREA_INTEGRAL(4,"每周单区域累计积分"),
    WEEK_AREA_CONSUME(5,"每周单区域消费次数"),

    MONTH_INTEGRAL(6,"每月单店累计积分"),
    MONTH_CONSUME(7,"每月单店消费次数"),

    MONTH_AREA_INTEGRAL(8,"每月单区域累计积分"),
    MONTH_AREA_CONSUME(9,"每月单区域消费次数");




    private Integer code;
    private String msg;

    MbrFrozenEnum(Integer code,String msg){
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }


    public static MbrFrozenEnum getMsg(Integer code) {
        if (code == null) {
            return null;
        }
        for (MbrFrozenEnum type : MbrFrozenEnum.values()) {
            if (code.equals(type.getCode())) {
                return type;
            }
        }
        return null;
    }

    public static MbrFrozenEnum getMsg(String msg) {
        if (msg == null) {
            return null;
        }
        for (MbrFrozenEnum type : MbrFrozenEnum.values()) {
            if (msg.equals(type.getMsg())) {
                return type;
            }
        }
        return null;
    }
}
