package com.bizvane.customized.facade.models.vo.goldLion.biz;

import com.bizvane.couponfacade.models.bo.CouponDefinitionBO;
import com.bizvane.couponfacade.models.po.CouponAuthTmallDetailPO;
import com.bizvane.customized.facade.models.vo.CouponDefinitionVo;
import com.bizvane.customized.facade.models.vo.CouponDefinitionWithBLOBsVo;
import com.bizvane.customized.facade.models.vo.goldLion.base.CusGoldlionMemberActivityVo;
import com.bizvane.customized.facade.models.vo.goldLion.base.CusGoldlionMemberReceiveRecordVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.models.auth.In;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by zhouyuming on 2020-04-15.
 */
@ApiModel(value = "BizGoldLionMemberActivityVo",description = "金利来会员活动")
public class BizGoldLionMemberActivityVo extends CusGoldlionMemberActivityVo implements Serializable {
    private static final long serialVersionUID = -1585105010712455524L;

    @ApiModelProperty(value = "当前会员活动可享权益剩余总次数")
    private Integer memberRencentUsableAmount;

    @ApiModelProperty(value = "卡券信息")
    private CouponDefinitionWithBLOBsVo couponDefinitionVo;

    @ApiModelProperty(value = "活动状态1：待执行 2：启用中 3：已结束 4：已禁用")
    private Integer bizActivityStatus;

    public Integer getBizActivityStatus() {
        return bizActivityStatus;
    }

    public void setBizActivityStatus(Integer bizActivityStatus) {
        this.bizActivityStatus = bizActivityStatus;
    }

    public CouponDefinitionWithBLOBsVo getCouponDefinitionVo() {
        return couponDefinitionVo;
    }

    public void setCouponDefinitionVo(CouponDefinitionWithBLOBsVo couponDefinitionVo) {
        this.couponDefinitionVo = couponDefinitionVo;
    }

    public Integer getMemberRencentUsableAmount() {
        return memberRencentUsableAmount;
    }

    public void setMemberRencentUsableAmount(Integer memberRencentUsableAmount) {
        this.memberRencentUsableAmount = memberRencentUsableAmount;
    }
}
