package com.bizvane.customized.facade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Data
public class ChangePasswordRequestVo {

    @ApiModelProperty(name = "memberCode", value = "会员code", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String memberCode;

    @ApiModelProperty(name = "旧密码", value = "123456", example = "123456", dataType = "String", required = true)
    @NotNull
    @Pattern(regexp = "\\d{6}")
    private String oldPassword;

    @ApiModelProperty(name = "新密码", value = "123456", example = "123456", dataType = "String", required = true)
    @NotNull
    @Pattern(regexp = "\\d{6}")
    private String newPassword;

    @ApiModelProperty(name = "确认新密码", value = "123456", example = "123456", dataType = "String", required = true)
    @NotNull
    @Pattern(regexp = "\\d{6}")
    private String confirmNewPassword;

}
