package com.bizvane.customized.facade.models.vo;

import com.bizvane.customized.facade.models.po.CusUrRechargeCardStylePO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author kitandrew
 * @version 1.0.0
 * @ClassName CusUrTransferPageVo.java
 * @Description 发起转增页面数据
 * @createTime 2020年03月18日 10:02:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CusUrTransferPageVo {

    @ApiModelProperty(value = "cardStyleList", name = "卡面")
    private List<CusUrRechargeCardStylePO> cardStyleList;

    @ApiModelProperty(value = "money", name = "当前会员储值卡余额")
    private BigDecimal money;

    @ApiModelProperty(value = "giveMessage", name = "赠送留言")
    private String giveMessage;

    @ApiModelProperty(value = "giveDescription", name = "赠送说明")
    private String giveDescription;

    @ApiModelProperty(value = "shareDescription",name = "小程序分享说明")
    private String shareDescription;

    @ApiModelProperty(value = "sharePic",name = "小程序分享图")
    private String sharePic;

}
