package com.bizvane.customized.facade.enums;

public enum MbrFrozenThawEnum {

    /**
     * 冻结/解冻
     */
    ALL_IN(0,"全部"),
    FROZEN(1,"冻结"),
    THAW(2,"解冻");


    private Integer code;
    private String msg;

    MbrFrozenThawEnum(Integer code,String msg){
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static MbrFrozenEnum getMsg(Integer code) {
        if (code == null) {
            return null;
        }
        for (MbrFrozenEnum type : MbrFrozenEnum.values()) {
            if (code.equals(type.getCode())) {
                return type;
            }
        }
        return null;
    }
}
