package com.bizvane.customized.facade.models.vo.goldLion.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "CusGoldlionMemberReceiveRecordVo",description = "会员活动权益领取记录")
public class CusGoldlionMemberReceiveRecordVo implements Serializable {
    private static final long serialVersionUID = -682415841116162914L;

    @ApiModelProperty(value = "主键id")
    private Long cusGoldlionMemberReceiveRecordId;

    @ApiModelProperty(value = "活动id")
    private Long cusGoldlionMemberActivityId;

    @ApiModelProperty(value = "活动编号")
    private String activityNo;

    @ApiModelProperty(value = "会员code")
    private String memberCode;

    @ApiModelProperty(value = "会员手机号")
    private String mobile;

    @ApiModelProperty(value = "会员当前可享权益次数")
    private Integer memberRencentUsableAmount;

    @ApiModelProperty(value = "活动当前可享权益次数")
    private Integer activityRencentUsableAmount;

    @ApiModelProperty(value = "卡券id")
    private Long couponId;

    @ApiModelProperty(value = "卡券名称")
    private String couponName;

    @ApiModelProperty(value = "创建人id")
    private Long createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "修改人id")
    private Long modifiedUserId;

    @ApiModelProperty(value = "修改人")
    private String modifiedUserName;

    @ApiModelProperty(value = "修改时间")
    private LocalDateTime modifiedDate;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "数据有效性（1有效，0无效）")
    private Boolean valid;

    public Long getCusGoldlionMemberReceiveRecordId() {
        return cusGoldlionMemberReceiveRecordId;
    }

    public void setCusGoldlionMemberReceiveRecordId(Long cusGoldlionMemberReceiveRecordId) {
        this.cusGoldlionMemberReceiveRecordId = cusGoldlionMemberReceiveRecordId;
    }

    public Long getCusGoldlionMemberActivityId() {
        return cusGoldlionMemberActivityId;
    }

    public void setCusGoldlionMemberActivityId(Long cusGoldlionMemberActivityId) {
        this.cusGoldlionMemberActivityId = cusGoldlionMemberActivityId;
    }

    public String getActivityNo() {
        return activityNo;
    }

    public void setActivityNo(String activityNo) {
        this.activityNo = activityNo;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public Integer getMemberRencentUsableAmount() {
        return memberRencentUsableAmount;
    }

    public void setMemberRencentUsableAmount(Integer memberRencentUsableAmount) {
        this.memberRencentUsableAmount = memberRencentUsableAmount;
    }

    public Integer getActivityRencentUsableAmount() {
        return activityRencentUsableAmount;
    }

    public void setActivityRencentUsableAmount(Integer activityRencentUsableAmount) {
        this.activityRencentUsableAmount = activityRencentUsableAmount;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public LocalDateTime getCreateDate() {
        return createDate;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }

    public Long getModifiedUserId() {
        return modifiedUserId;
    }

    public void setModifiedUserId(Long modifiedUserId) {
        this.modifiedUserId = modifiedUserId;
    }

    public String getModifiedUserName() {
        return modifiedUserName;
    }

    public void setModifiedUserName(String modifiedUserName) {
        this.modifiedUserName = modifiedUserName;
    }

    public LocalDateTime getModifiedDate() {
        return modifiedDate;
    }

    public void setModifiedDate(LocalDateTime modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Boolean getValid() {
        return valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }
}