package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.po.CusYwQuickRechargePO;
import com.bizvane.customized.facade.models.po.CusYwRechargeCardStylePO;
import com.bizvane.customized.facade.models.vo.yiwen.RechargeCardYwQueryVo;
import com.bizvane.customized.facade.models.vo.yiwen.RechargeCardYwResponseVo;
import com.bizvane.customized.facade.models.vo.yiwen.YwRechargeQueryVo;
import com.bizvane.customized.facade.models.vo.yiwen.YwRechargeRecordVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author xz
 * @date 2020/4/15 17:38
 **/
@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/yw/rechargeCardRpc")
public interface CusYwRechargeServiceFeign {

    /**
     * 给定品牌id和充值金额以及卡类型判断是否在自定义金额范围之内,以及是否在赠送设置的区间之内,如果符合自定义限制并且落在某个区间则返回需要赠送的金额
     * @param ywRechargeQueryVo
     * @return
     */
    @PostMapping(value = "/judgeAndGetGiveAmount")
     ResponseData<Double> judgeAndGetGiveAmount(@RequestBody YwRechargeQueryVo ywRechargeQueryVo);

    /**
     * 根据品牌id和卡类型获取快捷支付列表
     */
    @PostMapping(value = "/getMbrQuickRechargeList")
    ResponseData<List<CusYwQuickRechargePO>> getMbrQuickRechargeList(@RequestBody YwRechargeQueryVo ywRechargeQueryVo);

    /**
     * 根据手机号和卡类型返回卡集合(分页)
     * @param rechargeCardYwQueryVo
     * @return
     */
    @PostMapping(value = "/getCardList")
    ResponseData<PageInfo<RechargeCardYwResponseVo>> getCardList(RechargeCardYwQueryVo rechargeCardYwQueryVo);

    /**
     * 根据手机号和卡号查询具体的储值卡信息
     * @param rechargeCardYwQueryVo
     * @return
     */
    @PostMapping(value = "/getCardInfo")
    ResponseData<RechargeCardYwResponseVo> getCardInfo(RechargeCardYwQueryVo rechargeCardYwQueryVo);

    /**
     * 微信充值成功之后将消息写到mq
     */
    @RequestMapping(value = "/sendMq", method = RequestMethod.POST)
    ResponseData<String> sendMq(YwRechargeRecordVo vo);

    /**
     * 查询会员充值样式
     * @param po
     * @return
     *
     * */
    @RequestMapping(value = "/getMbrRechargeStyle", method = RequestMethod.POST)
    ResponseData<List<CusYwRechargeCardStylePO>> getMbrRechargeStyle(CusYwRechargeCardStylePO po);
}
