package com.bizvane.customized.facade.models.vo.goldLion.biz;

import com.bizvane.customized.facade.models.vo.goldLion.base.CusGoldlionMemberActivityVo;
import com.bizvane.customized.facade.models.vo.goldLion.base.CusGoldlionMemberReceiveRecordVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.models.auth.In;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by zhouyuming on 2020-04-15.
 */
@ApiModel(value = "BizGoldLionMemberActivityVo",description = "金利来会员活动")
public class BizGoldLionMemberActivityVo extends CusGoldlionMemberActivityVo implements Serializable {
    private static final long serialVersionUID = -1585105010712455524L;

    @ApiModelProperty(value = "当前会员活动可享权益剩余总次数")
    private Integer memberRencentUsableAmount;

    @ApiModelProperty(value = "优惠类型（1现金，2折扣，3兑换）")
    private Integer preferentialType;

    @ApiModelProperty(value = "券的面额")
    private BigDecimal money;

    @ApiModelProperty(value = "券的折扣")
    private BigDecimal discount;

    @ApiModelProperty(value = "有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天")
    private Integer validType;

    @ApiModelProperty(value = "渠道限制 :1仅线下，2全渠道，3仅线上，4员工券，5天猫券")
    private Integer useChannel;

    @ApiModelProperty(value = "优惠类型描述")
    private String preferentialTypeDesc;

    @ApiModelProperty(value = "有效期类型描述")
    private String validTypeDesc;

    @ApiModelProperty(value = "渠道限制描述")
    private String useChannelDesc;



    public Integer getMemberRencentUsableAmount() {
        return memberRencentUsableAmount;
    }

    public void setMemberRencentUsableAmount(Integer memberRencentUsableAmount) {
        this.memberRencentUsableAmount = memberRencentUsableAmount;
    }

    public Integer getPreferentialType() {
        return preferentialType;
    }

    public void setPreferentialType(Integer preferentialType) {
        this.preferentialType = preferentialType;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public Integer getValidType() {
        return validType;
    }

    public void setValidType(Integer validType) {
        this.validType = validType;
    }

    public Integer getUseChannel() {
        return useChannel;
    }

    public void setUseChannel(Integer useChannel) {
        this.useChannel = useChannel;
    }

    public String getPreferentialTypeDesc() {
        return preferentialTypeDesc;
    }

    public void setPreferentialTypeDesc(String preferentialTypeDesc) {
        this.preferentialTypeDesc = preferentialTypeDesc;
    }

    public String getValidTypeDesc() {
        return validTypeDesc;
    }

    public void setValidTypeDesc(String validTypeDesc) {
        this.validTypeDesc = validTypeDesc;
    }

    public String getUseChannelDesc() {
        return useChannelDesc;
    }

    public void setUseChannelDesc(String useChannelDesc) {
        this.useChannelDesc = useChannelDesc;
    }
}
