package com.bizvane.customized.facade.models.vo.goldLion.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

@ApiModel(value = "CusGoldlionMemberActivityVo", description = "金利来会员活动表")
public class CusGoldlionMemberActivityVo implements Serializable {
    private static final long serialVersionUID = -758276238241718180L;

    @ApiModelProperty(value = "主键id")
    private Long cusGoldlionMemberActivityId;

    @NotNull(message = "活动名称不能为空")
    @ApiModelProperty(value = "活动名称")
    private String activityName;

    @NotNull(message = "活动编号不能为空")
    @ApiModelProperty(value = "活动编号")
    private String activityNo;

    @NotNull(message = "活动开始时间不能为空")
    @ApiModelProperty(value = "活动开始时间")
    private LocalDateTime beginDate;

    @NotNull(message = "活动结束时间不能为空")
    @ApiModelProperty(value = "活动结束时间")
    private LocalDateTime endDate;

    @NotNull(message = "每人可享权益次数不能为空")
    @Min(value = 1,message = "每人可享权益次数不能为0")
    @ApiModelProperty(value = "每人可享权益次数")
    private Integer maxAcquirableEquityAmount;

    @NotNull(message = "可享权益总次数不能为空")
    @ApiModelProperty(value = "可享权益总次数")
    @Min(value = 1,message = "可享权益总次数不能小于0")
    private Integer totalAcquirableEquityAmount;

    @ApiModelProperty(value = "已领取次数")
    private Integer alreadyReceivedAmount;

    @NotNull(message = "活动说明不能为空")
    @ApiModelProperty(value = "活动说明")
    private String activityDescription;

    @ApiModelProperty(value = "活动状态0:关闭 1:打开")
    private Integer activityStatus;

    @NotNull(message = "卡券id不能为空")
    @ApiModelProperty(value = "卡券id")
    private Long couponId;

    @NotNull(message = "卡券名称不能为空")
    @ApiModelProperty(value = "卡券名称")
    private String couponName;

    @ApiModelProperty(value = "创建人id")
    private Long createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "修改人id")
    private Long modifiedUserId;

    @ApiModelProperty(value = "修改人")
    private String modifiedUserName;

    @ApiModelProperty(value = "修改时间")
    private LocalDateTime modifiedDate;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "数据有效性（1有效，0无效）")
    private Boolean valid;


    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public Long getCusGoldlionMemberActivityId() {
        return cusGoldlionMemberActivityId;
    }


    public void setCusGoldlionMemberActivityId(Long cusGoldlionMemberActivityId) {
        this.cusGoldlionMemberActivityId = cusGoldlionMemberActivityId;
    }


    public String getActivityName() {
        return activityName;
    }


    public void setActivityName(String activityName) {
        this.activityName = activityName == null ? null : activityName.trim();
    }


    public String getActivityNo() {
        return activityNo;
    }


    public void setActivityNo(String activityNo) {
        this.activityNo = activityNo == null ? null : activityNo.trim();
    }


    public LocalDateTime getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(LocalDateTime beginDate) {
        this.beginDate = beginDate;
    }

    public LocalDateTime getEndDate() {
        return endDate;
    }

    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public Integer getMaxAcquirableEquityAmount() {
        return maxAcquirableEquityAmount;
    }


    public void setMaxAcquirableEquityAmount(Integer maxAcquirableEquityAmount) {
        this.maxAcquirableEquityAmount = maxAcquirableEquityAmount;
    }

    public Integer getTotalAcquirableEquityAmount() {
        return totalAcquirableEquityAmount;
    }


    public void setTotalAcquirableEquityAmount(Integer totalAcquirableEquityAmount) {
        this.totalAcquirableEquityAmount = totalAcquirableEquityAmount;
    }


    public Integer getAlreadyReceivedAmount() {
        return alreadyReceivedAmount;
    }


    public void setAlreadyReceivedAmount(Integer alreadyReceivedAmount) {
        this.alreadyReceivedAmount = alreadyReceivedAmount;
    }


    public String getActivityDescription() {
        return activityDescription;
    }


    public void setActivityDescription(String activityDescription) {
        this.activityDescription = activityDescription == null ? null : activityDescription.trim();
    }


    public Long getCouponId() {
        return couponId;
    }


    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }


    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName == null ? null : couponName.trim();
    }


    public Long getCreateUserId() {
        return createUserId;
    }


    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }


    public String getCreateUserName() {
        return createUserName;
    }


    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }


    public LocalDateTime getCreateDate() {
        return createDate;
    }


    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }


    public Long getModifiedUserId() {
        return modifiedUserId;
    }

    public void setModifiedUserId(Long modifiedUserId) {
        this.modifiedUserId = modifiedUserId;
    }


    public String getModifiedUserName() {
        return modifiedUserName;
    }


    public void setModifiedUserName(String modifiedUserName) {
        this.modifiedUserName = modifiedUserName == null ? null : modifiedUserName.trim();
    }


    public LocalDateTime getModifiedDate() {
        return modifiedDate;
    }


    public void setModifiedDate(LocalDateTime modifiedDate) {
        this.modifiedDate = modifiedDate;
    }


    public String getRemark() {
        return remark;
    }


    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }


    public Boolean getValid() {
        return valid;
    }


    public void setValid(Boolean valid) {
        this.valid = valid;
    }
}