package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.vo.goldLion.base.CusGoldlionMemberActivityVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.BizGoldLionMemberActivityVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.GoldLionMemberActivityReqVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.MemberActivityListReqVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.MemberActivityListResVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.TakeEquityReqVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Created by zhouyuming on 2020-04-15.
 */
@Api(tags = {"goldlionMeberActivity"}, description = "")
@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/feign/goldlionMemberActivit")
public interface CusGoldLionMemberActivityFeign {

    /**
     * 权益活动领取
     * @param takeEquityReqVo
     * 调用方：applet
     * @return
     */
    @PostMapping(value = "takeEquity")
    public ResponseData takeEquity(@RequestBody TakeEquityReqVo takeEquityReqVo);

    /**
     * 权益活动列表
     * @param memberActivityListReqVo
     * 调用方：applet
     * @return
     */
    @PostMapping(value = "memberActivityList")
    public ResponseData<List<MemberActivityListResVo>> memberActivityList(@RequestBody MemberActivityListReqVo memberActivityListReqVo);

    /**
     * 活动详情查看
     * @param cusGoldlionMemberActivityId
     * 调用方：applet
     * @return
     */
    @GetMapping(value = "getById")
    public ResponseData<BizGoldLionMemberActivityVo> getById(@RequestParam Long cusGoldlionMemberActivityId);
}
