package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.po.CusYwQuickRechargePO;
import com.bizvane.customized.facade.models.vo.yiwen.YwRechargeQueryVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author xz
 * @date 2020/4/15 17:38
 **/
@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/yw/rechargeCardRpc")
public interface CusYwRechargeServiceFeign {

    /**
     * 给定品牌id和充值金额以及卡类型判断是否在自定义金额范围之内,以及是否在赠送设置的区间之内,如果符合自定义限制并且落在某个区间则返回需要赠送的金额
     * @param ywRechargeQueryVo
     * @return
     */
    @PostMapping(value = "/judgeAndGetGiveAmount")
     ResponseData<Double> judgeAndGetGiveAmount(@RequestBody YwRechargeQueryVo ywRechargeQueryVo);

    /**
     * 根据品牌id和卡类型获取快捷支付列表
     */
    @PostMapping(value = "/getMbrQuickRechargeList")
    ResponseData<List<CusYwQuickRechargePO>> getMbrQuickRechargeList(@RequestBody YwRechargeQueryVo ywRechargeQueryVo);

}
