package com.bizvane.customized.facade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;

/**
 * @author kitandrew
 * @version 1.0.0
 * @ClassName CusUrTransferVo.java
 * @Description ur转增接口vo
 * @createTime 2020年03月16日 17:11:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CusUrTransferVo {

    @ApiModelProperty(value = "memberCode" , name = "会员code")
    @NonNull
    private String memberCode;

    @ApiModelProperty(value = "sysCompanyId" , name = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "sysBrandId" , name = "品牌id")
    private Long sysBrandId;

    @ApiModelProperty(value = "givecardStylecode" , name = "转增卡面code")
    @NonNull
    private String givecardStylecode;

    @ApiModelProperty(value = "name" , name = "转赠人姓名")
    @NonNull
    private String transferName;

    @ApiModelProperty(value = "transferDate" , name = "转增日期")
    @NonNull
    private String transferDate;

    @ApiModelProperty(value = "transferMessage" , name = "转增留言")
    @NonNull
    private String transferMessage;

    @ApiModelProperty(value = "transferMoney", name = "转增金额")
    @NonNull
    private BigDecimal transferMoney;


}
