package com.bizvane.customized.facade.models.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Lijc
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class CusUrRechargeCardVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 当前页数
     */
    private Integer pageNumber = 1;

    /**
     * 页面大小
     */
    private Integer pageSize = 10;

    private Long sysCompanyId;

    private Long sysBrandId;

    /**
     * 会员姓名
     */
    private String name;

    /**
     * 储蓄卡号
     */
    private String cardNo;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 账户余额
     */
    private String accountBalance;

    /**
     * 退款金额
     */
    private BigDecimal refundAccount;

    /**
     * 赠送金额
     */
    private BigDecimal giveAmount;

    /**
     * 会员CODE
     */
    private String memberCode;

    /**
     * 卡状态 0不可用 1可用
     */
    private Integer cardStatus;

    private List<String> memberCodeList;

    private Integer cardFreeze;
}
