package com.bizvane.customized.facade.interfaces;

import com.bizvane.connectorservice.entity.common.RechargeRecordRequestVO;
import com.bizvane.customized.facade.models.po.CusUrRechargeCardPO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeConfigVO;
import com.bizvane.customized.facade.models.vo.UrRechargeCardVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${feign.client.customized.name}",path="${feign.client.customized.path}/ur/rechargeCard")
@Api(value = "储蓄卡相关接口",tags = {"储蓄卡"})
public interface RechargeCardServiceFeign {

    @PostMapping(value = "/addDebitCardRechargeRecord")
    ResponseData addDebitCardRechargeRecord(@RequestBody UrRechargeCardVo vo);


    @PostMapping(value = "/queryDebitCardInfo")
    ResponseData queryDebitCardInfo(@RequestBody CusUrRechargeCardPO po);

    @PostMapping(value = "/addDebitCardRechargeCallBack")
    ResponseData addDebitCardRechargeCallBack(@RequestBody RechargeRecordRequestVO po);

    @PostMapping("/getRechargeConfig")
    ResponseData<CusUrRechargeConfigVO> getRechargeConfig(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId);

}
