package com.bizvane.customized.facade.interfaces;


import com.bizvane.customized.facade.models.po.CusUrMbrEvaluationConfigPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePO;
import com.bizvane.customized.facade.models.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/ur/mbr/evaluationQuestionnaireRpc")
@Api(tags = {"调查问卷RPC接口"}, description = "与线下交互接口")
public interface EvaluationQuestionnaireServiceFeign {

    /**
     * 问卷配置查询
     * @param vo
     * @return
     */
    @RequestMapping(value = "/queryEvalConfig", method = RequestMethod.POST)
    ResponseData<PageInfo<CusUrMbrEvaluationConfigPO>> queryEvalConfig(@RequestBody @Valid CusUrMbrEvalConfigVO vo);

    /**
     * 问卷模板查询
     * @param vo
     * @return
     */
    @RequestMapping(value = "/queryQuestionTemplate", method = RequestMethod.POST)
    ResponseData<CusUrMbrQuestionnaireTemplatePO> queryQuestionTemplate(@RequestBody @Valid CusUrMbrQuestionnaireTemplateVO vo);

    /**
     * 问卷回答详情查询
     * @param vo
     * @return
     */
    @RequestMapping(value = "/queryAnswerOrderDetail", method = RequestMethod.POST)
    ResponseData<CusUrMbrQuestionnaireOrderPO> queryAnswerOrderDetail(@RequestBody @Valid EvaluationOrderRequestVO vo);

    /**
     * 保存订单问卷
     * @param vo
     * @return
     */
    @RequestMapping(value = "/saveQuestionnaireOrder", method = RequestMethod.POST)
    ResponseData<String> saveQuestionnaireOrder(@RequestBody @Valid EvaluationSaveTempRequestVO vo);


}
