package com.bizvane.customized.facade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class QueryRecordListRequestVo {

    @ApiModelProperty(name = "memberCode", value = "会员code", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String memberCode;

    @ApiModelProperty(name = "mbrCardNo", value = "会员储值卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String mbrCardNo;

    @ApiModelProperty(name = "类型 1：全部 2：消费 3：转出", value = "123456", example = "123456", dataType = "String", required = true)
    @NotNull
    private Integer type;

    @ApiModelProperty(name = "品牌id", value = "123456", example = "123456", dataType = "String", required = true)
    @NotNull
    private Long brandId;

    @ApiModelProperty(name = "公司id", value = "123456", example = "123456", dataType = "String", required = true)
    @NotNull
    private Long sysCompanyId;

    @ApiModelProperty(name = "pageNum", value = "页号", example = "1", dataType = "int", required = true)
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "页size", example = "10", dataType = "int", required = true)
    private Integer pageSize;

}
