package com.bizvane.customized.facade.models.vo;

import com.bizvane.customized.facade.annotations.Assert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @author dingShiChen
 * @since 2019/6/20
 */
@Assert(allNotNull = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "储值卡转增PO")
public class CusUrStorageCardSendVO {

	@ApiModelProperty(value = "线上企业id", required = true)
	private Long sysCompanyId;
	@ApiModelProperty(value = "线上品牌id", required = true)
	private Long brandId;
	@ApiModelProperty(value = "会员code", required = true)
	private String memberCode;
	@ApiModelProperty(value = "转增人手机号", required = true)
	private String phone;
	@ApiModelProperty(value = "变更金额", required = true)
	private BigDecimal balance;
//	@ApiModelProperty(value = "目标人ID", required = true)
//	private Long targetId;
	@ApiModelProperty(value = "目标人名称", required = true)
	private String targetName;
	@ApiModelProperty(value = "目标人会员code", required = true)
	private String targetMemberCode;


}
