package com.bizvane.customized.facade.models.vo.goldLion.biz;

import com.bizvane.customized.facade.models.vo.goldLion.base.PageParam;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * Created by zhouyuming on 2020-04-15.
 */
@ApiModel(value = "GoldLionMemberActivityReqVo",description = "金利来列表请求vo")
public class GoldLionMemberActivityReqVo extends PageParam implements Serializable {
    private static final long serialVersionUID = 8186642092108349497L;

    @ApiModelProperty(value = "活动权益id")
    private String activityNo;

    @ApiModelProperty(value = "活动权益id")
    private String activityName;

    @ApiModelProperty(value = "品牌ID")
    private Long brandId;

    @ApiModelProperty(value = "开始时间起")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startBeginDate;

    @ApiModelProperty(value = "开始时间止")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startEndDate;

    @ApiModelProperty(value = "结束时间起")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date overBeginDate;

    @ApiModelProperty(value = "结束时间止")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date overEndDate;

    @ApiModelProperty(value = "开始时间起(前端忽略)")
    private LocalDateTime startBeginDateTime;

    @ApiModelProperty(value = "开始时间止(前端忽略")
    private LocalDateTime startEndDateTime;

    @ApiModelProperty(value = "结束时间起(前端忽略")
    private LocalDateTime overBeginDateTime;

    @ApiModelProperty(value = "结束时间止(前端忽略")
    private LocalDateTime overEndDateTime;

    @ApiModelProperty(value = "活动状态1：待执行 2：启用中 3：已结束 4：已禁用")
    private Integer activityStatus;

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public LocalDateTime getStartBeginDateTime() {
        return startBeginDateTime;
    }

    public void setStartBeginDateTime(LocalDateTime startBeginDateTime) {
        this.startBeginDateTime = startBeginDateTime;
    }

    public LocalDateTime getStartEndDateTime() {
        return startEndDateTime;
    }

    public void setStartEndDateTime(LocalDateTime startEndDateTime) {
        this.startEndDateTime = startEndDateTime;
    }

    public LocalDateTime getOverBeginDateTime() {
        return overBeginDateTime;
    }

    public void setOverBeginDateTime(LocalDateTime overBeginDateTime) {
        this.overBeginDateTime = overBeginDateTime;
    }

    public LocalDateTime getOverEndDateTime() {
        return overEndDateTime;
    }

    public void setOverEndDateTime(LocalDateTime overEndDateTime) {
        this.overEndDateTime = overEndDateTime;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public String getActivityNo() {
        return activityNo;
    }

    public void setActivityNo(String activityNo) {
        this.activityNo = activityNo;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Date getStartBeginDate() {
        return startBeginDate;
    }

    public void setStartBeginDate(Date startBeginDate) {
        this.startBeginDate = startBeginDate;
    }

    public Date getStartEndDate() {
        return startEndDate;
    }

    public void setStartEndDate(Date startEndDate) {
        this.startEndDate = startEndDate;
    }

    public Date getOverBeginDate() {
        return overBeginDate;
    }

    public void setOverBeginDate(Date overBeginDate) {
        this.overBeginDate = overBeginDate;
    }

    public Date getOverEndDate() {
        return overEndDate;
    }

    public void setOverEndDate(Date overEndDate) {
        this.overEndDate = overEndDate;
    }
}
