/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.crypto.aspect;

import com.bizvane.crypto.annotation.RequestDecryptField;
import com.bizvane.crypto.utils.SM3Utils;
import com.bizvane.crypto.utils.SM4Utils;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class RequestDecryptAspect {
    @Value(value="${spring.crypto.header-key:deviceId}")
    private String cryptoKey;
    @Autowired
    private HttpServletRequest request;

    @PostConstruct
    public void init() {
        System.out.println("RequestDecryptAspect inited.");
    }

    @Pointcut(value="execution(* com.bizvane..*Controller.*(..))")
    public void controllerMethods() {
    }

    @Before(value="controllerMethods()")
    public void replaceTextInFields(JoinPoint joinPoint) throws IllegalAccessException {
        Object[] args;
        String deviceId = this.request.getHeader(this.cryptoKey);
        if (deviceId == null || deviceId.trim().isEmpty()) {
            return;
        }
        String keyHex = SM3Utils.generateKeyHex(deviceId);
        for (Object arg : args = joinPoint.getArgs()) {
            this.processObjectFields(arg, keyHex, new HashSet<Object>());
        }
    }

    private void processObjectFields(Object obj, String keyHex, Set<Object> visited) throws IllegalAccessException {
        Field[] fields;
        if (obj == null || visited.contains(obj)) {
            return;
        }
        visited.add(obj);
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object value = field.get(obj);
            if (field.isAnnotationPresent(RequestDecryptField.class) && value instanceof String && !StringUtils.isEmpty((Object)value)) {
                String decryptedText = SM4Utils.decryptSM4((String)value, keyHex);
                field.set(obj, decryptedText);
            }
            if (value == null || field.getType().isPrimitive() || value instanceof String) continue;
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    this.processObjectFields(item, keyHex, visited);
                }
                continue;
            }
            this.processObjectFields(value, keyHex, visited);
        }
    }
}

