/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.crypto.nacos;

import com.bizvane.crypto.utils.SM3Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class NacosConfig {
    @Value(value="${spring.cloud.nacos.config.server-addr}")
    private String server;
    @Value(value="${spring.cloud.nacos.config.namespace}")
    private String namespace;
    private static final String NACOS_CONFIG_KEY = "CRYPTO_PRIVATE_KEYS";
    private static final String NACOS_DEFAULT_GROUP = "DEFAULT_GROUP";
    private final RestTemplate restTemplate;
    private static final Map<String, String> PRIVATE_KEYS = new ConcurrentHashMap<String, String>();

    public NacosConfig(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @PostConstruct
    public void init() {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(this::refreshNacosConfig, 0L, 2L, TimeUnit.MINUTES);
    }

    public static String getSecretKey(String biz) {
        String key = PRIVATE_KEYS.get(biz);
        if (StringUtils.isEmpty((Object)key)) {
            throw new RuntimeException("Nacos\u914d\u7f6e\u300cCRYPTO_PRIVATE_KEYS\u300d\u4e2d\u672a\u914d\u7f6e\u8be5\u4e1a\u52a1\u5bc6\u94a5\uff0cbiz\uff1a" + biz);
        }
        return key;
    }

    private void refreshNacosConfig() {
        try {
            String url = String.format("http://%s/nacos/v1/cs/configs?dataId=%s&group=%s&namespace=%s", this.server, NACOS_CONFIG_KEY, NACOS_DEFAULT_GROUP, this.namespace);
            String cfg = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
            ObjectMapper objectMapper = new ObjectMapper();
            List list = (List)objectMapper.readValue(cfg, (TypeReference)new TypeReference<List<Map<String, String>>>(){});
            for (Map map : list) {
                PRIVATE_KEYS.put((String)map.get("biz"), SM3Utils.generateKeyHex((String)map.get("key")));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u83b7\u53d6nacos config\u5931\u8d25\uff0chost\uff1a%s,namespace:%s", this.server, this.namespace), e);
        }
    }
}

