/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.oaserver.conf;

import com.bizvane.oaserver.aop.OpenApiServerAspect;
import com.bizvane.oaserver.properties.OpenApiProperties;
import com.bizvane.oaserver.service.OpenApiHeaderService;
import com.bizvane.oaserver.service.OpenApiServerCheckService;
import com.bizvane.oaserver.service.impl.DefaultOpenApiHeaderServiceImpl;
import com.bizvane.oaserver.service.impl.DefaultOpenApiServerCheckServiceImpl;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={OpenApiProperties.class})
public class OpenApiServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OpenApiHeaderService openApiHeaderService(HttpServletRequest request) {
        return new DefaultOpenApiHeaderServiceImpl(request);
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenApiServerCheckService openApiServerCheckService(OpenApiProperties properties, OpenApiHeaderService openApiHeaderService) {
        return new DefaultOpenApiServerCheckServiceImpl(properties, openApiHeaderService);
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenApiServerAspect openApiServerAspect(OpenApiServerCheckService openApiServerCheckService) {
        return new OpenApiServerAspect(openApiServerCheckService);
    }
}

