package com.bizvane.oaserver.service.impl;

import cn.bizvane.openapi.client.sdk.SignatureUtils;
import com.alibaba.fastjson.JSON;
import com.bizvane.oaserver.exception.OpenApiCheckException;
import com.bizvane.oaserver.properties.OpenApiProperties;
import com.bizvane.oaserver.service.OpenApiHeaderService;
import com.bizvane.oaserver.service.OpenApiServerCheckService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * @author dingShiChen
 * @since 2019/9/3
 */
public class DefaultOpenApiServerCheckServiceImpl implements OpenApiServerCheckService {

	private Logger log = LoggerFactory.getLogger(DefaultOpenApiServerCheckServiceImpl.class);

	private OpenApiProperties openApiProperties;

	private OpenApiHeaderService openApiHeaderService;

	public DefaultOpenApiServerCheckServiceImpl(OpenApiProperties openApiProperties, OpenApiHeaderService openApiHeaderService) {
		this.openApiProperties = openApiProperties;
		this.openApiHeaderService = openApiHeaderService;
	}

	@Override
	public void check(Object param) throws OpenApiCheckException {
		checkAppkey();

		checkSign(param);
	}

	private void checkAppkey() throws OpenApiCheckException {
		String appkeyFromConfig = openApiProperties.getAppkey();

		String appKeyFromClient = openApiHeaderService.getAppKeyFromClient();

		if(appkeyFromConfig == null || appKeyFromClient == null){
			throw new OpenApiCheckException("get appkey error!");
		}

		if(!appkeyFromConfig.equals(appKeyFromClient)){
			log.error("check appkey is fail!  : appkeyFromConfig : {}, appKeyFromClient : {}", appkeyFromConfig, appKeyFromClient);
			throw new OpenApiCheckException("check appkey is fail!");
		}
	}


	private void checkSign(Object param) throws OpenApiCheckException {
		//组装签名参数
		String body = JSON.toJSONString(param);
		Map<String, Object> map = new HashMap<>(JSON.parseObject(body));
		map.putAll(openApiHeaderService.getNeedCheckParamsFromClient());
		//签名
		String sign = SignatureUtils.sign(openApiProperties.getAppsecret(), map);

		String signFromClient = openApiHeaderService.getSignFromClient();
		if(signFromClient == null){
			throw new OpenApiCheckException("get sign error!");
		}

		if(!sign.equals(signFromClient)){
			log.error("check sign is fail!  : signFromClient : {}, sign : {}", signFromClient, sign);
			throw new OpenApiCheckException("check sign is fail!");
		}
	}
}
