package com.bizvane.oaserver.service.impl;

import com.bizvane.oaserver.consts.HeaderConsts;
import com.bizvane.oaserver.service.OpenApiHeaderService;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * @author dingShiChen
 * @since 2019/9/3
 */
public class DefaultOpenApiHeaderServiceImpl implements OpenApiHeaderService {

	private HttpServletRequest request;

	public DefaultOpenApiHeaderServiceImpl(HttpServletRequest request) {
		this.request = request;
	}

	@Override
	public String getAppKeyFromClient() {
		return getHeader(HeaderConsts.BIZVANE_APPKEY);
	}

	@Override
	public Map<String, Object> getNeedCheckParamsFromClient() {
		Map<String, Object> map = new HashMap<>();
		String[] needCheckHeaders = getHeader(HeaderConsts.BIZVANE_SIGNATUE_HEADERS).split(",");
		for (String n : needCheckHeaders) {
			String e = getHeader(n);
			map.put(n, e);
		}
		return map;
	}

	@Override
	public String getSignFromClient() {
		return getHeader(HeaderConsts.BIZVANE_SIGNATURE);
	}


	private String getHeader(String header){
		return this.request.getHeader(header);
	}
}
