package com.bizvane.oaserver.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;


/**
 * OpenApi配置
 * @author dingShiChen
 * @since 2019/7/25
 */
@ConfigurationProperties(prefix = "bizvane.openapi.servant")
public class OpenApiProperties {

	//服务者名
	private String producer;

	//服务者appkey
	private String appkey;

	//服务者appsecret
	private String appsecret;

	public String getProducer() {
		return producer;
	}

	public void setProducer(String producer) {
		this.producer = producer;
	}

	public String getAppkey() {
		return appkey;
	}

	public void setAppkey(String appkey) {
		this.appkey = appkey;
	}

	public String getAppsecret() {
		return appsecret;
	}

	public void setAppsecret(String appsecret) {
		this.appsecret = appsecret;
	}

	@Override
	public String toString() {
		return "OpenApiProperties{" +
				"producer='" + producer + '\'' +
				", appkey='" + appkey + '\'' +
				", appsecret='" + appsecret + '\'' +
				'}';
	}
}
