package com.bizvane.oaserver.aop;

import com.bizvane.oaserver.annotation.OpenApiServer;
import com.bizvane.oaserver.service.OpenApiServerCheckService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/**
 * OpenApi 服务端注解验签
 * {@link OpenApiServer}
 * @author dingShiChen
 * @since 2019/7/25
 */
@Aspect
public class OpenApiServerAspect {

	private OpenApiServerCheckService openApiServerCheckService;

	public OpenApiServerAspect(OpenApiServerCheckService openApiServerCheckService) {
		this.openApiServerCheckService = openApiServerCheckService;
	}

	@Around(value = "@annotation(com.bizvane.oaserver.annotation.OpenApiServer)")
	@Order(1)
	public Object checkSign(ProceedingJoinPoint joinPoint) throws Throwable {
		MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
		Method method = methodSignature.getMethod();
		Annotation[][] parameterAnnotations = method.getParameterAnnotations();
		Object[] args = joinPoint.getArgs();
		for (int i = 0; i < parameterAnnotations.length; i++) {
			for (Annotation annotation : parameterAnnotations[i]) {
				if(annotation instanceof RequestBody){
					Assert.notNull(args[i], "@requestbody param is null!");
					openApiServerCheckService.check(args[i]);
				}
			}
		}
		return  joinPoint.proceed();
	}

}
