/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.jobhandler;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.bo.SendCouponFailContinueBO;
import com.bizvane.couponfacade.models.po.CouponManualPO;
import com.bizvane.couponfacade.models.po.CouponManualPOExample;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.utils.DateUtil;
import com.bizvane.couponservice.common.utils.ObjectConvertUtils;
import com.bizvane.couponservice.mappers.CouponManualPOMapper;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.trace.annotation.TraceWeaving;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@JobHandler(value="sendCouponFailContinueJobHandler")
@Component
public class SendCouponFailContinueJobHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(SendCouponFailContinueJobHandler.class);
    @Autowired
    private CouponManualPOMapper couponManualPOMapper;
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    private String redisKey = "coupon:job:sendCouponFailContinue_key";

    @TraceWeaving
    public ReturnT<String> execute(String param) throws Exception {
        log.info("start sendCouponFailContinueJobHandler execute method !");
        this.redisTemplate.expire((Object)this.redisKey, 1L, TimeUnit.DAYS);
        ReturnT returnT = new ReturnT();
        if (this.redisTemplate.opsForValue().increment((Object)this.redisKey, 1L) % 3L != 0L) {
            CouponManualPOExample example = new CouponManualPOExample();
            example.createCriteria().andMqStateEqualTo(Integer.valueOf(1)).andSendTimeGreaterThanOrEqualTo(DateUtil.addDay((Date)new Date(), (int)-7)).andSendTimeLessThanOrEqualTo(new Date());
            CouponManualPO record = new CouponManualPO();
            record.setMqState(Integer.valueOf(0));
            this.couponManualPOMapper.updateByExampleSelective(record, example);
        } else {
            CouponManualPOExample example = new CouponManualPOExample();
            example.createCriteria().andMqStateEqualTo(Integer.valueOf(0)).andSendTimeGreaterThanOrEqualTo(DateUtil.addDay((Date)new Date(), (int)-7)).andSendTimeLessThanOrEqualTo(new Date()).andTaskStatusIn(Arrays.asList((byte)25, (byte)45));
            List couponManualPOList = this.couponManualPOMapper.selectByExample(example);
            for (CouponManualPO couponManualPO : couponManualPOList) {
                SendCouponFailContinueBO bo = (SendCouponFailContinueBO)JSONObject.parseObject((String)couponManualPO.getMqCouponJson(), SendCouponFailContinueBO.class);
                if (bo == null || CollectionUtils.isEmpty((Collection)bo.getDefinitionPOList()) || CollectionUtils.isEmpty((Collection)bo.getRequestVOList())) {
                    log.info("\u6570\u636ejson\u4e3a\u7a7a\uff0c\u8df3\u8fc7" + couponManualPO.getCouponManualId());
                    continue;
                }
                ObjectConvertUtils.sort((List)bo.getDefinitionPOList());
                ObjectConvertUtils.sort2((List)bo.getRequestVOList());
                this.couponManualService.sendCouponFailContinue(bo);
            }
        }
        log.info("end sendCouponFailContinueJobHandler execute method !");
        returnT.setCode(SysResponseEnum.SUCCESS.getCode());
        returnT.setMsg(SysResponseEnum.SUCCESS.getMessage());
        return returnT;
    }
}

