/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.jobhandler;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.bo.SendCouponDifindustryBo;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponManualPO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponfacade.utils.SysAccountVo;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.utils.DigitalJudgmentUtil;
import com.bizvane.couponservice.common.utils.ObjectConvertUtils;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponManualPOMapper;
import com.bizvane.couponservice.service.CouponDifindustryService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.mktcenterservice.models.bo.ActivityGiftbagBO;
import com.bizvane.mktcenterservice.models.po.MktGiftBagPO;
import com.bizvane.mktcenterservice.rpc.SendCouponServiceRpc;
import com.bizvane.trace.annotation.TraceWeaving;
import com.bizvane.utils.responseinfo.ResponseData;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="sendBatchJobHandler")
@Component
public class SendBatchJobHandler
extends IJobHandler {
    private static final Logger logger = LoggerFactory.getLogger(SendBatchJobHandler.class);
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPoMapper;
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private SendCouponServiceRpc sendCouponServiceRpc;
    @Autowired
    private CouponManualPOMapper couponManualPOMapper;
    @Autowired
    private CouponDifindustryService couponDifindustryService;

    @TraceWeaving
    public ReturnT<String> execute(String param) throws Exception {
        logger.info("enter 666666666666666 SendBatchJobHandler execute method !" + param);
        ReturnT returnT = new ReturnT();
        if (StringUtils.isBlank((CharSequence)param)) {
            returnT.setCode(SysResponseEnum.FAILED.getCode());
            returnT.setMsg(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return returnT;
        }
        SendCouponBatchRequestVO requestVO = (SendCouponBatchRequestVO)JSONObject.parseObject((String)param, SendCouponBatchRequestVO.class);
        requestVO.setCouponManualId(requestVO.getBusinessId());
        Object ids = requestVO.getCouponDefinitionIds();
        if (requestVO.getMktGiftBagId() != null) {
            ActivityGiftbagBO data;
            MktGiftBagPO mktGiftBagPo = new MktGiftBagPO();
            mktGiftBagPo.setSysCompanyId(requestVO.getSysCompanyId());
            mktGiftBagPo.setSysBrandId(requestVO.getSysBrandId());
            mktGiftBagPo.setMktGiftBagId(requestVO.getMktGiftBagId());
            ResponseData activityGiftbagBoResponseData = this.sendCouponServiceRpc.selectGiftBagDetailForCounpon(mktGiftBagPo);
            if (activityGiftbagBoResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && activityGiftbagBoResponseData.getData() != null && CollectionUtils.isNotEmpty((Collection)(data = (ActivityGiftbagBO)activityGiftbagBoResponseData.getData()).getCouponDefinitionPOList())) {
                Object couponDefId = "";
                for (int i = 0; i < data.getCouponDefinitionPOList().size(); ++i) {
                    CouponDefinitionPOWithBLOBs couponDefinitionPoWithBlobs = (CouponDefinitionPOWithBLOBs)data.getCouponDefinitionPOList().get(i);
                    couponDefId = (String)couponDefId + couponDefinitionPoWithBlobs.getCouponDefinitionId().toString() + ",";
                }
                logger.info("changeCheckStatus couponDefId:{}", couponDefId);
                if (StringUtils.isNotBlank((CharSequence)couponDefId)) {
                    ids = StringUtils.isBlank((CharSequence)ids) ? couponDefId : (((String)ids).endsWith(",") ? (String)ids + (String)couponDefId : (String)ids + "," + (String)couponDefId);
                }
            }
        }
        logger.info("SendBatchJobHandler execute ids:{}", ids);
        ArrayList<String> idList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            if (((String)ids).contains(",")) {
                Collections.addAll(idList, ((String)ids).split(","));
            } else {
                idList.add((String)ids);
            }
        }
        ArrayList<CouponDefinitionPOWithBLOBs> definitionPoList = new ArrayList<CouponDefinitionPOWithBLOBs>();
        ArrayList<SendCouponDifindustryBo> sendCouponDifindustryBoList = new ArrayList<SendCouponDifindustryBo>();
        for (String id : idList) {
            boolean numeric = DigitalJudgmentUtil.isNumeric((String)id);
            if (numeric) {
                CouponDefinitionPOWithBLOBs definitionPo = new CouponDefinitionPOWithBLOBs();
                CouponDefinitionPOWithBLOBs definitionPoSource = this.couponDefinitionPoMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(id)));
                if (definitionPoSource == null) continue;
                BeanUtils.copyProperties((Object)definitionPoSource, (Object)definitionPo);
                definitionPoList.add(definitionPo);
                continue;
            }
            String[] split = id.split("_");
            String bandId = split[0];
            String menualId = split[1];
            CouponManualPO couponManua = this.couponManualPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(menualId)));
            if (couponManua == null || !Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()).equals(couponManua.getCouponType())) continue;
            CouponDefinitionPOWithBLOBs definitionPOSource = this.couponDefinitionPoMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(couponManua.getCouponDefinitionId())));
            SendCouponDifindustryBo sendCouponDifindustryBo = new SendCouponDifindustryBo();
            sendCouponDifindustryBo.setBatchNum(couponManua.getBatchNum());
            sendCouponDifindustryBo.setSysCompanyId(couponManua.getSysCompanyId());
            sendCouponDifindustryBo.setSysBrandId(couponManua.getSysBrandId());
            sendCouponDifindustryBo.setSourceBusinessId(couponManua.getCouponManualId());
            sendCouponDifindustryBo.setSourceBusinessType(String.valueOf(couponManua.getCouponType()));
            sendCouponDifindustryBo.setSourceBrandId(couponManua.getSysBrandId());
            sendCouponDifindustryBo.setCouponDefinitionPOWithBLOBs(definitionPOSource);
            sendCouponDifindustryBoList.add(sendCouponDifindustryBo);
        }
        boolean taskInvalid = this.couponManualService.isManualTaskInvalid(requestVO.getBusinessId());
        if (taskInvalid) {
            returnT.setCode(SysResponseEnum.SUCCESS.getCode());
            returnT.setMsg("\u81ea\u52a8\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u53d1\u5238\u4efb\u52a1\u56e0\u4f5c\u5e9f\u800c\u53d6\u6d88");
            return returnT;
        }
        ResponseData responseData = null;
        if (Integer.valueOf(SendTypeEnum.SEND_COUPON_STAFF.getCode()).equals(requestVO.getCouponType()) && CollectionUtils.isNotEmpty(definitionPoList)) {
            responseData = this.couponManualService.sendStaffCoupon((CouponDefinitionPOWithBLOBs)definitionPoList.get(0), requestVO);
        } else if (!definitionPoList.isEmpty()) {
            ObjectConvertUtils.sort(definitionPoList);
            responseData = this.couponManualService.sendNewCouponByUseChannel(definitionPoList, requestVO);
        }
        if (!sendCouponDifindustryBoList.isEmpty()) {
            SysAccountVo sysAccountVo = new SysAccountVo();
            sysAccountVo.setSysCompanyId(requestVO.getSysCompanyId());
            this.couponDifindustryService.sendDifindustryCouponByUseChannel(sendCouponDifindustryBoList, requestVO);
        }
        if (SysResponseEnum.SUCCESS.getCode() != responseData.getCode()) {
            returnT.setCode(SysResponseEnum.FAILED.getCode());
            returnT.setMsg(responseData.getMessage());
            return returnT;
        }
        returnT.setCode(SysResponseEnum.SUCCESS.getCode());
        returnT.setMsg(SysResponseEnum.SUCCESS.getMessage());
        return returnT;
    }
}

