/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.jobhandler;

import com.bizvane.couponfacade.models.vo.CouponSendAgainRequestVO;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.mappers.CouponSendFailLogPOMapper;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.trace.annotation.TraceWeaving;
import com.bizvane.utils.responseinfo.ResponseData;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="sendBatchAgainJobHandler")
@Component
public class SendBatchAgainJobHandler
extends IJobHandler {
    private static final Logger logger = LoggerFactory.getLogger(SendBatchAgainJobHandler.class);
    @Autowired
    private CouponSendFailLogPOMapper couponSendFailLogPoMapper;
    @Autowired
    private SendCouponService sendCouponService;

    @TraceWeaving
    public ReturnT<String> execute(String sendNum) throws Exception {
        logger.info("enter SendBatchAgainJobHandler execute method:param:{}", (Object)sendNum);
        ReturnT returnT = new ReturnT();
        if (StringUtils.isBlank((CharSequence)sendNum)) {
            returnT.setCode(SysResponseEnum.FAILED.getCode());
            returnT.setMsg(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return returnT;
        }
        Byte tryZero = SystemConstants.COUPON_SEND_FAIL_TIMES_ZERO;
        List againList = this.couponSendFailLogPoMapper.getListBySendNum(sendNum, tryZero);
        ArrayList singleBatchList = new ArrayList();
        ArrayList batchList = new ArrayList();
        for (int i = 0; i < againList.size(); ++i) {
            if (StringUtils.isBlank((CharSequence)((CouponSendAgainRequestVO)againList.get(i)).getBatchSendCode())) {
                singleBatchList.add(againList.get(i));
                continue;
            }
            batchList.add(againList.get(i));
        }
        if (CollectionUtils.isNotEmpty(singleBatchList)) {
            ResponseData responseData = this.sendCouponService.sendSingleBatchAgainExecute(singleBatchList);
        }
        if (CollectionUtils.isNotEmpty(batchList)) {
            ResponseData responseData = this.sendCouponService.sendBatchAgainExecute(batchList);
        }
        returnT.setCode(SysResponseEnum.SUCCESS.getCode());
        returnT.setMsg(SysResponseEnum.SUCCESS.getMessage());
        return returnT;
    }
}

