/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.jobhandler;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponfacade.models.po.CouponLockPO;
import com.bizvane.couponfacade.models.po.CouponLockPOExample;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.mappers.CouponLockPOMapper;
import com.bizvane.trace.annotation.TraceWeaving;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="couponUnlockJobHandler")
@Component
public class CouponUnlockJobHandler
extends IJobHandler {
    private static final Logger logger = LoggerFactory.getLogger(CouponUnlockJobHandler.class);
    @Autowired
    private CouponEntityPOMapper couponEntityPoMapper;
    @Autowired
    private CouponLockPOMapper couponLockPoMapper;

    @TraceWeaving
    public ReturnT<String> execute(String s) throws Exception {
        logger.info("enter CouponUnlockJobHandler execute method !");
        ReturnT returnT = new ReturnT();
        Date now = new Date();
        DateTime fifteenMinutesAgo = DateUtil.offset((Date)now, (DateField)DateField.MINUTE, (int)-15);
        CouponLockPOExample example = new CouponLockPOExample();
        example.createCriteria().andLockStatusEqualTo(Boolean.valueOf(true)).andLockDateLessThanOrEqualTo((Date)fifteenMinutesAgo).andValidEqualTo(Boolean.valueOf(true)).andUnLockOnTimeEqualTo(Boolean.valueOf(true));
        List couponLockPos = this.couponLockPoMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)couponLockPos)) {
            for (CouponLockPO couponLock : couponLockPos) {
                CouponEntityPO entityPo;
                logger.info("CouponUnlockJobHandler stayUnlock couponCode:{}", (Object)couponLock.getCouponCode());
                couponLock.setLockStatus(Boolean.valueOf(false));
                couponLock.setUnlockDate(now);
                couponLock.setUnlockReason("\u5b9a\u65f6\u4efb\u52a1\u89e3\u51bb");
                couponLock.setModifiedDate(now);
                this.couponLockPoMapper.updateByPrimaryKeySelective(couponLock);
                CouponEntityPOExample entityExample = new CouponEntityPOExample();
                entityExample.createCriteria().andSysBrandIdEqualTo(couponLock.getSysBrandId()).andSysCompanyIdEqualTo(couponLock.getSysCompanyId()).andCouponCodeEqualTo(couponLock.getCouponCode()).andValidEqualTo(Boolean.valueOf(true));
                List couponEntityPoList = this.couponEntityPoMapper.selectByExample(entityExample);
                if (!CollectionUtils.isNotEmpty((Collection)couponEntityPoList) || !(entityPo = (CouponEntityPO)couponEntityPoList.get(0)).getIsLock().booleanValue()) continue;
                entityPo.setIsLock(Boolean.valueOf(false));
                entityPo.setModifiedDate(new Date());
                this.couponEntityPoMapper.updateByExampleSelective(entityPo, entityExample);
            }
        }
        returnT.setCode(SysResponseEnum.SUCCESS.getCode());
        returnT.setMsg(SysResponseEnum.SUCCESS.getMessage());
        return returnT;
    }
}

