/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.jobhandler;

import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.DateUtil;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.trace.annotation.TraceWeaving;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="couponStatusExpireJobHandler")
@Component
public class CouponStatusExpireJobHandler
extends IJobHandler {
    private static final Logger logger = LoggerFactory.getLogger(CouponStatusExpireJobHandler.class);
    @Autowired
    private CouponEntityPOMapper couponEntityPoMapper;

    @TraceWeaving
    public ReturnT<String> execute(String s) throws Exception {
        logger.info("enter CouponStatusExpireJobHandler execute method !");
        ReturnT returnT = new ReturnT();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date yesterDayZeroHour = DateUtil.getYesterDayZeroHour((int)-3);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            yesterDayZeroHour = DateUtil.getYesterDayZeroHour((int)Integer.valueOf(s));
        }
        Date yesterDay24Hour = DateUtil.getYesterDay24Hour();
        CouponEntityPOExample entityPoExample = new CouponEntityPOExample();
        entityPoExample.createCriteria().andValidDateEndGreaterThanOrEqualTo(yesterDayZeroHour).andValidDateEndLessThanOrEqualTo(yesterDay24Hour).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andCouponStatusEqualTo(SystemConstants.COUPON_STATUS_UNUSED);
        CouponEntityPO entityPo = new CouponEntityPO();
        entityPo.setCouponStatus(SystemConstants.COUPON_STATUS_OVERDUE);
        this.couponEntityPoMapper.updateByExampleSelective(entityPo, entityPoExample);
        returnT.setCode(SysResponseEnum.SUCCESS.getCode());
        returnT.setMsg(SysResponseEnum.SUCCESS.getMessage());
        return returnT;
    }
}

