/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.jobhandler;

import com.bizvane.couponfacade.models.po.CouponQuotaPOExample;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.mappers.CouponQuotaPOMapper;
import com.bizvane.couponservice.service.CouponQuotaDifferentBrandService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="couponQuotaDifferentBrandReleaseJobHandler")
@Component
public class CouponQuotaDifferentBrandReleaseJobHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(CouponQuotaDifferentBrandReleaseJobHandler.class);
    @Autowired
    private CouponQuotaPOMapper couponQuotaPOMapper;
    @Autowired
    private CouponQuotaDifferentBrandService couponQuotaDifferentBrandService;

    public ReturnT<String> execute(String s) throws Exception {
        CouponQuotaPOExample couponQuotaPOExample = new CouponQuotaPOExample();
        couponQuotaPOExample.createCriteria().andQuotaTypeEqualTo(Integer.valueOf(1)).andEndDateLessThan(new Date());
        List couponQuotaPOList = this.couponQuotaPOMapper.selectByExample(couponQuotaPOExample);
        log.info("CouponQuotaDifferentBrandReleaseJobHandler couponQuotaPOList: {}", (Object)JacksonUtil.list2Json((List)couponQuotaPOList));
        if (CollectionUtils.isNotEmpty((Collection)couponQuotaPOList)) {
            couponQuotaPOList.stream().forEach(po -> {
                try {
                    this.couponQuotaDifferentBrandService.releaseDifindustryCouponQuantity(po.getCouponQuotaId());
                }
                catch (Exception e) {
                    log.info("couponQuotaDifferentBrandReleaseJobHandler po: {}, exception: {}", (Object)JacksonUtil.bean2Json((Object)po), (Object)e);
                }
            });
        }
        return ReturnT.SUCCESS;
    }
}

