/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.jobhandler;

import com.alibaba.fastjson.JSON;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponfacade.models.po.SysCodeValuePO;
import com.bizvane.couponfacade.models.po.SysCodeValuePOExample;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.StandardMessageUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.mappers.SysCodeValuePOMapper;
import com.bizvane.couponservice.service.impl.CouponMessageComponentServiceImpl;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.messagefacade.interfaces.WechatCouponServiceFeign;
import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.bizvane.trace.annotation.TraceWeaving;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="couponExpireJobHandler")
@Component
public class CouponExpireJobHandler
extends IJobHandler {
    private static final Logger logger = LoggerFactory.getLogger(CouponExpireJobHandler.class);
    @Autowired
    private CouponEntityPOMapper couponEntityPoMapper;
    @Autowired
    private WechatCouponServiceFeign wechatCouponServiceFeign;
    @Autowired
    private SysCodeValuePOMapper sysCodeValuePoMapper;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private StandardMessageUtil standardMessageUtil;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private CouponMessageComponentServiceImpl couponMessageComponentService;

    @TraceWeaving
    public ReturnT<String> execute(String nullStr) throws Exception {
        logger.info("enter CouponExpireJobHandler execute method");
        ReturnT returnT = new ReturnT();
        SysCodeValuePOExample codeExample = new SysCodeValuePOExample();
        codeExample.createCriteria().andCodeTypeEqualTo("expire_day");
        List sysCodeValuePoList = this.sysCodeValuePoMapper.selectByExample(codeExample);
        String expireDay = ((SysCodeValuePO)sysCodeValuePoList.get(0)).getItemCode();
        if (StringUtils.isBlank((CharSequence)expireDay)) {
            returnT.setMsg(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return returnT;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, Integer.parseInt(expireDay));
        Date date = format.parse(format.format(calendar.getTime()));
        CouponEntityPOExample entityPoExample = new CouponEntityPOExample();
        entityPoExample.createCriteria().andValidDateEndEqualTo(date).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List entityPoList = this.couponEntityPoMapper.selectByExample(entityPoExample);
        for (int i = 0; i < entityPoList.size(); ++i) {
            ResponseData publicPo;
            CouponEntityPO couponEntityPo = this.couponEntityPoMapper.selectByPrimaryKey(((CouponEntityPO)entityPoList.get(i)).getCouponEntityId());
            CouponMessageVO messageVO = new CouponMessageVO();
            messageVO.setMemberCode(couponEntityPo.getMemberCode());
            messageVO.setCouponCode(couponEntityPo.getCouponCode());
            messageVO.setCouponName(couponEntityPo.getCouponName());
            messageVO.setPreferentialType(couponEntityPo.getPreferentialType() + "");
            messageVO.setDenomination(couponEntityPo.getMoney() + "");
            if (couponEntityPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_MONEY)) {
                messageVO.setDenomination(couponEntityPo.getMoney() + "");
            } else if (couponEntityPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_DISCOUNT)) {
                messageVO.setDenomination(couponEntityPo.getDiscount() + "");
            }
            messageVO.setValidDateStart(couponEntityPo.getValidDateStart());
            messageVO.setValidDateEnd(couponEntityPo.getValidDateEnd());
            messageVO.setSendType(couponEntityPo.getSendType());
            messageVO.setSendBusinessId(couponEntityPo.getSendBusinessId());
            WxChannelInfoVo channelVO = new WxChannelInfoVo();
            channelVO.setMemberCode(((CouponEntityPO)entityPoList.get(i)).getMemberCode());
            channelVO.setBrandId(((CouponEntityPO)entityPoList.get(i)).getSysBrandId());
            channelVO.setMiniProgram(Integer.valueOf(1));
            ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
            if (channelResult.getData() != null) {
                WxChannelInfoVo channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
                MemberInfoModel memberInfoModel = ((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel();
                messageVO.setMemberName(channelInfoVo.getName());
                messageVO.setMemberPhone(channelInfoVo.getPhone());
                messageVO.setSendWxmember(channelInfoVo.getFocus() + "");
                messageVO.setSysCompanyId(channelInfoVo.getSysCompanyId());
                messageVO.setServiceStoreCode(memberInfoModel.getServiceStoreCode());
                messageVO.setServiceStoreId(memberInfoModel.getServiceStoreId());
                messageVO.setAreaCode(memberInfoModel.getAreaCode());
            }
            if ((publicPo = this.wxPublicServiceFeign.getWxPublicBySysBrandId(couponEntityPo.getSysBrandId())).getData() != null) {
                messageVO.setNickName(((WxPublicPO)publicPo.getData()).getNickName());
            }
            logger.info("\u8c03\u7528\u6d88\u606f\u6a21\u5757\u7684wechatCouponServiceFeign.couponExpire:{}", (Object)JSON.toJSONString((Object)messageVO));
            ResponseData entityResult = this.wechatCouponServiceFeign.couponExpire(messageVO);
            logger.info("\u8c03\u7528\u6d88\u606f\u6a21\u5757\u7684CouponExpireJobHandler.couponMessageComponentService.couponExpire:{}", (Object)JSON.toJSONString((Object)couponEntityPo.getCouponDefinitionId()));
            CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPo.getCouponDefinitionId()));
            ResponseData subscribeResp = this.couponMessageComponentService.couponExpire(messageVO, definitionPO);
            logger.info("CouponExpireJobHandler#CouponMessageComponentServiceImpl#couponExpire#subscribeResp:{}", (Object)JSON.toJSONString((Object)subscribeResp));
            logger.info("\u8c03\u7528\u6d88\u606f\u6a21\u5757\u7684  standardMessageUtil.expireCouponMessage:{}", (Object)JSON.toJSONString((Object)messageVO));
            ResponseData responseData = this.standardMessageUtil.expireCouponMessage(messageVO);
        }
        return returnT;
    }
}

