/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.jobhandler;

import com.alibaba.fastjson.JSON;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.StandardMessageUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.service.impl.CouponMessageComponentServiceImpl;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.messagebase.model.po.MsgCoupontimePO;
import com.bizvane.messagefacade.interfaces.MsgCouponTimeServiceFeign;
import com.bizvane.messagefacade.interfaces.WechatCouponServiceFeign;
import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.bizvane.trace.annotation.TraceWeaving;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="couponExpireByBrandJobHandler")
@Component
public class CouponExpireByBrandJobHandler
extends IJobHandler {
    private static final Logger logger = LoggerFactory.getLogger(CouponExpireByBrandJobHandler.class);
    @Autowired
    private MsgCouponTimeServiceFeign msgCouponTimeServiceFeign;
    @Autowired
    private CouponEntityPOMapper couponEntityPoMapper;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private WechatCouponServiceFeign wechatCouponServiceFeign;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private StandardMessageUtil standardMessageUtil;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private CouponMessageComponentServiceImpl couponMessageComponentService;

    @TraceWeaving
    public ReturnT<String> execute(String nullStr) throws Exception {
        logger.info("enter CouponExpireByBrandJobHandler execute method !");
        ReturnT returnT = new ReturnT();
        ResponseData couponTimeResult = this.msgCouponTimeServiceFeign.getCouponTimeList();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)couponTimeResult.getData()))) {
            for (MsgCoupontimePO coupon : (List)couponTimeResult.getData()) {
                try {
                    String expireDay = coupon.getDays() + "";
                    if (StringUtils.isBlank((CharSequence)expireDay)) continue;
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(new Date());
                    calendar.add(5, Integer.parseInt(expireDay));
                    Date date = format.parse(format.format(calendar.getTime()));
                    calendar.add(5, 1);
                    Date dateEnd = format.parse(format.format(calendar.getTime()));
                    logger.info("enter CouponExpireByBrandJobHandler execute method calendar!" + date.getTime() + "dateEnd" + dateEnd.getTime() + "brandId" + coupon.getSysBrandId());
                    List entityPoList = this.couponEntityPoMapper.findWxCouponList(date, dateEnd, coupon.getSysBrandId(), SystemConstants.COUPON_STATUS_UNUSED);
                    ResponseData publicPo = this.wxPublicServiceFeign.getWxPublicBySysBrandId(coupon.getSysBrandId());
                    if (!CollectionUtils.isNotEmpty((Collection)entityPoList)) continue;
                    logger.info("entityPOLIst \u4e0d\u4e3a\u7a7aentityPoList\uff1a{}", (Object)JSON.toJSONString((Object)entityPoList));
                    for (int i = 0; i < entityPoList.size(); ++i) {
                        CouponEntityVO entityVO = (CouponEntityVO)entityPoList.get(i);
                        entityVO.setModifiedUserName("1");
                        CouponMessageVO messageVO = new CouponMessageVO();
                        messageVO.setMemberCode(entityVO.getMemberCode());
                        messageVO.setCouponCode(entityVO.getCouponCode());
                        messageVO.setCouponName(entityVO.getCouponName());
                        messageVO.setPreferentialType(entityVO.getPreferentialType() + "");
                        if (entityVO.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_MONEY)) {
                            messageVO.setDenomination(entityVO.getMoney() + "");
                        } else if (entityVO.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_DISCOUNT)) {
                            messageVO.setDenomination(entityVO.getDiscount() + "");
                        } else {
                            messageVO.setDenomination(entityVO.getMoney() + "");
                        }
                        messageVO.setUseTime(entityVO.getUseTime());
                        messageVO.setValidDateStart(entityVO.getValidDateStart());
                        messageVO.setValidDateEnd(entityVO.getValidDateEnd());
                        messageVO.setMemberName(entityVO.getName());
                        messageVO.setSysBrandId(entityVO.getSysBrandId());
                        messageVO.setSendType(entityVO.getSendType());
                        messageVO.setSendBusinessId(entityVO.getSendBusinessId());
                        WxChannelInfoVo channelVO = new WxChannelInfoVo();
                        channelVO.setMemberCode(entityVO.getMemberCode());
                        channelVO.setBrandId(entityVO.getSysBrandId());
                        channelVO.setMiniProgram(Integer.valueOf(1));
                        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
                        if (channelResult.getData() != null) {
                            WxChannelInfoVo channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
                            MemberInfoModel memberInfoModel = ((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel();
                            messageVO.setMemberName(channelInfoVo.getName());
                            messageVO.setMemberPhone(channelInfoVo.getPhone());
                            messageVO.setSendWxmember(channelInfoVo.getFocus() + "");
                            messageVO.setSysCompanyId(channelInfoVo.getSysCompanyId());
                            if (memberInfoModel != null && StringUtils.isNotEmpty((CharSequence)memberInfoModel.getServiceStoreCode())) {
                                messageVO.setServiceStoreCode(memberInfoModel.getServiceStoreCode());
                            } else {
                                messageVO.setServiceStoreCode("default");
                            }
                            if (memberInfoModel != null) {
                                messageVO.setServiceStoreId(memberInfoModel.getServiceStoreId());
                                messageVO.setAreaCode(memberInfoModel.getAreaCode());
                            }
                        }
                        if (publicPo.getData() != null) {
                            messageVO.setNickName(((WxPublicPO)publicPo.getData()).getNickName());
                        }
                        ResponseData entityResult = this.wechatCouponServiceFeign.couponExpire(messageVO);
                        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(entityVO.getCouponDefinitionId()));
                        ResponseData subscribeResp = this.couponMessageComponentService.couponExpire(messageVO, definitionPO);
                        logger.info("CouponExpireByBrandJobHandler#CouponMessageComponentServiceImpl#couponExpire#subscribeResp:{}", (Object)JSON.toJSONString((Object)subscribeResp));
                        ResponseData responseData = this.standardMessageUtil.expireCouponMessage(messageVO);
                    }
                }
                catch (Exception e) {
                    logger.info("CouponExpireByBrandJobHandler execute Exception : {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return returnT;
    }
}

