/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.baisonBase.facade.models.mj.MjCouponUseRequestVo;
import com.bizvane.baisonBase.facade.rpc.MjMemberServiceNewRpc;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.po.SysYzBrandStoreMapping;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysYzBrandStoreMappingServiceRpc;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponfacade.models.vo.VoucherVerificationVo;
import com.bizvane.couponfacade.models.vo.standard.StandardCouponUseRequestVo;
import com.bizvane.couponservice.common.config.Mj2Config;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.datavo.CouponUseRequestVo;
import com.bizvane.couponservice.common.datavo.YouzanCouponBO;
import com.bizvane.couponservice.common.utils.StandardMessageUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.StandardCouponService;
import com.bizvane.couponservice.service.ThirdBusinessService;
import com.bizvane.couponservice.service.impl.CouponMessageComponentServiceImpl;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.messagefacade.interfaces.WechatCouponServiceFeign;
import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.bizvane.thirddock.service.rpc.YouzanCouponServiceRpc;
import com.bizvane.thirdrouting.bo.AsynBO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class StandardCouponServiceImpl
implements StandardCouponService {
    private static final Logger log = LoggerFactory.getLogger(StandardCouponServiceImpl.class);
    @Autowired
    private CouponEntityPOMapper couponEntityPoMapper;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private StandardMessageUtil standardMessageUtil;
    @Autowired
    private WechatCouponServiceFeign wechatCouponServiceFeign;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private SysYzBrandStoreMappingServiceRpc sysYzBrandStoreMappingServiceRpc;
    @Autowired
    private ThirdBusinessService thirdBusinessService;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private CouponMessageComponentServiceImpl couponMessageComponentService;
    @Autowired
    private Mj2Config mj2Config;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MjMemberServiceNewRpc mjMemberServiceNewRpc;
    @Autowired
    private CouponEntityService couponEntityService;
    @Autowired
    private YouzanCouponServiceRpc youzanCouponServiceRpc;

    public ResponseData<String> couponUse(StandardCouponUseRequestVo standardCouponUseRequestVo) {
        ResponseData storeCodeResult;
        ResponseData responseData = new ResponseData();
        String brandCode = standardCouponUseRequestVo.getBrandCode();
        String couponCode = standardCouponUseRequestVo.getCouponCode();
        if (StringUtils.isNotEmpty((CharSequence)brandCode)) {
            responseData.setMessage("brandCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)couponCode)) {
            responseData.setMessage("couponCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long sysBrandId = null;
        SysBrandPo sysBrandPo = new SysBrandPo();
        sysBrandPo.setSysCompanyId(standardCouponUseRequestVo.getSysCompanyId());
        sysBrandPo.setBrandCode(brandCode);
        ResponseData brandPoResponseData = this.brandServiceRpc.getBrandIdByCode(sysBrandPo);
        if (brandPoResponseData != null && brandPoResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            sysBrandId = (Long)brandPoResponseData.getData();
        } else {
            log.warn("\u8c03\u7528brandServiceRpc.getBrandIdByCode\u5931\u8d25");
        }
        CouponEntityPOExample example = new CouponEntityPOExample();
        example.createCriteria().andSysCompanyIdEqualTo(standardCouponUseRequestVo.getSysCompanyId()).andSysBrandIdEqualTo(sysBrandId).andCouponCodeEqualTo(couponCode);
        List list = this.couponEntityPoMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5238\u53f7:" + couponCode + ",\u5728\u7ebf\u4e0a\u4e0d\u5b58\u5728\uff0c\u6838\u9500\u5931\u8d25");
            return responseData;
        }
        if (list.size() > 1) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5238\u53f7:" + couponCode + ",\u5728\u7ebf\u4e0a\u5b58\u5728\u591a\u5f20\uff0c\u6838\u9500\u5931\u8d25");
            return responseData;
        }
        CouponEntityPO entityPo = (CouponEntityPO)list.get(0);
        if (entityPo.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) {
            log.info("Coupon is used" + JSONObject.toJSONString((Object)entityPo));
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5238\u53f7:" + couponCode + ",\u5df2\u88ab\u6838\u9500,\u6838\u9500\u5931\u8d25");
            return responseData;
        }
        if (entityPo.getCouponStatus().equals(SystemConstants.COUPON_STATUS_OVERDUE)) {
            log.info("Coupon is expired" + JSONObject.toJSONString((Object)entityPo));
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5238\u53f7:" + couponCode + ",\u5df2\u8fc7\u671f");
            return responseData;
        }
        CouponEntityPO record = new CouponEntityPO();
        if (StringUtils.isNotBlank((CharSequence)standardCouponUseRequestVo.getStoreCode()) && (storeCodeResult = this.storeServiceRpc.getStoreInfoByCodeAndSysCompanyId(standardCouponUseRequestVo.getStoreCode(), standardCouponUseRequestVo.getSysCompanyId())).getData() != null) {
            record.setUseStoreId(((SysStorePo)storeCodeResult.getData()).getStoreId());
        }
        record.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        record.setIsUse(SystemConstants.COUPON_DEFINITION_STATUS_USE);
        if (standardCouponUseRequestVo.getOrderAmount() != null) {
            record.setUseBusinessAmount(BigDecimal.valueOf(standardCouponUseRequestVo.getOrderAmount()));
        }
        record.setUseBusinessCode(standardCouponUseRequestVo.getOrderNo());
        record.setModifiedDate(new Date());
        entityPo.setModifiedDate(new Date());
        if (StringUtils.isNotBlank((CharSequence)standardCouponUseRequestVo.getUseTime())) {
            record.setUseTime((Date)DateUtil.parse((CharSequence)standardCouponUseRequestVo.getUseTime()));
        } else {
            record.setUseTime(new Date());
        }
        int result = this.couponEntityPoMapper.updateByExampleSelective(record, example);
        try {
            AsynBO asynBO = new AsynBO(standardCouponUseRequestVo.getSysCompanyId(), sysBrandId, "couponUsed", JSON.toJSONString((Object)entityPo));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            log.error("\u6838\u9500 thirdBusinessService.asyn e {}", (Throwable)e);
        }
        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(entityPo.getCouponDefinitionId()));
        YouzanCouponBO youzanCouponBO = this.couponEntityService.isSyncYouzan(entityPo.getSysBrandId().longValue(), entityPo, couponDefinitionPOWithBLOBs);
        if (youzanCouponBO != null) {
            try {
                log.info("youzanCouponServiceRpc.couponUse\u5165\u53c2\uff1a{}", (Object)couponCode);
                Boolean youzanResult = (Boolean)this.youzanCouponServiceRpc.couponUse(entityPo.getSysBrandId(), couponCode).getData();
                log.info("youzanCouponServiceRpc.couponUse:" + youzanResult);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u6709\u8d5e\u5238\u5b9e\u4f8b\u62a5\u9519 e {}", (Throwable)e);
            }
        }
        if (this.mj2Config.isSyncMj(entityPo.getSysCompanyId().longValue(), couponDefinitionPOWithBLOBs.getUseChannel())) {
            MemberInfoModel memberInfoModelParam = new MemberInfoModel();
            memberInfoModelParam.setMemberCode(entityPo.getMemberCode());
            MemberInfoModel member = (MemberInfoModel)this.memberInfoApiService.getMemberModel(memberInfoModelParam).getData();
            String cardNo = member.getCardNo();
            String name = member.getName();
            record.setCouponCode(entityPo.getCouponCode());
            record.setStaffCode(member.getServiceGuideCode());
            MjCouponUseRequestVo mjCouponUseRequestVo = new MjCouponUseRequestVo(cardNo, name, record);
            log.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:{}" + JSON.toJSONString((Object)mjCouponUseRequestVo));
            boolean syncResult = (Boolean)this.mjMemberServiceNewRpc.couponUse(mjCouponUseRequestVo).getTData();
            log.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:" + syncResult);
        }
        if (result > 0) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u6838\u9500\u6210\u529f");
            responseData.setData((Object)couponCode);
        }
        this.sendMessage(entityPo, record.getUseTime());
        return responseData;
    }

    public ResponseData<String> sendMessage(CouponEntityPO couponEntityPo, Date useTime) {
        ResponseData publicPo;
        ResponseData responseData = new ResponseData();
        WxChannelInfoVo channelVO = new WxChannelInfoVo();
        channelVO.setMemberCode(couponEntityPo.getMemberCode());
        channelVO.setBrandId(couponEntityPo.getSysBrandId());
        channelVO.setMiniProgram(Integer.valueOf(1));
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
        WxChannelInfoVo channelInfoVo = null;
        MemberInfoModel memberInfoModel = null;
        if (channelResult.getData() != null) {
            channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
            memberInfoModel = ((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel();
        }
        if (null == channelInfoVo) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.WECHAT_CHANNEL_NOT_EXISTS.getMessage());
            return responseData;
        }
        CouponMessageVO messageVO = new CouponMessageVO();
        messageVO.setMemberCode(couponEntityPo.getMemberCode());
        messageVO.setCouponCode(couponEntityPo.getCouponCode());
        messageVO.setCouponName(couponEntityPo.getCouponName());
        messageVO.setPreferentialType(couponEntityPo.getPreferentialType() + "");
        messageVO.setDenomination(couponEntityPo.getMoney() + "");
        if (couponEntityPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_MONEY)) {
            messageVO.setDenomination(couponEntityPo.getMoney() + "");
        } else if (couponEntityPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_DISCOUNT)) {
            messageVO.setDenomination(couponEntityPo.getDiscount() + "");
        }
        messageVO.setUseTime(couponEntityPo.getUseTime());
        messageVO.setValidDateStart(couponEntityPo.getValidDateStart());
        messageVO.setValidDateEnd(couponEntityPo.getValidDateEnd());
        messageVO.setMemberName(channelInfoVo.getName());
        messageVO.setOrderNo(couponEntityPo.getUseBusinessCode());
        messageVO.setSysBrandId(couponEntityPo.getSysBrandId());
        messageVO.setSendType(couponEntityPo.getSendType());
        messageVO.setSendBusinessId(couponEntityPo.getSendBusinessId());
        String phone = channelInfoVo.getPhone();
        if (StringUtils.isEmpty((CharSequence)phone)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u624b\u673a\u53f7\u4e0d\u5b58\u5728\uff0c\u4e0d\u53d1\u9001\u6d88\u606f");
            return responseData;
        }
        messageVO.setMemberPhone(channelInfoVo.getPhone());
        messageVO.setNickName(channelInfoVo.getWxNick());
        messageVO.setSendWxmember(channelInfoVo.getFocus() + "");
        messageVO.setSysCompanyId(channelInfoVo.getSysCompanyId());
        if (memberInfoModel != null) {
            messageVO.setServiceStoreCode(memberInfoModel.getServiceStoreCode());
            messageVO.setServiceStoreId(memberInfoModel.getServiceStoreId());
            messageVO.setAreaCode(memberInfoModel.getAreaCode());
        }
        if ((publicPo = this.wxPublicServiceFeign.getWxPublicBySysBrandId(couponEntityPo.getSysBrandId())).getData() != null) {
            messageVO.setNickName(((WxPublicPO)publicPo.getData()).getNickName());
        }
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPo.getCouponDefinitionId()));
        ResponseData subscribeResp = this.couponMessageComponentService.couponUse(messageVO, definitionPO, couponEntityPo, useTime);
        log.info("StandardCouponServiceImpl#CouponMessageComponentServiceImpl#couponUse#subscribeResp:{}", (Object)JSON.toJSONString((Object)subscribeResp));
        log.info("\u8c03\u7528\u6d88\u606f\u6a21\u5757\u7684   standardMessageUtil.useCouponMessage:{}", (Object)JSON.toJSONString((Object)messageVO));
        this.standardMessageUtil.useCouponMessage(couponEntityPo, channelInfoVo, messageVO);
        log.info("wechatCouponServiceFeign.couponUse:{}", (Object)JSON.toJSONString((Object)messageVO));
        return this.wechatCouponServiceFeign.couponUse(messageVO);
    }

    @Async
    public void couponUse(VoucherVerificationVo param) {
        log.info("enter youZan useCoupon start:{}", (Object)JacksonUtil.bean2Json((Object)param));
        StopWatch stopWatch = new StopWatch("\u6838\u9500\u51ed\u8bc1");
        stopWatch.start("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u4efb\u52a1");
        SysYzBrandStoreMapping storeMapping = this.getYzStoreInfo(param.getKdtId());
        stopWatch.stop();
        CouponUseRequestVo couponUseRequestVo = new CouponUseRequestVo();
        couponUseRequestVo.setBrandCode(storeMapping.getBrandCode());
        couponUseRequestVo.setId(param.getId());
        couponUseRequestVo.setOrderNo(param.getOrderNo());
        couponUseRequestVo.setStoreCode(storeMapping.getServiceStoreCode());
        couponUseRequestVo.setSysCompanyId(storeMapping.getSysCompanyId());
        couponUseRequestVo.setBrandId(storeMapping.getSysBrandId());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        couponUseRequestVo.setUseTime(dateTimeFormatter.format(LocalDateTime.now()));
        ResponseData responseData = new ResponseData();
        String brandCode = couponUseRequestVo.getBrandCode();
        Long couponId = couponUseRequestVo.getId();
        if (StringUtils.isNotEmpty((CharSequence)brandCode)) {
            responseData.setMessage("brandCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (couponId != null) {
            responseData.setMessage("couponId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CouponEntityPOExample example = new CouponEntityPOExample();
        example.createCriteria().andSysCompanyIdEqualTo(couponUseRequestVo.getSysCompanyId()).andSysBrandIdEqualTo(couponUseRequestVo.getBrandId()).andCouponEntityIdEqualTo(couponId);
        List list = this.couponEntityPoMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BizException(-1, "\u5238ID:" + couponId + ",\u5728\u7ebf\u4e0a\u4e0d\u5b58\u5728\uff0c\u6838\u9500\u5931\u8d25");
        }
        if (list.size() > 1) {
            throw new BizException(-1, "\u5238ID:" + couponId + ",\u5728\u7ebf\u4e0a\u5b58\u5728\u591a\u5f20\uff0c\u6838\u9500\u5931\u8d25");
        }
        CouponEntityPO entityPo = (CouponEntityPO)list.get(0);
        if (entityPo.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) {
            log.info("Coupon is used" + JSONObject.toJSONString((Object)entityPo));
            throw new BizException(-1, "\u5238ID:" + couponId + ",\u5df2\u88ab\u6838\u9500,\u6838\u9500\u5931\u8d25");
        }
        if (entityPo.getCouponStatus().equals(SystemConstants.COUPON_STATUS_OVERDUE)) {
            log.info("Coupon is expired" + JSONObject.toJSONString((Object)entityPo));
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            throw new BizException(-1, "\u5238ID:" + couponId + ",\u5df2\u8fc7\u671f");
        }
        CouponEntityPO record = new CouponEntityPO();
        record.setUseStoreId(couponUseRequestVo.getStoreId());
        record.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        record.setIsUse(SystemConstants.COUPON_DEFINITION_STATUS_USE);
        if (couponUseRequestVo.getOrderAmount() != null) {
            record.setUseBusinessAmount(BigDecimal.valueOf(couponUseRequestVo.getOrderAmount()));
        }
        record.setUseBusinessCode(couponUseRequestVo.getOrderNo());
        record.setModifiedDate(new Date());
        entityPo.setModifiedDate(new Date());
        if (StringUtils.isNotBlank((CharSequence)couponUseRequestVo.getUseTime())) {
            record.setUseTime((Date)DateUtil.parse((CharSequence)couponUseRequestVo.getUseTime()));
        } else {
            record.setUseTime(new Date());
        }
        int result = this.couponEntityPoMapper.updateByExampleSelective(record, example);
        if (result > 0) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u6838\u9500\u6210\u529f");
            responseData.setData((Object)String.valueOf(couponId));
        }
        this.sendMessage(entityPo, record.getUseTime());
    }

    private SysYzBrandStoreMapping getYzStoreInfo(Long kdtId) {
        return (SysYzBrandStoreMapping)this.sysYzBrandStoreMappingServiceRpc.getYzStoreInfo(String.valueOf(kdtId)).getData();
    }
}

