/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysCompanyPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.CompanyServiceRpc;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.bo.BigDataPartBo;
import com.bizvane.couponfacade.models.bo.CouponPartBo;
import com.bizvane.couponfacade.models.bo.SingleCouponSurveyBo;
import com.bizvane.couponfacade.models.bo.SingleSalesNum;
import com.bizvane.couponfacade.models.bo.SingleSendCouponWayBo;
import com.bizvane.couponservice.common.datavo.SalesNumVO;
import com.bizvane.couponservice.common.utils.BaseData;
import com.bizvane.couponservice.common.utils.BaseUrl;
import com.bizvane.couponservice.common.utils.DateConversionUtil;
import com.bizvane.couponservice.common.utils.SetBasicBigDataPartBoUtil;
import com.bizvane.couponservice.service.SingleCoupleAnalysisService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SingleCoupleAnalysisServiceImpl
implements SingleCoupleAnalysisService {
    private static final Logger logger = LoggerFactory.getLogger(SingleCoupleAnalysisServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private CompanyServiceRpc companyServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private BaseUrl baseUrl;
    @Autowired
    private SetBasicBigDataPartBoUtil setBasicBigDataPartBoUtil;
    final DecimalFormat df = new DecimalFormat("0.00");

    public ResponseData getCouponSurvey(CouponPartBo bo) {
        logger.info("------------------------\u8fdb\u5165\u5355\u5238\u5238\u5c55\u793a\u7684\u5165\u53e3------------------------------");
        ResponseData responseData = new ResponseData();
        SingleCouponSurveyBo singleCouponSurveyBo = new SingleCouponSurveyBo();
        BigDataPartBo bigDataPartBo = new BigDataPartBo();
        SysCompanyPo sysCompanyPo = (SysCompanyPo)this.companyServiceRpc.getCompanyById(bo.getSysCompanyId()).getData();
        bigDataPartBo.setCorpId(sysCompanyPo.getCompanyCode());
        bigDataPartBo.setBusinessNum(this.baseUrl.getBusinessNum());
        bigDataPartBo.setApiKey(this.baseUrl.getApiKey());
        if (StringUtils.isNotBlank((CharSequence)bo.getVouTypeId())) {
            bigDataPartBo.setVouTypeId(bo.getVouTypeId());
        }
        String analysisUrl = this.baseUrl.url + "vouTaskAnalysis";
        ResponseEntity response = null;
        try {
            JSONObject bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            responseData.setCode(500);
            responseData.setMessage("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)((String)response.getBody()));
        String flag = jsonObject.getString("successFlag");
        if ("0".equals(flag)) {
            responseData.setData((Object)"\u6ca1\u6709\u5f97\u5230\u6570\u636e\uff01");
            return responseData;
        }
        String data = jsonObject.getString("data");
        JSONObject dataJson = JSONObject.parseObject((String)data);
        Double totleTickets = dataJson.getDouble("totalTickets");
        singleCouponSurveyBo.setTotalTickets(this.eraseZero(totleTickets));
        Double salesVolume = dataJson.getDouble("salesVolume");
        singleCouponSurveyBo.setSalesVolume(this.eraseZero(salesVolume));
        Double saleRate = totleTickets == 0.0 ? Double.valueOf(0.0) : Double.valueOf(salesVolume / totleTickets * 100.0);
        singleCouponSurveyBo.setSaleRate(this.eraseZero(saleRate) + "%");
        Double orderNum = dataJson.getDouble("orderNum");
        singleCouponSurveyBo.setOrderNum(dataJson.getString("orderNum"));
        Double achievements = dataJson.getDouble("achievements");
        singleCouponSurveyBo.setAchievements("\uffe5" + this.df.format(achievements));
        Double penNumber = dataJson.getDouble("penNumber");
        singleCouponSurveyBo.setPenNumber(this.eraseZero(penNumber));
        Double clientPrice = achievements / orderNum;
        String clientPriceString = this.df.format(clientPrice);
        singleCouponSurveyBo.setClientPrice("\uffe5" + clientPriceString);
        Double pieceNumber = dataJson.getDouble("pieceNumber");
        Double jointRate = pieceNumber / penNumber;
        String jointRageString = this.df.format(jointRate);
        singleCouponSurveyBo.setJointRate(jointRageString);
        Double discount = dataJson.getDouble("discount");
        Double ROI = achievements / discount * 100.0;
        singleCouponSurveyBo.setROI(this.eraseZero(ROI) + "%");
        responseData.setData((Object)singleCouponSurveyBo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData singleSaleNum(CouponPartBo couponPartBo) {
        logger.info("--------------------------\u8fdb\u5165single\u5355\u5238\u8ba2\u5355\u91cf\u6216\u8005\u6210\u4ea4\u989d\u7684\u5165\u53e3------------------------");
        ResponseData responseData = new ResponseData();
        SingleSalesNum singleSalesNum = new SingleSalesNum();
        BigDataPartBo bigDataPartBo = new BigDataPartBo();
        bigDataPartBo.setBusinessNum(this.baseUrl.getBusinessNum());
        bigDataPartBo.setApiKey(this.baseUrl.getApiKey());
        SysCompanyPo sysCompanyPo = (SysCompanyPo)this.companyServiceRpc.getCompanyById(couponPartBo.getSysCompanyId()).getData();
        bigDataPartBo.setCorpId(sysCompanyPo.getCompanyCode());
        SysBrandPo sysBrandPo = (SysBrandPo)this.brandServiceRpc.getBrandByID(couponPartBo.getSysBrandId()).getData();
        bigDataPartBo.setBrandId(sysBrandPo.getBrandCode());
        bigDataPartBo.setStartDate(couponPartBo.getStartDate());
        bigDataPartBo.setEndDate(couponPartBo.getEndDate());
        if (StringUtils.isNotBlank((CharSequence)couponPartBo.getVouTypeId())) {
            bigDataPartBo.setVouTypeId(couponPartBo.getVouTypeId());
        }
        SalesNumVO salesNumVO = new SalesNumVO();
        salesNumVO.setStartDate(couponPartBo.getStartDate());
        salesNumVO.setEndDate(couponPartBo.getEndDate());
        SalesNumVO salesNumVO1 = BaseData.salesNumVoDate((SalesNumVO)salesNumVO);
        bigDataPartBo.setYesteryearStartDate(salesNumVO1.getYesteryearStartDate());
        bigDataPartBo.setYesteryearEndDate(salesNumVO1.getYesteryearEndDate());
        bigDataPartBo.setLastStartDate(salesNumVO1.getLastStartDate());
        bigDataPartBo.setLastEndDate(salesNumVO1.getLastEndDate());
        if (StringUtils.isBlank((CharSequence)couponPartBo.getOrderNumOrTurnVolume())) {
            responseData.setData((Object)"\u8ba2\u5355\u91cf\u6210\u4ea4\u989d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String analysisUrl = "\u8ba2\u5355\u91cf".equals(couponPartBo.getOrderNumOrTurnVolume()) ? this.baseUrl.url + "salesNum" : this.baseUrl.url + "salesAchievements";
        ResponseEntity response = null;
        try {
            JSONObject bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            responseData.setCode(500);
            responseData.setMessage("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)((String)response.getBody()));
        String successFlag = jsonObject.getString("successFlag");
        if ("0".equals(successFlag)) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u6570\u636e~");
            responseData.setData(new ArrayList());
            return responseData;
        }
        String data = jsonObject.getString("data");
        JSONObject dataJson = JSONObject.parseObject((String)data);
        Double yesteryearData = dataJson.getDouble("yesteryearData");
        Double lastData = dataJson.getDouble("lastData");
        Double currentData = dataJson.getDouble("currentData");
        Double useVouData = dataJson.getDouble("useVouData");
        Double elseData = dataJson.getDouble("elseData");
        Double yesterdayDataPercent = currentData == 0.0 || yesteryearData == 0.0 ? Double.valueOf(0.0) : Double.valueOf((currentData - yesteryearData) / yesteryearData * 100.0);
        Double lastDataPercent = currentData == 0.0 || lastData == 0.0 ? Double.valueOf(0.0) : Double.valueOf((currentData - lastData) / lastData * 100.0);
        singleSalesNum.setYesteryearData(this.eraseZero(yesteryearData));
        singleSalesNum.setLastData(this.eraseZero(lastData));
        singleSalesNum.setCurrentData(this.eraseZero(currentData));
        singleSalesNum.setUseVouData(this.eraseZero(useVouData));
        singleSalesNum.setElseData(this.eraseZero(elseData));
        singleSalesNum.setYesterdayDataPercent(this.eraseZero(yesterdayDataPercent) + "%");
        singleSalesNum.setLastDataPercent(this.eraseZero(lastDataPercent) + "%");
        responseData.setData((Object)singleSalesNum);
        return responseData;
    }

    public ResponseData singleSendWayList(CouponPartBo bo) {
        logger.info("SingleCoupleAnalysisServiceImpl singleSendWayList bo : {}", (Object)bo);
        ResponseData responseData = new ResponseData();
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(bo.getPageNumber());
        pageInfo.setPageSize(bo.getPageSize());
        DateConversionUtil dateConversionUtil = new DateConversionUtil();
        BigDataPartBo bigDataPartBo = new BigDataPartBo();
        bigDataPartBo.setApiKey(this.baseUrl.getApiKey());
        bigDataPartBo.setBusinessNum(this.baseUrl.getBusinessNum());
        SysCompanyPo sysCompanyPo = (SysCompanyPo)this.companyServiceRpc.getCompanyById(bo.getSysCompanyId()).getData();
        bigDataPartBo.setCorpId(sysCompanyPo.getCompanyCode());
        SysBrandPo sysBrandPo = (SysBrandPo)this.brandServiceRpc.getBrandByID(bo.getSysBrandId()).getData();
        bigDataPartBo.setBrandId(sysBrandPo.getBrandCode());
        bigDataPartBo = this.setBasicBigDataPartBoUtil.setBigDataPartBo(bigDataPartBo, bo);
        bigDataPartBo.setVouTypeId(bo.getVouTypeId());
        bigDataPartBo.setStartRecord("1");
        bigDataPartBo.setQueryNum(1000);
        String analysisUrl = this.baseUrl.url + "sendWayList";
        ResponseEntity response = null;
        String text = JSONObject.toJSONString((Object)bigDataPartBo);
        try {
            JSONObject bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            responseData.setCode(500);
            responseData.setMessage("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)((String)response.getBody()));
        String successFlag = jsonObject.getString("successFlag");
        if ("0".equals(successFlag)) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u6240\u6709\u6570\u636e:" + jsonObject.getString("message"));
            pageInfo.setList(new ArrayList());
            pageInfo.setTotal(0L);
            responseData.setData((Object)pageInfo);
            return responseData;
        }
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        Integer totalSize = jsonArray.size();
        pageInfo.setTotal((long)totalSize.intValue());
        bigDataPartBo.setQueryNum(bo.getPageSize());
        bigDataPartBo.setStartRecord(String.valueOf((bo.getPageNumber() - 1) * bo.getPageSize() + 1));
        ResponseEntity response1 = null;
        try {
            JSONObject bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
            response1 = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            responseData.setCode(500);
            responseData.setMessage("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        String body = (String)response1.getBody();
        logger.info("\u5206\u9875\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)body);
        JSONObject jsonObject1 = JSONObject.parseObject((String)body);
        String successFlag1 = jsonObject.getString("successFlag");
        if ("0".equals(successFlag1)) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u90e8\u5206\u6570\u636e:" + jsonObject.getString("message"));
            pageInfo.setList(new ArrayList());
            responseData.setData((Object)pageInfo);
            return responseData;
        }
        JSONArray jsonArray1 = jsonObject1.getJSONArray("data");
        ArrayList<SingleSendCouponWayBo> singleSendCouponWayBoList = new ArrayList<SingleSendCouponWayBo>();
        if (jsonArray1 != null) {
            for (int i = 0; i < jsonArray1.size(); ++i) {
                SingleSendCouponWayBo singleSendCouponWayBo = new SingleSendCouponWayBo();
                JSONObject mapObject = jsonArray1.getJSONObject(i);
                String sendCouponId = mapObject.getString("id");
                String sendCouponWay = SendTypeEnum.getValue((String)sendCouponId);
                Double sendCouponNum = mapObject.getDouble("totalTickets");
                Double salesVolume = mapObject.getDouble("salesVolume");
                Double saleRate = sendCouponNum == 0.0 || salesVolume == 0.0 ? Double.valueOf(0.0) : Double.valueOf(salesVolume / sendCouponNum * 100.0);
                Double achievements = mapObject.getDouble("achievements");
                Double penNumber = mapObject.getDouble("penNumber");
                Double clientPrice = achievements == 0.0 && penNumber == 0.0 ? Double.valueOf(0.0) : Double.valueOf(achievements / penNumber);
                String clientPriceString = this.df.format(clientPrice);
                BigDecimal pieceNumberBd = new BigDecimal(mapObject.getDouble("pieceNumber"));
                BigDecimal penNumberBd = new BigDecimal(mapObject.getDouble("penNumber"));
                String jointRate = salesVolume == 0.0 || penNumber == 0.0 ? "0.00" : pieceNumberBd.divide(penNumberBd, 2, 4).toString();
                Double discount = mapObject.getDouble("discount");
                Double ROI = achievements == 0.0 || discount == 0.0 ? Double.valueOf(0.0) : Double.valueOf(achievements / discount * 100.0);
                singleSendCouponWayBo.setSendCouponWay(sendCouponWay);
                singleSendCouponWayBo.setSendCouponNum(this.eraseZero(sendCouponNum));
                singleSendCouponWayBo.setSalesVolume(this.eraseZero(salesVolume));
                singleSendCouponWayBo.setSaleRate(this.eraseZero(saleRate) + "%");
                singleSendCouponWayBo.setClientPrice("\uffe5" + clientPriceString);
                singleSendCouponWayBo.setJointRate(jointRate);
                singleSendCouponWayBo.setAchievements("\uffe5" + this.df.format(achievements));
                singleSendCouponWayBo.setROI(this.eraseZero(ROI) + "%");
                singleSendCouponWayBoList.add(singleSendCouponWayBo);
            }
        }
        pageInfo.setList(singleSendCouponWayBoList);
        responseData.setData((Object)pageInfo);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public String eraseZero(Double number) {
        String numberString = this.df.format(number);
        if (numberString.indexOf(".") > 0) {
            numberString = numberString.replaceAll("0+?$", "");
            numberString = numberString.replaceAll("[.]$", "");
        }
        return numberString;
    }
}

