/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.rpc.SysOnlineOrgServcieRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.CouponBatchBindRequestVO;
import com.bizvane.connectorservice.entity.common.CouponBatchRequestVO;
import com.bizvane.connectorservice.entity.common.CouponBindRequestVO;
import com.bizvane.connectorservice.entity.common.CouponRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.ConnectorServiceFeign;
import com.bizvane.couponfacade.enums.CouponManualTaskStatusEnum;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.bo.CouponCodeWithPwd;
import com.bizvane.couponfacade.models.po.CouponBatchSendRecordPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponManualPO;
import com.bizvane.couponfacade.models.po.CouponSendFailLogPO;
import com.bizvane.couponfacade.models.vo.CouponStatusUpdateBatchRequestVO;
import com.bizvane.couponfacade.models.vo.ProductCategoryVO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleOldVO;
import com.bizvane.couponfacade.utils.TimeUtils;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.BusinessCodeUtil;
import com.bizvane.couponservice.common.utils.RedisLock;
import com.bizvane.couponservice.common.utils.StandardMessageUtil;
import com.bizvane.couponservice.mappers.CouponBatchSendRecordPOMapper;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.mappers.CouponManualPOMapper;
import com.bizvane.couponservice.mappers.CouponSendFailLogPOMapper;
import com.bizvane.couponservice.rocketmq.MQSendCouponService;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.CouponSendFailLogService;
import com.bizvane.couponservice.service.SendCouponMqService;
import com.bizvane.couponservice.service.ThirdBusinessService;
import com.bizvane.couponservice.service.impl.CouponMessageComponentServiceImpl;
import com.bizvane.members.facade.enums.DirectionEnum;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.Order;
import com.bizvane.members.facade.es.vo.SearchRangRequest;
import com.bizvane.members.facade.service.api.MembersAdvancedSearchApiService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.MemberInfoSimpleVO;
import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.messagefacade.interfaces.WechatCouponServiceFeign;
import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.bizvane.thirdrouting.bo.AsynBO;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SendCouponMqServiceImpl
implements SendCouponMqService {
    private static final Logger logger = LoggerFactory.getLogger(SendCouponMqServiceImpl.class);
    @Autowired
    private StringRedisTemplate rs;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    @Autowired
    private CouponSendFailLogPOMapper couponSendFailLogPOMapper;
    @Autowired
    private WechatCouponServiceFeign wechatCouponServiceFeign;
    @Autowired
    private CouponBatchSendRecordPOMapper couponBatchSendRecordPOMapper;
    @Autowired
    private MQSendCouponService mqSendCouponService;
    @Autowired
    private ConnectorServiceFeign connectorServiceFeign;
    @Autowired
    private MembersAdvancedSearchApiService membersAdvancedSearchApiService;
    @Lazy
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private CouponManualPOMapper couponManualPOMapper;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private CouponSendFailLogService couponSendFailLogService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private CouponEntityService couponEntityService;
    @Autowired
    private StandardMessageUtil standardMessageUtil;
    @Lazy
    @Autowired
    private SendCouponMqService sendCouponMqService;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    @Autowired
    private ThirdBusinessService thirdBusinessService;
    @Autowired
    private CouponMessageComponentServiceImpl couponMessageComponentService;
    private final Integer COUPON_ORG_LIMIT = 2;
    @Autowired
    private SysOnlineOrgServcieRpc sysOnlineOrgServcieRpc;
    @Autowired
    private RedisLock redisLock;

    public ResponseData<String> simpleOldcouponSave(SendCouponSimpleOldVO param) {
        logger.info("enter SendCouponServiceImplSimpleOldcoupon", (Object)JSONObject.toJSONString((Object)param));
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)param.getCouponCode())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)param.getErpCouponDefinitionCode())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)param.getErpId())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return responseData;
        }
        CouponDefinitionPOExample example = new CouponDefinitionPOExample();
        example.createCriteria().andErpCouponDefinitionCodeEqualTo(param.getErpCouponDefinitionCode());
        List definitionPOList = this.couponDefinitionPOMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)definitionPOList)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_DEFINITION_TYPE_NOT_EXISTS.getMessage());
            return responseData;
        }
        CouponEntityPO entityPO = new CouponEntityPO();
        CouponDefinitionPO definitionPO = (CouponDefinitionPO)definitionPOList.get(definitionPOList.size() - 1);
        List memberCodeList = this.couponEntityPOMapper.findMemberCode(param.getErpId(), definitionPO.getSysBrandId());
        if (CollectionUtils.isEmpty((Collection)memberCodeList)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.MEMBER_IS_EMPTY.getMessage());
            return responseData;
        }
        param.setMemberCode(((CouponEntityPO)memberCodeList.get(0)).getMemberCode());
        List couponEntityPOList = this.couponEntityPOMapper.findCouponCodeHave(param.getCouponCode());
        if (CollectionUtils.isNotEmpty((Collection)couponEntityPOList)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_CODE_HAVE.getMessage());
            return responseData;
        }
        Byte couponStatus = SystemConstants.COUPON_STATUS_USED;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            entityPO.setValidDateStart(sdf.parse(param.getStartTime()));
            entityPO.setValidDateEnd(sdf.parse(param.getEndTime()));
            if ("N".equals(param.getIsuse())) {
                couponStatus = SystemConstants.COUPON_STATUS_UNUSED;
            } else if (StringUtils.isNotEmpty((CharSequence)param.getUseTime())) {
                entityPO.setUseTime(sdf.parse(param.getUseTime()));
            }
        }
        catch (ParseException e) {
            logger.error("\u5f02\u5e38:", (Throwable)e);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.SYSTEM_ERROR_DATA.getMessage());
            return responseData;
        }
        param.setBusinessName("\u624b\u52a8\u540c\u6b65\u5238");
        param.setSendType(SendTypeEnum.SEND_COUPON_BATCH.getCode());
        entityPO.setCouponCode(param.getCouponCode());
        entityPO.setCouponDefinitionId(definitionPO.getCouponDefinitionId() + "");
        entityPO.setCouponBatchSendRecordId(definitionPO.getCouponDefinitionId());
        entityPO.setMemberCode(param.getMemberCode());
        entityPO.setCouponName(definitionPO.getCouponName());
        entityPO.setMoney(definitionPO.getMoney());
        entityPO.setDiscount(definitionPO.getDiscount());
        entityPO.setImg(definitionPO.getImg());
        entityPO.setInfo(definitionPO.getInfo());
        entityPO.setTransferSend(definitionPO.getTransferSend());
        entityPO.setTransferCouponDefinitionId(definitionPO.getTransferCouponDefinitionId());
        entityPO.setTransferInfo(definitionPO.getTransferInfo());
        entityPO.setBindStatus(SystemConstants.COUPON_BIND_STATUS_UNBIND);
        entityPO.setIsLock(SystemConstants.COUPON_STATUS_CHANGE_IS_UNLOCK);
        entityPO.setSendType(param.getSendType());
        entityPO.setSendBusinessId(param.getSendBussienId());
        entityPO.setRemark(definitionPO.getRemark());
        entityPO.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        entityPO.setPreferentialType(definitionPO.getPreferentialType());
        entityPO.setCreateDate(TimeUtils.getNowTime());
        entityPO.setModifiedDate(TimeUtils.getNowTime());
        entityPO.setBrandCode(definitionPO.getBrandCode());
        entityPO.setSysBrandId(definitionPO.getSysBrandId());
        entityPO.setSysCompanyId(definitionPO.getSysCompanyId());
        entityPO.setBusinessName(param.getBusinessName());
        entityPO.setCouponStatus(couponStatus);
        this.couponEntityPOMapper.insertSelective(entityPO);
        try {
            AsynBO asynBO = new AsynBO(entityPO.getSysCompanyId(), entityPO.getSysBrandId(), "couponSend", JSON.toJSONString((Object)entityPO));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("saveErpSendCouponEntity thirdBusinessService.asyn e {}", (Throwable)e);
        }
        return responseData;
    }

    @Async
    public ResponseData<String> sendCouponOnline(CouponDefinitionPO definitionPo, CouponEntityPO entityPo) {
        ResponseData responseData = new ResponseData();
        ResponseData publicPO = this.wxPublicServiceFeign.getWxPublicBySysBrandId(definitionPo.getSysBrandId());
        CouponMessageVO messageVO = new CouponMessageVO();
        messageVO.setUseTime(entityPo.getCreateDate());
        messageVO.setSysCompanyId(entityPo.getSysCompanyId());
        messageVO.setMemberCode(entityPo.getMemberCode());
        messageVO.setCouponCode(entityPo.getCouponCode());
        messageVO.setCouponName(entityPo.getCouponName());
        messageVO.setPreferentialType(entityPo.getPreferentialType() + "");
        messageVO.setDenomination(entityPo.getMoney() + "");
        messageVO.setValidDateStart(entityPo.getValidDateStart());
        messageVO.setValidDateEnd(entityPo.getValidDateEnd());
        messageVO.setSysBrandId(definitionPo.getSysBrandId());
        if (definitionPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_MONEY)) {
            messageVO.setDenomination(definitionPo.getMoney() + "");
        } else if (definitionPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_DISCOUNT)) {
            messageVO.setDenomination(definitionPo.getDiscount() + "");
        }
        messageVO.setSendType(entityPo.getSendType());
        messageVO.setSendBusinessId(entityPo.getSendBusinessId());
        WxChannelInfoVo channelVO = new WxChannelInfoVo();
        channelVO.setMemberCode(entityPo.getMemberCode());
        channelVO.setBrandId(entityPo.getSysBrandId());
        channelVO.setMiniProgram(Integer.valueOf(1));
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
        if (channelResult.getData() != null) {
            WxChannelInfoVo channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
            messageVO.setMemberName(channelInfoVo.getName());
            messageVO.setMemberPhone(channelInfoVo.getPhone());
            messageVO.setSendWxmember(channelInfoVo.getFocus() + "");
            messageVO.setSysCompanyId(channelInfoVo.getSysCompanyId());
            if (((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel() != null) {
                messageVO.setServiceStoreId(((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel().getServiceStoreId());
                messageVO.setAreaCode(((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel().getAreaCode());
            }
        }
        if (publicPO.getData() != null) {
            messageVO.setNickName(((WxPublicPO)publicPO.getData()).getNickName());
        }
        logger.info("enter SendCouponServiceImpl couponnoe method" + JSONObject.toJSONString((Object)messageVO) + JSONObject.toJSONString((Object)channelVO) + JSONObject.toJSONString((Object)((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo()));
        responseData = this.wechatCouponServiceFeign.couponReceive(messageVO);
        logger.info("\u8c03\u7528\u6d88\u606f\u6a21\u5757\u7684sendCouponOnline.couponMessageComponentService.couponReceive:{}", (Object)JSON.toJSONString((Object)messageVO));
        ResponseData subscribeResp = this.couponMessageComponentService.couponReceive(messageVO, definitionPo, entityPo.getValidDateStart(), entityPo.getValidDateEnd());
        logger.info("sendCouponOnline#CouponMessageComponentServiceImpl#couponReceive#subscribeResp:{}", (Object)JSON.toJSONString((Object)subscribeResp));
        logger.info("\u8c03\u7528standardMessageUtil.receiveCouponMessage:{}", (Object)JSON.toJSONString((Object)messageVO));
        this.standardMessageUtil.receiveCouponMessage(messageVO);
        return responseData;
    }

    public ResponseData<String> sendCouponOffline(CouponDefinitionPOWithBLOBs definitionPO, CouponEntityPO entityPO, Integer ifSendAgain) {
        ResponseData responseData = new ResponseData();
        CouponRequestVO erp = new CouponRequestVO();
        erp.setCouponDefinitionCode(definitionPO.getCouponDefinitionCode());
        erp.setCouponName(definitionPO.getCouponName());
        erp.setCouponCode(entityPO.getCouponCode());
        erp.setBindStatus(entityPO.getBindStatus());
        erp.setUsePassword(entityPO.getUsePassword());
        erp.setSendType(entityPO.getSendType());
        erp.setSendBusinessId(entityPO.getSendBusinessId());
        erp.setUseType(entityPO.getUseType());
        erp.setUseStoreId(entityPO.getUseStoreId());
        erp.setUseBusinessCode(entityPO.getUseBusinessCode());
        erp.setUseTime(entityPO.getUseTime());
        erp.setUse(entityPO.getIsUse());
        erp.setUseChannel(definitionPO.getUseChannel());
        erp.setPreferentialType(definitionPO.getPreferentialType());
        erp.setMoney(definitionPO.getMoney());
        erp.setDiscount(definitionPO.getDiscount() == null ? BigDecimal.ZERO : definitionPO.getDiscount());
        if (definitionPO.getValidType().equals(SystemConstants.VALID_TYPE__SOMEDAY)) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, definitionPO.getValidDay());
            definitionPO.setValidDateStart(TimeUtils.getNowTime());
            definitionPO.setValidDateEnd(calendar.getTime());
        } else if (SystemConstants.VALID_TYPE_DELAY.equals(definitionPO.getValidType())) {
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate startDate = LocalDate.now().plusDays(definitionPO.getDelayDay().intValue());
            LocalDateTime validDateStart = startDate.atTime(0, 0, 0);
            ZonedDateTime startTime = validDateStart.atZone(zoneId);
            LocalDate endDate = startDate.plusDays((long)definitionPO.getDelayValidDay().intValue() - 1L);
            LocalDateTime validEndDate = endDate.atTime(23, 59, 59);
            ZonedDateTime endTime = validEndDate.atZone(zoneId);
            entityPO.setValidDateStart(Date.from(startTime.toInstant()));
            entityPO.setValidDateEnd(Date.from(endTime.toInstant()));
        }
        erp.setValidDateStart(definitionPO.getValidDateStart());
        erp.setValidDateEnd(definitionPO.getValidDateEnd());
        erp.setQrCode(definitionPO.getQrCode());
        erp.setImg(definitionPO.getImg());
        erp.setPerMaxNum(definitionPO.getPerMaxNum());
        erp.setRealName(definitionPO.getIsRealName());
        erp.setTransfer(definitionPO.getIsTransfer());
        erp.setActivitySuperpositionBlackList(definitionPO.getActivitySuperpositionBlackList());
        erp.setActivitySuperpositionWhiteList(definitionPO.getActivitySuperpositionWhiteList());
        erp.setSuperposition(definitionPO.getIsSuperposition());
        erp.setTagPriceLimit(definitionPO.getIsTagPriceLimit());
        erp.setMinConsume(definitionPO.getMinConsume());
        erp.setCouponSaleAmount(definitionPO.getCouponSaleAmount());
        erp.setMaxPreferential(definitionPO.getMaxPreferential());
        erp.setMinCommodityNum(definitionPO.getMinCommodityNum());
        erp.setMaxCommodityNum(definitionPO.getMaxCommodityNum());
        erp.setMinDiscount(definitionPO.getMinDiscount());
        erp.setApplianceCommodityType(definitionPO.getApplianceCommodityType());
        erp.setApplianceStoreType(definitionPO.getApplianceStoreType());
        erp.setCommodityWhitelist(definitionPO.getCommodityWhitelist());
        erp.setCommodityBlacklist(definitionPO.getCommodityBlacklist());
        erp.setStoreWhitelist(definitionPO.getStoreWhitelist());
        erp.setStoreBlacklist(definitionPO.getStoreBlacklist());
        erp.setBrandId(definitionPO.getSysBrandId());
        WxChannelInfoVo channelVO = new WxChannelInfoVo();
        channelVO.setMemberCode(entityPO.getMemberCode());
        channelVO.setBrandId(entityPO.getSysBrandId());
        channelVO.setMiniProgram(Integer.valueOf(1));
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
        WxChannelInfoVo channelInfoVo = null;
        if (channelResult.getData() != null) {
            channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
            erp.setMemberCode(channelInfoVo.getOfflineCardNo());
            erp.setErpId(channelInfoVo.getErpId());
        }
        logger.info("enter hhhhhhhhh SendCouponServiceImpl sendCouponOffline:param:{}", (Object)(JSONObject.toJSONString((Object)erp) + JSONObject.toJSONString((Object)channelResult)));
        erp.setIdReissue(ifSendAgain);
        erp.setGoodsCondition(definitionPO.getGoodsCondition());
        String offlinePrdCode = definitionPO.getOfflinePrdCode();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{offlinePrdCode})) {
            List productCategoryVOS = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
            for (ProductCategoryVO productCategoryVO : productCategoryVOS) {
                String prdParentName = productCategoryVO.getPrdParentName();
                String str = productCategoryVO.getStr();
                if ("\u5927\u7c7b".equals(prdParentName)) {
                    erp.setBigCategory(str);
                    continue;
                }
                if ("\u4e2d\u7c7b".equals(prdParentName)) {
                    erp.setMiddleCategory(str);
                    continue;
                }
                if ("\u5c0f\u7c7b".equals(prdParentName)) {
                    erp.setSmallCategory(str);
                    continue;
                }
                if ("\u5e74\u4efd".equals(prdParentName)) {
                    erp.setParticularYear(str);
                    continue;
                }
                if (!"\u5b63\u8282".equals(prdParentName)) continue;
                erp.setSeason(str);
            }
        }
        String offlineOrgCodes = "";
        if (StringUtils.isNotBlank((CharSequence)definitionPO.getOrganizationCode())) {
            logger.info("enter SendCouponMqServiceImpl sendCouponOffline:sysCompanyId:{},organizationCode:{}", (Object)definitionPO.getSysCompanyId(), (Object)definitionPO.getOrganizationCode());
            offlineOrgCodes = this.couponDefinitionPOMapper.selectOfflineOrgCodesByOnline(definitionPO.getSysCompanyId(), definitionPO.getOrganizationCode());
        }
        erp.setOfflineOrgCodes(offlineOrgCodes);
        Result result = new Result();
        if (definitionPO.getCouponDefinitionType().equals((byte)2)) {
            ResponseData listResponseData;
            CouponBindRequestVO couponBindRequestVO = new CouponBindRequestVO();
            couponBindRequestVO.setBrandId(erp.getBrandId());
            couponBindRequestVO.setCouponCode(erp.getCouponCode());
            couponBindRequestVO.setErpId(channelInfoVo.getErpId());
            couponBindRequestVO.setOfflineCardNo(erp.getMemberCode());
            couponBindRequestVO.setIsReissue(erp.getIdReissue());
            couponBindRequestVO.setBigCategory(erp.getBigCategory());
            couponBindRequestVO.setMiddleCategory(erp.getMiddleCategory());
            couponBindRequestVO.setSmallCategory(erp.getSmallCategory());
            couponBindRequestVO.setParticularYear(erp.getParticularYear());
            couponBindRequestVO.setSeason(erp.getSeason());
            couponBindRequestVO.setOfflineOrgCodes(erp.getOfflineOrgCodes());
            if (this.COUPON_ORG_LIMIT.equals(definitionPO.getApplianceOrgType()) && StringUtils.isNotBlank((CharSequence)definitionPO.getApplianceOrgCodes()) && (listResponseData = this.sysOnlineOrgServcieRpc.queryOfflineOrgCodes(definitionPO.getSysCompanyId(), definitionPO.getApplianceOrgCodes())) != null && CollectionUtils.isNotEmpty((Collection)((Collection)listResponseData.getData()))) {
                String codes = ((List)listResponseData.getData()).stream().collect(Collectors.joining(","));
                couponBindRequestVO.setCouponDefOrgOfflineCodes(codes);
            }
            String success = "0";
            logger.info("enter uuuuuuuuuusingleCouponBind:" + erp.getCouponCode() + "  MemberCode:" + erp.getMemberCode() + "  ErpId:" + channelInfoVo.getErpId() + JSONObject.toJSONString((Object)couponBindRequestVO));
            if (StringUtils.isNotBlank((CharSequence)couponBindRequestVO.getCouponCode()) && !success.equals(couponBindRequestVO.getCouponCode())) {
                result = this.connectorServiceFeign.singleCouponBind(couponBindRequestVO);
            } else {
                logger.info("enter uuuuuuuuuusingleCouponBin\uff1a\u6ca1\u6709\u5238\u53f7\u4e86:" + erp.getMemberCode());
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            }
        } else {
            result = this.connectorServiceFeign.singlecoupon(erp);
        }
        logger.info("enter uuuuuuuuuuuuuuuuuu SendCouponServiceImpl sendCouponOffline:param 1:{}", (Object)JSONObject.toJSONString((Object)result));
        if (SysResponseEnum.SUCCESS.getCode() != result.getCode().intValue() && erp.getIdReissue().equals(SystemConstants.COUPON_SEND_AGAIN_NO)) {
            this.couponSendFailLogService.saveCouponSendFailLog((CouponDefinitionPO)definitionPO, entityPO, result.getMessage());
        }
        if (SysResponseEnum.SUCCESS.getCode() != result.getCode().intValue() && erp.getIdReissue().equals(SystemConstants.COUPON_SEND_AGAIN_YES)) {
            if (definitionPO.getCouponDefinitionType().equals((byte)2)) {
                this.couponSendFailLogService.updateSendStatus(SystemConstants.COUPON_SEND_NO, entityPO.getCouponEntityId(), result.getMessage());
            } else {
                this.couponSendFailLogService.updateSendStatus(SystemConstants.COUPON_SEND_NO, entityPO.getCouponCode(), result.getMessage());
            }
        }
        return responseData;
    }

    public List<CouponEntityPO> saveEntityList(CouponDefinitionPOWithBLOBs definitionPo, SendCouponBatchRequestVO requestVo, Long batchId, Byte couponStatus) {
        logger.info("enter SendCouponMQServiceImpl saveEntityList method");
        List memberList = requestVo.getMemberListManual();
        ArrayList<CouponEntityPO> entityPOList = new ArrayList<CouponEntityPO>();
        for (int i = 0; i < memberList.size(); ++i) {
            String couponCode = BusinessCodeUtil.getCouponCodeForSysCompany((Long)definitionPo.getSysCompanyId(), (String)definitionPo.getErpCouponDefinitionCode());
            CouponEntityPO entityPO = new CouponEntityPO();
            if (definitionPo.getCouponDefinitionType().equals((byte)2)) {
                ResponseData couponCodeWithPwdResponseData = this.couponManualService.getCouponCodeWithPwd(definitionPo.getCouponDefinitionId(), definitionPo.getSysBrandId());
                if (couponCodeWithPwdResponseData.getCode() == 0) {
                    couponCode = ((CouponCodeWithPwd)couponCodeWithPwdResponseData.getData()).getCouponCode();
                    entityPO.setUsePassword(((CouponCodeWithPwd)couponCodeWithPwdResponseData.getData()).getUsePwd());
                } else {
                    logger.info("enter SendCouponServiceImpl saveEntityList method \u6ca1\u6709\u5238\u53f7\u4e86,\u9ed8\u8ba4\u7ed9\u4e2a\u5047\u7684\u5238\u53f7");
                    couponCode = BusinessCodeUtil.getCouponCodeFalseCode();
                }
            }
            entityPO.setCouponCode(couponCode);
            entityPO.setSysCompanyId(definitionPo.getSysCompanyId());
            entityPO.setSysBrandId(definitionPo.getSysBrandId());
            entityPO.setBrandCode(definitionPo.getBrandCode());
            entityPO.setCouponDefinitionId(definitionPo.getCouponDefinitionId() + "");
            entityPO.setCouponBatchSendRecordId(batchId);
            entityPO.setMemberCode(((MemberInfoSimpleVO)memberList.get(i)).getMemberCode());
            ((MemberInfoSimpleVO)memberList.get(i)).getCardNo();
            entityPO.setCouponName(definitionPo.getCouponName());
            entityPO.setMoney(definitionPo.getMoney());
            entityPO.setDiscount(definitionPo.getDiscount());
            entityPO.setImg(definitionPo.getImg());
            entityPO.setInfo(definitionPo.getInfo());
            entityPO.setBindStatus(SystemConstants.COUPON_BIND_STATUS_UNBIND);
            Calendar calendar = Calendar.getInstance();
            if (definitionPo.getValidType().equals(SystemConstants.VALID_TYPE__SOMEDAY)) {
                calendar.add(5, definitionPo.getValidDay());
                calendar.set(11, 23);
                calendar.set(13, 59);
                calendar.set(12, 59);
                calendar.set(14, 59);
                entityPO.setValidDateStart(TimeUtils.getNowTime());
                entityPO.setValidDateEnd(calendar.getTime());
            } else if (SystemConstants.VALID_TYPE_DELAY.equals(definitionPo.getValidType())) {
                ZoneId zoneId = ZoneId.systemDefault();
                LocalDate startDate = LocalDate.now().plusDays(definitionPo.getDelayDay().intValue());
                LocalDateTime validDateStart = startDate.atTime(0, 0, 0);
                ZonedDateTime startTime = validDateStart.atZone(zoneId);
                LocalDate endDate = startDate.plusDays((long)definitionPo.getDelayValidDay().intValue() - 1L);
                LocalDateTime validEndDate = endDate.atTime(23, 59, 59);
                ZonedDateTime endTime = validEndDate.atZone(zoneId);
                entityPO.setValidDateStart(Date.from(startTime.toInstant()));
                entityPO.setValidDateEnd(Date.from(endTime.toInstant()));
            } else {
                entityPO.setValidDateStart(definitionPo.getValidDateStart());
                calendar.setTime(definitionPo.getValidDateEnd());
                calendar.set(11, 23);
                calendar.set(13, 59);
                calendar.set(12, 59);
                calendar.set(14, 59);
                entityPO.setValidDateEnd(calendar.getTime());
            }
            entityPO.setIsLock(SystemConstants.COUPON_STATUS_CHANGE_IS_UNLOCK);
            entityPO.setSendType(requestVo.getBusinessType());
            entityPO.setSendBusinessId(requestVo.getBusinessId());
            entityPO.setIsUse(SystemConstants.COUPON_USE_UNUSED);
            entityPO.setCouponStatus(couponStatus);
            entityPO.setInfo(definitionPo.getInfo());
            entityPO.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
            entityPO.setPreferentialType(definitionPo.getPreferentialType());
            entityPO.setCreateDate(TimeUtils.getNowTime());
            entityPO.setModifiedDate(TimeUtils.getNowTime());
            entityPO.setCreateUserId(requestVo.getCreateUserId());
            entityPO.setCreateUserName(requestVo.getCreateUserName());
            entityPO.setBusinessName(requestVo.getBusinessName());
            entityPO.setCouponBatchSendRecordId(definitionPo.getBatchSendCodeDetail());
            entityPO.setTransferSend(definitionPo.getTransferSend());
            entityPO.setTransferCouponDefinitionId(definitionPo.getTransferCouponDefinitionId());
            entityPO.setTransferInfo(definitionPo.getTransferInfo());
            entityPOList.add(entityPO);
        }
        if (!CollectionUtils.isEmpty(entityPOList)) {
            this.couponEntityPOMapper.insertBatch(entityPOList);
            for (CouponEntityPO entityPO : entityPOList) {
                try {
                    AsynBO asynBO = new AsynBO(entityPO.getSysCompanyId(), entityPO.getSysBrandId(), "couponSend", JSON.toJSONString((Object)entityPO));
                    this.thirdBusinessService.asyn(asynBO);
                }
                catch (Exception e) {
                    logger.error("couponinsertBatch thirdBusinessService.asyn e {}", (Throwable)e);
                }
            }
        }
        return entityPOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<CouponEntityPO> onLine(CouponDefinitionPOWithBLOBs definitionPo, SendCouponBatchRequestVO requestVo, CouponBatchSendRecordPO batchPo, Byte couponStatus) {
        String key = "coupon:mqConsumer:onLine:create:" + definitionPo.getCouponDefinitionId() + "::" + requestVo.getBatchSendCodeDetail() + "::" + ((MemberInfoSimpleVO)requestVo.getMemberListManual().get(0)).getMemberCode();
        if (this.redisTemplate.opsForValue().get((Object)key) != null) {
            return null;
        }
        List entityPOList = this.sendCouponMqService.saveEntityList(definitionPo, requestVo, batchPo.getCouponBatchSendRecordId(), couponStatus);
        if (SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(batchPo.getBizType()) && !CollectionUtils.isEmpty((Collection)entityPOList)) {
            this.couponManualService.findAndUpdateTaskStatus(requestVo.getTotalNumber().intValue(), entityPOList.size(), requestVo.getCouponManualId());
        }
        if (!this.redisLock.setNx(key, 259200L)) {
            logger.error("\u5238\u91cd\u590d\u53d1\u653e:" + key);
            throw new BizException(-1, "\u5238\u91cd\u590d\u53d1\u653e");
        }
        return entityPOList;
    }

    @Transactional
    public List<CouponEntityPO> allChannelOnLine(CouponDefinitionPOWithBLOBs definitionPO, SendCouponBatchRequestVO requestVO, CouponBatchSendRecordPO batchPO, Byte couponStatus) {
        String key = "coupon:mqConsumer:allChannel:onLine:create:" + definitionPO.getCouponDefinitionId() + ":" + requestVO.getBatchSendCodeDetail() + ":" + ((MemberInfoSimpleVO)requestVO.getMemberListManual().get(0)).getMemberCode();
        if (this.redisTemplate.opsForValue().get((Object)key) != null) {
            return null;
        }
        List entityPOList = this.sendCouponMqService.saveEntityList(definitionPO, requestVO, batchPO.getCouponBatchSendRecordId(), couponStatus);
        if (!this.redisLock.setNx(key, 259200L)) {
            logger.error("\u5238\u91cd\u590d\u53d1\u653e:" + key);
            throw new BizException(-1, "\u5238\u91cd\u590d\u53d1\u653e");
        }
        return entityPOList;
    }

    @Async
    public ResponseData<String> sendCouponBatchOnline(CouponDefinitionPO definitionPo, List<CouponEntityPO> entityPoList) {
        logger.info("enter SendCouponServiceImpl sendCouponBatchOnline method");
        ResponseData responseData = new ResponseData();
        ResponseData publicPO = this.wxPublicServiceFeign.getWxPublicBySysBrandId(definitionPo.getSysBrandId());
        for (int i = 0; i < entityPoList.size(); ++i) {
            CouponMessageVO messageVO = new CouponMessageVO();
            messageVO.setUseTime(entityPoList.get(i).getCreateDate());
            messageVO.setSysCompanyId(entityPoList.get(i).getSysCompanyId());
            messageVO.setMemberCode(entityPoList.get(i).getMemberCode());
            messageVO.setCouponCode(entityPoList.get(i).getCouponCode());
            messageVO.setCouponName(definitionPo.getCouponName());
            messageVO.setPreferentialType(definitionPo.getPreferentialType() + "");
            if (definitionPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_MONEY)) {
                messageVO.setDenomination(definitionPo.getMoney() + "");
            } else if (definitionPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_DISCOUNT)) {
                messageVO.setDenomination(definitionPo.getDiscount() + "");
            }
            messageVO.setValidDateStart(entityPoList.get(i).getValidDateStart());
            messageVO.setValidDateEnd(entityPoList.get(i).getValidDateEnd());
            messageVO.setSysBrandId(entityPoList.get(i).getSysBrandId());
            messageVO.setSendType(entityPoList.get(i).getSendType());
            messageVO.setSendBusinessId(entityPoList.get(i).getSendBusinessId());
            WxChannelInfoVo channelVO = new WxChannelInfoVo();
            channelVO.setMemberCode(entityPoList.get(i).getMemberCode());
            channelVO.setBrandId(entityPoList.get(i).getSysBrandId());
            channelVO.setMiniProgram(Integer.valueOf(1));
            ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
            if (channelResult.getData() != null) {
                WxChannelInfoVo channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
                messageVO.setMemberName(channelInfoVo.getName());
                messageVO.setMemberPhone(channelInfoVo.getPhone());
                messageVO.setSendWxmember(channelInfoVo.getFocus() + "");
                messageVO.setSysCompanyId(channelInfoVo.getSysCompanyId());
                if (((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel() != null) {
                    messageVO.setServiceStoreId(((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel().getServiceStoreId());
                    messageVO.setAreaCode(((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel().getAreaCode());
                }
            }
            if (publicPO.getData() != null) {
                messageVO.setNickName(((WxPublicPO)publicPO.getData()).getNickName());
            }
            logger.info("enter SendCouponServiceImpl couponReceive method1" + JSONObject.toJSONString((Object)messageVO) + JSONObject.toJSONString((Object)channelVO) + JSONObject.toJSONString((Object)((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo()));
            ResponseData sendOnlineResult = this.wechatCouponServiceFeign.couponReceive(messageVO);
            logger.info("\u8c03\u7528\u6d88\u606f\u6a21\u5757\u7684sendCouponBatchOnline.couponMessageComponentService.couponReceive:{}", (Object)JSON.toJSONString((Object)messageVO));
            ResponseData subscribeResp = this.couponMessageComponentService.couponReceive(messageVO, definitionPo, entityPoList.get(i).getValidDateStart(), entityPoList.get(i).getValidDateEnd());
            logger.info("sendCouponBatchOnline#CouponMessageComponentServiceImpl#couponReceive#subscribeResp:{}", (Object)JSON.toJSONString((Object)subscribeResp));
            logger.info("\u8c03\u7528sendCouponBatchOnline.standardMessageUtil.receiveCouponMessage1:{}", (Object)JSON.toJSONString((Object)messageVO));
            this.standardMessageUtil.receiveCouponMessage(messageVO);
        }
        return responseData;
    }

    public ResponseData<CouponStatusUpdateBatchRequestVO> sendCouponBatchOfflineSync(CouponDefinitionPOWithBLOBs definitionPo, List<CouponEntityPO> entityPoList, CouponBatchSendRecordPO batchPo, SendCouponBatchRequestVO requestVo) {
        Result result;
        ResponseData listResponseData;
        logger.info("enter sendCouponBatchOffline mq:{}" + JSONObject.toJSONString(entityPoList) + "----" + JSON.toJSONString((Object)definitionPo));
        ResponseData responseData = new ResponseData();
        ArrayList<CouponRequestVO> erpList = new ArrayList<CouponRequestVO>();
        ArrayList<String> failCouponCodeList = new ArrayList<String>();
        HashMap erpMap = new HashMap();
        HashMap carNoMap = new HashMap();
        if (requestVo.getMemberListManual() != null) {
            requestVo.getMemberListManual().forEach(vo -> {
                carNoMap.put(vo.getMemberCode(), vo.getOfflineCardNo());
                erpMap.put(vo.getOfflineCardNo(), vo.getErpId());
            });
        }
        String offlineOrgCodes = "";
        if (StringUtils.isNotBlank((CharSequence)definitionPo.getOrganizationCode())) {
            logger.info("enter SendCouponMqServiceImpl sendCouponBatchOfflineSync:sysCompanyId:{},organizationCode:{}", (Object)definitionPo.getSysCompanyId(), (Object)definitionPo.getOrganizationCode());
            offlineOrgCodes = this.couponDefinitionPOMapper.selectOfflineOrgCodesByOnline(definitionPo.getSysCompanyId(), definitionPo.getOrganizationCode());
        }
        String couponDefOrgOfflineCodes = "";
        if (this.COUPON_ORG_LIMIT.equals(definitionPo.getApplianceOrgType()) && StringUtils.isNotBlank((CharSequence)definitionPo.getApplianceOrgCodes()) && (listResponseData = this.sysOnlineOrgServcieRpc.queryOfflineOrgCodes(definitionPo.getSysCompanyId(), definitionPo.getApplianceOrgCodes())) != null && CollectionUtils.isNotEmpty((Collection)((Collection)listResponseData.getData()))) {
            couponDefOrgOfflineCodes = String.join((CharSequence)",", (Iterable)listResponseData.getData());
        }
        for (int i = 0; i < entityPoList.size(); ++i) {
            Object validDateStart;
            failCouponCodeList.add(entityPoList.get(i).getCouponCode());
            CouponRequestVO erp = new CouponRequestVO();
            if (requestVo.getType() == 1) {
                erp.setType("1");
            }
            erp.setCouponDefinitionCode(definitionPo.getErpCouponDefinitionCode());
            erp.setCouponName(definitionPo.getCouponName());
            erp.setCouponCode(entityPoList.get(i).getCouponCode());
            erp.setBindStatus(entityPoList.get(i).getBindStatus());
            erp.setUsePassword(entityPoList.get(i).getUsePassword());
            erp.setSendType(entityPoList.get(i).getSendType());
            erp.setSendBusinessId(entityPoList.get(i).getSendBusinessId());
            erp.setUseType(entityPoList.get(i).getUseType());
            erp.setUseStoreId(entityPoList.get(i).getUseStoreId());
            erp.setUseBusinessCode(entityPoList.get(i).getUseBusinessCode());
            erp.setUseTime(entityPoList.get(i).getUseTime());
            erp.setUse(entityPoList.get(i).getIsUse());
            erp.setUseChannel(definitionPo.getUseChannel());
            erp.setPreferentialType(definitionPo.getPreferentialType());
            erp.setMoney(definitionPo.getMoney());
            erp.setDiscount(definitionPo.getDiscount());
            erp.setSendCouponUserName(entityPoList.get(i).getCreateUserName());
            if (definitionPo.getValidType().equals(SystemConstants.VALID_TYPE__SOMEDAY)) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, definitionPo.getValidDay());
                definitionPo.setValidDateStart(TimeUtils.getNowTime());
                definitionPo.setValidDateEnd(calendar.getTime());
            } else if (SystemConstants.VALID_TYPE_DELAY.equals(definitionPo.getValidType())) {
                ZoneId zoneId = ZoneId.systemDefault();
                LocalDate startDate = LocalDate.now().plusDays(definitionPo.getDelayDay().intValue());
                validDateStart = startDate.atTime(0, 0, 0);
                ZonedDateTime startTime = ((LocalDateTime)validDateStart).atZone(zoneId);
                LocalDate endDate = startDate.plusDays((long)definitionPo.getDelayValidDay().intValue() - 1L);
                LocalDateTime validEndDate = endDate.atTime(23, 59, 59);
                ZonedDateTime endTime = validEndDate.atZone(zoneId);
                definitionPo.setValidDateStart(Date.from(startTime.toInstant()));
                definitionPo.setValidDateEnd(Date.from(endTime.toInstant()));
            }
            erp.setValidDateStart(definitionPo.getValidDateStart());
            erp.setValidDateEnd(definitionPo.getValidDateEnd());
            erp.setQrCode(definitionPo.getQrCode());
            erp.setImg(definitionPo.getImg());
            erp.setPerMaxNum(definitionPo.getPerMaxNum());
            erp.setRealName(definitionPo.getIsRealName());
            erp.setTransfer(definitionPo.getIsTransfer());
            erp.setActivitySuperpositionBlackList(definitionPo.getActivitySuperpositionBlackList());
            erp.setActivitySuperpositionWhiteList(definitionPo.getActivitySuperpositionWhiteList());
            erp.setSuperposition(definitionPo.getIsSuperposition());
            erp.setTagPriceLimit(definitionPo.getIsTagPriceLimit());
            erp.setMinConsume(definitionPo.getMinConsume());
            erp.setCouponSaleAmount(definitionPo.getCouponSaleAmount());
            erp.setMaxPreferential(definitionPo.getMaxPreferential());
            erp.setMinCommodityNum(definitionPo.getMinCommodityNum());
            erp.setMaxCommodityNum(definitionPo.getMaxCommodityNum());
            erp.setMinDiscount(definitionPo.getMinDiscount());
            erp.setApplianceCommodityType(definitionPo.getApplianceCommodityType());
            erp.setApplianceStoreType(definitionPo.getApplianceStoreType());
            erp.setCommodityWhitelist(definitionPo.getCommodityWhitelist());
            erp.setCommodityBlacklist(definitionPo.getCommodityBlacklist());
            erp.setStoreWhitelist(definitionPo.getStoreWhitelist());
            erp.setStoreBlacklist(definitionPo.getStoreBlacklist());
            if (SystemConstants.USE_CHANNEL_EMP.equals(definitionPo.getUseChannel())) {
                logger.info("\u5458\u5de5\u5238\uff0c\u5458\u5de5\u7f16\u53f7:" + JSONObject.toJSONString((Object)entityPoList.get(i)));
                erp.setMemberCode(entityPoList.get(i).getMemberCode());
            } else {
                erp.setMemberCode((String)carNoMap.get(entityPoList.get(i).getMemberCode()));
            }
            erp.setErpId((String)erpMap.get(carNoMap.get(entityPoList.get(i).getMemberCode())));
            erp.setOfflineOrgCodes(offlineOrgCodes);
            erp.setCouponDefOrgOfflineCodes(couponDefOrgOfflineCodes);
            erp.setGoodsCondition(definitionPo.getGoodsCondition());
            String offlinePrdCode = definitionPo.getOfflinePrdCode();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{offlinePrdCode})) {
                List productCategoryVOS = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
                validDateStart = productCategoryVOS.iterator();
                while (validDateStart.hasNext()) {
                    ProductCategoryVO productCategoryVO = (ProductCategoryVO)validDateStart.next();
                    String prdParentName = productCategoryVO.getPrdParentName();
                    String str = productCategoryVO.getStr();
                    if ("\u5927\u7c7b".equals(prdParentName)) {
                        erp.setBigCategory(str);
                        continue;
                    }
                    if ("\u4e2d\u7c7b".equals(prdParentName)) {
                        erp.setMiddleCategory(str);
                        continue;
                    }
                    if ("\u5c0f\u7c7b".equals(prdParentName)) {
                        erp.setSmallCategory(str);
                        continue;
                    }
                    if ("\u5e74\u4efd".equals(prdParentName)) {
                        erp.setParticularYear(str);
                        continue;
                    }
                    if (!"\u5b63\u8282".equals(prdParentName)) continue;
                    erp.setSeason(str);
                }
            }
            erpList.add(erp);
        }
        CouponBatchRequestVO batchVO = new CouponBatchRequestVO();
        batchVO.setList(erpList);
        batchVO.setBrandId(definitionPo.getSysBrandId());
        batchVO.setBatchCode(batchPo.getBatchSendCode());
        batchVO.setOfflineOrgCodes(offlineOrgCodes);
        batchVO.setCouponDefOrgOfflineCodes(couponDefOrgOfflineCodes);
        batchVO.setGoodsCondition(definitionPo.getGoodsCondition());
        batchVO.setIsReissue(SystemConstants.COUPON_SEND_AGAIN_NO);
        logger.info("enter  connectorServiceFeign sendCouponBatchOffline:param:{}", (Object)JSONObject.toJSONString((Object)batchVO));
        batchVO.setGoodsCondition(definitionPo.getGoodsCondition());
        String offlinePrdCode = definitionPo.getOfflinePrdCode();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{offlinePrdCode})) {
            List productCategoryVOS = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
            for (ProductCategoryVO productCategoryVO : productCategoryVOS) {
                String prdParentName = productCategoryVO.getPrdParentName();
                String str = productCategoryVO.getStr();
                if ("\u5927\u7c7b".equals(prdParentName)) {
                    batchVO.setBigCategory(str);
                    continue;
                }
                if ("\u4e2d\u7c7b".equals(prdParentName)) {
                    batchVO.setMiddleCategory(str);
                    continue;
                }
                if ("\u5c0f\u7c7b".equals(prdParentName)) {
                    batchVO.setSmallCategory(str);
                    continue;
                }
                if ("\u5e74\u4efd".equals(prdParentName)) {
                    batchVO.setParticularYear(str);
                    continue;
                }
                if (!"\u5b63\u8282".equals(prdParentName)) continue;
                batchVO.setSeason(str);
            }
        }
        if (definitionPo.getCouponDefinitionType().equals((byte)2)) {
            result = new Result();
            try {
                CouponBatchBindRequestVO couponBatchBindRequestVO = new CouponBatchBindRequestVO();
                couponBatchBindRequestVO.setBrandId(batchVO.getBrandId());
                couponBatchBindRequestVO.setBatchCode(batchVO.getBatchCode());
                couponBatchBindRequestVO.setIsReissue(SystemConstants.COUPON_SEND_AGAIN_NO);
                ArrayList<CouponBindRequestVO> couponBindRequestVOList = new ArrayList<CouponBindRequestVO>();
                for (CouponRequestVO erp : batchVO.getList()) {
                    CouponBindRequestVO couponBindRequestVO = new CouponBindRequestVO();
                    couponBindRequestVO.setErpCouponDefinitionCode(definitionPo.getErpCouponDefinitionCode());
                    couponBindRequestVO.setBrandId(erp.getBrandId());
                    couponBindRequestVO.setCouponCode(erp.getCouponCode());
                    couponBindRequestVO.setErpId((String)erpMap.get(erp.getMemberCode()));
                    couponBindRequestVO.setOfflineCardNo(erp.getMemberCode());
                    couponBindRequestVO.setIsReissue(SystemConstants.COUPON_SEND_AGAIN_NO);
                    couponBindRequestVO.setBigCategory(erp.getBigCategory());
                    couponBindRequestVO.setMiddleCategory(erp.getMiddleCategory());
                    couponBindRequestVO.setSmallCategory(erp.getSmallCategory());
                    couponBindRequestVO.setParticularYear(erp.getParticularYear());
                    couponBindRequestVO.setSeason(erp.getSeason());
                    couponBindRequestVO.setOfflineOrgCodes(erp.getOfflineOrgCodes());
                    couponBindRequestVO.setCouponDefOrgOfflineCodes(couponDefOrgOfflineCodes);
                    couponBindRequestVO.setSendCouponUserName(erp.getSendCouponUserName());
                    couponBindRequestVOList.add(couponBindRequestVO);
                }
                couponBatchBindRequestVO.setList(couponBindRequestVOList);
                logger.info("enter SendCouponServiceImpl connectorServiceFeignBatchCouponBind batchCouponBindSync:param:{}", (Object)JSONObject.toJSONString((Object)couponBatchBindRequestVO));
                logger.info("\u5f00\u59cb\u8c03\u7528connectorServiceFeign\u670d\u52a1-batchCouponBindSync param : {}", (Object)JSONObject.toJSONString((Object)couponBatchBindRequestVO));
                Result batchCouponBindSyncResult = this.connectorServiceFeign.batchCouponBindSync(couponBatchBindRequestVO);
                logger.info("enter wwwwwwwwwwwwwwwwwwwwwwww SendCouponServiceImpl batchCouponBindSync:result:{}", (Object)JSONObject.toJSONString((Object)batchCouponBindSyncResult));
                if (SysResponseEnum.SUCCESS.getCode() != batchCouponBindSyncResult.getCode().intValue() && batchVO.getIsReissue().equals(SystemConstants.COUPON_SEND_AGAIN_NO)) {
                    logger.info("enter failCouponCodeList:{},batchPO:{}", (Object)JSONObject.toJSONString(failCouponCodeList), (Object)JSONObject.toJSONString((Object)batchPo));
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    this.sendCouponBatchOfflineFail(failCouponCodeList, batchPo, batchCouponBindSyncResult.getMessage());
                }
                try {
                    this.couponEntityService.updateCouponStatusBatch(requestVo, (CouponStatusUpdateBatchRequestVO)batchCouponBindSyncResult.getTData());
                }
                catch (RuntimeException e) {
                    logger.error("\u5904\u7406\u7ebf\u4e0b\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
                    logger.error(e.getMessage());
                }
            }
            catch (Exception e) {
                logger.error("\u5f02\u5e38:", (Throwable)e);
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("connectorServiceFeign \u540c\u6b65\u5230\u7ebf\u4e0b\u5f02\u5e38 " + e);
                logger.info("enter connectorServiceFeign \u540c\u6b65\u5230\u7ebf\u4e0b\u5f02\u5e38 " + e);
            }
        } else {
            if (SystemConstants.USE_CHANNEL_EMP.equals(definitionPo.getUseChannel())) {
                logger.info("\u8fdb\u5165\u5458\u5de5\u5238");
                result = new Result();
                try {
                    logger.info("connectorServiceFeign.batchEmpCouponSync:request:" + JSONObject.toJSONString((Object)batchVO));
                    logger.info("\u5f00\u59cb\u8c03\u7528connectorServiceFeign\u670d\u52a1-batchEmpCouponSync param : {}", (Object)JSONObject.toJSONString((Object)batchVO));
                    result = this.connectorServiceFeign.batchEmpCouponSync(batchVO);
                    logger.info("connectorServiceFeign.batchEmpCouponSync:response:" + JSONObject.toJSONString((Object)result));
                }
                catch (RuntimeException e) {
                    result.setCode(Integer.valueOf(-1));
                    logger.error("connectorServiceFeign.batchEmpCouponSync:RuntimeException:{}", (Throwable)e);
                }
                if (SysResponseEnum.SUCCESS.getCode() != result.getCode().intValue() && batchVO.getIsReissue().equals(SystemConstants.COUPON_SEND_AGAIN_NO)) {
                    logger.info("enter failCouponCodeList:{},batchPO:{}", (Object)JSONObject.toJSONString(failCouponCodeList), (Object)JSONObject.toJSONString((Object)batchPo));
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    this.sendCouponBatchOfflineFail(failCouponCodeList, batchPo, result.getMessage());
                }
                try {
                    if (result.getTData() != null) {
                        this.couponEntityService.updateCouponStatusBatch(requestVo, (CouponStatusUpdateBatchRequestVO)result.getTData());
                    }
                }
                catch (RuntimeException e) {
                    logger.error("\u5904\u7406\u7ebf\u4e0b\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
                    logger.error(e.getMessage());
                }
                return new ResponseData(result.getTData());
            }
            result = new Result();
            try {
                logger.info("\u5f00\u59cb\u8c03\u7528connectorServiceFeign\u670d\u52a1-batchcouponsync param : {}", (Object)JSONObject.toJSONString((Object)batchVO));
                result = this.connectorServiceFeign.batchcouponsync(batchVO);
                logger.info("connectorServiceFeign.batchcouponsync:" + JSON.toJSONString((Object)batchVO) + "--" + JSON.toJSONString((Object)result));
            }
            catch (RuntimeException e) {
                result.setCode(Integer.valueOf(-1));
                logger.error("connectorServiceFeign.batchcouponsync:RuntimeException:{}", (Throwable)e);
            }
            if (SysResponseEnum.SUCCESS.getCode() != result.getCode().intValue() && batchVO.getIsReissue().equals(SystemConstants.COUPON_SEND_AGAIN_NO)) {
                logger.info("enter failCouponCodeList:{},batchPO:{}", (Object)JSONObject.toJSONString(failCouponCodeList), (Object)JSONObject.toJSONString((Object)batchPo));
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                this.sendCouponBatchOfflineFail(failCouponCodeList, batchPo, result.getMessage());
            }
            try {
                if (result.getTData() != null) {
                    this.couponEntityService.updateCouponStatusBatch(requestVo, (CouponStatusUpdateBatchRequestVO)result.getTData());
                }
            }
            catch (RuntimeException e) {
                logger.error("\u5904\u7406\u7ebf\u4e0b\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
                logger.error(e.getMessage());
            }
            return new ResponseData(result.getTData());
        }
        return new ResponseData();
    }

    public void sendCouponBatchOfflineFail(List<String> failCouponCodeList, CouponBatchSendRecordPO batchPO, String failDetail) {
        this.couponEntityPOMapper.updateCouponStatusBatch(failCouponCodeList, SystemConstants.COUPON_STATUS_SYNC_FAIL, failDetail);
        List failPOList = this.couponSendFailLogPOMapper.selectByCouponCodeList(failCouponCodeList);
        for (int i = 0; i < failPOList.size(); ++i) {
            ((CouponSendFailLogPO)failPOList.get(i)).setBatchSendCode(batchPO.getBatchSendCode());
            ((CouponSendFailLogPO)failPOList.get(i)).setSendStatus(SystemConstants.COUPON_SEND_NO);
            ((CouponSendFailLogPO)failPOList.get(i)).setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
            ((CouponSendFailLogPO)failPOList.get(i)).setCreateDate(TimeUtils.getNowTime());
            ((CouponSendFailLogPO)failPOList.get(i)).setFailReason("1");
            if (((CouponSendFailLogPO)failPOList.get(i)).getCouponCode().startsWith("false::")) {
                ((CouponSendFailLogPO)failPOList.get(i)).setFailReason("3");
            }
            ((CouponSendFailLogPO)failPOList.get(i)).setFailTimes(Integer.valueOf(0));
        }
        this.couponSendFailLogPOMapper.insertBatch(failPOList);
    }

    public ResponseData<String> sendCouponBatchOfflineNow(CouponDefinitionPOWithBLOBs definitionPo, SendCouponBatchRequestVO requestVo, CouponBatchSendRecordPO batchPo, long mbrMemberId) {
        ResponseData responseData = new ResponseData();
        CouponManualPO manualPO = this.couponManualService.getCouponManualPoById(requestVo.getBusinessId());
        MembersInfoSearchVo searchVo = (MembersInfoSearchVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)manualPO.getMemberCondition()), MembersInfoSearchVo.class);
        searchVo.setPageNumber(SystemConstants.SEARCH_MEMBERS_PAGE_NUMBER);
        searchVo.setPageSize(SystemConstants.SEARCH_MEMBERS_PAGE_SIZE_TEM);
        searchVo.setSysCompanyId(requestVo.getSysCompanyId());
        logger.info("sendCouponBatchOfflineNow advancedSearch ent\uff1a" + JSONObject.toJSONString((Object)searchVo));
        ResponseData esFirstResult = this.membersAdvancedSearchApiService.advancedSearch(searchVo);
        logger.info("sendCouponBatchOfflineNow advancedSearch out\uff1a" + JSONObject.toJSONString((Object)esFirstResult));
        if (esFirstResult.getCode() == SysResponseEnum.FAILED.getCode()) {
            this.updateSendCouponBatchException(batchPo, batchPo.getSendNum(), (CouponDefinitionPO)definitionPo);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        int totalNumber = Integer.parseInt(((PageInfo)esFirstResult.getData()).getTotal() + "");
        String key = "coupon:mqConsumer:offLine:sum:" + definitionPo.getCouponDefinitionId() + "::" + requestVo.getBatchSendCodeDetail();
        if (this.redisLock.setNx(key, 604800L)) {
            CouponBatchSendRecordPO batchSendRequest = new CouponBatchSendRecordPO();
            batchSendRequest.setSendNum(Integer.valueOf(totalNumber));
            batchSendRequest.setCouponBatchSendRecordId(batchPo.getCouponBatchSendRecordId());
            this.couponBatchSendRecordPOMapper.updateSendNum(Integer.valueOf(totalNumber), batchPo.getCouponBatchSendRecordId());
        }
        requestVo.setTotalNumber(Integer.valueOf(totalNumber));
        requestVo.setCouponManualId(manualPO.getCouponManualId());
        ArrayList<Order> orderList = new ArrayList<Order>();
        Order order = new Order();
        order.setDirection(DirectionEnum.ASC);
        order.setProperty("mbrMemberId");
        orderList.add(order);
        searchVo.setOrders(orderList);
        while (true) {
            ArrayList<SearchRangRequest> searchRangRequestList = new ArrayList<SearchRangRequest>();
            SearchRangRequest searchRangRequest = new SearchRangRequest();
            searchRangRequest.setMin(String.valueOf(mbrMemberId));
            searchRangRequestList.add(searchRangRequest);
            searchVo.setMbrMemberIdRanges(searchRangRequestList);
            ResponseData esResult = this.membersAdvancedSearchApiService.advancedSimpleSearch(searchVo);
            if (SysResponseEnum.SUCCESS.getCode() != esResult.getCode()) {
                throw new RuntimeException();
            }
            List dataList = ((PageInfo)esResult.getData()).getList();
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                return responseData;
            }
            requestVo.setMemberListManual(dataList);
            SendResult sendResult = null;
            sendResult = this.mqSendCouponService.sendCoupon(definitionPo, requestVo, batchPo, totalNumber);
            logger.info("Send MQ is ok sendCouponBatchOfflineNow sendMQMessageId:!" + sendResult.getMsgId());
            this.couponManualService.updateMqMbrMemberId(Long.valueOf(Long.parseLong(batchPo.getBizCode())), ((MemberInfoSimpleVO)((PageInfo)esResult.getData()).getList().get(((PageInfo)esResult.getData()).getList().size() - 1)).getMbrMemberId(), 1);
            this.couponManualPOMapper.updateMemberCount(Integer.valueOf(dataList.size()), Long.valueOf(Long.parseLong(batchPo.getBizCode())));
            mbrMemberId = ((MemberInfoSimpleVO)dataList.get(dataList.size() - 1)).getMbrMemberId();
        }
    }

    public void updateSendCouponBatchException(CouponBatchSendRecordPO batchPo, Integer count, CouponDefinitionPO definitionPo) {
        this.couponBatchSendRecordPOMapper.updateFailNum(count, batchPo.getCouponBatchSendRecordId());
        if (SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(batchPo.getBizType())) {
            int syncFailCount = 0;
            if (definitionPo.getUseChannel().equals(SystemConstants.USE_CHANNEL_OFFLINE) || definitionPo.getUseChannel().equals(SystemConstants.USE_CHANNEL_ANY)) {
                syncFailCount = count;
            }
            this.couponManualPOMapper.updateCouponManualFailCount(count.intValue(), syncFailCount, Long.valueOf(Long.parseLong(batchPo.getBizCode())));
            this.couponManualService.updateTaskStatus(Long.valueOf(Long.parseLong(batchPo.getBizCode())), Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_PART_FAIL.getCode().byteValue()));
        }
    }

    public void sendPreCouponOrEmpCouponMq(CouponDefinitionPOWithBLOBs definitionPo, SendCouponBatchRequestVO requestVo, CouponBatchSendRecordPO batchPo) throws Exception {
        CouponManualPO manualPO = this.couponManualPOMapper.selectByPrimaryKey(requestVo.getBusinessId());
        String memberCondition = manualPO.getMemberCondition();
        List ids = null;
        int count = requestVo.getTotalNumber();
        if (StringUtils.isNotBlank((CharSequence)memberCondition)) {
            ids = this.couponManualService.downloadEmpIdsExcel(memberCondition);
        }
        requestVo.setCouponManualId(manualPO.getCouponManualId());
        if (ids == null) {
            for (int i = 0; i < count; ++i) {
                if ((i & 1) == 1 && this.isObsolete(manualPO.getCouponManualId())) {
                    logger.info("CouponManualServiceImpl sendPreCouponMq stop by id : {}", (Object)manualPO.getCouponManualId());
                    this.couponEntityPOMapper.obsoletePreCoupon(manualPO.getCouponManualId());
                    this.removeObsolete(manualPO.getCouponManualId());
                    break;
                }
                try {
                    SendResult sendResult = null;
                    sendResult = this.mqSendCouponService.sendSinglePreCoupon(definitionPo, requestVo, batchPo, count);
                    logger.info("Send MQ is ok sendPreCouponMq sendMQMessageId : {}!", (Object)sendResult.getMsgId());
                    continue;
                }
                catch (Exception e) {
                    logger.error("CouponManualServiceImpl sendPreCouponMq");
                    logger.error(e.getMessage(), (Throwable)e);
                    this.updateSendCouponBatchException(batchPo, Integer.valueOf(1), (CouponDefinitionPO)definitionPo);
                }
            }
        } else {
            Integer singleEmpBindNum = manualPO.getSingleEmpBindNum();
            if (singleEmpBindNum == null) {
                singleEmpBindNum = 1;
            }
            block5: for (int k = 1; k <= singleEmpBindNum; ++k) {
                for (int i = 0; i < ids.size(); ++i) {
                    if ((i & 1) == 1 && this.isObsolete(manualPO.getCouponManualId())) {
                        logger.info("CouponManualServiceImpl sendEmpCouponMq stop by id : {}", (Object)manualPO.getCouponManualId());
                        continue block5;
                    }
                    try {
                        requestVo.setStaffCode((String)ids.get(i));
                        SendResult sendResult = this.mqSendCouponService.sendSinglePreCoupon(definitionPo, requestVo, batchPo, ids.size() * singleEmpBindNum);
                        logger.info("Send MQ is ok sendEmpCouponMq sendMQMessageId : {}!", (Object)sendResult.getMsgId());
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("CouponManualServiceImpl sendEmpCouponMq");
                        logger.error(e.getMessage(), (Throwable)e);
                        this.updateSendCouponBatchException(batchPo, Integer.valueOf(1), (CouponDefinitionPO)definitionPo);
                    }
                }
            }
        }
    }

    public boolean isObsolete(Long couponManualId) {
        String value = (String)this.rs.opsForValue().get((Object)("OBSOLETE_SEND_COUPON_TASK_ID_" + couponManualId));
        return StringUtils.isNotBlank((CharSequence)value);
    }

    public void removeObsolete(Long couponManualId) {
        this.rs.delete((Object)("OBSOLETE_SEND_COUPON_TASK_ID_" + couponManualId));
    }

    public CouponEntityPO savePreCouponEmpEntitySingle(CouponDefinitionPOWithBLOBs definitionPo, SendCouponBatchRequestVO requestVo, Long couponBatchSendRecordId, Byte couponStatusUnused) {
        logger.info("enter SendCouponMqServiceImpl savePreCouponEmpEntitySingle method");
        ArrayList<CouponEntityPO> entityPOList = new ArrayList<CouponEntityPO>();
        String couponCode = BusinessCodeUtil.getCouponCodeForSysCompany((Long)definitionPo.getSysCompanyId(), (String)definitionPo.getErpCouponDefinitionCode());
        CouponEntityPO entityPO = new CouponEntityPO();
        if (definitionPo.getCouponDefinitionType().equals((byte)2)) {
            ResponseData couponCodeWithPwdResponseData = this.couponManualService.getCouponCodeWithPwd(definitionPo.getCouponDefinitionId(), definitionPo.getSysBrandId());
            if (couponCodeWithPwdResponseData.getCode() == 0) {
                couponCode = ((CouponCodeWithPwd)couponCodeWithPwdResponseData.getData()).getCouponCode();
                entityPO.setUsePassword(((CouponCodeWithPwd)couponCodeWithPwdResponseData.getData()).getUsePwd());
            } else {
                logger.info("enter SendCouponServiceImpl saveEntityList method \u6ca1\u6709\u5238\u53f7\u4e86,\u9ed8\u8ba4\u7ed9\u4e2a\u5047\u7684\u5238\u53f7");
                couponCode = BusinessCodeUtil.getCouponCodeFalseCode();
            }
        }
        entityPO.setCouponCode(couponCode);
        entityPO.setSysCompanyId(definitionPo.getSysCompanyId());
        entityPO.setSysBrandId(definitionPo.getSysBrandId());
        entityPO.setBrandCode(definitionPo.getBrandCode());
        entityPO.setCouponDefinitionId(definitionPo.getCouponDefinitionId() + "");
        entityPO.setCouponBatchSendRecordId(couponBatchSendRecordId);
        entityPO.setSendBusinessId(requestVo.getBusinessId());
        if (StringUtils.isBlank((CharSequence)requestVo.getStaffCode())) {
            if (SendTypeEnum.SEND_ALIPAY_VOUCHER.getCode().equals(requestVo.getBusinessType())) {
                entityPO.setSendType(SendTypeEnum.SEND_ALIPAY_VOUCHER.getCode());
                entityPO.setMemberCode("2");
                entityPO.setSendBusinessId(requestVo.getMktActivityId());
            } else {
                entityPO.setSendType(SendTypeEnum.SEND_COUPON_PRE.getCode());
                entityPO.setMemberCode("1");
            }
        } else {
            entityPO.setMemberCode(requestVo.getStaffCode());
            entityPO.setSendType(SendTypeEnum.SEND_COUPON_STAFF.getCode());
        }
        entityPO.setCouponName(definitionPo.getCouponName());
        entityPO.setMoney(definitionPo.getMoney());
        entityPO.setDiscount(definitionPo.getDiscount());
        entityPO.setImg(definitionPo.getImg());
        entityPO.setInfo(definitionPo.getInfo());
        entityPO.setBindStatus(SystemConstants.COUPON_BIND_STATUS_UNBIND);
        Calendar calendar = Calendar.getInstance();
        if (definitionPo.getValidType().equals(SystemConstants.VALID_TYPE__SOMEDAY)) {
            calendar.add(5, definitionPo.getValidDay());
            calendar.set(11, 23);
            calendar.set(13, 59);
            calendar.set(12, 59);
            calendar.set(14, 59);
            entityPO.setValidDateStart(TimeUtils.getNowTime());
            entityPO.setValidDateEnd(calendar.getTime());
        } else if (SystemConstants.VALID_TYPE_DELAY.equals(definitionPo.getValidType())) {
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate startDate = LocalDate.now().plusDays(definitionPo.getDelayDay().intValue());
            LocalDateTime validDateStart = startDate.atTime(0, 0, 0);
            ZonedDateTime startTime = validDateStart.atZone(zoneId);
            LocalDate endDate = startDate.plusDays((long)definitionPo.getDelayValidDay().intValue() - 1L);
            LocalDateTime validEndDate = endDate.atTime(23, 59, 59);
            ZonedDateTime endTime = validEndDate.atZone(zoneId);
            entityPO.setValidDateStart(Date.from(startTime.toInstant()));
            entityPO.setValidDateEnd(Date.from(endTime.toInstant()));
        } else {
            entityPO.setValidDateStart(definitionPo.getValidDateStart());
            calendar.setTime(definitionPo.getValidDateEnd());
            calendar.set(11, 23);
            calendar.set(13, 59);
            calendar.set(12, 59);
            calendar.set(14, 59);
            entityPO.setValidDateEnd(calendar.getTime());
        }
        entityPO.setIsLock(SystemConstants.COUPON_STATUS_CHANGE_IS_UNLOCK);
        entityPO.setIsUse(SystemConstants.COUPON_USE_UNUSED);
        entityPO.setCouponStatus(couponStatusUnused);
        entityPO.setInfo(definitionPo.getInfo());
        entityPO.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        entityPO.setPreferentialType(definitionPo.getPreferentialType());
        entityPO.setCreateDate(TimeUtils.getNowTime());
        entityPO.setModifiedDate(TimeUtils.getNowTime());
        entityPO.setCreateUserId(requestVo.getCreateUserId());
        entityPO.setCreateUserName(requestVo.getCreateUserName());
        entityPO.setBusinessName(requestVo.getBusinessName());
        entityPO.setCouponBatchSendRecordId(definitionPo.getBatchSendCodeDetail());
        entityPO.setTransferSend(definitionPo.getTransferSend());
        entityPO.setTransferCouponDefinitionId(definitionPo.getTransferCouponDefinitionId());
        entityPO.setTransferInfo(definitionPo.getTransferInfo());
        entityPOList.add(entityPO);
        this.couponEntityPOMapper.insertBatch(entityPOList);
        return entityPO;
    }
}

