/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.couponservice.common.datavo.POIUtil;
import com.bizvane.couponservice.common.datavo.ReportTempPO;
import com.bizvane.couponservice.common.thread.CacheThreadFactory;
import com.bizvane.couponservice.common.utils.QiNiuUtil;
import com.bizvane.couponservice.service.CouponReportTempService;
import com.bizvane.utils.tokens.SysAccountPO;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements CouponReportTempService {
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;

    public void export(SysAccountPO sysAccountPo, String nameEnd, String jsonStr, ReportTempPO fileReportTempPolist) {
        Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        CacheThreadFactory.cacheThread().execute(() -> {
            try {
                JSONArray arr = null;
                if ("_cycle".equals(nameEnd)) {
                    NavigableMap<String, JSONObject> mapjsonObje = new TreeMap();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    arr = new JSONArray();
                    if (jsonStr != null && jsonStr.startsWith("{") && jsonStr.endsWith("}")) {
                        JSONObject json = JSONObject.parseObject((String)jsonStr);
                        for (Object k : json.keySet()) {
                            JSONObject jsonObject1 = JSONObject.parseObject((String)json.get(k).toString());
                            if (k.toString().length() > 9) {
                                jsonObject1.put("time", (Object)k.toString().substring(0, k.toString().length() - 9));
                            } else {
                                jsonObject1.put("time", (Object)k.toString());
                            }
                            if ("all".equals(k.toString())) {
                                arr.put((Map)jsonObject1);
                                continue;
                            }
                            try {
                                Date date = simpleDateFormat.parse(k.toString());
                                long ts = date.getTime();
                                mapjsonObje.put(String.valueOf(ts), jsonObject1);
                            }
                            catch (ParseException e) {
                                log.error("\u5f02\u5e38", (Throwable)e);
                            }
                        }
                        mapjsonObje = ((TreeMap)mapjsonObje).descendingMap();
                        for (String[] key : mapjsonObje.keySet()) {
                            arr.put((Map)mapjsonObje.get(key));
                        }
                    }
                } else {
                    arr = new JSONArray(jsonStr);
                }
                fileTaskPo.setTaskId(taskId);
                fileTaskPo.setFileId(String.valueOf(taskId));
                fileTaskPo.setTaskTypeCode(String.valueOf(arr.length()) + "\u6761");
                fileTaskPo.setTaskName(fileReportTempPolist.getTemplateName() + nameEnd);
                if (sysAccountPo != null) {
                    fileTaskPo.setSysCompanyId(sysAccountPo.getSysCompanyId());
                    fileTaskPo.setSysBrandId(sysAccountPo.getBrandId());
                    fileTaskPo.setCreateUserId(sysAccountPo.getSysAccountId());
                    fileTaskPo.setCreateUserName(sysAccountPo.getName());
                }
                fileTaskPo.setCreateDate(new Date());
                fileTaskPo.setFileStatus(Long.valueOf(0L));
                fileTaskPo.setFileType("EXPORT");
                fileTaskPo.setValid(Boolean.valueOf(true));
                this.fileTaskServiceRpc.addFileTask(fileTaskPo);
                String qiniuUrl = null;
                HashMap<Integer, String> map = new HashMap<Integer, String>();
                HashMap mapbiaotou = new HashMap();
                int i = 1;
                for (String string : fileReportTempPolist.getReportDataName().split(",")) {
                    map.put(i++, string);
                }
                i = 1;
                for (String string : fileReportTempPolist.getReportData().split(",")) {
                    mapbiaotou.put(string, map.get(i++));
                }
                fileTaskPo.setFileStatus(Long.valueOf(30L));
                this.fileTaskServiceRpc.update(fileTaskPo);
                POIUtil poiUtil = new POIUtil();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                fileTaskPo.setFileStatus(Long.valueOf(80L));
                this.fileTaskServiceRpc.update(fileTaskPo);
                poiUtil.exportExcel((OutputStream)out, fileReportTempPolist.getTemplateName(), arr, nameEnd, mapbiaotou, map);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                String filename = fileReportTempPolist.getTemplateName() + nameEnd + format.format(new Date());
                ByteArrayOutputStream tempByteOstream = null;
                BufferedOutputStream tempBufferOstream = null;
                ZipOutputStream tempZstream = null;
                ZipEntry tempEntry = null;
                tempByteOstream = new ByteArrayOutputStream();
                tempZstream = new ZipOutputStream(tempByteOstream);
                tempBufferOstream = new BufferedOutputStream(tempZstream);
                tempEntry = new ZipEntry(filename + ".xlsx");
                tempZstream.putNextEntry(tempEntry);
                int len = 0;
                byte[] buff = new byte[1024];
                while ((len = in.read(buff)) != -1) {
                    tempZstream.write(buff, 0, len);
                }
                tempBufferOstream.flush();
                tempByteOstream.flush();
                tempZstream.closeEntry();
                tempZstream.close();
                tempByteOstream.close();
                tempBufferOstream.close();
                ByteArrayInputStream into = new ByteArrayInputStream(tempByteOstream.toByteArray());
                fileTaskPo.setFileStatus(Long.valueOf(99L));
                this.fileTaskServiceRpc.update(fileTaskPo);
                qiniuUrl = QiNiuUtil.upload((InputStream)into, (String)(filename + ".zip"));
                System.out.println("\u62a5\u8868\u4e0a\u4f20\u5230\u4e03\u725bReportIncomeController\uff1a" + qiniuUrl);
                in.close();
                ((OutputStream)out).close();
                fileTaskPo.setFileStatus(Long.valueOf(100L));
                fileTaskPo.setFileUnl(qiniuUrl);
                this.fileTaskServiceRpc.update(fileTaskPo);
            }
            catch (JSONException e) {
                log.error("\u5f02\u5e38", (Throwable)e);
                fileTaskPo.setFileStatus(Long.valueOf(-1L));
                this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            }
            catch (IOException e) {
                log.error("\u5f02\u5e38", (Throwable)e);
                fileTaskPo.setFileStatus(Long.valueOf(-1L));
                this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            }
        });
    }
}

