/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.couponfacade.models.vo.GetIntegralActivityCouponAnalyseRequestVO;
import com.bizvane.couponfacade.models.vo.GetIntegralActivityCouponAnalyseResponseVO;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IntegralActivityServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(IntegralActivityServiceImpl.class);
    @Resource
    private CouponEntityPOMapper couponEntityPOMapper;

    public ResponseData getIntegralActivityCouponAnalyse(GetIntegralActivityCouponAnalyseRequestVO requestVO) {
        List integralActivityCouponList;
        List integralActivityCouponNumAndCashList;
        ResponseData responseData = new ResponseData();
        GetIntegralActivityCouponAnalyseResponseVO responseVO = new GetIntegralActivityCouponAnalyseResponseVO();
        List integralActivityCouponUserList = this.couponEntityPOMapper.getIntegralActivityCouponUser(requestVO);
        if (CollectionUtils.isNotEmpty((Collection)integralActivityCouponUserList)) {
            responseVO.setUsers(((GetIntegralActivityCouponAnalyseResponseVO)integralActivityCouponUserList.get(0)).getUsers());
        }
        if (CollectionUtils.isNotEmpty((Collection)(integralActivityCouponNumAndCashList = this.couponEntityPOMapper.getIntegralActivityCouponNumAndCash(requestVO)))) {
            responseVO.setCash(((GetIntegralActivityCouponAnalyseResponseVO)integralActivityCouponNumAndCashList.get(0)).getCash());
        }
        if (CollectionUtils.isEmpty((Collection)(integralActivityCouponList = this.couponEntityPOMapper.getIntegralActivityCoupons(requestVO))) || ((GetIntegralActivityCouponAnalyseResponseVO)integralActivityCouponList.get(0)).getUsedNum() == 0L) {
            responseData.setData((Object)responseVO);
            return responseData;
        }
        BigDecimal all = new BigDecimal(((GetIntegralActivityCouponAnalyseResponseVO)integralActivityCouponList.get(0)).getUsedNum());
        responseVO.setChangeNum(Long.valueOf(all.longValue()));
        requestVO.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        List integralActivityCouponUsedList = this.couponEntityPOMapper.getIntegralActivityCoupons(requestVO);
        if (CollectionUtils.isEmpty((Collection)integralActivityCouponUsedList) || ((GetIntegralActivityCouponAnalyseResponseVO)integralActivityCouponUsedList.get(0)).getUsedNum() == 0L) {
            responseVO.setUnUsedNum(Long.valueOf(all.longValue()));
            responseData.setData((Object)responseVO);
            return responseData;
        }
        BigDecimal usedNum = new BigDecimal(((GetIntegralActivityCouponAnalyseResponseVO)integralActivityCouponUsedList.get(0)).getUsedNum());
        responseVO.setUsedNum(Long.valueOf(usedNum.longValue()));
        responseVO.setUnUsedNum(Long.valueOf(all.subtract(usedNum).longValue()));
        responseVO.setUserRate(usedNum.divide(all, 2, RoundingMode.HALF_UP));
        log.info("IntegralActivityServiceImpl#getIntegralActivityCouponAnalyse#user:{}", (Object)responseVO);
        responseData.setData((Object)responseVO);
        return responseData;
    }

    public ResponseData<Map<String, GetIntegralActivityCouponAnalyseResponseVO>> getIntegralActivityCouponAnalyseSub(GetIntegralActivityCouponAnalyseRequestVO requestVO) {
        List integralActivityCouponList;
        List integralActivityCouponNumAndCashList;
        HashMap responseVOMap = new HashMap();
        requestVO.getExchangeNoList().forEach(item -> {
            GetIntegralActivityCouponAnalyseResponseVO getIntegralActivityCouponAnalyseResponseVO = new GetIntegralActivityCouponAnalyseResponseVO();
            getIntegralActivityCouponAnalyseResponseVO.setExchangeCode(item);
            responseVOMap.put(item, getIntegralActivityCouponAnalyseResponseVO);
        });
        List integralActivityCouponUserList = this.couponEntityPOMapper.getIntegralActivityCouponUser(requestVO);
        log.info("2:{}", (Object)JSON.toJSONString((Object)integralActivityCouponUserList));
        if (CollectionUtils.isNotEmpty((Collection)integralActivityCouponUserList)) {
            integralActivityCouponUserList.forEach(item -> {
                GetIntegralActivityCouponAnalyseResponseVO temp = (GetIntegralActivityCouponAnalyseResponseVO)responseVOMap.get(item.getExchangeCode());
                if (temp != null) {
                    temp.setUsers(item.getUsers());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(integralActivityCouponNumAndCashList = this.couponEntityPOMapper.getIntegralActivityCouponNumAndCash(requestVO)))) {
            integralActivityCouponNumAndCashList.forEach(item -> {
                GetIntegralActivityCouponAnalyseResponseVO temp = (GetIntegralActivityCouponAnalyseResponseVO)responseVOMap.get(item.getExchangeCode());
                if (temp != null) {
                    temp.setCash(item.getCash());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(integralActivityCouponList = this.couponEntityPOMapper.getIntegralActivityCoupons(requestVO)))) {
            integralActivityCouponList.forEach(item -> {
                GetIntegralActivityCouponAnalyseResponseVO temp = (GetIntegralActivityCouponAnalyseResponseVO)responseVOMap.get(item.getExchangeCode());
                if (temp != null) {
                    temp.setChangeNum(item.getUsedNum());
                    temp.setTotal(item.getUsedNum());
                }
            });
        }
        requestVO.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        List integralActivityCouponUsedList = this.couponEntityPOMapper.getIntegralActivityCoupons(requestVO);
        if (CollectionUtils.isNotEmpty((Collection)integralActivityCouponUsedList)) {
            integralActivityCouponUsedList.forEach(item -> {
                GetIntegralActivityCouponAnalyseResponseVO temp = (GetIntegralActivityCouponAnalyseResponseVO)responseVOMap.get(item.getExchangeCode());
                if (temp != null) {
                    temp.setUsedNum(item.getUsedNum());
                }
            });
        }
        log.info("IntegralActivityServiceImpl#getIntegralActivityCouponAnalyseSub#beforeCal:{}", (Object)JSON.toJSONString(responseVOMap));
        ArrayList calList = new ArrayList(responseVOMap.values());
        for (GetIntegralActivityCouponAnalyseResponseVO vo : calList) {
            if (vo.getTotal() == 0L) continue;
            if (vo.getUsedNum() == 0L) {
                vo.setUnUsedNum(vo.getTotal());
                continue;
            }
            BigDecimal usedNum = new BigDecimal(vo.getUsedNum());
            BigDecimal all = new BigDecimal(vo.getTotal());
            vo.setUserRate(usedNum.divide(all, 2, RoundingMode.HALF_UP));
        }
        log.info("IntegralActivityServiceImpl#getIntegralActivityCouponAnalyseSub#afterCal:{}", (Object)JSON.toJSONString(responseVOMap));
        ResponseData responseData = new ResponseData();
        responseData.setData(responseVOMap);
        return responseData;
    }
}

