/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.couponfacade.enums.CouponSendTypeEnum;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponSendFailLogVO;
import com.bizvane.couponfacade.models.vo.CouponStatusEntitySuccessVO;
import com.bizvane.couponfacade.models.vo.HideCouponRecordParam;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.thread.CacheThreadFactory;
import com.bizvane.couponservice.common.utils.DateUtil;
import com.bizvane.couponservice.common.utils.QiNiuUtil;
import com.bizvane.couponservice.common.utils.StreamingExportExcelPageInfoUtil;
import com.bizvane.couponservice.common.utils.StreamingExportExcelUtil;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.FileTaskService;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.couponservice.service.StreamingCallBack;
import com.bizvane.couponservice.service.impl.CouponEntityServiceImpl;
import com.bizvane.couponservice.service.impl.SendCouponServiceImpl;
import com.bizvane.members.facade.es.pojo.BasicMembersInfoSearchPojo;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.service.api.MemberOrderApiService;
import com.bizvane.members.facade.service.api.MembersAdvancedSearchApiService;
import com.bizvane.members.facade.utils.DesensitizeUtil;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class FileTaskServiceImpl
implements FileTaskService {
    Logger logger = LoggerFactory.getLogger(FileTaskServiceImpl.class);
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Value(value="${three61.sysCompanyId}")
    private Long sysCompanyId361;
    @Value(value="${UR.sysCompanyId}")
    private Long sysCompanyId;
    @Autowired
    @Lazy
    private CouponEntityService couponEntityService;
    @Autowired
    CouponEntityServiceImpl couponEntityServiceImpl;
    @Autowired
    SendCouponServiceImpl sendCouponServiceImpl;
    @Autowired
    MemberOrderApiService memberOrderApiService;
    @Autowired
    StaffServiceRpc staffServiceRpc;
    @Autowired
    private MembersAdvancedSearchApiService membersAdvancedSearchApiService;
    private final String ONE = "1";
    private final String TWO = "2";
    private final String THREE = "3";
    private final String FOUR = "4";
    private final String FIVE = "5";
    private final String SIX = "6";
    private final String SEVEN = "7";
    private final String EIGHT = "8";
    @Autowired
    private SendCouponService sendCouponService;

    public ResponseData<String> exportEntityExcel(CouponEntityVO entityParam, SysAccountPo accountPo) {
        this.logger.info("enter FileTaskServiceImpl exportEntityExcel method !");
        ResponseData responseData = new ResponseData();
        ResponseData findFileTaskNumResponseData = this.fileTaskServiceRpc.findFileTaskNum(accountPo.getSysAccountId());
        if (findFileTaskNumResponseData.getCode() > 0) {
            return findFileTaskNumResponseData;
        }
        Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        String fileName = "\u5238\u53d1\u653e\u8bb0\u5f55\u5bfc\u51fa" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        CouponStatusEntitySuccessVO successVO = new CouponStatusEntitySuccessVO();
        successVO.setCouponStatusUnused(SystemConstants.COUPON_STATUS_UNUSED);
        successVO.setCouponStatusOverdue(SystemConstants.COUPON_STATUS_OVERDUE);
        successVO.setCouponStatusUsed(SystemConstants.COUPON_STATUS_USED);
        if ("1".equals(entityParam.getListType())) {
            entityParam.setListType("85");
            entityParam.setListTypeBusinessName("\u4efb\u52a1\u540d\u79f0");
        } else if ("2".equals(entityParam.getListType())) {
            entityParam.setListType("10,15,30,35,45,50,55,56,90,100,103,104,105,106,107,108,109");
            entityParam.setListTypeBusinessName("\u6d3b\u52a8\u540d\u79f0");
        } else if ("3".equals(entityParam.getListType())) {
            entityParam.setListType("60,65,70,75,80");
            entityParam.setListTypeBusinessName("\u4efb\u52a1\u540d\u79f0");
        } else if ("4".equals(entityParam.getListType())) {
            entityParam.setListType("95");
            entityParam.setListTypeBusinessName("\u5206\u7ec4\u540d\u79f0");
        } else if ("5".equals(entityParam.getListType())) {
            entityParam.setListType("94");
            entityParam.setListTypeBusinessName("\u667a\u80fd\u8425\u9500");
        } else if ("6".equals(entityParam.getListType())) {
            entityParam.setListType("20");
            entityParam.setListTypeBusinessName("\u7f16\u53f7");
        } else if ("7".equals(entityParam.getListType())) {
            entityParam.setListType("101");
            entityParam.setListTypeBusinessName("\u79ef\u5206\u8ba2\u5355");
        } else if ("8".equals(entityParam.getListType())) {
            entityParam.setListType("102");
            entityParam.setListTypeBusinessName("\u5bfc\u8d2d\u540d\u79f0/\u5de5\u53f7");
        }
        int count = this.couponEntityPOMapper.findListExportByConditionscount(entityParam, successVO, accountPo.getBrandId(), null, null);
        if (count == 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
            return responseData;
        }
        if (count > 500000) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setData((Object)String.valueOf(count));
            responseData.setMessage("\u6700\u591a\u5bfc\u51fa50\u4e07\u6761\u6570\u636e");
            return responseData;
        }
        StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(Long.parseLong(count + "")));
        FileTaskPo fileTaskPo = this.addExportTask(accountPo, taskId, fileName, count);
        exportExcelUtil.setExportProcessId((Object)taskId);
        this.logger.info("enter FileTaskServiceImpl exportEntityExcel \u67e5\u6570\u636e\u65b0\u65b9\u6cd5 !");
        CacheThreadFactory.cacheThread().execute(() -> {
            try {
                Method method = this.couponEntityServiceImpl.getClass().getMethod("findListExportByConditions", CouponEntityVO.class, CouponStatusEntitySuccessVO.class, Long.class, Long.class, Long.class);
                exportExcelUtil.read("couponEntityServiceImpl", method, (StreamingCallBack)new /* Unavailable Anonymous Inner Class!! */, new Object[]{entityParam, successVO, accountPo.getBrandId()});
            }
            catch (Exception e) {
                this.logger.info("FileTaskServiceImpl exportEntityExcel method error ! Exception:{}", (Object)JSONObject.toJSONString((Object)e));
            }
        });
        this.monitorExportPercentage(fileName, fileTaskPo, exportExcelUtil);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<String> exportEntityExcelEs(CouponEntityVO entityParam, SysAccountPo accountPo) {
        switch (entityParam.getListType()) {
            case "-1": {
                entityParam.setListTypeBusinessName("\u8425\u9500\u53d1\u5238");
            }
            case "1": {
                entityParam.setListTypeBusinessName("\u4efb\u52a1\u540d\u79f0");
                break;
            }
            case "2": {
                entityParam.setListTypeBusinessName("\u6d3b\u52a8\u540d\u79f0");
                break;
            }
            case "3": {
                entityParam.setListTypeBusinessName("\u4efb\u52a1\u540d\u79f0");
                break;
            }
            case "4": {
                entityParam.setListTypeBusinessName("\u5206\u7ec4\u540d\u79f0");
                break;
            }
            case "5": {
                entityParam.setListTypeBusinessName("\u667a\u80fd\u8425\u9500");
                break;
            }
            case "6": {
                entityParam.setListTypeBusinessName("\u7f16\u53f7");
                break;
            }
            case "7": {
                entityParam.setListTypeBusinessName("\u79ef\u5206\u8ba2\u5355");
                break;
            }
            case "8": {
                entityParam.setListTypeBusinessName("\u5bfc\u8d2d\u540d\u79f0/\u5de5\u53f7");
                break;
            }
            case "9": {
                entityParam.setListTypeBusinessName("\u9884\u751f\u6210\u5238");
                break;
            }
            case "10": {
                entityParam.setListTypeBusinessName("\u5458\u5de5\u5238");
                break;
            }
            case "11": {
                entityParam.setListTypeBusinessName("\u7ebf\u4e0bERP\u53d1\u5238");
                break;
            }
            case "12": {
                entityParam.setListTypeBusinessName("\u5929\u732b\u5238");
                break;
            }
            case "13": {
                entityParam.setListTypeBusinessName("\u6e20\u9053\u9886\u5238");
                break;
            }
            default: {
                entityParam.setListTypeBusinessName("");
            }
        }
        this.logger.info("enter FileTaskServiceImpl exportEntityExcel method !");
        ResponseData responseData = new ResponseData();
        ResponseData findFileTaskNumResponseData = this.fileTaskServiceRpc.findFileTaskNum(accountPo.getSysAccountId());
        if (findFileTaskNumResponseData.getCode() > 0) {
            return findFileTaskNumResponseData;
        }
        Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        String fileName = "\u5238\u53d1\u653e\u8bb0\u5f55\u5bfc\u51fa" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        PageRequest pageableCoupon = PageRequest.of((int)0, (int)10, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"couponEntityId"}));
        entityParam.setSysBrandId(accountPo.getBrandId());
        entityParam.setSysCompanyId(accountPo.getSysCompanyId());
        ResponseData pageInfo = this.couponEntityService.getListEs(entityParam, (Pageable)pageableCoupon);
        int count = (int)((PageInfo)pageInfo.getData()).getTotal();
        if (count == 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
            return responseData;
        }
        if (count > 500000) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setData((Object)String.valueOf(count));
            responseData.setMessage("\u6700\u591a\u5bfc\u51fa50\u4e07\u6761\u6570\u636e");
            return responseData;
        }
        if (entityParam.getTypeList() == null || entityParam.getTypeList().size() == 0) {
            entityParam.setTypeList(CouponSendTypeEnum.getMktTypeList());
        }
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"couponEntityId"});
        StreamingExportExcelPageInfoUtil test = new StreamingExportExcelPageInfoUtil(Long.valueOf(((PageInfo)pageInfo.getData()).getTotal()));
        FileTaskPo fileTaskPo = this.addExportTask(accountPo, taskId, fileName, count);
        test.setExportProcessId((Object)taskId);
        this.logger.info("entityParam.getTypeList():{}", (Object)JSON.toJSONString((Object)entityParam.getTypeList()));
        if (entityParam.getTypeList().contains(CouponSendTypeEnum.STAFF_COUPON.getCode())) {
            Boolean isDesensitize = this.couponEntityService.getMemberDataDesensitizeByAccountConfig(accountPo.getSysAccountId());
            CacheThreadFactory.cacheThread().execute(() -> {
                this.logger.info("enter FileTaskServiceImpl exportEntityExcel method !");
                try {
                    Method method = this.couponEntityServiceImpl.getClass().getMethod("getListEsExport", CouponEntityVO.class, Pageable.class);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    test.read("couponEntityServiceImpl", method, (couponEntityInfoSearchPojo, row) -> {
                        if (isDesensitize.booleanValue() && null != couponEntityInfoSearchPojo) {
                            couponEntityInfoSearchPojo.setCardNo(DesensitizeUtil.encrypt((String)couponEntityInfoSearchPojo.getCardNo()));
                            couponEntityInfoSearchPojo.setPhone(DesensitizeUtil.encrypt((String)couponEntityInfoSearchPojo.getPhone()));
                        }
                        if (row.getRowNum() == 0) {
                            row.createCell(0).setCellValue("\u5238\u540d\u79f0");
                            row.createCell(1).setCellValue("\u5238\u53f7");
                            row.createCell(2).setCellValue("\u5238\u5b9a\u4e49ID");
                            row.createCell(3).setCellValue("\u53d1\u5238\u65f6\u95f4");
                            row.createCell(4).setCellValue("\u662f\u5426\u7ed1\u5b9a");
                            row.createCell(5).setCellValue("\u6279\u6b21\u53f7");
                            row.createCell(6).setCellValue("\u5458\u5de5id");
                            row.createCell(7).setCellValue("\u5238\u72b6\u6001");
                            row.createCell(8).setCellValue("\u5238\u5f00\u59cb\u65f6\u95f4");
                            row.createCell(9).setCellValue("\u5238\u7ed3\u675f\u65f6\u95f4");
                            row.createCell(10).setCellValue("\u6838\u9500\u5bfc\u8d2dcode");
                            row.createCell(11).setCellValue("\u6838\u9500\u5bfc\u8d2d\u4eba");
                        } else {
                            try {
                                row.createCell(0).setCellValue(couponEntityInfoSearchPojo.getCouponName() == null ? "" : couponEntityInfoSearchPojo.getCouponName());
                                row.createCell(1).setCellValue(couponEntityInfoSearchPojo.getCouponCode() == null ? "" : couponEntityInfoSearchPojo.getCouponCode());
                                row.createCell(2).setCellValue(couponEntityInfoSearchPojo.getCouponDefinitionId() == null ? "" : couponEntityInfoSearchPojo.getCouponDefinitionId());
                                row.createCell(3).setCellValue(couponEntityInfoSearchPojo.getCreateDate() == null ? "" : format.format(couponEntityInfoSearchPojo.getCreateDate()));
                                row.createCell(4).setCellValue("Y");
                                row.createCell(5).setCellValue(couponEntityInfoSearchPojo.getCouponBatchSendRecordId().toString() == null ? "" : couponEntityInfoSearchPojo.getCouponBatchSendRecordId().toString());
                                row.createCell(6).setCellValue(couponEntityInfoSearchPojo.getMemberCode() == null ? "" : couponEntityInfoSearchPojo.getMemberCode());
                                String valueName = couponEntityInfoSearchPojo.getCouponStatus().toString();
                                if (couponEntityInfoSearchPojo.getCouponStatus() == 20) {
                                    valueName = "\u672a\u4f7f\u7528";
                                } else if (couponEntityInfoSearchPojo.getCouponStatus() == 25) {
                                    valueName = "\u5df2\u8fc7\u671f";
                                } else if (couponEntityInfoSearchPojo.getCouponStatus() == 30) {
                                    valueName = "\u5df2\u6838\u9500";
                                }
                                row.createCell(7).setCellValue(valueName);
                                row.createCell(8).setCellValue(couponEntityInfoSearchPojo.getValidDateStart() == null ? "" : format.format(couponEntityInfoSearchPojo.getValidDateStart()));
                                row.createCell(9).setCellValue(couponEntityInfoSearchPojo.getValidDateEnd() == null ? "" : format.format(couponEntityInfoSearchPojo.getValidDateEnd()));
                                row.createCell(10).setCellValue(couponEntityInfoSearchPojo.getStaffCode() == null ? "" : couponEntityInfoSearchPojo.getStaffCode());
                                row.createCell(11).setCellValue(couponEntityInfoSearchPojo.getStaffName() == null ? "" : couponEntityInfoSearchPojo.getStaffName());
                            }
                            catch (Exception e) {
                                this.logger.info("enter FileTaskServiceImpl exportEntityExcel Error:{}", (Throwable)e);
                            }
                        }
                    }, sort, new Object[]{entityParam});
                }
                catch (Exception e) {
                    this.logger.error("\u5f02\u5e38", (Throwable)e);
                }
            });
        } else if ("\u9884\u751f\u6210\u5238".equals(entityParam.getListTypeBusinessName())) {
            this.logger.info("\u9884\u751f\u6210\u5238");
            Boolean isDesensitize = this.couponEntityService.getMemberDataDesensitizeByAccountConfig(accountPo.getSysAccountId());
            CacheThreadFactory.cacheThread().execute(() -> {
                try {
                    Method method = this.couponEntityServiceImpl.getClass().getMethod("getListEsExport", CouponEntityVO.class, Pageable.class);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    test.read("couponEntityServiceImpl", method, (couponEntityInfoSearchPojo, row) -> {
                        if (isDesensitize.booleanValue() && null != couponEntityInfoSearchPojo) {
                            couponEntityInfoSearchPojo.setCardNo(DesensitizeUtil.encrypt((String)couponEntityInfoSearchPojo.getCardNo()));
                            couponEntityInfoSearchPojo.setPhone(DesensitizeUtil.encrypt((String)couponEntityInfoSearchPojo.getPhone()));
                        }
                        if (row.getRowNum() == 0) {
                            row.createCell(0).setCellValue("\u4efb\u52a1\u540d\u79f0");
                            row.createCell(1).setCellValue("\u751f\u6210\u6e20\u9053");
                            row.createCell(2).setCellValue("\u5238\u5b9a\u4e49ID");
                            row.createCell(3).setCellValue("\u5238\u540d\u79f0");
                            row.createCell(4).setCellValue("\u4f18\u60e0\u5238\u53f7");
                            row.createCell(5).setCellValue("\u5238\u4f18\u60e0\u5f62\u5f0f");
                            row.createCell(6).setCellValue("\u5238\u9762\u989d/\u6298\u6263");
                            row.createCell(7).setCellValue("\u5238\u4f7f\u7528\u8bf4\u660e");
                            row.createCell(8).setCellValue("\u5238\u5f00\u59cb\u65f6\u95f4");
                            row.createCell(9).setCellValue("\u5238\u7ed3\u675f\u65f6\u95f4");
                            row.createCell(10).setCellValue("\u6838\u9500\u5bfc\u8d2dcode");
                            row.createCell(11).setCellValue("\u6838\u9500\u5bfc\u8d2d\u4eba");
                        } else {
                            try {
                                row.createCell(0).setCellValue(couponEntityInfoSearchPojo.getBusinessName() == null ? "" : couponEntityInfoSearchPojo.getBusinessName());
                                row.createCell(1).setCellValue("\u7ebf\u4e0a\u751f\u6210");
                                row.createCell(2).setCellValue(couponEntityInfoSearchPojo.getCouponDefinitionId() == null ? "" : couponEntityInfoSearchPojo.getCouponDefinitionId());
                                row.createCell(3).setCellValue(couponEntityInfoSearchPojo.getCouponName() == null ? "" : couponEntityInfoSearchPojo.getCouponName());
                                row.createCell(4).setCellValue(couponEntityInfoSearchPojo.getCouponCode() == null ? "" : couponEntityInfoSearchPojo.getCouponCode());
                                if (couponEntityInfoSearchPojo.getPreferentialType() == 1) {
                                    row.createCell(5).setCellValue("\u73b0\u91d1");
                                    row.createCell(6).setCellValue(couponEntityInfoSearchPojo.getMoney().toString() == null ? "" : couponEntityInfoSearchPojo.getMoney().toString() + "\u5143");
                                } else if (couponEntityInfoSearchPojo.getPreferentialType() == 2) {
                                    row.createCell(5).setCellValue("\u6298\u6263");
                                    row.createCell(6).setCellValue(couponEntityInfoSearchPojo.getDiscount() == null ? "" : couponEntityInfoSearchPojo.getDiscount() + "\u6298");
                                } else {
                                    row.createCell(5).setCellValue("\u5151\u6362\u5238");
                                    row.createCell(6).setCellValue(couponEntityInfoSearchPojo.getMoney().toString() == null ? "" : couponEntityInfoSearchPojo.getMoney().toString());
                                }
                                row.createCell(7).setCellValue(couponEntityInfoSearchPojo.getInfo() == null ? "" : couponEntityInfoSearchPojo.getInfo());
                                row.createCell(8).setCellValue(couponEntityInfoSearchPojo.getValidDateStart() == null ? "" : format.format(couponEntityInfoSearchPojo.getValidDateStart()));
                                row.createCell(9).setCellValue(couponEntityInfoSearchPojo.getValidDateEnd() == null ? "" : format.format(couponEntityInfoSearchPojo.getValidDateEnd()));
                                row.createCell(10).setCellValue(couponEntityInfoSearchPojo.getStaffCode() == null ? "" : couponEntityInfoSearchPojo.getStaffCode());
                                row.createCell(11).setCellValue(couponEntityInfoSearchPojo.getStaffName() == null ? "" : couponEntityInfoSearchPojo.getStaffName());
                            }
                            catch (Exception e) {
                                this.logger.info("enter FileTaskServiceImpl exportEntityExcel Error:{}", (Throwable)e);
                            }
                        }
                    }, sort, new Object[]{entityParam});
                }
                catch (Exception e) {
                    this.logger.error("\u5f02\u5e38", (Throwable)e);
                }
            });
        } else if (entityParam.getTypeList().contains(CouponSendTypeEnum.TMALL_COUPON.getCode())) {
            this.logger.info("\u5929\u732b\u5238");
            Boolean isDesensitize = this.couponEntityService.getMemberDataDesensitizeByAccountConfig(accountPo.getSysAccountId());
            CacheThreadFactory.cacheThread().execute(() -> {
                try {
                    Method method = this.couponEntityServiceImpl.getClass().getMethod("getListEsExport", CouponEntityVO.class, Pageable.class);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    test.read("couponEntityServiceImpl", method, (couponEntityInfoSearchPojo, row) -> {
                        if (isDesensitize.booleanValue() && null != couponEntityInfoSearchPojo) {
                            couponEntityInfoSearchPojo.setCardNo(DesensitizeUtil.encrypt((String)couponEntityInfoSearchPojo.getCardNo()));
                            couponEntityInfoSearchPojo.setPhone(DesensitizeUtil.encrypt((String)couponEntityInfoSearchPojo.getPhone()));
                        }
                        if (row.getRowNum() == 0) {
                            row.createCell(0).setCellValue("\u4f1a\u5458\u59d3\u540d");
                            row.createCell(1).setCellValue("\u6dd8\u5b9d\u6635\u79f0");
                            row.createCell(2).setCellValue("\u4f1a\u5458\u624b\u673a\u53f7");
                            row.createCell(3).setCellValue("\u4f1a\u5458\u5361\u53f7");
                            row.createCell(4).setCellValue("\u6240\u5c5e\u95e8\u5e97ID");
                            row.createCell(5).setCellValue("\u6240\u5c5e\u95e8\u5e97Code");
                            row.createCell(6).setCellValue("\u6240\u5c5e\u95e8\u5e97");
                            row.createCell(7).setCellValue("\u5238\u540d\u79f0");
                            row.createCell(8).setCellValue("\u5238\u53f7");
                            row.createCell(9).setCellValue("\u5238\u5b9a\u4e49ID");
                            row.createCell(10).setCellValue("\u53d1\u9001\u65f6\u95f4");
                            row.createCell(11).setCellValue("\u6838\u9500\u5bfc\u8d2dcode");
                            row.createCell(12).setCellValue("\u6838\u9500\u5bfc\u8d2d\u4eba");
                        } else {
                            try {
                                row.createCell(0).setCellValue(couponEntityInfoSearchPojo.getName() == null ? "" : couponEntityInfoSearchPojo.getName());
                                row.createCell(1).setCellValue(couponEntityInfoSearchPojo.getRemark() == null ? "" : couponEntityInfoSearchPojo.getRemark());
                                row.createCell(2).setCellValue(couponEntityInfoSearchPojo.getPhone() == null ? "" : couponEntityInfoSearchPojo.getPhone());
                                row.createCell(3).setCellValue(couponEntityInfoSearchPojo.getCardNo() == null ? "" : couponEntityInfoSearchPojo.getCardNo());
                                row.createCell(4).setCellValue(couponEntityInfoSearchPojo.getServiceStoreId() == null ? "" : couponEntityInfoSearchPojo.getServiceStoreId());
                                row.createCell(5).setCellValue(couponEntityInfoSearchPojo.getServiceStoreCode() == null ? "" : couponEntityInfoSearchPojo.getServiceStoreCode());
                                row.createCell(6).setCellValue(couponEntityInfoSearchPojo.getServiceStoreName() == null ? "" : couponEntityInfoSearchPojo.getServiceStoreName());
                                row.createCell(7).setCellValue(couponEntityInfoSearchPojo.getCouponName() == null ? "" : couponEntityInfoSearchPojo.getCouponName());
                                row.createCell(8).setCellValue(couponEntityInfoSearchPojo.getCouponCode() == null ? "" : couponEntityInfoSearchPojo.getCouponCode());
                                row.createCell(9).setCellValue(couponEntityInfoSearchPojo.getCouponDefinitionId() == null ? "" : couponEntityInfoSearchPojo.getCouponDefinitionId());
                                row.createCell(10).setCellValue(couponEntityInfoSearchPojo.getCreateDate() == null ? "" : format.format(couponEntityInfoSearchPojo.getCreateDate()));
                                row.createCell(11).setCellValue(couponEntityInfoSearchPojo.getStaffCode() == null ? "" : couponEntityInfoSearchPojo.getStaffCode());
                                row.createCell(12).setCellValue(couponEntityInfoSearchPojo.getStaffName() == null ? "" : couponEntityInfoSearchPojo.getStaffName());
                            }
                            catch (Exception e) {
                                this.logger.info("enter FileTaskServiceImpl exportEntityExcel Error:{}", (Throwable)e);
                            }
                        }
                    }, sort, new Object[]{entityParam});
                }
                catch (Exception e) {
                    this.logger.error("\u5f02\u5e38", (Throwable)e);
                }
            });
        } else if ("7".equals(entityParam.getListType()) || "8".equals(entityParam.getListType())) {
            this.logger.info("\u4f1a\u5458\u5361\u5238");
            Boolean isDesensitize = this.couponEntityService.getMemberDataDesensitizeByAccountConfig(accountPo.getSysAccountId());
            CacheThreadFactory.cacheThread().execute(() -> {
                try {
                    Method method = this.couponEntityServiceImpl.getClass().getMethod("getListEsExport", CouponEntityVO.class, Pageable.class);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    test.read("couponEntityServiceImpl", method, (couponEntityInfoSearchPojo, row) -> {
                        if (isDesensitize.booleanValue() && null != couponEntityInfoSearchPojo) {
                            couponEntityInfoSearchPojo.setCardNo(DesensitizeUtil.encrypt((String)couponEntityInfoSearchPojo.getCardNo()));
                            couponEntityInfoSearchPojo.setPhone(DesensitizeUtil.encrypt((String)couponEntityInfoSearchPojo.getPhone()));
                        }
                        if (row.getRowNum() == 0) {
                            row.createCell(0).setCellValue(entityParam.getListTypeBusinessName());
                            row.createCell(1).setCellValue("\u4f1a\u5458\u59d3\u540d");
                            row.createCell(2).setCellValue("\u4f1a\u5458\u624b\u673a\u53f7");
                            row.createCell(3).setCellValue("\u4f1a\u5458\u5361\u53f7");
                            row.createCell(4).setCellValue("\u6240\u5c5e\u95e8\u5e97Id");
                            row.createCell(5).setCellValue("\u6240\u5c5e\u95e8\u5e97Code");
                            row.createCell(6).setCellValue("\u6240\u5c5e\u95e8\u5e97");
                            row.createCell(7).setCellValue("\u5238\u6240\u5c5e\u8fd0\u8425\u7ec4\u7ec7");
                            row.createCell(8).setCellValue("\u5238\u6240\u5c5e\u8fd0\u8425\u7ec4\u7ec7\u7f16\u53f7");
                            row.createCell(9).setCellValue("\u5238\u540d\u79f0");
                            row.createCell(10).setCellValue("\u5238\u53f7");
                            row.createCell(11).setCellValue("\u5238\u5b9a\u4e49ID");
                            row.createCell(12).setCellValue("\u5238\u7c7b\u578b");
                            row.createCell(13).setCellValue("\u53d1\u9001\u65f6\u95f4");
                            row.createCell(14).setCellValue("\u5238\u72b6\u6001");
                            row.createCell(15).setCellValue("\u8ba2\u5355\u53f7");
                            row.createCell(16).setCellValue("\u8ba2\u5355\u91d1\u989d");
                            row.createCell(17).setCellValue("\u6210\u4ea4\u91d1\u989d");
                            row.createCell(18).setCellValue("\u6838\u9500\u65f6\u95f4");
                            int rowH = 19;
                            if (accountPo.getSysCompanyId().equals(this.sysCompanyId361)) {
                                row.createCell(rowH++).setCellValue("\u6838\u9500\u7ec4\u7ec7");
                            }
                            row.createCell(rowH++).setCellValue("\u6838\u9500\u95e8\u5e97Code");
                            row.createCell(rowH++).setCellValue("\u6838\u9500\u95e8\u5e97");
                            if (!"\u7ebf\u4e0bERP\u53d1\u5238".equals(entityParam.getListTypeBusinessName())) {
                                row.createCell(rowH++).setCellValue("\u8ba2\u5355\u4f1a\u5458");
                                row.createCell(rowH++).setCellValue("\u8ba2\u5355\u4f1a\u5458\u5361\u53f7");
                            }
                            row.createCell(rowH++).setCellValue("\u6838\u9500\u5bfc\u8d2dcode");
                            row.createCell(rowH++).setCellValue("\u6838\u9500\u5bfc\u8d2d\u4eba");
                        } else {
                            try {
                                row.createCell(0).setCellValue(couponEntityInfoSearchPojo.getBusinessName() == null ? "" : couponEntityInfoSearchPojo.getBusinessName());
                                row.createCell(1).setCellValue(couponEntityInfoSearchPojo.getName() == null ? "" : couponEntityInfoSearchPojo.getName());
                                row.createCell(2).setCellValue(couponEntityInfoSearchPojo.getPhone() == null ? "" : couponEntityInfoSearchPojo.getPhone());
                                row.createCell(3).setCellValue(couponEntityInfoSearchPojo.getCardNo() == null ? "" : couponEntityInfoSearchPojo.getCardNo());
                                row.createCell(4).setCellValue(couponEntityInfoSearchPojo.getServiceStoreId() == null ? "" : couponEntityInfoSearchPojo.getServiceStoreId());
                                row.createCell(5).setCellValue(couponEntityInfoSearchPojo.getServiceStoreCode() == null ? "" : couponEntityInfoSearchPojo.getServiceStoreCode());
                                row.createCell(6).setCellValue(couponEntityInfoSearchPojo.getServiceStoreName() == null ? "" : couponEntityInfoSearchPojo.getServiceStoreName());
                                row.createCell(7).setCellValue(couponEntityInfoSearchPojo.getOnlineOrgCode() == null && couponEntityInfoSearchPojo.getOnlineOrgName() == null ? "\u54c1\u724c\u603b\u90e8" : couponEntityInfoSearchPojo.getOnlineOrgName());
                                row.createCell(8).setCellValue(couponEntityInfoSearchPojo.getOnlineOrgCode() == null ? "" : couponEntityInfoSearchPojo.getOnlineOrgCode());
                                row.createCell(9).setCellValue(couponEntityInfoSearchPojo.getCouponName() == null ? "" : couponEntityInfoSearchPojo.getCouponName());
                                row.createCell(10).setCellValue(couponEntityInfoSearchPojo.getCouponCode() == null ? "" : couponEntityInfoSearchPojo.getCouponCode());
                                row.createCell(11).setCellValue(couponEntityInfoSearchPojo.getCouponDefinitionId() == null ? "" : couponEntityInfoSearchPojo.getCouponDefinitionId());
                                Byte useChannel = couponEntityInfoSearchPojo.getUseChannel();
                                row.createCell(12).setCellValue(this.getUseChannelName(useChannel));
                                row.createCell(13).setCellValue(couponEntityInfoSearchPojo.getCreateDate() == null ? "" : format.format(couponEntityInfoSearchPojo.getCreateDate()));
                                String valueName = couponEntityInfoSearchPojo.getCouponStatus().toString();
                                if (couponEntityInfoSearchPojo.getCouponStatus() == 20) {
                                    valueName = "\u672a\u4f7f\u7528";
                                } else if (couponEntityInfoSearchPojo.getCouponStatus() == 25) {
                                    valueName = "\u5df2\u8fc7\u671f";
                                } else if (couponEntityInfoSearchPojo.getCouponStatus() == 30) {
                                    valueName = "\u5df2\u6838\u9500";
                                }
                                row.createCell(14).setCellValue(valueName);
                                row.createCell(15).setCellValue(couponEntityInfoSearchPojo.getUseBusinessCode() == null ? "" : couponEntityInfoSearchPojo.getUseBusinessCode());
                                row.createCell(16).setCellValue(couponEntityInfoSearchPojo.getUseBusinessAmount() == null ? "" : couponEntityInfoSearchPojo.getUseBusinessAmount() + "");
                                row.createCell(17).setCellValue(couponEntityInfoSearchPojo.getUseBusinessAmount() == null ? "" : couponEntityInfoSearchPojo.getUseBusinessAmount() + "");
                                row.createCell(18).setCellValue(couponEntityInfoSearchPojo.getUseTime() == null ? "" : format.format(couponEntityInfoSearchPojo.getUseTime()));
                                int rowV = 19;
                                if (couponEntityInfoSearchPojo.getUseStoreId() != null) {
                                    ArrayList<String> storellist = new ArrayList<String>();
                                    storellist.add(couponEntityInfoSearchPojo.getUseStoreId() + "");
                                    SysStoreVo sysStoreVo = new SysStoreVo();
                                    sysStoreVo.setStoreIds(storellist);
                                    sysStoreVo.setSysCompanyId(couponEntityInfoSearchPojo.getSysCompanyId());
                                    ResponseData getStore = this.storeServiceRpc.getStoreGroupNameByStoreCodes(sysStoreVo);
                                    Map storeVoMap = (Map)getStore.getData();
                                    SysStoreVo storeVo = (SysStoreVo)storeVoMap.get(couponEntityInfoSearchPojo.getUseStoreId() + "");
                                    String getStoreName = storeVo.getStoreName();
                                    if (accountPo.getSysCompanyId().equals(this.sysCompanyId361)) {
                                        row.createCell(rowV++).setCellValue(couponEntityInfoSearchPojo.getUseOrgName());
                                    }
                                    row.createCell(rowV++).setCellValue(storeVo.getSysStoreOnlineCode());
                                    row.createCell(rowV++).setCellValue(getStoreName);
                                } else {
                                    if (accountPo.getSysCompanyId().equals(this.sysCompanyId361)) {
                                        row.createCell(rowV++).setCellValue(couponEntityInfoSearchPojo.getUseOrgName());
                                    }
                                    row.createCell(rowV++).setCellValue("");
                                    if (couponEntityInfoSearchPojo.getUseFrom() == null) {
                                        row.createCell(rowV++).setCellValue("");
                                    } else if (couponEntityInfoSearchPojo.getUseFrom() == 5) {
                                        row.createCell(rowV++).setCellValue("\u5bfc\u8d2d\u52a9\u624b");
                                    } else if (couponEntityInfoSearchPojo.getUseFrom() == 3) {
                                        row.createCell(rowV++).setCellValue("\u5fae\u5546\u57ce");
                                    } else if (couponEntityInfoSearchPojo.getUseFrom() == 1) {
                                        row.createCell(rowV++).setCellValue("CRM\u540e\u53f0");
                                    } else {
                                        row.createCell(rowV++).setCellValue("");
                                    }
                                }
                                if (!"\u7ebf\u4e0bERP\u53d1\u5238".equals(entityParam.getListTypeBusinessName())) {
                                    String useName;
                                    String cardNo = null;
                                    String useMemberCode = couponEntityInfoSearchPojo.getUseMemberCode();
                                    this.logger.info("\u67e5\u8be2\u5230\u7684\u5238couponEntityInfoSearchPojo:{}", (Object)JSON.toJSONString((Object)couponEntityInfoSearchPojo));
                                    if (useMemberCode == null) {
                                        useName = null;
                                    } else {
                                        MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
                                        membersInfoSearchVo.setMemberCode(useMemberCode);
                                        membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
                                        membersInfoSearchVo.setPageSize(Integer.valueOf(10));
                                        membersInfoSearchVo.setSysCompanyId(couponEntityInfoSearchPojo.getSysCompanyId());
                                        membersInfoSearchVo.setBrandId(couponEntityInfoSearchPojo.getSysBrandId());
                                        this.logger.info("membersInfoSearchVo:{}", (Object)JSON.toJSONString((Object)membersInfoSearchVo));
                                        ResponseData pageInfoResponseData = this.membersAdvancedSearchApiService.searchBasicMemberInfo(membersInfoSearchVo);
                                        this.logger.info("useMemberCode:{},\u4ecees\u67e5\u8be2\u5230\u7684\u4f1a\u5458\u6570\u636e\u662f:{}", (Object)useMemberCode, (Object)JSON.toJSONString((Object)pageInfoResponseData));
                                        useName = ((BasicMembersInfoSearchPojo)((com.bizvane.utils.responseinfo.PageInfo)pageInfoResponseData.getData()).getList().get(0)).getName();
                                        cardNo = ((BasicMembersInfoSearchPojo)((com.bizvane.utils.responseinfo.PageInfo)pageInfoResponseData.getData()).getList().get(0)).getCardNo();
                                    }
                                    row.createCell(rowV++).setCellValue(useName == null ? "" : useName);
                                    row.createCell(rowV++).setCellValue(cardNo == null ? "" : cardNo);
                                }
                                row.createCell(rowV++).setCellValue(couponEntityInfoSearchPojo.getStaffCode() == null ? "" : couponEntityInfoSearchPojo.getStaffCode());
                                row.createCell(rowV++).setCellValue(couponEntityInfoSearchPojo.getStaffName() == null ? "" : couponEntityInfoSearchPojo.getStaffName());
                            }
                            catch (Exception e) {
                                this.logger.info("enter FileTaskServiceImpl exportEntityExcel Error:{}", (Throwable)e);
                            }
                        }
                    }, sort, new Object[]{entityParam});
                }
                catch (Exception e) {
                    this.logger.error("\u5f02\u5e38", (Throwable)e);
                }
            });
        } else {
            Boolean isDesensitize = this.couponEntityService.getMemberDataDesensitizeByAccountConfig(accountPo.getSysAccountId());
            CacheThreadFactory.cacheThread().execute(() -> {
                this.logger.info("\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0:{}\uff0c\u5f53\u524d\u7ebf\u7a0bID\uff1a{}", (Object)Thread.currentThread().getName(), (Object)Thread.currentThread().getId());
                try {
                    Method method = this.couponEntityServiceImpl.getClass().getMethod("getListEsExport", CouponEntityVO.class, Pageable.class);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    test.read("couponEntityServiceImpl", method, (couponEntityInfoSearchPojo, row) -> {
                        if (isDesensitize.booleanValue() && null != couponEntityInfoSearchPojo) {
                            couponEntityInfoSearchPojo.setCardNo(DesensitizeUtil.encrypt((String)couponEntityInfoSearchPojo.getCardNo()));
                            couponEntityInfoSearchPojo.setPhone(DesensitizeUtil.encrypt((String)couponEntityInfoSearchPojo.getPhone()));
                        }
                        if (row.getRowNum() == 0) {
                            this.logger.info("rowV:{}", (Object)"rowV");
                            row.createCell(0).setCellValue("\u53d1\u5238\u7c7b\u578b");
                            row.createCell(1).setCellValue("\u4efb\u52a1\u540d\u79f0");
                            row.createCell(2).setCellValue("\u4f1a\u5458\u59d3\u540d");
                            row.createCell(3).setCellValue("\u4f1a\u5458\u624b\u673a\u53f7");
                            row.createCell(4).setCellValue("\u4f1a\u5458\u5361\u53f7");
                            row.createCell(5).setCellValue("\u5238\u540d\u79f0");
                            row.createCell(6).setCellValue("\u5238\u53f7");
                            row.createCell(7).setCellValue("\u5238\u7c7b\u578b\u53f7");
                            row.createCell(8).setCellValue("\u5238\u5b9a\u4e49ID");
                            row.createCell(9).setCellValue("\u5238\u9762\u989d/\u6298\u6263");
                            row.createCell(10).setCellValue("\u5238\u7c7b\u578b");
                            row.createCell(11).setCellValue("\u6240\u5c5e\u5e97\u94fa");
                            row.createCell(12).setCellValue("\u6240\u5c5e\u5e97\u94faid");
                            row.createCell(13).setCellValue("\u6240\u5c5e\u5e97\u94facode");
                            row.createCell(14).setCellValue("\u5238\u6240\u5c5e\u8fd0\u8425\u7ec4\u7ec7");
                            row.createCell(15).setCellValue("\u5238\u6240\u5c5e\u8fd0\u8425\u7ec4\u7ec7\u7f16\u53f7");
                            row.createCell(16).setCellValue("\u8ba2\u5355\u7f16\u53f7");
                            row.createCell(17).setCellValue("\u6210\u4ea4\u91d1\u989d");
                            row.createCell(18).setCellValue("\u53d1\u653e\u65f6\u95f4");
                            row.createCell(19).setCellValue("\u6838\u9500\u65f6\u95f4");
                            int rowH = 20;
                            if (accountPo.getSysCompanyId().equals(this.sysCompanyId361)) {
                                row.createCell(rowH++).setCellValue("\u6838\u9500\u7ec4\u7ec7");
                            }
                            row.createCell(rowH++).setCellValue("\u6838\u9500\u95e8\u5e97Code");
                            row.createCell(rowH++).setCellValue("\u6838\u9500\u95e8\u5e97");
                            row.createCell(rowH++).setCellValue("\u5238\u72b6\u6001");
                            row.createCell(rowH++).setCellValue("\u53d1\u5238\u4eba");
                            row.createCell(rowH++).setCellValue("\u6838\u9500\u5bfc\u8d2dcode");
                            row.createCell(rowH++).setCellValue("\u6838\u9500\u5bfc\u8d2d\u4eba");
                            if (accountPo.getSysCompanyId().equals(this.sysCompanyId)) {
                                row.createCell(rowH++).setCellValue("\u4e1a\u52a1\u5355\u53f7");
                            }
                        } else {
                            this.logger.info("couponEntityInfoSearchPojo info:{}", couponEntityInfoSearchPojo);
                            try {
                                row.createCell(0).setCellValue(CouponSendTypeEnum.getMessage((String)couponEntityInfoSearchPojo.getSendType()) == null ? "" : CouponSendTypeEnum.getMessage((String)couponEntityInfoSearchPojo.getSendType()));
                                row.createCell(1).setCellValue(couponEntityInfoSearchPojo.getBusinessName() == null ? "" : couponEntityInfoSearchPojo.getBusinessName());
                                row.createCell(2).setCellValue(couponEntityInfoSearchPojo.getName() == null ? "" : couponEntityInfoSearchPojo.getName());
                                row.createCell(3).setCellValue(couponEntityInfoSearchPojo.getPhone() == null ? "" : couponEntityInfoSearchPojo.getPhone());
                                row.createCell(4).setCellValue(couponEntityInfoSearchPojo.getCardNo() == null ? "" : couponEntityInfoSearchPojo.getCardNo());
                                row.createCell(5).setCellValue(couponEntityInfoSearchPojo.getCouponName() == null ? "" : couponEntityInfoSearchPojo.getCouponName());
                                row.createCell(6).setCellValue(couponEntityInfoSearchPojo.getCouponCode() == null ? "" : couponEntityInfoSearchPojo.getCouponCode());
                                row.createCell(7).setCellValue(couponEntityInfoSearchPojo.getCouponDefinitionCode() == null ? "" : couponEntityInfoSearchPojo.getCouponDefinitionCode());
                                row.createCell(8).setCellValue(couponEntityInfoSearchPojo.getCouponDefinitionId() == null ? "" : couponEntityInfoSearchPojo.getCouponDefinitionId());
                                if (couponEntityInfoSearchPojo.getPreferentialType() == 1) {
                                    row.createCell(9).setCellValue(couponEntityInfoSearchPojo.getMoney() == null ? "" : couponEntityInfoSearchPojo.getMoney().toString() + "\u5143");
                                } else if (couponEntityInfoSearchPojo.getPreferentialType() == 2) {
                                    row.createCell(9).setCellValue(couponEntityInfoSearchPojo.getDiscount() == null ? "" : couponEntityInfoSearchPojo.getDiscount() + "\u6298");
                                } else {
                                    row.createCell(9).setCellValue(couponEntityInfoSearchPojo.getMoney() == null ? "" : couponEntityInfoSearchPojo.getMoney().toString());
                                }
                                Byte useChannel = couponEntityInfoSearchPojo.getUseChannel();
                                row.createCell(10).setCellValue(this.getUseChannelName(useChannel));
                                row.createCell(11).setCellValue(couponEntityInfoSearchPojo.getServiceStoreName() == null ? "" : couponEntityInfoSearchPojo.getServiceStoreName());
                                row.createCell(12).setCellValue(couponEntityInfoSearchPojo.getServiceStoreId() == null ? "" : couponEntityInfoSearchPojo.getServiceStoreId());
                                row.createCell(13).setCellValue(couponEntityInfoSearchPojo.getServiceStoreCode() == null ? "" : couponEntityInfoSearchPojo.getServiceStoreCode());
                                row.createCell(14).setCellValue(couponEntityInfoSearchPojo.getOnlineOrgCode() == null && couponEntityInfoSearchPojo.getOnlineOrgName() == null ? "\u54c1\u724c\u603b\u90e8" : couponEntityInfoSearchPojo.getOnlineOrgName());
                                row.createCell(15).setCellValue(couponEntityInfoSearchPojo.getOnlineOrgCode() == null ? "" : couponEntityInfoSearchPojo.getOnlineOrgCode());
                                row.createCell(16).setCellValue(couponEntityInfoSearchPojo.getUseBusinessCode() == null ? "" : couponEntityInfoSearchPojo.getUseBusinessCode());
                                row.createCell(17).setCellValue(couponEntityInfoSearchPojo.getUseBusinessAmount() == null ? "" : couponEntityInfoSearchPojo.getUseBusinessAmount() + "");
                                row.createCell(18).setCellValue(couponEntityInfoSearchPojo.getCreateDate() == null ? "" : format.format(couponEntityInfoSearchPojo.getCreateDate()));
                                row.createCell(19).setCellValue(couponEntityInfoSearchPojo.getUseTime() == null ? "" : format.format(couponEntityInfoSearchPojo.getUseTime()));
                                int rowV = 20;
                                if (couponEntityInfoSearchPojo.getUseStoreId() != null) {
                                    ArrayList<String> storellist = new ArrayList<String>();
                                    storellist.add(couponEntityInfoSearchPojo.getUseStoreId() + "");
                                    SysStoreVo sysStoreVo = new SysStoreVo();
                                    sysStoreVo.setStoreIds(storellist);
                                    sysStoreVo.setSysCompanyId(couponEntityInfoSearchPojo.getSysCompanyId());
                                    ResponseData getStore = this.storeServiceRpc.getStoreGroupNameByStoreCodes(sysStoreVo);
                                    Map storeVoMap = (Map)getStore.getData();
                                    SysStoreVo storeVo = (SysStoreVo)storeVoMap.get(couponEntityInfoSearchPojo.getUseStoreId() + "");
                                    String getStoreName = storeVo.getStoreName();
                                    if (accountPo.getSysCompanyId().equals(this.sysCompanyId361)) {
                                        row.createCell(rowV++).setCellValue(couponEntityInfoSearchPojo.getUseOrgName());
                                    }
                                    row.createCell(rowV++).setCellValue(storeVo.getSysStoreOnlineCode());
                                    row.createCell(rowV++).setCellValue(getStoreName);
                                } else {
                                    if (accountPo.getSysCompanyId().equals(this.sysCompanyId361)) {
                                        row.createCell(rowV++).setCellValue(couponEntityInfoSearchPojo.getUseOrgName());
                                    }
                                    row.createCell(rowV++).setCellValue("");
                                    if (couponEntityInfoSearchPojo.getUseFrom() == null) {
                                        row.createCell(rowV++).setCellValue("");
                                    } else if (couponEntityInfoSearchPojo.getUseFrom() == 5) {
                                        row.createCell(rowV++).setCellValue("\u5bfc\u8d2d\u52a9\u624b");
                                    } else if (couponEntityInfoSearchPojo.getUseFrom() == 3) {
                                        row.createCell(rowV++).setCellValue("\u5fae\u5546\u57ce");
                                    } else if (couponEntityInfoSearchPojo.getUseFrom() == 1) {
                                        row.createCell(rowV++).setCellValue("CRM\u540e\u53f0");
                                    } else {
                                        row.createCell(rowV++).setCellValue("");
                                    }
                                }
                                String valueName = couponEntityInfoSearchPojo.getCouponStatus().toString();
                                if (couponEntityInfoSearchPojo.getCouponStatus() == 20) {
                                    valueName = "\u672a\u4f7f\u7528";
                                } else if (couponEntityInfoSearchPojo.getCouponStatus() == 25) {
                                    valueName = "\u5df2\u8fc7\u671f";
                                } else if (couponEntityInfoSearchPojo.getCouponStatus() == 30) {
                                    valueName = "\u5df2\u6838\u9500";
                                }
                                row.createCell(rowV++).setCellValue(valueName);
                                row.createCell(rowV++).setCellValue(couponEntityInfoSearchPojo.getCreateUserName() == null ? "" : couponEntityInfoSearchPojo.getCreateUserName());
                                row.createCell(rowV++).setCellValue(couponEntityInfoSearchPojo.getStaffCode() == null ? "" : couponEntityInfoSearchPojo.getStaffCode());
                                row.createCell(rowV++).setCellValue(couponEntityInfoSearchPojo.getStaffName() == null ? "" : couponEntityInfoSearchPojo.getStaffName());
                                if (accountPo.getSysCompanyId().equals(this.sysCompanyId)) {
                                    row.createCell(rowV++).setCellValue(couponEntityInfoSearchPojo.getServiceOrder() == null ? "" : couponEntityInfoSearchPojo.getServiceOrder());
                                }
                            }
                            catch (Exception e) {
                                this.logger.info("enter FileTaskServiceImpl exportEntityExcel Error:{}", (Throwable)e);
                            }
                        }
                    }, sort, new Object[]{entityParam});
                }
                catch (Exception e) {
                    this.logger.error("\u5f02\u5e38", (Throwable)e);
                }
            });
        }
        CacheThreadFactory.cacheThread().execute(() -> {
            OutputStream out = null;
            ByteArrayInputStream in = null;
            try {
                BigDecimal process = null;
                while (true) {
                    if ((process = StreamingExportExcelPageInfoUtil.getExportPercentageProcess((Object)taskId)).compareTo(new BigDecimal(0)) < 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(-1L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    if (process.compareTo(new BigDecimal(1)) == 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(99L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        out = new ByteArrayOutputStream();
                        test.exprotToZipOutputStream(out, fileName + ".xlsx", fileName + ".zip");
                        in = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                        String qiniuUrl = QiNiuUtil.upload((InputStream)in, (String)(fileName + ".zip"));
                        this.logger.info("enter out ok \u5bfc\u51fa\u5b8c\u6210" + qiniuUrl);
                        fileTaskPo.setFileStatus(Long.valueOf(100L));
                        fileTaskPo.setFileUnl(qiniuUrl);
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    fileTaskPo.setFileStatus(Long.valueOf(process.multiply(new BigDecimal(100)).longValue()));
                    this.fileTaskServiceRpc.update(fileTaskPo);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                fileTaskPo.setFileStatus(Long.valueOf(-1L));
                this.fileTaskServiceRpc.update(fileTaskPo);
                this.logger.error("\u5f02\u5e38", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.logger.error("\u5f02\u5e38", (Throwable)e);
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        this.logger.error("\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
        });
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<String> exportExcelCouponFail(CouponSendFailLogVO entityParam, SysAccountPO accountPo) {
        this.logger.info("enter FileTaskServiceImpl exportExcelCouponFail method {}", (Object)JacksonUtil.bean2Json((Object)entityParam));
        ResponseData responseData = new ResponseData();
        Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        String fileName = "\u5238\u53d1\u653e\u5931\u8d25\u8bb0\u5f55\u5bfc\u51fa" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        entityParam.setSysBrandId(accountPo.getBrandId());
        entityParam.setSysCompanyId(accountPo.getSysCompanyId());
        entityParam.setSysAccountId(accountPo.getSysAccountId());
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        PageInfo pageInfo = this.sendCouponService.couponSendFail(entityParam, (Pageable)pageable);
        int count = (int)pageInfo.getTotal();
        if (count == 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
            return responseData;
        }
        if (count > 500000) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setData((Object)String.valueOf(count));
            responseData.setMessage("\u6700\u591a\u5bfc\u51fa50\u4e07\u6761\u6570\u636e");
            return responseData;
        }
        StreamingExportExcelPageInfoUtil test = new StreamingExportExcelPageInfoUtil(Long.valueOf(pageInfo.getTotal()));
        FileTaskPo taskPO = new FileTaskPo();
        taskPO.setSysCompanyId(accountPo.getSysCompanyId());
        taskPO.setSysBrandId(accountPo.getBrandId());
        taskPO.setTaskId(taskId);
        taskPO.setFileName(fileName);
        taskPO.setCreateUserId(accountPo.getSysAccountId());
        taskPO.setCreateUserName(accountPo.getName());
        taskPO.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        taskPO.setTaskName("\u5238\u53d1\u653e\u5931\u8d25\u8bb0\u5f55\u5bfc\u51fa");
        taskPO.setTaskTypeCode(count + "\u6761");
        taskPO.setFileStatus(Long.valueOf(0L));
        taskPO.setFileType("EXPORT");
        ResponseData addFileResponseData = this.fileTaskServiceRpc.addFileTask(taskPO);
        taskPO.setFileTaskId(Long.valueOf(Long.parseLong((String)addFileResponseData.getData())));
        test.setExportProcessId((Object)taskId);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"couponSendFailLogId"});
        CacheThreadFactory.cacheThread().execute(() -> {
            try {
                Method method = this.sendCouponServiceImpl.getClass().getMethod("couponSendFail", CouponSendFailLogVO.class, Pageable.class);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                test.read("sendCouponServiceImpl", method, (logVO, row) -> {
                    if (row.getRowNum() == 0) {
                        row.createCell(0).setCellValue("\u5238\u540d\u79f0");
                        row.createCell(1).setCellValue("\u4e1a\u52a1\u540d\u79f0");
                        row.createCell(2).setCellValue("\u4f1a\u5458\u59d3\u540d");
                        row.createCell(3).setCellValue("\u4f1a\u5458\u624b\u673a\u53f7");
                        row.createCell(4).setCellValue("\u4e1a\u52a1\u5355\u53f7");
                        row.createCell(5).setCellValue("\u8865\u53d1\u65f6\u95f4");
                        row.createCell(6).setCellValue("\u8865\u53d1\u6b21\u6570");
                        row.createCell(7).setCellValue("\u5931\u8d25\u539f\u56e0");
                    } else {
                        try {
                            row.createCell(0).setCellValue(logVO.getCouponName());
                            row.createCell(1).setCellValue(logVO.getBusinessName());
                            row.createCell(2).setCellValue(logVO.getMemberName());
                            row.createCell(3).setCellValue(logVO.getPhone());
                            row.createCell(4).setCellValue(logVO.getBizCode());
                            row.createCell(5).setCellValue(logVO.getSendDate() != null ? DateUtil.format((Date)logVO.getSendDate(), (String)"yyyy-MM-dd HH:mm:ss SSS") : "");
                            row.createCell(6).setCellValue((double)logVO.getFailTimes().intValue());
                            row.createCell(7).setCellValue(logVO.getFailDetail());
                        }
                        catch (Exception e) {
                            this.logger.info("enter FileTaskServiceImpl exportEntityExcel Error:{}", (Throwable)e);
                        }
                    }
                }, sort, new Object[]{entityParam});
            }
            catch (Exception e) {
                this.logger.error("\u5f02\u5e38", (Throwable)e);
            }
        });
        CacheThreadFactory.cacheThread().execute(() -> {
            OutputStream out = null;
            ByteArrayInputStream in = null;
            try {
                BigDecimal process = null;
                while (true) {
                    if ((process = StreamingExportExcelPageInfoUtil.getExportPercentageProcess((Object)taskId)).compareTo(new BigDecimal(0)) < 0) {
                        taskPO.setFileStatus(Long.valueOf(-1L));
                        this.fileTaskServiceRpc.update(taskPO);
                        break;
                    }
                    if (process.compareTo(new BigDecimal(1)) == 0) {
                        taskPO.setFileStatus(Long.valueOf(99L));
                        this.fileTaskServiceRpc.update(taskPO);
                        out = new ByteArrayOutputStream();
                        test.exprotToZipOutputStream(out, fileName + ".xlsx", fileName + ".zip");
                        in = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                        String qiniuUrl = QiNiuUtil.upload((InputStream)in, (String)(fileName + ".zip"));
                        this.logger.info("enter out ok \u5bfc\u51fa\u5b8c\u6210" + qiniuUrl);
                        taskPO.setFileStatus(Long.valueOf(100L));
                        taskPO.setFileUnl(qiniuUrl);
                        this.fileTaskServiceRpc.update(taskPO);
                        break;
                    }
                    taskPO.setFileStatus(Long.valueOf(process.multiply(new BigDecimal(100)).longValue()));
                    this.fileTaskServiceRpc.update(taskPO);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                taskPO.setFileStatus(Long.valueOf(-1L));
                this.fileTaskServiceRpc.update(taskPO);
                this.logger.error("\u5f02\u5e38", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.logger.error("\u5f02\u5e38", (Throwable)e);
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        this.logger.error("\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
        });
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<String> getHideCouponRecordExportExcel(HideCouponRecordParam param, SysAccountPO accountPo) {
        this.logger.info("enter FileTaskServiceImpl getHideCouponRecordExportExcel method {}", (Object)JacksonUtil.bean2Json((Object)param));
        ResponseData responseData = new ResponseData();
        Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        String fileName = "\u5238\u9690\u85cf|\u663e\u793a\u64cd\u4f5c\u8bb0\u5f55\u5bfc\u51fa" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        PageInfo pageInfo = this.couponEntityService.getHideCouponRecordList(param, (Pageable)pageable);
        int count = (int)pageInfo.getTotal();
        if (count == 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
            return responseData;
        }
        if (count > 500000) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setData((Object)String.valueOf(count));
            responseData.setMessage("\u6700\u591a\u5bfc\u51fa50\u4e07\u6761\u6570\u636e");
            return responseData;
        }
        StreamingExportExcelPageInfoUtil test = new StreamingExportExcelPageInfoUtil(Long.valueOf(pageInfo.getTotal()));
        FileTaskPo taskPO = new FileTaskPo();
        taskPO.setSysCompanyId(accountPo.getSysCompanyId());
        taskPO.setSysBrandId(accountPo.getBrandId());
        taskPO.setTaskId(taskId);
        taskPO.setFileName(fileName);
        taskPO.setCreateUserId(accountPo.getSysAccountId());
        taskPO.setCreateUserName(accountPo.getName());
        taskPO.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        taskPO.setTaskName("\u5238\u9690\u85cf|\u663e\u793a\u64cd\u4f5c\u8bb0\u5f55\u5bfc\u51fa");
        taskPO.setTaskTypeCode(count + "\u6761");
        taskPO.setFileStatus(Long.valueOf(0L));
        taskPO.setFileType("EXPORT");
        ResponseData addFileResponseData = this.fileTaskServiceRpc.addFileTask(taskPO);
        taskPO.setFileTaskId(Long.valueOf(Long.parseLong((String)addFileResponseData.getData())));
        test.setExportProcessId((Object)taskId);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"couponRecordId"});
        CacheThreadFactory.cacheThread().execute(() -> {
            try {
                Method method = this.couponEntityServiceImpl.getClass().getMethod("getHideCouponRecordList", HideCouponRecordParam.class, Pageable.class);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                test.read("couponEntityServiceImpl", method, (logVO, row) -> {
                    if (row.getRowNum() == 0) {
                        row.createCell(0).setCellValue("\u4f1a\u5458\u624b\u673a\u53f7");
                        row.createCell(1).setCellValue("\u4f1a\u5458\u5361\u53f7");
                        row.createCell(2).setCellValue("\u5238\u53f7");
                        row.createCell(3).setCellValue("\u64cd\u4f5c\u7c7b\u578b");
                        row.createCell(4).setCellValue("\u64cd\u4f5c\u4eba");
                        row.createCell(5).setCellValue("\u64cd\u4f5c\u65f6\u95f4");
                    } else {
                        try {
                            row.createCell(0).setCellValue(logVO.getMemberPhone());
                            row.createCell(1).setCellValue(logVO.getCardNo());
                            row.createCell(2).setCellValue(logVO.getCouponCode());
                            row.createCell(3).setCellValue(Integer.valueOf(4).equals(logVO.getType()) ? "\u9690\u85cf" : "\u53d6\u6d88\u9690\u85cf");
                            row.createCell(4).setCellValue(logVO.getCreateUserName());
                            row.createCell(5).setCellValue(logVO.getCreateDate() != null ? DateUtil.format((Date)logVO.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss") : "");
                        }
                        catch (Exception e) {
                            this.logger.info("enter FileTaskServiceImpl getHideCouponRecordExportExcel Error:{}", (Throwable)e);
                        }
                    }
                }, sort, new Object[]{param});
            }
            catch (Exception e) {
                this.logger.error("\u5f02\u5e38", (Throwable)e);
            }
        });
        CacheThreadFactory.cacheThread().execute(() -> {
            OutputStream out = null;
            ByteArrayInputStream in = null;
            try {
                BigDecimal process = null;
                while (true) {
                    if ((process = StreamingExportExcelPageInfoUtil.getExportPercentageProcess((Object)taskId)).compareTo(new BigDecimal(0)) < 0) {
                        taskPO.setFileStatus(Long.valueOf(-1L));
                        this.fileTaskServiceRpc.update(taskPO);
                        break;
                    }
                    if (process.compareTo(new BigDecimal(1)) == 0) {
                        taskPO.setFileStatus(Long.valueOf(99L));
                        this.fileTaskServiceRpc.update(taskPO);
                        out = new ByteArrayOutputStream();
                        test.exprotToZipOutputStream(out, fileName + ".xlsx", fileName + ".zip");
                        in = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                        String qiniuUrl = QiNiuUtil.upload((InputStream)in, (String)(fileName + ".zip"));
                        this.logger.info("enter out ok \u5bfc\u51fa\u5b8c\u6210" + qiniuUrl);
                        taskPO.setFileStatus(Long.valueOf(100L));
                        taskPO.setFileUnl(qiniuUrl);
                        this.fileTaskServiceRpc.update(taskPO);
                        break;
                    }
                    taskPO.setFileStatus(Long.valueOf(process.multiply(new BigDecimal(100)).longValue()));
                    this.fileTaskServiceRpc.update(taskPO);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                taskPO.setFileStatus(Long.valueOf(-1L));
                this.fileTaskServiceRpc.update(taskPO);
                this.logger.error("\u5f02\u5e38", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.logger.error("\u5f02\u5e38", (Throwable)e);
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        this.logger.error("\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
        });
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    private String getUseChannelName(Byte useChannel) {
        String useChannelName = "";
        if (Byte.valueOf("1").equals(useChannel)) {
            useChannelName = "\u7ebf\u4e0b\u5238";
        } else if (Byte.valueOf("2").equals(useChannel)) {
            useChannelName = "\u5168\u6e20\u9053\u5238";
        } else if (Byte.valueOf("3").equals(useChannel)) {
            useChannelName = "\u5fae\u5546\u57ce";
        } else if (Byte.valueOf("4").equals(useChannel)) {
            useChannelName = "\u5458\u5de5\u5238";
        } else if (Byte.valueOf("5").equals(useChannel)) {
            useChannelName = "\u5929\u732b\u5238";
        } else if (Byte.valueOf("6").equals(useChannel)) {
            useChannelName = "\u79ef\u5206\u5238";
        }
        return useChannelName;
    }

    public FileTaskPo addExportTask(SysAccountPo accountPo, Long taskId, String fileName, int count) {
        FileTaskPo taskPO = new FileTaskPo();
        taskPO.setSysCompanyId(accountPo.getSysCompanyId());
        taskPO.setSysBrandId(accountPo.getBrandId());
        taskPO.setTaskId(taskId);
        taskPO.setFileName(fileName);
        taskPO.setCreateUserId(accountPo.getSysAccountId());
        taskPO.setCreateUserName(accountPo.getName());
        taskPO.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        taskPO.setTaskName(SysResponseEnum.COUPON_EXPORT_LOG.getMessage());
        taskPO.setTaskTypeCode(count + "\u6761");
        taskPO.setFileStatus(Long.valueOf(0L));
        taskPO.setFileType("EXPORT");
        ResponseData responseData = this.fileTaskServiceRpc.addFileTask(taskPO);
        taskPO.setFileTaskId(Long.valueOf(Long.parseLong((String)responseData.getData())));
        return taskPO;
    }

    private void monitorExportPercentage(String exportFileName, FileTaskPo fileTaskPo, StreamingExportExcelUtil exportExcelUtil) {
        CacheThreadFactory.cacheThread().execute(() -> {
            try {
                BigDecimal process = null;
                while (true) {
                    if ((process = StreamingExportExcelUtil.getExportPercentageProcess((Object)fileTaskPo.getTaskId())).compareTo(new BigDecimal(0)) < 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(-1L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    if (process.compareTo(new BigDecimal(1)) == 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(99L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        exportExcelUtil.exprotToZipOutputStream((OutputStream)out, exportFileName + ".xlsx", exportFileName + ".zip");
                        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                        String qiniuUrl = QiNiuUtil.upload((InputStream)in, (String)(exportFileName + ".zip"));
                        this.logger.info("enter FileTaskServiceImpl monitorExportPercentage method param:qiniuUrl:{}", (Object)qiniuUrl);
                        in.close();
                        ((OutputStream)out).close();
                        fileTaskPo.setFileStatus(Long.valueOf(100L));
                        fileTaskPo.setFileUnl(qiniuUrl);
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    fileTaskPo.setFileStatus(Long.valueOf(process.multiply(new BigDecimal(100)).longValue()));
                    this.fileTaskServiceRpc.update(fileTaskPo);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                fileTaskPo.setFileStatus(Long.valueOf(-1L));
                this.fileTaskServiceRpc.update(fileTaskPo);
                this.logger.error("\u5f02\u5e38", (Throwable)e);
            }
        });
    }

    static /* synthetic */ StoreServiceRpc access$000(FileTaskServiceImpl x0) {
        return x0.storeServiceRpc;
    }
}

