/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.bo.CompanyBrandBO;
import com.bizvane.couponfacade.models.bo.CreateErpCouponBO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.ErpSendCouponRequestVO;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.DateUtil;
import com.bizvane.couponservice.service.CompanyBrandService;
import com.bizvane.couponservice.service.CouponDefinitionService;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.ErpSendCouponService;
import com.bizvane.couponservice.service.MemberService;
import com.bizvane.couponservice.service.SendCouponMqService;
import io.jsonwebtoken.lang.Assert;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ErpSendCouponServiceImpl
implements ErpSendCouponService {
    private static final Logger log = LoggerFactory.getLogger(ErpSendCouponServiceImpl.class);
    private static final String IPOS_COUPON_KEY = "KafkaConsumerErpSendCoupon-couponCode-%s-%s-%s";
    private static final String IPOS_COUPON_VALUE = "&";
    @Autowired
    private CouponDefinitionService couponDefinitionService;
    @Autowired
    private CouponEntityService couponEntityService;
    @Autowired
    private SendCouponMqService sendCouponMqService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private CompanyBrandService companyBrandService;
    @Autowired
    private StringRedisTemplate redis;

    public void execute(ErpSendCouponRequestVO vo) {
        log.info("ErpSendCouponServiceImpl get coupon code : {}", (Object)vo.getCouponCode());
        String rsKey = String.format(IPOS_COUPON_KEY, vo.getOfflineCompanyCode(), vo.getBrandCode(), vo.getCouponCode());
        Boolean iscontinue = this.redis.opsForValue().setIfAbsent((Object)("coupon:biz:erpSendCoupon:" + rsKey), (Object)IPOS_COUPON_VALUE);
        Assert.isTrue((iscontinue != null && iscontinue != false ? 1 : 0) != 0, (String)"1\u5206\u949f\u4e4b\u5185\u91cd\u590d\u6d88\u606f\uff0c\u4e0d\u4e88\u6267\u884c");
        this.redis.expire((Object)("coupon:biz:erpSendCoupon:" + rsKey), 1L, TimeUnit.MINUTES);
        CompanyBrandBO companyBrand = this.companyBrandService.getCompanyBrand(vo.getOfflineCompanyCode(), vo.getBrandCode());
        CouponDefinitionPO couponDefinitionPo = this.couponDefinitionService.getCouponDefinitionByErp(vo.getCouponDefinitionCode(), companyBrand);
        String memberCode = this.memberService.queryMemberCodeByErpId(vo.getErpId(), companyBrand.getCompanyId(), companyBrand.getBrandId());
        Assert.hasText((String)memberCode, (String)"\u83b7\u53d6\u4e0d\u5230\u6b63\u786e\u7684\u4f1a\u5458\u4fe1\u606f");
        log.info("ErpSendCouponServiceImpl get membercode \uff1a{}", (Object)memberCode);
        Byte couponStatus = null;
        boolean valid = Boolean.TRUE;
        boolean isUse = SystemConstants.COUPON_USE_UNUSED;
        switch (vo.getIsUse()) {
            case 0: {
                couponStatus = SystemConstants.COUPON_STATUS_UNUSED;
                break;
            }
            case 1: {
                couponStatus = SystemConstants.COUPON_STATUS_USED;
                isUse = SystemConstants.COUPON_USE_USED;
                break;
            }
            case 2: {
                couponStatus = SystemConstants.COUPON_STATUS_OVERDUE;
                break;
            }
            case 3: {
                valid = Boolean.FALSE;
                break;
            }
        }
        CreateErpCouponBO createErpCouponBO = CreateErpCouponBO.builder().couponDefinitionPO(couponDefinitionPo).companyBrandBO(companyBrand).couponCode(vo.getCouponCode()).sendDate(DateUtil.parse((String)vo.getSendDate(), (String)"yyyy-MM-dd HH:mm:ss")).expiredDate(DateUtil.parse((String)vo.getExpiredDate(), (String)"yyyy-MM-dd HH:mm:ss")).offlineUpdateDate(vo.getOfflineUpdateDate()).memberCode(memberCode).isUse(Boolean.valueOf(isUse)).couponStatus(couponStatus).useTime(DateUtil.parse((String)vo.getUseTime(), (String)"yyyy-MM-dd HH:mm:ss")).useBuinessCode(vo.getUseBuinessCode()).useStoreCode(vo.getUseStoreCode()).usePassword(vo.getUsePassword()).valid(Boolean.valueOf(valid)).build();
        CouponEntityPO couponEntity = this.couponEntityService.findCouponEntityByCouponCode(vo.getCouponCode(), companyBrand);
        if (couponEntity == null) {
            CouponEntityPO couponEntityPo = this.couponEntityService.saveErpSendCouponEntity(createErpCouponBO);
            if (SystemConstants.COUPON_USE_UNUSED.equals(couponEntityPo.getIsUse())) {
                this.sendCouponMqService.sendCouponOnline(couponDefinitionPo, couponEntityPo);
            }
        } else {
            if (!SendTypeEnum.SEND_COUPON_FROM_ERP.getCode().equals(couponEntity.getSendType())) {
                log.info("This is not a coupon generated offline, not synchronized");
                return;
            }
            createErpCouponBO.setCouponEntityId(couponEntity.getCouponEntityId());
            int count = this.couponEntityService.updateErpSendCouponEntity(createErpCouponBO);
            log.info("ERP\u53d1\u5238\u540c\u6b65\u66f4\u65b0\uff1a{}", (Object)count);
        }
    }
}

