/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.bizvane.couponfacade.models.po.SysCodeValuePO;
import com.bizvane.couponfacade.models.po.SysCodeValuePOExample;
import com.bizvane.couponservice.common.system.DictHelper;
import com.bizvane.couponservice.mappers.SysCodeValuePOMapper;
import com.bizvane.couponservice.service.DictService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictServiceImpl
implements DictService {
    private static final Logger logger = LoggerFactory.getLogger(DictServiceImpl.class);
    @Autowired
    private SysCodeValuePOMapper sysCodeValuePOMapper;

    public List<SysCodeValuePO> getDicts(String dictType) {
        return DictHelper.getDicts((String)dictType);
    }

    public Map<String, SysCodeValuePO> getDictMap(String dictType) {
        return DictHelper.getDictMap((String)dictType);
    }

    public void init() {
        SysCodeValuePOExample sysCodeValueExample = new SysCodeValuePOExample();
        List list = this.sysCodeValuePOMapper.selectByExample(sysCodeValueExample);
        DictHelper.getDictMap().clear();
        for (SysCodeValuePO dict : list) {
            this.initData(dict);
        }
    }

    protected void initData(SysCodeValuePO dict) {
        List list = (List)DictHelper.getDictMap().get(dict.getCodeType());
        if (list == null || list.isEmpty()) {
            ArrayList<SysCodeValuePO> dicts = new ArrayList<SysCodeValuePO>();
            dicts.add(dict);
            DictHelper.getDictMap().put(dict.getCodeType(), dicts);
        } else {
            ((List)DictHelper.getDictMap().get(dict.getCodeType())).add(dict);
        }
    }

    public void reload() {
        logger.info("======================================reload dict data start================================");
        this.init();
        logger.info("======================================reload dict data end================================");
    }

    public SysCodeValuePO getSysCodeValue(String dictType, String itemCode) {
        List sysCodeValues = DictHelper.getDicts((String)dictType);
        for (SysCodeValuePO sysCodeValue : sysCodeValues) {
            String item = sysCodeValue.getItemCode();
            if (!item.contains(itemCode)) continue;
            return sysCodeValue;
        }
        return null;
    }

    public Map<String, List<SysCodeValuePO>> getDictsBatch(String dictType) {
        HashMap<String, List<SysCodeValuePO>> map = new HashMap<String, List<SysCodeValuePO>>();
        String[] dictArr = dictType.split(",");
        if (dictArr.length > 0) {
            for (int i = 0; i < dictArr.length; ++i) {
                List list = DictHelper.getDicts((String)dictArr[i]);
                map.put(dictArr[i], list);
            }
        }
        return map;
    }
}

