/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysDimSkuPo;
import com.bizvane.centerstageservice.models.po.SysOnlineOrgPo;
import com.bizvane.centerstageservice.models.po.SysSkuPropertyPO;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.GetOnlineOrgStoresRequestVo;
import com.bizvane.centerstageservice.models.vo.OnlineOrgStoreInfoResponseVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysDimSkuServiceRpc;
import com.bizvane.centerstageservice.rpc.SysOnlineOrgServcieRpc;
import com.bizvane.couponfacade.enums.TypeEnum;
import com.bizvane.couponfacade.es.CouponEntityInfoSearchPojo;
import com.bizvane.couponfacade.models.bo.CouponEntityAvailResponseBO;
import com.bizvane.couponfacade.models.bo.CouponOrderAvailableBO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponfacade.models.po.CouponOrderEntityPO;
import com.bizvane.couponfacade.models.po.OrderDetailInfoPO;
import com.bizvane.couponfacade.models.po.OrderInfoPO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponOrderEntityVO;
import com.bizvane.couponservice.common.constants.CouponConstants;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.DateUtil;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.es.repository.CouponEntityserviceRepository;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.service.CouponVerifyService;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class CouponVerifyServiceImpl
implements CouponVerifyService {
    private static final Logger logger = LoggerFactory.getLogger(CouponVerifyServiceImpl.class);
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private CouponEntityserviceRepository couponEntityserviceRepository;
    @Autowired
    private SysDimSkuServiceRpc sysDimSkuServiceRpc;
    @Autowired
    private SysOnlineOrgServcieRpc sysOnlineOrgServcieRpc;
    @Value(value="${361wm.wmCompanyId}")
    private Long wmCompanyId;

    public ResponseData<CouponOrderEntityVO> verifyCouponRules(CouponOrderEntityPO couponOrderEntity) throws Exception {
        ArrayList OrderDetailInfoPOList;
        int sum;
        Boolean flag;
        byte activitySuperpositionType;
        logger.info("verifyCouponRules couponOrderEntity :{}", (Object)JSONObject.toJSONString((Object)couponOrderEntity));
        ArrayList notSuitGoodList = Lists.newArrayList();
        if (null == couponOrderEntity) {
            return this.assembleResult("2", "", "", "", new BigDecimal(0), Double.valueOf(0.0), new BigDecimal(0), 0, 0, "", new ArrayList(), new BigDecimal(0), "\u6b64\u4f18\u60e0\u5238\u4e0d\u5b58\u5728", null, null, notSuitGoodList, 0, null, null);
        }
        CouponEntityPO couponEntityPO = this.findCouponEntityPO(couponOrderEntity.getCouponCode());
        logger.info("verifyCouponRules couponEntityPO :{}", (Object)JSONObject.toJSONString((Object)couponEntityPO));
        if (null == couponEntityPO) {
            return this.assembleResult(TypeEnum.COUPON_NOT_EXISTS.getCode(), "", "", "", new BigDecimal(0), Double.valueOf(0.0), new BigDecimal(0), 0, 0, "", new ArrayList(), new BigDecimal(0), "\u6b64\u4f18\u60e0\u5238\u4e0d\u5b58\u5728", null, null, notSuitGoodList, 0, null, null);
        }
        if (couponEntityPO.getValidDateStart().compareTo(new Date()) > 0) {
            return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), "", "", "", new BigDecimal(0), Double.valueOf(0.0), new BigDecimal(0), 0, 0, "", new ArrayList(), new BigDecimal(0), "\u6b64\u4f18\u60e0\u5238\u4e0d\u80fd\u4f7f\u7528\uff0c\u672a\u5230\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", null, null, notSuitGoodList, 0, null, null);
        }
        if (couponEntityPO.getValidDateEnd().compareTo(new Date()) < 0) {
            return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), "", "", "", new BigDecimal(0), Double.valueOf(0.0), new BigDecimal(0), 0, 0, "", new ArrayList(), new BigDecimal(0), "\u6b64\u4f18\u60e0\u5238\u5df2\u8fc7\u671f", null, null, notSuitGoodList, 0, null, null);
        }
        if (couponEntityPO.getIsLock().booleanValue()) {
            return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), "", "", "", new BigDecimal(0), Double.valueOf(0.0), new BigDecimal(0), 0, 0, "", new ArrayList(), new BigDecimal(0), "\u6b64\u4f18\u60e0\u5238\u5df2\u88ab\u51bb\u7ed3", null, null, notSuitGoodList, 0, null, null);
        }
        BigDecimal maxOffsetAmount = new BigDecimal(0);
        String couponCode = couponEntityPO.getCouponCode();
        String couponName = couponEntityPO.getCouponName();
        int couponSize = 2;
        int couponSizeNum = 0;
        int doubleDiscountState = 0;
        BigDecimal money = new BigDecimal(0);
        BigDecimal minMoney = new BigDecimal(0);
        Double discount = 0.0;
        CouponDefinitionPOWithBLOBs couponDefinition = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(couponEntityPO.getCouponDefinitionId())));
        logger.info("verifyCouponRules couponDefinition :{}", (Object)JSONObject.toJSONString((Object)couponDefinition));
        if (null == couponDefinition) {
            return new ResponseData(SysResponseEnum.COUPON_NOT_EXIST.getCode(), SysResponseEnum.COUPON_NOT_EXIST.getMessage());
        }
        byte couponType = couponDefinition.getPreferentialType();
        String couponTypeStr = String.valueOf(couponType);
        if (couponType != SystemConstants.PREFERENTIAL_TYPE_MONEY) {
            discount = couponEntityPO.getDiscount() == null ? 0.0 : couponEntityPO.getDiscount().doubleValue();
            minMoney = couponDefinition.getMinConsume();
        } else {
            money = couponEntityPO.getMoney();
            minMoney = couponDefinition.getMinConsume();
        }
        if (null == couponDefinition.getIsSuperposition() || couponDefinition.getIsSuperposition().booleanValue()) {
            couponSize = 1;
            couponSizeNum = 0;
        } else {
            couponSize = 2;
            couponSizeNum = 1;
        }
        if (couponDefinition.getActivitySuperpositionType() != null && (activitySuperpositionType = couponDefinition.getActivitySuperpositionType().byteValue()) == SystemConstants.ACTIVITY_SUPERPOSITION_TYPE_YES) {
            doubleDiscountState = 1;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_OVERDUE)) {
            return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u5df2\u8fc7\u671f", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED) && couponEntityPO.getIsUse().booleanValue()) {
            return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u5df2\u6838\u9500", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
        }
        boolean isSendTypeFlag = true;
        if ("110".equals(couponEntityPO.getSendType()) || "111".equals(couponEntityPO.getSendType()) || "120".equals(couponEntityPO.getSendType())) {
            isSendTypeFlag = false;
        }
        if (StringUtils.isNotEmpty((String)couponEntityPO.getMemberCode()) && isSendTypeFlag) {
            MemberInfoModel model = new MemberInfoModel();
            model.setMemberCode(couponEntityPO.getMemberCode());
            ResponseData memberInfo = this.memberInfoApiService.getSingleMemberModel(model);
            if (null == memberInfo.getData()) {
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u4f1a\u5458", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
            if (!couponOrderEntity.getOrderInfoPO().getErpId().equalsIgnoreCase(((MemberInfoModel)memberInfo.getData()).getErpId())) {
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u53ea\u9650\u672c\u4eba\u4f7f\u7528", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
        }
        if (SystemConstants.USE_CHANNEL_ONLINE.equals(couponDefinition.getUseChannel()) || SystemConstants.USE_CHANNEL_EMP.equals(couponDefinition.getUseChannel()) || SystemConstants.USE_CHANNEL_TMALL.equals(couponDefinition.getUseChannel())) {
            return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e3a\u7ebf\u4e0a\u5238,\u7ebf\u4e0b\u4e0d\u80fd\u6838\u9500", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
        }
        if (couponOrderEntity.getOrderInfoPO().getOrderMoney().compareTo(couponDefinition.getMinConsume()) < 0) {
            return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u7b26\u5408\u6700\u4f4e\u6d88\u8d39\u91d1\u989d", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
        }
        if (null != couponDefinition.getMaxPreferential() && couponDefinition.getMaxPreferential().compareTo(new BigDecimal(0)) > 0) {
            BigDecimal allGoodsMoney = new BigDecimal(0);
            ArrayList OrderDetailInfoPOList2 = couponOrderEntity.getOrderDetailInfoPOList();
            for (OrderDetailInfoPO po : OrderDetailInfoPOList2) {
                allGoodsMoney = allGoodsMoney.add(po.getGoodsMoney().multiply(new BigDecimal(po.getGoodsNumber())));
            }
            BigDecimal preferentialgoods = new BigDecimal(0);
            if (this.wmCompanyId.equals(couponDefinition.getSysCompanyId())) {
                preferentialgoods = preferentialgoods.add(allGoodsMoney.subtract(allGoodsMoney.multiply(new BigDecimal(discount).divide(new BigDecimal(10), 2, RoundingMode.HALF_UP))));
                logger.info("wmCompanyId:{},preferentialgoods:{}", (Object)this.wmCompanyId, (Object)preferentialgoods);
            } else {
                preferentialgoods = preferentialgoods.add(allGoodsMoney.subtract(couponOrderEntity.getOrderInfoPO().getOrderMoney()));
                logger.info("preferentialgoods:{}", (Object)preferentialgoods);
            }
            if (preferentialgoods.compareTo(couponDefinition.getMaxPreferential()) > 0) {
                maxOffsetAmount = couponDefinition.getMaxPreferential();
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u80fd\u4f7f\u7528\uff0c\u5df2\u8d85\u51fa\u6700\u5927\u4f18\u60e0\u989d\u5ea6", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
            maxOffsetAmount = couponDefinition.getMaxPreferential();
        }
        ArrayList minDiscountFilterList = new ArrayList();
        Boolean minDiscountFlag = true;
        if (null != couponDefinition.getMinDiscount() && couponDefinition.getMinDiscount().compareTo(BigDecimal.valueOf(0.0)) != 0) {
            ArrayList OrderDetailInfoPOList3 = couponOrderEntity.getOrderDetailInfoPOList();
            flag = false;
            minDiscountFlag = false;
            JSONObject suitGoodCode = new JSONObject();
            for (String[] po : OrderDetailInfoPOList3) {
                BigDecimal goodsRebate = new BigDecimal(po.getGoodsRebate()).multiply(new BigDecimal("10"));
                if (goodsRebate.compareTo(couponDefinition.getMinDiscount()) > 0 || goodsRebate.compareTo(couponDefinition.getMinDiscount()) == 0) {
                    OrderDetailInfoPO orderDetailInfoPO = new OrderDetailInfoPO();
                    orderDetailInfoPO.setGoodsCode(po.getGoodsCode());
                    orderDetailInfoPO.setGoodsMoney(po.getGoodsMoney());
                    orderDetailInfoPO.setGoodsNumber(po.getGoodsNumber());
                    orderDetailInfoPO.setGoodsRebate(po.getGoodsRebate());
                    orderDetailInfoPO.setMoney(po.getMoney());
                    orderDetailInfoPO.setSkuCode(po.getSkuCode());
                    minDiscountFilterList.add(orderDetailInfoPO);
                    suitGoodCode.put(po.getGoodsCode(), (Object)po.getSkuCode());
                    continue;
                }
                flag = true;
            }
            if (flag.booleanValue()) {
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u8ba2\u5355\u4e2d\u6709\u5546\u54c1\u6298\u6263\u5c0f\u4e8e\u4f18\u60e0\u5238\u6700\u4f4e\u6298\u6263\u9650\u5236", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
        }
        if (minDiscountFlag.booleanValue()) {
            minDiscountFilterList = couponOrderEntity.getOrderDetailInfoPOList();
        }
        if (null != couponDefinition.getMinCommodityNum() && couponOrderEntity.getOrderInfoPO().getOrderNumber().intValue() < couponDefinition.getMinCommodityNum()) {
            return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u7b26\u5408\u5546\u54c1\u6570\u91cf\u6700\u4f4e\u9650\u5236", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
        }
        if (null != couponDefinition.getMinCommodityNum() && couponOrderEntity.getOrderInfoPO().getOrderNumber().intValue() > couponDefinition.getMinCommodityNum()) {
            return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u7b26\u5408\u5546\u54c1\u6570\u91cf\u6700\u9ad8\u9650\u5236", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
        }
        if (null != couponDefinition.getGoodsCondition() && !Boolean.FALSE.equals(couponOrderEntity.getGoodsNumConditionSwitch()) && (sum = couponOrderEntity.getOrderDetailInfoPOList().stream().filter(f -> f.getGoodsMoney() != null && f.getGoodsMoney().compareTo(new BigDecimal(0)) > 0).mapToInt(f -> Integer.parseInt(f.getGoodsNumber())).sum()) >= couponDefinition.getGoodsCondition()) {
            return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u7b26\u5408\u5546\u54c1\u6570\u91cf\u9650\u5236", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
        }
        ArrayList<String> suitGoodlist = new ArrayList<String>();
        if (couponDefinition.getApplianceCommodityType() == 2) {
            OrderDetailInfoPOList = minDiscountFilterList;
            ArrayList blackGoodCodeList = new ArrayList();
            if (this.blackCommodityCheck(couponDefinition, OrderDetailInfoPOList, suitGoodlist, blackGoodCodeList)) {
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", new ArrayList(), maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u80fd\u5e94\u7528\u4e8e\u8ba2\u5355\u4e2d\u7684\u5546\u54c1", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
            if (this.singleWhiteGoodCheck(couponDefinition, suitGoodlist, OrderDetailInfoPOList, notSuitGoodList)) {
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", suitGoodlist, maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u80fd\u5e94\u7528\u4e8e\u8ba2\u5355\u4e2d\u7684\u5546\u54c1", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
            if (this.compoundWhiteGoodCheck(couponDefinition, suitGoodlist, OrderDetailInfoPOList, notSuitGoodList)) {
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", suitGoodlist, maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u80fd\u5e94\u7528\u4e8e\u8ba2\u5355\u4e2d\u7684\u5546\u54c1", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
            if (this.goodsPropertyCheck(couponOrderEntity, couponDefinition, suitGoodlist)) {
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", suitGoodlist, maxOffsetAmount, "\u90e8\u5206\u5546\u54c1\u4e0d\u5728\u5238\u5546\u54c1\u5c5e\u6027\u9002\u7528\u8303\u56f4", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
        } else if (couponDefinition.getApplianceCommodityType() == 1) {
            OrderDetailInfoPOList = minDiscountFilterList;
            for (OrderDetailInfoPO po : OrderDetailInfoPOList) {
                suitGoodlist.add(po.getGoodsCode());
            }
        }
        if (couponDefinition.getApplianceStoreType() == 2) {
            if (StringUtils.isBlank((String)couponOrderEntity.getOrderInfo().getStoreCode())) {
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", suitGoodlist, maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u7b26\u5408\u9002\u7528\u6b64\u95e8\u5e97", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
            if (StringUtils.isNotEmpty((String)couponDefinition.getStoreBlacklist())) {
                flag = false;
                String[] blackListStores = couponDefinition.getStoreBlacklist().split(",");
                ResponseData responseData = this.getStoreByOfflineCode(couponEntityPO.getSysCompanyId(), couponOrderEntity.getOrderInfoPO().getStoreCode());
                if (null == responseData.getData()) {
                    return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", suitGoodlist, maxOffsetAmount, "\u6b64\u8ba2\u5355\u5e97\u94fa\u672a\u80fd\u67e5\u8be2\u5230", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
                }
                for (String store : blackListStores) {
                    if (!store.equals(((SysStorePo)responseData.getData()).getSysStoreOfflineCode())) continue;
                    flag = true;
                }
                logger.info("\u5e97\u94fa:{}", (Object)flag);
                if (flag.booleanValue()) {
                    return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", suitGoodlist, maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u7b26\u5408\u9002\u7528\u6b64\u95e8\u5e97", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
                }
            }
            if (StringUtils.isNotEmpty((String)couponDefinition.getStoreWhitelist())) {
                String[] suitStore = couponDefinition.getStoreWhitelist().split(",");
                Boolean flag2 = true;
                String storeOnlineCode = couponOrderEntity.getOrderInfo().getStoreCode();
                List storeListByOnlineCode = this.getStoreListByOnlineCode(couponEntityPO.getSysCompanyId(), Arrays.asList(suitStore));
                if (CollectionUtils.isNotEmpty((Collection)storeListByOnlineCode) && storeListByOnlineCode.contains(storeOnlineCode)) {
                    flag2 = false;
                }
                if (flag2.booleanValue()) {
                    return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", suitGoodlist, maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u7b26\u5408\u9002\u7528\u6b64\u95e8\u5e97", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
                }
            }
        }
        if (CouponConstants.PART_ORG.equals(couponDefinition.getApplianceOrgType()) && StringUtils.isNotBlank((String)couponDefinition.getApplianceOrgCodes())) {
            List appliance;
            String[] orgCodes = couponDefinition.getApplianceOrgCodes().split(",");
            GetOnlineOrgStoresRequestVo requestVo = new GetOnlineOrgStoresRequestVo();
            requestVo.setSysCompanyId(couponDefinition.getSysCompanyId());
            requestVo.setBrandId(couponDefinition.getSysBrandId());
            requestVo.setOnlineOrgCodes(Arrays.asList(orgCodes));
            ResponseData storesResp = this.sysOnlineOrgServcieRpc.getStoresByOnlineOrgCodes(requestVo);
            if (storesResp == null || storesResp.getCode() == SysResponseEnum.FAILED.getCode()) {
                throw new RuntimeException();
            }
            if (!((List)storesResp.getData()).isEmpty() && couponOrderEntity.getOrderInfo() != null && StringUtils.isNotBlank((String)couponOrderEntity.getOrderInfo().getStoreCode()) && !(appliance = ((List)storesResp.getData()).stream().map(OnlineOrgStoreInfoResponseVo::getSysStoreOfflineCode).collect(Collectors.toList())).contains(couponOrderEntity.getOrderInfo().getStoreCode())) {
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", suitGoodlist, maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u7b26\u5408\u9002\u7528\u6b64\u95e8\u5e97(\u7ec4\u7ec7\u9650\u5236)", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
        }
        if (StringUtils.isNotBlank((String)couponDefinition.getOrganizationCode())) {
            if (StringUtils.isBlank((String)couponOrderEntity.getOrderInfo().getStoreCode())) {
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", suitGoodlist, maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u7b26\u5408\u9002\u7528\u6b64\u95e8\u5e97", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
            ResponseData onlineOrgRes = this.sysOnlineOrgServcieRpc.getOnlineOrgByOfflineStoreCode(couponDefinition.getSysCompanyId(), couponOrderEntity.getOrderInfo().getStoreCode());
            logger.info("\u521b\u5efa\u4eba\u8fd0\u8425\u7ec4\u7ec7\u6821\u9a8c,onlineOrgRes:{}", (Object)JacksonUtil.bean2Json((Object)onlineOrgRes));
            if (onlineOrgRes == null || onlineOrgRes.getData() == null || !couponDefinition.getOrganizationCode().equals(((SysOnlineOrgPo)onlineOrgRes.getData()).getOnlineOrgCode())) {
                return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", suitGoodlist, maxOffsetAmount, "\u6b64\u4f18\u60e0\u5238\u4e0d\u7b26\u5408\u9002\u7528\u6b64\u95e8\u5e97", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
            }
        }
        return this.assembleResult(TypeEnum.COUPON_ABLE_TO_USE_YES.getCode(), couponCode, couponName, couponTypeStr, money, discount, minMoney, couponSize, couponSizeNum, "", suitGoodlist, maxOffsetAmount, "", couponDefinition.getCouponDefinitionId(), couponDefinition.getMoney(), notSuitGoodList, doubleDiscountState, couponDefinition.getGoodsCondition(), couponDefinition.getMaxPreferential());
    }

    private boolean compoundWhiteGoodCheck(CouponDefinitionPOWithBLOBs couponDefinition, ArrayList<String> suitGoodlist, ArrayList<OrderDetailInfoPO> orderDetailInfoPOList, ArrayList<String> notSuitGoodList) {
        if (StringUtils.isNotEmpty((String)couponDefinition.getCommodityCompoundWhitelist())) {
            logger.info("compoundWhiteGoodCheck orderDetailInfoPOList:{}", JSONArray.toJSON(orderDetailInfoPOList));
            String[] commoditys = couponDefinition.getCommodityCompoundWhitelist().split(",");
            for (OrderDetailInfoPO po : orderDetailInfoPOList) {
                if (Arrays.asList(commoditys).contains(po.getGoodsCode())) {
                    suitGoodlist.add(po.getGoodsCode());
                    continue;
                }
                notSuitGoodList.add(po.getGoodsCode());
            }
            return suitGoodlist.size() != orderDetailInfoPOList.size();
        }
        return false;
    }

    private boolean singleWhiteGoodCheck(CouponDefinitionPOWithBLOBs couponDefinition, ArrayList<String> suitGoodlist, ArrayList<OrderDetailInfoPO> orderDetailInfoPOList, ArrayList<String> notSuitGoodList) {
        if (StringUtils.isNotEmpty((String)couponDefinition.getCommodityWhitelist())) {
            logger.info("singleWhiteGoodCheck orderDetailInfoPOList:{}", JSONArray.toJSON(orderDetailInfoPOList));
            Boolean whiteGoodCheck = Boolean.FALSE;
            String[] commoditys = couponDefinition.getCommodityWhitelist().split(",");
            for (OrderDetailInfoPO po : orderDetailInfoPOList) {
                if (Arrays.asList(commoditys).contains(po.getGoodsCode())) {
                    whiteGoodCheck = Boolean.TRUE;
                    if (suitGoodlist.contains(po.getGoodsCode())) continue;
                    suitGoodlist.add(po.getGoodsCode());
                    continue;
                }
                if (notSuitGoodList.contains(po.getGoodsCode())) continue;
                notSuitGoodList.add(po.getGoodsCode());
            }
            return whiteGoodCheck == false;
        }
        return false;
    }

    private boolean blackCommodityCheck(CouponDefinitionPOWithBLOBs couponDefinition, ArrayList<OrderDetailInfoPO> minDiscountFilterList, ArrayList<String> suitGoodlist, ArrayList<String> blackGoodCodeList) {
        if (StringUtils.isNotEmpty((String)couponDefinition.getCommodityBlacklist())) {
            logger.info("blackCommodityCheck minDiscountFilterList:{}", JSONArray.toJSON(minDiscountFilterList));
            Boolean blackGoodListCheck = Boolean.FALSE;
            String[] commoditys = couponDefinition.getCommodityBlacklist().split(",");
            for (OrderDetailInfoPO po : minDiscountFilterList) {
                if (!Arrays.asList(commoditys).contains(po.getGoodsCode())) continue;
                blackGoodCodeList.add(po.getGoodsCode());
                blackGoodListCheck = Boolean.TRUE;
            }
            if (blackGoodListCheck.booleanValue()) {
                return true;
            }
            ArrayList<OrderDetailInfoPO> OrderDetailInfoPOListFilter = minDiscountFilterList;
            Iterator<OrderDetailInfoPO> ite = OrderDetailInfoPOListFilter.iterator();
            while (ite.hasNext()) {
                OrderDetailInfoPO po = ite.next();
                for (int i = 0; i < blackGoodCodeList.size(); ++i) {
                    if (!blackGoodCodeList.get(i).equals(po.getGoodsCode())) continue;
                    ite.remove();
                }
            }
            for (OrderDetailInfoPO po : OrderDetailInfoPOListFilter) {
                suitGoodlist.add(po.getGoodsCode());
            }
        }
        return false;
    }

    private boolean goodsPropertyCheck(CouponOrderEntityPO couponOrderEntity, CouponDefinitionPOWithBLOBs couponDefinition, ArrayList<String> suitGoodlist) throws Exception {
        if (CollectionUtils.isNotEmpty((Collection)JSONArray.parseArray((String)couponDefinition.getOfflinePrdCode())) && CollectionUtils.isNotEmpty((Collection)couponOrderEntity.getOrderDetailInfo())) {
            ArrayList orderDetailInfo = couponOrderEntity.getOrderDetailInfo();
            ArrayList cate1CodeList = Lists.newArrayList();
            ArrayList cate2CodeList = Lists.newArrayList();
            ArrayList cate3CodeList = Lists.newArrayList();
            ArrayList yearCodeList = Lists.newArrayList();
            ArrayList seasonCodeList = Lists.newArrayList();
            JSONArray goodsPropertiesLimit = JSONArray.parseArray((String)couponDefinition.getOfflinePrdCode());
            for (int i = 0; i < goodsPropertiesLimit.size(); ++i) {
                String prdCodes = goodsPropertiesLimit.getJSONObject(i).get((Object)"str").toString();
                if (!StringUtils.isNotBlank((String)prdCodes)) continue;
                List<String> list = Arrays.asList(prdCodes.split(","));
                if ("\u5927\u7c7b".equals(goodsPropertiesLimit.getJSONObject(i).get((Object)"prdParentName"))) {
                    cate1CodeList.addAll(list);
                    continue;
                }
                if ("\u4e2d\u7c7b".equals(goodsPropertiesLimit.getJSONObject(i).get((Object)"prdParentName"))) {
                    cate2CodeList.addAll(list);
                    continue;
                }
                if ("\u5c0f\u7c7b".equals(goodsPropertiesLimit.getJSONObject(i).get((Object)"prdParentName"))) {
                    cate3CodeList.addAll(list);
                    continue;
                }
                if ("\u5e74\u4efd".equals(goodsPropertiesLimit.getJSONObject(i).get((Object)"prdParentName"))) {
                    yearCodeList.addAll(list);
                    continue;
                }
                if (!"\u5b63\u8282".equals(goodsPropertiesLimit.getJSONObject(i).get((Object)"prdParentName"))) continue;
                seasonCodeList.addAll(list);
            }
            logger.info("cate1CodeList:{}", JSONArray.toJSON((Object)cate1CodeList));
            logger.info("cate2CodeList:{}", JSONArray.toJSON((Object)cate2CodeList));
            logger.info("cate3CodeList:{}", JSONArray.toJSON((Object)cate3CodeList));
            logger.info("yearCodeList:{}", JSONArray.toJSON((Object)yearCodeList));
            logger.info("seasonCodeList:{}", JSONArray.toJSON((Object)seasonCodeList));
            Boolean goodsPropertyLimit = Boolean.FALSE;
            String skuCodes = orderDetailInfo.stream().map(OrderDetailInfoPO::getSkuCode).distinct().collect(Collectors.joining(","));
            ResponseData skuListResp = this.sysDimSkuServiceRpc.getSkuBySkuCodeStrBrandCompanyId(skuCodes, couponDefinition.getSysBrandId(), couponDefinition.getSysCompanyId());
            if (skuListResp.getCode() == SysResponseEnum.FAILED.getCode()) {
                throw new RuntimeException("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
            }
            List skuListData = (List)skuListResp.getData();
            for (SysDimSkuPo commodity : skuListData) {
                JSONArray properties;
                Boolean singleCommodityLimit = Boolean.FALSE;
                if (CollectionUtils.isNotEmpty((Collection)cate1CodeList) && !cate1CodeList.contains(commodity.getCata1Code()) || CollectionUtils.isNotEmpty((Collection)cate2CodeList) && !cate2CodeList.contains(commodity.getCata2Code()) || CollectionUtils.isNotEmpty((Collection)cate3CodeList) && !cate3CodeList.contains(commodity.getCata3Code()) || CollectionUtils.isNotEmpty((Collection)yearCodeList) && !yearCodeList.contains(commodity.getYearPrd())) {
                    goodsPropertyLimit = Boolean.TRUE;
                    singleCommodityLimit = Boolean.TRUE;
                    logger.info("commodity:{}", (Object)JSONObject.toJSONString((Object)commodity));
                }
                if (CollectionUtils.isNotEmpty((Collection)(properties = (JSONArray)JSON.parse((String)commodity.getProperties())))) {
                    for (int i = 0; i < properties.size(); ++i) {
                        JSONObject property = properties.getJSONObject(i);
                        SysSkuPropertyPO.SkuProperty skuProperty = (SysSkuPropertyPO.SkuProperty)JSON.toJavaObject((JSON)property, SysSkuPropertyPO.SkuProperty.class);
                        if (skuProperty == null || !StringUtils.isNotEmpty((String)skuProperty.getOfflineCode()) || skuProperty.getType() != 2 || !CollectionUtils.isNotEmpty((Collection)seasonCodeList) || seasonCodeList.contains(skuProperty.getOfflineCode())) continue;
                        goodsPropertyLimit = Boolean.TRUE;
                        singleCommodityLimit = Boolean.TRUE;
                        logger.info("season \u5224\u65ad:{}", (Object)JSONObject.toJSONString((Object)property));
                    }
                }
                if (singleCommodityLimit.booleanValue()) continue;
                suitGoodlist.add(commodity.getProductCode());
            }
            return goodsPropertyLimit;
        }
        return false;
    }

    public ResponseData<PageInfo<CouponEntityAvailResponseBO>> mbrAvailableCouponList(CouponOrderAvailableBO bo) {
        logger.info("CouponVerifyServiceImpl mbrAvailableCouponList method");
        ResponseData responseData = new ResponseData();
        SysBrandPo brandPo = new SysBrandPo();
        brandPo.setBrandCode(bo.getBrandCode());
        ResponseData brandPoResponseData = this.brandServiceRpc.getBrandIdAndCompanyIdByCode(brandPo);
        if (brandPoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || brandPoResponseData.getData() == null) {
            logger.info("mbrAvailableCouponList getBrandIdAndCompanyIdByCode \u6839\u636e\u4f20\u5165\u7684brandCode:{}\u67e5\u8be2\u4e0d\u5230\u54c1\u724c\u4fe1\u606f", (Object)bo.getBrandCode());
            responseData.setCode(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
            responseData.setMessage(brandPoResponseData.getMessage());
            return responseData;
        }
        SysBrandPo sysBrandPo = (SysBrandPo)brandPoResponseData.getData();
        MemberInfoModel model = MemberInfoModel.builder().phone(bo.getPhone()).erpId(bo.getErpId()).cardNo(bo.getCardNo()).sysCompanyId(sysBrandPo.getSysCompanyId()).brandId(sysBrandPo.getSysBrandId()).build();
        ResponseData memberInfoResponseData = this.memberInfoApiService.getMemberModel(model);
        if (memberInfoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || memberInfoResponseData.getData() == null) {
            logger.info("mbrAvailableCouponList getMemberModel \u6839\u636e\u4f20\u5165\u7684phone:{},erpId:{},cardNo:{},brandCode:{}\u67e5\u8be2\u4e0d\u5230\u4f1a\u5458\u4fe1\u606f", new Object[]{bo.getPhone(), bo.getErpId(), bo.getCardNo(), bo.getBrandCode()});
            responseData.setCode(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
            responseData.setMessage("\u4f1a\u5458\u4e0d\u5b58\u5728");
            return responseData;
        }
        MemberInfoModel memberInfoModel = (MemberInfoModel)memberInfoResponseData.getData();
        ArrayList<String> ableCouponList = new ArrayList<String>();
        ArrayList<String> notAbleCouponList = new ArrayList<String>();
        CouponOrderEntityPO couponOrderEntityPO = new CouponOrderEntityPO();
        couponOrderEntityPO.setSysCompanyId(sysBrandPo.getSysCompanyId());
        couponOrderEntityPO.setSysBrandId(sysBrandPo.getSysBrandId());
        OrderInfoPO orderInfo = bo.getOrderInfo();
        orderInfo.setErpId(memberInfoModel.getErpId());
        couponOrderEntityPO.setOrderInfoPO(orderInfo);
        couponOrderEntityPO.setOrderDetailInfoPOList(bo.getOrderDetailInfo());
        BoolQueryBuilder builderCoupon = QueryBuilders.boolQuery();
        CouponEntityVO entityParam = new CouponEntityVO();
        entityParam.setMemberCode(memberInfoModel.getMemberCode());
        entityParam.setSysBrandId(sysBrandPo.getSysBrandId());
        entityParam.setSysCompanyId(sysBrandPo.getSysCompanyId());
        entityParam.setValid(Boolean.valueOf(true));
        builderCoupon = this.getESWhere(entityParam, builderCoupon);
        ArrayList<CouponEntityAvailResponseBO> couponEntityAvailResponseBOList = new ArrayList<CouponEntityAvailResponseBO>();
        long total = 0L;
        int pageNo = 0;
        int pageSize = 0;
        if (StringUtils.isEmpty((String)bo.getAvailableType()) || "3".equals(bo.getAvailableType())) {
            PageRequest pageable = PageRequest.of((int)(bo.getPageNo() - 1), (int)bo.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"couponEntityId"}));
            logger.info("mbrAvailableCouponList ES DSL builder1{}", (Object)builderCoupon);
            Page pageCoupon = this.couponEntityserviceRepository.search((QueryBuilder)builderCoupon, (Pageable)pageable);
            List entityVOList = pageCoupon.getContent();
            if (CollectionUtils.isEmpty((Collection)entityVOList)) {
                logger.info("mbrAvailableCouponList \u67e5\u8be2\u5238\u5217\u8868\u4e3a\u7a7a");
                return responseData;
            }
            total = pageCoupon.getTotalElements();
            pageNo = pageCoupon.getNumber();
            pageSize = pageCoupon.getSize();
            for (CouponEntityInfoSearchPojo entity : entityVOList) {
                CouponEntityAvailResponseBO entityResponseBO = new CouponEntityAvailResponseBO();
                BeanUtils.copyProperties((Object)entity, (Object)entityResponseBO);
                entityResponseBO.setUseStoreCode(entity.getUseStoreId());
                try {
                    couponOrderEntityPO.setCouponCode(entity.getCouponCode());
                    ResponseData couponOrderEntityVOResponseData = this.verifyCouponRules(couponOrderEntityPO);
                    String couponType = ((CouponOrderEntityVO)couponOrderEntityVOResponseData.getData()).getType();
                    entityResponseBO.setAvailableType(couponType);
                }
                catch (Exception e) {
                    logger.info("mbrAvailableCouponList verifyCouponRules error couponCode:{}", (Object)entity.getCouponCode());
                    entityResponseBO.setAvailableType(TypeEnum.COUPON_ABLE_TO_USE_NO.getCode());
                }
                couponEntityAvailResponseBOList.add(entityResponseBO);
            }
        } else if ("1".equals(bo.getAvailableType()) || "2".equals(bo.getAvailableType())) {
            logger.info("mbrAvailableCouponList ES DSL builder2{}", (Object)builderCoupon);
            Iterable iterable = this.couponEntityserviceRepository.search((QueryBuilder)builderCoupon);
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                String couponCode = ((CouponEntityInfoSearchPojo)iterator.next()).getCouponCode();
                couponOrderEntityPO.setCouponCode(couponCode);
                try {
                    ResponseData couponOrderEntityVOResponseData = this.verifyCouponRules(couponOrderEntityPO);
                    String couponType = ((CouponOrderEntityVO)couponOrderEntityVOResponseData.getData()).getType();
                    if (TypeEnum.COUPON_ABLE_TO_USE_YES.getCode().equals(couponType)) {
                        ableCouponList.add(couponCode);
                        continue;
                    }
                    if (!TypeEnum.COUPON_ABLE_TO_USE_NO.getCode().equals(couponType)) continue;
                    notAbleCouponList.add(couponCode);
                }
                catch (Exception e) {
                    logger.info("mbrAvailableCouponList verifyCouponRules error couponCode:{}", (Object)couponCode);
                }
            }
            BoolQueryBuilder builderCouponfinal = QueryBuilders.boolQuery();
            if ("1".equals(bo.getAvailableType())) {
                if (CollectionUtils.isEmpty(ableCouponList)) {
                    logger.info("mbrAvailableCouponList ableCouponList \u67e5\u8be2\u5238\u5217\u8868\u4e3a\u7a7a");
                    return responseData;
                }
                entityParam.setCouponCodeList(ableCouponList);
                builderCouponfinal = this.getESWhere(entityParam, builderCouponfinal);
            } else if ("2".equals(bo.getAvailableType())) {
                if (CollectionUtils.isEmpty(notAbleCouponList)) {
                    logger.info("mbrAvailableCouponList notAbleCouponList \u67e5\u8be2\u5238\u5217\u8868\u4e3a\u7a7a");
                    return responseData;
                }
                entityParam.setCouponCodeList(notAbleCouponList);
                builderCouponfinal = this.getESWhere(entityParam, builderCouponfinal);
            }
            PageRequest pageable = PageRequest.of((int)(bo.getPageNo() - 1), (int)bo.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"couponEntityId"}));
            logger.info("mbrAvailableCouponList ES DSL builder3{}", (Object)builderCouponfinal);
            logger.info("mbrAvailableCouponList es\u5238\u67e5\u8be2\u5f00\u59cb--" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss SSS"));
            Page pageCoupon = this.couponEntityserviceRepository.search((QueryBuilder)builderCouponfinal, (Pageable)pageable);
            logger.info("mbrAvailableCouponList es\u5238\u67e5\u8be2\u7ed3\u675f--" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss SSS"));
            List entityVOList = pageCoupon.getContent();
            if (CollectionUtils.isEmpty((Collection)entityVOList)) {
                logger.info("mbrAvailableCouponList \u67e5\u8be2\u5238\u5217\u8868\u4e3a\u7a7a");
                return responseData;
            }
            total = pageCoupon.getTotalElements();
            pageNo = pageCoupon.getNumber();
            pageSize = pageCoupon.getSize();
            for (CouponEntityInfoSearchPojo entity : entityVOList) {
                CouponEntityAvailResponseBO entityResponseBO = new CouponEntityAvailResponseBO();
                BeanUtils.copyProperties((Object)entity, (Object)entityResponseBO);
                entityResponseBO.setUseStoreCode(entity.getUseStoreId());
                entityResponseBO.setAvailableType(bo.getAvailableType());
                couponEntityAvailResponseBOList.add(entityResponseBO);
            }
        }
        PageInfo pageinfo = new PageInfo(couponEntityAvailResponseBOList);
        pageinfo.setTotal(total);
        pageinfo.setPageNum(pageNo);
        pageinfo.setPageSize(pageSize);
        responseData.setData((Object)pageinfo);
        return responseData;
    }

    private ResponseData<CouponOrderEntityVO> assembleResult(String type, String couponCode, String couponName, String couponType, BigDecimal money, Double discount, BigDecimal minMoney, int couponSize, int couponSizeNum, String storeCodes, List<String> suitGoodlist, BigDecimal maxOffsetAmount, String reason, Long couponDefinitionId, BigDecimal exchangeValue, ArrayList<String> notSuitGoodList, int doubleDiscountState, Integer goodsNumCondition, BigDecimal maxPreferential) {
        ResponseData result = new ResponseData();
        suitGoodlist = this.removeNull(suitGoodlist);
        result.setCode(SysResponseEnum.SUCCESS.getCode());
        result.setMessage(SysResponseEnum.SUCCESS.getMessage());
        String join = Joiner.on((String)",").join((Iterable)suitGoodlist);
        CouponOrderEntityVO vo = new CouponOrderEntityVO();
        vo.setType(type);
        vo.setCouponCode(couponCode);
        vo.setCouponName(couponName);
        vo.setCouponType(couponType);
        vo.setMaxOffsetAmount(maxOffsetAmount);
        vo.setMoney(money);
        BigDecimal discountTemp = new BigDecimal(discount);
        vo.setDiscount(discountTemp.divide(new BigDecimal(10), 2, RoundingMode.HALF_UP).doubleValue());
        vo.setMinMoney(minMoney);
        vo.setCouponSize(couponSize);
        vo.setCouponSizeNum(couponSizeNum);
        vo.setStoreCodes(storeCodes);
        vo.setGoodsSKUCodes(join);
        vo.setReason(reason);
        vo.setCouponDefinitionId(couponDefinitionId);
        vo.setExchangeValue(exchangeValue);
        vo.setGoodsSKUCodesNot(notSuitGoodList);
        vo.setDoubleDiscountState(Integer.valueOf(doubleDiscountState));
        vo.setGoodsCondition(goodsNumCondition);
        vo.setMaxPreferential(maxPreferential);
        result.setData((Object)vo);
        return result;
    }

    private CouponEntityPO findCouponEntityPO(String couponCode) {
        logger.info("enter  CouponVerifyServiceImpl findCouponEntityPO method");
        CouponEntityPOExample entityExample = new CouponEntityPOExample();
        entityExample.createCriteria().andCouponCodeEqualTo(couponCode).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List entityList = this.couponEntityPOMapper.selectByExample(entityExample);
        CouponEntityPO entityPO = null;
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityPO = (CouponEntityPO)entityList.get(0);
        }
        return entityPO;
    }

    private ResponseData<SysStorePo> getStoreByOfflineCode(Long sysCompanyId, String storeOfflineCode) {
        ResponseData responseData = this.storeServiceRpc.getStoreByOfflineCode(storeOfflineCode, sysCompanyId);
        return responseData;
    }

    private List<String> getStoreListByOnlineCode(Long sysCompanyId, List<String> storeOnlineCodeList) {
        List<String> storeOfflineCodeList = new ArrayList<String>();
        ResponseData storeListByOnlineCode = this.storeServiceRpc.getStoreListByOnlineCode(storeOnlineCodeList, sysCompanyId);
        List storeList = (List)storeListByOnlineCode.getData();
        if (CollectionUtils.isNotEmpty((Collection)storeList)) {
            storeOfflineCodeList = storeList.stream().map(SysStorePo::getSysStoreOfflineCode).collect(Collectors.toList());
        }
        return storeOfflineCodeList;
    }

    private List<String> removeNull(List<String> oldList) {
        oldList.removeAll(Collections.singleton(null));
        return oldList;
    }

    public BoolQueryBuilder getESWhere(CouponEntityVO infoSearchVo, BoolQueryBuilder builder) throws MemberException {
        if (infoSearchVo.getValid() != null) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"valid", (Object)infoSearchVo.getValid()));
        }
        if (null != infoSearchVo.getSysCompanyId()) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"sysCompanyId", (Object)infoSearchVo.getSysCompanyId()));
        }
        if (null != infoSearchVo.getSysBrandId()) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"sysBrandId", (Object)infoSearchVo.getSysBrandId()));
        }
        if (infoSearchVo.getCouponCodeList() != null) {
            BoolQueryBuilder couponBuilder = QueryBuilders.boolQuery();
            List couponCodeList = infoSearchVo.getCouponCodeList();
            while (couponCodeList != null && couponCodeList.size() > 0) {
                if (couponCodeList.size() > 1000) {
                    couponBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"couponCode.keyword", couponCodeList.subList(0, 1000)));
                    couponCodeList = couponCodeList.subList(1000, couponCodeList.size());
                    continue;
                }
                couponBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"couponCode.keyword", couponCodeList.subList(0, couponCodeList.size())));
                couponCodeList = null;
            }
            builder.filter((QueryBuilder)couponBuilder);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getCouponCode())) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"couponCode.keyword", (Object)infoSearchVo.getCouponCode()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoSearchVo.getMemberCode())) {
            builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"memberCode", (Object)infoSearchVo.getMemberCode()));
        }
        return builder;
    }
}

