/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.exception.ExceptionUtils;
import com.bizvane.baisonBase.facade.models.LedengCouponTransferRequest;
import com.bizvane.baisonBase.facade.models.mj.MjCouponTransferRequestVo;
import com.bizvane.baisonBase.facade.models.mj.MjCouponUseRequestVo;
import com.bizvane.baisonBase.facade.rpc.LedengServiceRpc;
import com.bizvane.baisonBase.facade.rpc.MjMemberServiceNewRpc;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.CouponCancelRequestVO;
import com.bizvane.connectorservice.entity.common.CouponGiveRequestVO;
import com.bizvane.connectorservice.entity.common.CouponUseRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.ConnectorServiceFeign;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.po.CouponDefinitionCodePOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponfacade.models.po.CouponRecordPO;
import com.bizvane.couponfacade.models.po.CouponRecordPOExample;
import com.bizvane.couponfacade.models.po.CouponReversqlRecordPO;
import com.bizvane.couponfacade.models.po.CouponReversqlRecordPOExample;
import com.bizvane.couponfacade.models.po.CouponStatusLogPO;
import com.bizvane.couponfacade.models.vo.CouponAllUseRequestVO;
import com.bizvane.couponfacade.models.vo.CouponByTransferVO;
import com.bizvane.couponfacade.models.vo.CouponCancelUseRequestVO;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponDetailModelVO;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponDifindustryVO;
import com.bizvane.couponfacade.models.vo.CouponEntityAndDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponFindCouponCountResponseVO;
import com.bizvane.couponfacade.models.vo.CouponInfoVo;
import com.bizvane.couponfacade.models.vo.CouponIntegralCouponUseAllRequestVO;
import com.bizvane.couponfacade.models.vo.CouponInvalidRequestVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponfacade.models.vo.CouponOfflineCreateResponseVO;
import com.bizvane.couponfacade.models.vo.CouponOfflineUseRequestVO;
import com.bizvane.couponfacade.models.vo.CouponOnlineUseRequestVO;
import com.bizvane.couponfacade.models.vo.CouponRecordRequestVO;
import com.bizvane.couponfacade.models.vo.CouponRecordResponseVO;
import com.bizvane.couponfacade.models.vo.CouponRecordTransferRequestVO;
import com.bizvane.couponfacade.models.vo.CouponRecordTransferVO;
import com.bizvane.couponfacade.models.vo.CouponRefundRequestVO;
import com.bizvane.couponfacade.models.vo.CouponReversalRequestVO;
import com.bizvane.couponfacade.models.vo.CouponSendMemberListRequestVO;
import com.bizvane.couponfacade.models.vo.CouponSendMemberListResponseVO;
import com.bizvane.couponfacade.models.vo.CouponSevenDaysDataVO;
import com.bizvane.couponfacade.models.vo.CouponStatusEntitySuccessVO;
import com.bizvane.couponfacade.models.vo.CouponUseVO;
import com.bizvane.couponfacade.models.vo.ProductCategoryVO;
import com.bizvane.couponfacade.models.vo.ReceiveCouponStatusVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.couponfacade.mq.OnlineCouponUseEvent;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponfacade.utils.TimeUtils;
import com.bizvane.couponservice.common.config.Mj2Config;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.datavo.CouponCancelUseYzVo;
import com.bizvane.couponservice.common.datavo.YouzanCouponBO;
import com.bizvane.couponservice.common.utils.BaseData;
import com.bizvane.couponservice.common.utils.CouponException;
import com.bizvane.couponservice.common.utils.DateUtil;
import com.bizvane.couponservice.common.utils.ExportExcelUtil;
import com.bizvane.couponservice.common.utils.StandardMessageUtil;
import com.bizvane.couponservice.common.utils.StreamingExportExcelUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionCodePOMapper;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.mappers.CouponRecordPOMapper;
import com.bizvane.couponservice.mappers.CouponReversqlRecordPOMapper;
import com.bizvane.couponservice.mappers.CouponStatusLogPOMapper;
import com.bizvane.couponservice.service.CouponDifindustryQuantityRecordService;
import com.bizvane.couponservice.service.CouponDifindustryService;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.CouponService;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.couponservice.service.ThirdBusinessService;
import com.bizvane.couponservice.service.impl.CouponMessageComponentServiceImpl;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.customized.facade.utils.UUIDUtil;
import com.bizvane.members.facade.enums.BusinessTypeEnum;
import com.bizvane.members.facade.enums.IntegralChangeTypeEnum;
import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.members.facade.models.bo.GetMemberDeductionInfo;
import com.bizvane.members.facade.service.api.IntegralChangeApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberSysApiService;
import com.bizvane.members.facade.service.api.MembersAdvancedSearchApiService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.members.facade.utils.DesensitizeUtil;
import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.messagefacade.interfaces.WechatCouponServiceFeign;
import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.bizvane.redis.canal.dto.CompanyCacheDto;
import com.bizvane.redis.canal.service.IRedisCacheService;
import com.bizvane.thirddock.service.rpc.YouzanCouponServiceRpc;
import com.bizvane.thirdrouting.bo.AsynBO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Functions;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.rocketmq.client.producer.SendResult;
import org.eclipse.jetty.util.StringUtil;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class CouponServiceImpl
implements CouponService {
    private static Logger logger = LoggerFactory.getLogger(CouponServiceImpl.class);
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    @Autowired
    private CouponStatusLogPOMapper couponStatusLogPOMapper;
    @Autowired
    private WechatCouponServiceFeign wechatCouponServiceFeign;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private ConnectorServiceFeign connectorServiceFeign;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private SendCouponService sendCouponService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private ThirdBusinessService thirdBusinessService;
    @Autowired
    private StandardMessageUtil standardMessageUtil;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CouponReversqlRecordPOMapper couponReversqlRecordPOMapper;
    @Autowired
    private CouponRecordPOMapper couponRecordPOMapper;
    @Autowired
    private MembersAdvancedSearchApiService membersAdvancedSearchApiService;
    @Autowired
    private IntegralChangeApiService integralChangeApiService;
    @Autowired
    private MemberSysApiService memberSysApiService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private IRedisCacheService iRedisCacheService;
    @Autowired
    private CouponDefinitionCodePOMapper couponDefinitionCodePOMapper;
    @Value(value="${mjwm.wmCompanyId}")
    private Long mjWmCompanyId;
    @Value(value="${gd.gdCompanyId}")
    private Long gdCompanyId;
    @Value(value="${361wm.wmCompanyId}")
    private Long wmCompanyId;
    @Value(value="#{'${weimeng.companyIdList}'.split(',')}")
    private List<Long> weimengCompanyIdList;
    @Autowired
    private CouponDifindustryService couponDifindustryService;
    @Autowired
    public CouponDifindustryQuantityRecordService couponDifindustryQuantityRecordService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Autowired
    private CouponEntityService couponEntityService;
    @Autowired
    private CouponMessageComponentServiceImpl couponMessageComponentService;
    @Autowired
    private Mj2Config mj2Config;
    @Autowired
    private MjMemberServiceNewRpc mjMemberServiceNewRpc;
    @Autowired
    private YouzanCouponServiceRpc youzanCouponServiceRpc;
    @Value(value="#{'${ledeng.sysBrandIdList}'.split(',')}")
    private List<Long> ledengSysBrandIdList;
    @Autowired
    private LedengServiceRpc ledengServiceRpc;
    @Value(value="${UR.sysCompanyId}")
    private Long urSysCompanyId;

    public ResponseData<String> onlineUse(CouponOnlineUseRequestVO param) {
        YouzanCouponBO youzanCouponBO;
        logger.info("enter CouponServiceImpl onlineUse method");
        ResponseData responseData = new ResponseData();
        String couponCode = param.getCouponCode();
        Long sysCompanyId = param.getSysCompanyId();
        String useBusinessCode = param.getUseBusinessCode();
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPO = null;
        couponEntityPO = sysCompanyId != null ? this.findCouponEntityByCompanyId(couponCode, sysCompanyId) : this.findCouponEntityPO(couponCode);
        if (null == couponEntityPO) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_USED.getMessage());
            return responseData;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_OVERDUE)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_EXPIRED.getMessage());
            return responseData;
        }
        if (this.checkCouponIfIntegralCoupon(couponEntityPO.getCouponDefinitionId()).booleanValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_TAIDI_ONLY.getMessage());
            return responseData;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date validDateStart = couponEntityPO.getValidDateStart();
            Date startDate = format.parse(format.format(validDateStart));
            Date today = format.parse(format.format(new Date()));
            if (today.getTime() < startDate.getTime()) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_VALID.getMessage());
                return responseData;
            }
        }
        catch (Exception e) {
            logger.info("enter CouponServiceImpl use  method ! date format error");
        }
        if (couponEntityPO.getSendType().equals(SendTypeEnum.SEND_COUPON_BATCH.getCode())) {
            this.couponManualService.updateCouponManualCount(couponEntityPO.getUseStoreId(), couponEntityPO.getSendBusinessId(), param.getProfitMoney(), param.getDiscountMoney());
        }
        couponEntityPO.setUseBusinessCode(useBusinessCode);
        couponEntityPO.setUseBusinessAmount(param.getProfitMoney());
        couponEntityPO.setUseType(SystemConstants.COUPON_USE_TYPE_ONLINE);
        couponEntityPO.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        couponEntityPO.setUseTime(TimeUtils.getNowTime());
        couponEntityPO.setModifiedDate(TimeUtils.getNowTime());
        couponEntityPO.setIsUse(SystemConstants.COUPON_DEFINITION_STATUS_USE);
        couponEntityPO.setUseFrom(param.getUseFrom());
        couponEntityPO.setStaffCode(param.getStaffCode());
        ResponseData memberSysModel = this.memberSysApiService.getMemberSysModel(couponEntityPO.getSysBrandId(), couponEntityPO.getSysCompanyId());
        if (memberSysModel != null && memberSysModel.getData() != null) {
            ResponseData storeById = this.storeServiceRpc.getStoreById(((MembersSysModel)memberSysModel.getData()).getOpenCardStoreId());
            couponEntityPO.setUseStoreId(((SysStorePo)storeById.getData()).getStoreId());
        }
        couponEntityPO.setUseMemberCode(param.getUseMemberCode());
        logger.info("enter semd getTransferSend" + couponEntityPO.getCouponCode() + JSONObject.toJSONString((Object)couponEntityPO));
        this.couponEntityPOMapper.updateByPrimaryKeySelective(couponEntityPO);
        try {
            AsynBO asynBO = new AsynBO(couponEntityPO.getSysCompanyId(), couponEntityPO.getSysBrandId(), "couponUsed", JSON.toJSONString((Object)couponEntityPO));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("\u6838\u9500 thirdBusinessService.asyn e {}", (Throwable)e);
        }
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPO.getCouponDefinitionId()));
        if (definitionPO.getUseChannel() == 2) {
            CouponUseRequestVO useVO = new CouponUseRequestVO();
            useVO.setCouponCode(couponEntityPO.getCouponCode());
            useVO.setBrandId(couponEntityPO.getSysBrandId());
            useVO.setMemberCode(couponEntityPO.getMemberCode());
            useVO.setOrderNo(useBusinessCode);
            useVO.setIsMember(Integer.valueOf(1));
            useVO.setMoney(couponEntityPO.getMoney());
            useVO.setPreferentialType(couponEntityPO.getPreferentialType());
            useVO.setGoodsCondition(definitionPO.getGoodsCondition());
            String offlinePrdCode = definitionPO.getOfflinePrdCode();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{offlinePrdCode})) {
                List productCategoryVOS = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
                for (ProductCategoryVO productCategoryVO : productCategoryVOS) {
                    String prdParentName = productCategoryVO.getPrdParentName();
                    String str = productCategoryVO.getStr();
                    if ("\u5927\u7c7b".equals(prdParentName)) {
                        useVO.setBigCategory(str);
                        continue;
                    }
                    if ("\u4e2d\u7c7b".equals(prdParentName)) {
                        useVO.setMiddleCategory(str);
                        continue;
                    }
                    if ("\u5c0f\u7c7b".equals(prdParentName)) {
                        useVO.setSmallCategory(str);
                        continue;
                    }
                    if ("\u5e74\u4efd".equals(prdParentName)) {
                        useVO.setParticularYear(str);
                        continue;
                    }
                    if (!"\u5b63\u8282".equals(prdParentName)) continue;
                    useVO.setSeason(str);
                }
            }
            logger.info("enter connectorServiceFeign usecoupon ! param:requestVO:{}", (Object)JSONObject.toJSONString((Object)useVO));
            Result useResult = this.connectorServiceFeign.usecoupon(useVO);
            logger.info("enter semd onlineUseTransferSenduseResult", (Object)JSONObject.toJSONString((Object)useResult));
        }
        logger.info("enter semd getTransferSend", (Object)(couponEntityPO.getCouponCode() + JSONObject.toJSONString((Object)couponEntityPO)));
        if (couponEntityPO.getTransferSend() != null && couponEntityPO.getTransferSend().booleanValue()) {
            SendCouponSimpleRequestVO sendVO = new SendCouponSimpleRequestVO();
            sendVO.setMemberCode(couponEntityPO.getTransferMemberCode());
            sendVO.setCouponDefinitionId(couponEntityPO.getTransferCouponDefinitionId());
            sendVO.setSendType(couponEntityPO.getSendType());
            sendVO.setSendBussienId(couponEntityPO.getSendBusinessId());
            sendVO.setBusinessName(couponEntityPO.getBusinessName());
            sendVO.setBrandId(couponEntityPO.getSysBrandId());
            sendVO.setCompanyId(couponEntityPO.getSysCompanyId());
            sendVO.setBrandCode(couponEntityPO.getBrandCode());
            this.sendCouponService.simple(sendVO);
        }
        CouponStatusLogPO couponStatusLogPO = new CouponStatusLogPO();
        couponStatusLogPO.setCouponEntityId(couponEntityPO.getCouponEntityId());
        couponStatusLogPO.setCouponCode(couponCode);
        couponStatusLogPO.setBusinessType(SystemConstants.COUPON_STATUS_CHANGE_BUSINESS_TYPE_USE);
        couponStatusLogPO.setBusinessCode(useBusinessCode);
        couponStatusLogPO.setBusinessTime(TimeUtils.getNowTime());
        couponStatusLogPO.setCreateDate(TimeUtils.getNowTime());
        this.couponStatusLogPOMapper.insertSelective(couponStatusLogPO);
        WxChannelInfoVo channelVO = new WxChannelInfoVo();
        channelVO.setMemberCode(couponEntityPO.getMemberCode());
        channelVO.setBrandId(couponEntityPO.getSysBrandId());
        channelVO.setMiniProgram(Integer.valueOf(1));
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
        WxChannelInfoVo channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
        MemberInfoModel memberInfoModel = ((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel();
        CouponMessageVO messageVO = new CouponMessageVO();
        messageVO.setMemberCode(couponEntityPO.getMemberCode());
        messageVO.setCouponCode(couponCode);
        messageVO.setCouponName(couponEntityPO.getCouponName());
        messageVO.setPreferentialType(couponEntityPO.getPreferentialType() + "");
        messageVO.setDenomination(couponEntityPO.getMoney() + "");
        messageVO.setSendType(couponEntityPO.getSendType());
        messageVO.setSendBusinessId(couponEntityPO.getSendBusinessId());
        if (couponEntityPO.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_MONEY)) {
            messageVO.setDenomination(couponEntityPO.getMoney() + "");
        } else if (couponEntityPO.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_DISCOUNT)) {
            messageVO.setDenomination(couponEntityPO.getDiscount() + "");
        }
        messageVO.setUseTime(couponEntityPO.getUseTime());
        messageVO.setValidDateStart(couponEntityPO.getValidDateStart());
        messageVO.setValidDateEnd(couponEntityPO.getValidDateEnd());
        messageVO.setMemberName(channelInfoVo.getName());
        messageVO.setOrderNo(useBusinessCode);
        messageVO.setSysBrandId(couponEntityPO.getSysBrandId());
        messageVO.setMemberPhone(channelInfoVo.getPhone());
        messageVO.setSendWxmember(channelInfoVo.getFocus() + "");
        messageVO.setSysCompanyId(channelInfoVo.getSysCompanyId());
        messageVO.setServiceStoreCode(memberInfoModel.getServiceStoreCode());
        messageVO.setServiceStoreId(memberInfoModel.getServiceStoreId());
        messageVO.setAreaCode(memberInfoModel.getAreaCode());
        ResponseData publicPO = this.wxPublicServiceFeign.getWxPublicBySysBrandId(couponEntityPO.getSysBrandId());
        if (publicPO.getData() != null) {
            messageVO.setNickName(((WxPublicPO)publicPO.getData()).getNickName());
        }
        this.wechatCouponServiceFeign.couponUse(messageVO);
        ResponseData subscribeResp = this.couponMessageComponentService.couponUse(messageVO, definitionPO, couponEntityPO, new Date());
        logger.info("CouponServiceImpl#CouponMessageComponentServiceImpl#couponUse#subscribeResp:{}", (Object)JSON.toJSONString((Object)subscribeResp));
        logger.info("\u8c03\u7528\u6d88\u606f\u6a21\u5757\u7684standardMessageUtil.useCouponMessage:{}", (Object)JSON.toJSONString((Object)messageVO));
        this.standardMessageUtil.useCouponMessage(couponEntityPO, channelVO, messageVO);
        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPO.getCouponDefinitionId()));
        if (!SystemConstants.COUPON_USE_FROM_YOUZAN.equals(param.getUseFrom()) && (youzanCouponBO = this.couponEntityService.isSyncYouzan(couponEntityPO.getSysBrandId().longValue(), couponEntityPO, couponDefinitionPOWithBLOBs)) != null) {
            try {
                logger.info("youzanCouponServiceRpc.couponUse\u5165\u53c2\uff1a{}", (Object)couponCode);
                Boolean youzanResult = (Boolean)this.youzanCouponServiceRpc.couponUse(couponEntityPO.getSysBrandId(), couponCode).getData();
                logger.info("youzanCouponServiceRpc.couponUse:" + youzanResult);
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u6709\u8d5e\u5238\u5b9e\u4f8b\u62a5\u9519 e {}", (Throwable)e);
            }
        }
        if (this.mj2Config.isSyncMj(couponEntityPO.getSysCompanyId().longValue(), definitionPO.getUseChannel())) {
            MemberInfoModel memberInfoModelParam = new MemberInfoModel();
            memberInfoModelParam.setMemberCode(couponEntityPO.getMemberCode());
            MemberInfoModel member = (MemberInfoModel)this.memberInfoApiService.getMemberModel(memberInfoModelParam).getData();
            String cardNo = member.getCardNo();
            String name = member.getName();
            couponEntityPO.setStaffCode(member.getServiceGuideCode());
            MjCouponUseRequestVo mjCouponUseRequestVo = new MjCouponUseRequestVo(cardNo, name, couponEntityPO);
            logger.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:{}" + JSON.toJSONString((Object)mjCouponUseRequestVo));
            boolean syncResult = (Boolean)this.mjMemberServiceNewRpc.couponUse(mjCouponUseRequestVo).getTData();
            logger.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:" + syncResult);
        }
        return responseData;
    }

    public ResponseData<Integer> offlineUse(CouponOfflineUseRequestVO param) {
        YouzanCouponBO youzanCouponBO;
        ResponseData sysStorePoResponseData;
        logger.info("enter CouponServiceImpl offlineUse method");
        ResponseData responseData = new ResponseData();
        if (null == param) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)param.getCouponCode())) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPO = null;
        couponEntityPO = param.getSysCompanyId() != null ? this.findCouponEntityByCompanyId(param.getCouponCode(), param.getSysCompanyId()) : this.findCouponEntityPO(param.getCouponCode());
        if (null == couponEntityPO) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        String useStoreCode = null;
        String useStoreName = null;
        if (StringUtils.isNotBlank((CharSequence)param.getUseStoreCode())) {
            sysStorePoResponseData = this.storeServiceRpc.getStoreInfoByCodeAndSysCompanyId(param.getUseStoreCode(), param.getSysCompanyId());
            if (sysStorePoResponseData != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == sysStorePoResponseData.getCode()) {
                param.setUseStoreId(((SysStorePo)sysStorePoResponseData.getData()).getStoreId());
                useStoreCode = param.getUseStoreCode();
                useStoreName = ((SysStorePo)sysStorePoResponseData.getData()).getStoreName();
            }
        } else if (StringUtils.isNotBlank((CharSequence)param.getVerifyedStoreCode()) && (sysStorePoResponseData = this.storeServiceRpc.getStoreInfoByCodeAndSysCompanyId(param.getVerifyedStoreCode(), param.getSysCompanyId())) != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == sysStorePoResponseData.getCode()) {
            param.setUseStoreId(((SysStorePo)sysStorePoResponseData.getData()).getStoreId());
            useStoreCode = param.getVerifyedStoreCode();
            useStoreName = ((SysStorePo)sysStorePoResponseData.getData()).getStoreName();
        }
        if (StringUtils.isEmpty((CharSequence)param.getUseStoreId())) {
            logger.info("SysCompanyId: " + couponEntityPO.getSysCompanyId() + " ,SysBrandId:" + couponEntityPO.getSysBrandId());
            ResponseData memberSysModel = this.memberSysApiService.getMemberSysModel(couponEntityPO.getSysBrandId(), couponEntityPO.getSysCompanyId());
            if (memberSysModel != null && memberSysModel.getData() != null) {
                ResponseData storeById = this.storeServiceRpc.getStoreById(((MembersSysModel)memberSysModel.getData()).getOpenCardStoreId());
                param.setUseStoreId(((SysStorePo)storeById.getData()).getStoreId());
                useStoreCode = ((SysStorePo)storeById.getData()).getSysStoreOfflineCode();
                useStoreName = ((SysStorePo)storeById.getData()).getStoreName();
            }
        }
        if (this.checkCouponIfIntegralCoupon(couponEntityPO.getCouponDefinitionId()).booleanValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_TAIDI_ONLY.getMessage());
            return responseData;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_USED.getMessage());
            return responseData;
        }
        if (couponEntityPO.getIsUse().booleanValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_USED.getMessage());
            return responseData;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_OVERDUE)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_EXPIRED.getMessage());
            return responseData;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date validDateStart = couponEntityPO.getValidDateStart();
            Date startDate = format.parse(format.format(validDateStart));
            Date today = format.parse(format.format(new Date()));
            if (today.getTime() < startDate.getTime()) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_VALID.getMessage());
                return responseData;
            }
        }
        catch (Exception e) {
            logger.info("enter CouponServiceImpl use  method ! date format error");
        }
        if (couponEntityPO.getSendType().equals(SendTypeEnum.SEND_COUPON_BATCH.getCode())) {
            this.couponManualService.updateCouponManualCount(couponEntityPO.getUseStoreId(), couponEntityPO.getSendBusinessId(), param.getProfitMoney(), param.getDiscountMoney());
        }
        couponEntityPO.setUseType(SystemConstants.COUPON_USE_TYPE_OFFLINE);
        couponEntityPO.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        if (StringUtil.isNotBlank((String)param.getUseTime())) {
            couponEntityPO.setUseTime(DateUtil.parse((String)param.getUseTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            couponEntityPO.setUseTime(TimeUtils.getNowTime());
        }
        couponEntityPO.setUseBusinessCode(param.getBusinessCode());
        couponEntityPO.setUseStoreId(param.getUseStoreId());
        couponEntityPO.setUseStoreCode(useStoreCode);
        couponEntityPO.setUseStoreName(useStoreName);
        couponEntityPO.setUseBusinessAmount(param.getProfitMoney());
        couponEntityPO.setModifiedDate(TimeUtils.getNowTime());
        couponEntityPO.setIsUse(SystemConstants.COUPON_DEFINITION_STATUS_USE);
        couponEntityPO.setUseFrom(param.getUseFrom());
        couponEntityPO.setStaffCode(param.getStaffCode());
        couponEntityPO.setUseMemberCode(param.getUseMemberCode());
        logger.info("enter semd getTransferSend" + couponEntityPO.getCouponCode() + JSONObject.toJSONString((Object)couponEntityPO));
        int count = this.couponEntityPOMapper.updateByPrimaryKeySelectiveAndNotUse(couponEntityPO);
        try {
            AsynBO asynBO = new AsynBO(couponEntityPO.getSysCompanyId(), couponEntityPO.getSysBrandId(), "couponUsed", JSON.toJSONString((Object)couponEntityPO));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("\u6838\u9500 thirdBusinessService.asyn e {}", (Throwable)e);
        }
        if (count <= 0) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_USED.getMessage());
            return responseData;
        }
        if (couponEntityPO.getTransferSend() != null && couponEntityPO.getTransferSend().booleanValue()) {
            SendCouponSimpleRequestVO sendVO = new SendCouponSimpleRequestVO();
            sendVO.setMemberCode(couponEntityPO.getTransferMemberCode());
            sendVO.setCouponDefinitionId(couponEntityPO.getTransferCouponDefinitionId());
            sendVO.setSendType(couponEntityPO.getSendType());
            sendVO.setSendBussienId(couponEntityPO.getSendBusinessId());
            sendVO.setBusinessName(couponEntityPO.getBusinessName());
            sendVO.setBrandId(couponEntityPO.getSysBrandId());
            sendVO.setCompanyId(couponEntityPO.getSysCompanyId());
            sendVO.setBrandCode(couponEntityPO.getBrandCode());
            this.sendCouponService.simple(sendVO);
        }
        CouponStatusLogPO couponStatusLogPO = new CouponStatusLogPO();
        couponStatusLogPO.setCouponEntityId(couponEntityPO.getCouponEntityId());
        couponStatusLogPO.setCouponCode(param.getCouponCode());
        couponStatusLogPO.setBusinessType(SystemConstants.COUPON_STATUS_CHANGE_BUSINESS_TYPE_USE);
        couponStatusLogPO.setBusinessCode(param.getBusinessCode());
        couponStatusLogPO.setBusinessTime(TimeUtils.getNowTime());
        couponStatusLogPO.setCreateDate(TimeUtils.getNowTime());
        this.couponStatusLogPOMapper.insertSelective(couponStatusLogPO);
        CouponDefinitionPOWithBLOBs lOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPO.getCouponDefinitionId()));
        try {
            if (!CollectionUtils.isEmpty((Collection)this.weimengCompanyIdList) && this.weimengCompanyIdList.contains(couponEntityPO.getSysCompanyId()) && SystemConstants.USE_CHANNEL_ANY.equals(lOBs.getUseChannel())) {
                logger.info("CouponServiceImpl offlineUse wmmq send param:{}", (Object)JSONObject.toJSONString((Object)couponEntityPO));
                SendResult send = this.rocketMQTemplate.send(Destination.builder().topic("wm_topic_use_channel_coupon").build(), (Object)JSONObject.toJSONString((Object)couponEntityPO));
                logger.info("CouponServiceImpl offlineUse wmmq sendResult param:{}", (Object)send.toString());
            }
        }
        catch (Exception e) {
            logger.error("CouponServiceImpl offlineUse send wmmq\uff0cerror:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (lOBs.getUseChannel() > 2 && !SystemConstants.USE_CHANNEL_EMP.equals(lOBs.getUseChannel()) && this.gdCompanyId != param.getSysCompanyId()) {
            return responseData;
        }
        logger.info("\u8d70\u7ebf\u4e0b\uff0csysCompanyId\uff1a{}", (Object)param.getSysCompanyId());
        CouponUseRequestVO useVO = new CouponUseRequestVO();
        if (!StringUtils.isNotBlank((CharSequence)couponEntityPO.getMemberCode())) {
            logger.info("\u6ca1\u6709\u4f1a\u5458\uff0c\u4e0d\u9700\u8981\u540c\u6b65\u7ebf\u4e0bgetCouponCode\uff1a" + couponEntityPO.getCouponCode());
            return responseData;
        }
        useVO.setMemberCode(couponEntityPO.getMemberCode());
        useVO.setIsMember(Integer.valueOf(1));
        useVO.setCouponDefinitionId(couponEntityPO.getCouponDefinitionId());
        useVO.setCouponCode(param.getCouponCode());
        useVO.setBrandId(param.getSysBrandId());
        useVO.setOrderNo(param.getBusinessCode());
        useVO.setMoney(couponEntityPO.getMoney());
        useVO.setPreferentialType(couponEntityPO.getPreferentialType());
        useVO.setVerifyedStoreCode(param.getVerifyedStoreCode());
        useVO.setVerifyedUser(param.getVerifyedUser());
        useVO.setGoodsCondition(lOBs.getGoodsCondition());
        String offlinePrdCode = lOBs.getOfflinePrdCode();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{offlinePrdCode})) {
            List productCategoryVOS = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
            for (ProductCategoryVO productCategoryVO : productCategoryVOS) {
                String prdParentName = productCategoryVO.getPrdParentName();
                String str = productCategoryVO.getStr();
                if ("\u5927\u7c7b".equals(prdParentName)) {
                    useVO.setBigCategory(str);
                    continue;
                }
                if ("\u4e2d\u7c7b".equals(prdParentName)) {
                    useVO.setMiddleCategory(str);
                    continue;
                }
                if ("\u5c0f\u7c7b".equals(prdParentName)) {
                    useVO.setSmallCategory(str);
                    continue;
                }
                if ("\u5e74\u4efd".equals(prdParentName)) {
                    useVO.setParticularYear(str);
                    continue;
                }
                if (!"\u5b63\u8282".equals(prdParentName)) continue;
                useVO.setSeason(str);
            }
        }
        logger.info("enter connectorServiceFeign usecoupon371param:requestVO:{}", (Object)JSONObject.toJSONString((Object)useVO));
        Result useResult = this.connectorServiceFeign.usecoupon(useVO);
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPO.getCouponDefinitionId()));
        if (!SystemConstants.COUPON_USE_FROM_YOUZAN.equals(param.getUseFrom()) && (youzanCouponBO = this.couponEntityService.isSyncYouzan(couponEntityPO.getSysBrandId().longValue(), couponEntityPO, definitionPO)) != null) {
            try {
                logger.info("youzanCouponServiceRpc.couponUse\u5165\u53c2\uff1a{}", (Object)couponEntityPO.getCouponCode());
                Boolean youzanResult = (Boolean)this.youzanCouponServiceRpc.couponUse(couponEntityPO.getSysBrandId(), couponEntityPO.getCouponCode()).getData();
                logger.info("youzanCouponServiceRpc.couponUse:" + youzanResult);
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u6709\u8d5e\u5238\u5b9e\u4f8b\u62a5\u9519 e {}", (Throwable)e);
            }
        }
        if (!"1".equals(param.getUseSystem()) && this.mj2Config.isSyncMj(couponEntityPO.getSysCompanyId().longValue(), definitionPO.getUseChannel())) {
            MemberInfoModel memberInfoModelParam = new MemberInfoModel();
            memberInfoModelParam.setMemberCode(couponEntityPO.getMemberCode());
            MemberInfoModel member = (MemberInfoModel)this.memberInfoApiService.getMemberModel(memberInfoModelParam).getData();
            String cardNo = member.getCardNo();
            String name = member.getName();
            couponEntityPO.setStaffCode(member.getServiceGuideCode());
            MjCouponUseRequestVo mjCouponUseRequestVo = new MjCouponUseRequestVo(cardNo, name, couponEntityPO);
            logger.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:{}" + JSON.toJSONString((Object)mjCouponUseRequestVo));
            boolean syncResult = (Boolean)this.mjMemberServiceNewRpc.couponUse(mjCouponUseRequestVo).getTData();
            logger.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:" + syncResult);
        }
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != useResult.getCode().intValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(useResult.getMessage());
            return responseData;
        }
        return responseData;
    }

    public ResponseData<Integer> offlineUseCheck(CouponOfflineUseRequestVO param) {
        ResponseData sysStorePoResponseData;
        ResponseData responseData = new ResponseData();
        if (null == param) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)param.getCouponCode())) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPO = null;
        couponEntityPO = param.getSysCompanyId() != null ? this.findCouponEntityByCompanyId(param.getCouponCode(), param.getSysCompanyId()) : this.findCouponEntityPO(param.getCouponCode());
        if (null == couponEntityPO) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        String useStoreCode = null;
        String useStoreName = null;
        if (StringUtils.isNotBlank((CharSequence)param.getUseStoreCode())) {
            sysStorePoResponseData = this.storeServiceRpc.getStoreInfoByCodeAndSysCompanyId(param.getUseStoreCode(), param.getSysCompanyId());
            if (sysStorePoResponseData != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == sysStorePoResponseData.getCode()) {
                param.setUseStoreId(((SysStorePo)sysStorePoResponseData.getData()).getStoreId());
                useStoreCode = param.getUseStoreCode();
                useStoreName = ((SysStorePo)sysStorePoResponseData.getData()).getStoreName();
            }
        } else if (StringUtils.isNotBlank((CharSequence)param.getVerifyedStoreCode()) && (sysStorePoResponseData = this.storeServiceRpc.getStoreInfoByCodeAndSysCompanyId(param.getVerifyedStoreCode(), param.getSysCompanyId())) != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == sysStorePoResponseData.getCode()) {
            param.setUseStoreId(((SysStorePo)sysStorePoResponseData.getData()).getStoreId());
            useStoreCode = param.getVerifyedStoreCode();
            useStoreName = ((SysStorePo)sysStorePoResponseData.getData()).getStoreName();
        }
        if (StringUtils.isEmpty((CharSequence)param.getUseStoreId())) {
            logger.info("SysCompanyId: " + couponEntityPO.getSysCompanyId() + " ,SysBrandId:" + couponEntityPO.getSysBrandId());
            ResponseData memberSysModel = this.memberSysApiService.getMemberSysModel(couponEntityPO.getSysBrandId(), couponEntityPO.getSysCompanyId());
            if (memberSysModel != null && memberSysModel.getData() != null) {
                ResponseData storeById = this.storeServiceRpc.getStoreById(((MembersSysModel)memberSysModel.getData()).getOpenCardStoreId());
                param.setUseStoreId(((SysStorePo)storeById.getData()).getStoreId());
                useStoreCode = ((SysStorePo)storeById.getData()).getSysStoreOfflineCode();
                useStoreName = ((SysStorePo)storeById.getData()).getStoreName();
            }
        }
        if (this.checkCouponIfIntegralCoupon(couponEntityPO.getCouponDefinitionId()).booleanValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_TAIDI_ONLY.getMessage());
            return responseData;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_USED.getMessage());
            return responseData;
        }
        if (couponEntityPO.getIsUse().booleanValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_USED.getMessage());
            return responseData;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_OVERDUE)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_EXPIRED.getMessage());
            return responseData;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date validDateStart = couponEntityPO.getValidDateStart();
            Date startDate = format.parse(format.format(validDateStart));
            Date today = format.parse(format.format(new Date()));
            if (today.getTime() < startDate.getTime()) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_VALID.getMessage());
                return responseData;
            }
        }
        catch (Exception e) {
            logger.info("enter CouponServiceImpl offlineUseCheck  method ! date format error");
        }
        return responseData;
    }

    public ResponseData<String> allUse(CouponAllUseRequestVO requestVO) {
        YouzanCouponBO youzanCouponBO;
        ResponseData sysStorePoResponseData;
        logger.info("enter CouponServiceImpl allUse method");
        ResponseData responseData = new ResponseData();
        if (null == requestVO) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)requestVO.getCouponCode())) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPO = null;
        couponEntityPO = requestVO.getSysCompanyId() != null ? this.findCouponEntityByCompanyId(requestVO.getCouponCode(), requestVO.getSysCompanyId()) : this.findCouponEntityPO(requestVO.getCouponCode());
        if (null == couponEntityPO) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_USED.getMessage());
            return responseData;
        }
        if (this.checkCouponIfIntegralCoupon(couponEntityPO.getCouponDefinitionId()).booleanValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_TAIDI_ONLY.getMessage());
            return responseData;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_OVERDUE)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_EXPIRED.getMessage());
            return responseData;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date validDateStart = couponEntityPO.getValidDateStart();
            Date startDate = format.parse(format.format(validDateStart));
            Date today = format.parse(format.format(new Date()));
            if (today.getTime() < startDate.getTime()) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_VALID.getMessage());
                return responseData;
            }
        }
        catch (Exception e) {
            logger.info("enter CouponServiceImpl use  method ! date format error");
        }
        if (StringUtils.isNotBlank((CharSequence)requestVO.getVerifyedStoreCode()) && (sysStorePoResponseData = this.storeServiceRpc.getStoreInfoByCodeAndSysCompanyId(requestVO.getVerifyedStoreCode(), requestVO.getSysCompanyId())) != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == sysStorePoResponseData.getCode()) {
            couponEntityPO.setUseStoreId(((SysStorePo)sysStorePoResponseData.getData()).getStoreId());
        }
        if (couponEntityPO.getSendType().equals(SendTypeEnum.SEND_COUPON_BATCH.getCode())) {
            this.couponManualService.updateCouponManualCount(couponEntityPO.getUseStoreId(), couponEntityPO.getSendBusinessId(), requestVO.getProfitMoney(), requestVO.getDiscountMoney());
        }
        couponEntityPO.setUseType(SystemConstants.COUPON_USE_TYPE_ALL);
        couponEntityPO.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        couponEntityPO.setUseTime(TimeUtils.getNowTime());
        couponEntityPO.setModifiedDate(TimeUtils.getNowTime());
        couponEntityPO.setIsUse(SystemConstants.COUPON_DEFINITION_STATUS_USE);
        couponEntityPO.setUseFrom(requestVO.getUseFrom());
        couponEntityPO.setStaffCode(requestVO.getStaffCode());
        couponEntityPO.setUseMemberCode(requestVO.getUseMemberCode());
        this.couponEntityPOMapper.updateByPrimaryKeySelective(couponEntityPO);
        try {
            AsynBO asynBO = new AsynBO(couponEntityPO.getSysCompanyId(), couponEntityPO.getSysBrandId(), "couponUsed", JSON.toJSONString((Object)couponEntityPO));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("\u6838\u9500 thirdBusinessService.asyn e {}", (Throwable)e);
        }
        logger.info("enter semd getTransferSend", (Object)(couponEntityPO.getCouponCode() + JSONObject.toJSONString((Object)couponEntityPO)));
        if (couponEntityPO.getTransferSend() != null && couponEntityPO.getTransferSend().booleanValue()) {
            SendCouponSimpleRequestVO sendVO = new SendCouponSimpleRequestVO();
            sendVO.setMemberCode(couponEntityPO.getTransferMemberCode());
            sendVO.setCouponDefinitionId(couponEntityPO.getTransferCouponDefinitionId());
            sendVO.setSendType(couponEntityPO.getSendType());
            sendVO.setSendBussienId(couponEntityPO.getSendBusinessId());
            sendVO.setBusinessName(couponEntityPO.getBusinessName());
            sendVO.setBrandId(couponEntityPO.getSysBrandId());
            sendVO.setCompanyId(couponEntityPO.getSysCompanyId());
            sendVO.setBrandCode(couponEntityPO.getBrandCode());
            this.sendCouponService.simple(sendVO);
        }
        CouponStatusLogPO couponStatusLogPO = new CouponStatusLogPO();
        couponStatusLogPO.setCouponEntityId(couponEntityPO.getCouponEntityId());
        couponStatusLogPO.setCouponCode(requestVO.getCouponCode());
        couponStatusLogPO.setBusinessType(SystemConstants.COUPON_STATUS_CHANGE_BUSINESS_TYPE_USE);
        couponStatusLogPO.setBusinessTime(TimeUtils.getNowTime());
        couponStatusLogPO.setCreateDate(TimeUtils.getNowTime());
        this.couponStatusLogPOMapper.insertSelective(couponStatusLogPO);
        CouponUseRequestVO useVO = new CouponUseRequestVO();
        useVO.setCouponCode(requestVO.getCouponCode());
        useVO.setBrandId(requestVO.getBrandId());
        useVO.setMemberCode(couponEntityPO.getMemberCode());
        useVO.setIsMember(SystemConstants.IS_MEMBER);
        useVO.setMoney(couponEntityPO.getMoney());
        useVO.setPreferentialType(couponEntityPO.getPreferentialType());
        useVO.setVerifyedStoreCode(requestVO.getVerifyedStoreCode());
        useVO.setVerifyedUser(requestVO.getVerifyedUser());
        useVO.setGoodsCondition(requestVO.getGoodsCondition());
        String offlinePrdCode = requestVO.getOfflinePrdCode();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{offlinePrdCode})) {
            List productCategoryVOS = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
            for (ProductCategoryVO productCategoryVO : productCategoryVOS) {
                String prdParentName = productCategoryVO.getPrdParentName();
                String str = productCategoryVO.getStr();
                if ("\u5927\u7c7b".equals(prdParentName)) {
                    useVO.setBigCategory(str);
                    continue;
                }
                if ("\u4e2d\u7c7b".equals(prdParentName)) {
                    useVO.setMiddleCategory(str);
                    continue;
                }
                if ("\u5c0f\u7c7b".equals(prdParentName)) {
                    useVO.setSmallCategory(str);
                    continue;
                }
                if ("\u5e74\u4efd".equals(prdParentName)) {
                    useVO.setParticularYear(str);
                    continue;
                }
                if (!"\u5b63\u8282".equals(prdParentName)) continue;
                useVO.setSeason(str);
            }
        }
        logger.info("20231025\u68a6\u6d01\u5168\u6e20\u9053\u5238\u5546\u79c0\u6838\u9500:" + couponEntityPO.getCouponCode());
        CouponDefinitionPOWithBLOBs lOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPO.getCouponDefinitionId()));
        try {
            if (!CollectionUtils.isEmpty((Collection)this.weimengCompanyIdList) && this.weimengCompanyIdList.contains(couponEntityPO.getSysCompanyId()) && SystemConstants.USE_CHANNEL_ANY.equals(lOBs.getUseChannel())) {
                logger.info("CouponServiceImpl offlineUse wmmq send param:{}", (Object)JSONObject.toJSONString((Object)couponEntityPO));
                SendResult send = this.rocketMQTemplate.send(Destination.builder().topic("wm_topic_use_channel_coupon").build(), (Object)JSONObject.toJSONString((Object)couponEntityPO));
                logger.info("CouponServiceImpl offlineUse wmmq sendResult param:{}", (Object)send.toString());
            }
        }
        catch (Exception e) {
            logger.error("CouponServiceImpl offlineUse send wmmq\uff0cerror:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        logger.info("enter connectorServiceFeign usecoupon502param:requestVO:{}", (Object)JSONObject.toJSONString((Object)useVO));
        Result useResult = this.connectorServiceFeign.usecoupon(useVO);
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPO.getCouponDefinitionId()));
        if (!SystemConstants.COUPON_USE_FROM_YOUZAN.equals(requestVO.getUseFrom()) && (youzanCouponBO = this.couponEntityService.isSyncYouzan(couponEntityPO.getSysBrandId().longValue(), couponEntityPO, definitionPO)) != null) {
            try {
                logger.info("youzanCouponServiceRpc.couponUse\u5165\u53c2\uff1a{}", (Object)requestVO.getCouponCode());
                Boolean youzanResult = (Boolean)this.youzanCouponServiceRpc.couponUse(couponEntityPO.getSysBrandId(), requestVO.getCouponCode()).getData();
                logger.info("youzanCouponServiceRpc.couponUse:" + youzanResult);
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u6709\u8d5e\u5238\u5b9e\u4f8b\u62a5\u9519 e {}", (Throwable)e);
            }
        }
        if (this.mj2Config.isSyncMj(couponEntityPO.getSysCompanyId().longValue(), definitionPO.getUseChannel())) {
            MemberInfoModel memberInfoModelParam = new MemberInfoModel();
            memberInfoModelParam.setMemberCode(couponEntityPO.getMemberCode());
            MemberInfoModel member = (MemberInfoModel)this.memberInfoApiService.getMemberModel(memberInfoModelParam).getData();
            String cardNo = member.getCardNo();
            String name = member.getName();
            couponEntityPO.setStaffCode(member.getServiceGuideCode());
            MjCouponUseRequestVo mjCouponUseRequestVo = new MjCouponUseRequestVo(cardNo, name, couponEntityPO);
            logger.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:{}" + JSON.toJSONString((Object)mjCouponUseRequestVo));
            boolean syncResult = (Boolean)this.mjMemberServiceNewRpc.couponUse(mjCouponUseRequestVo).getTData();
            logger.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:" + syncResult);
        }
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != useResult.getCode().intValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(useResult.getMessage());
            return responseData;
        }
        return responseData;
    }

    public ResponseData<Object> cancelUse(CouponCancelUseRequestVO vo) {
        logger.info("enter CouponServiceImpl cancelUse method");
        ResponseData responseData = new ResponseData();
        String couponCode = vo.getCouponCode();
        String memberCode = vo.getMemberCode();
        ResponseData findCouponEntityResult = this.findCouponEntity(couponCode, memberCode);
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != findCouponEntityResult.getCode()) {
            responseData.setCode(findCouponEntityResult.getCode());
            responseData.setMessage(findCouponEntityResult.getMessage());
            return responseData;
        }
        CouponCancelRequestVO couponCancelRequestVO = new CouponCancelRequestVO();
        couponCancelRequestVO.setBrandId(vo.getSysBrandId());
        couponCancelRequestVO.setCouponCode(couponCode);
        couponCancelRequestVO.setMemberCode(memberCode);
        logger.info("enter connectorServiceFeign cancelUseCoupon:requestVO:{}", (Object)JSONObject.toJSONString((Object)couponCancelRequestVO));
        Result result = this.connectorServiceFeign.cancelUseCoupon(couponCancelRequestVO);
        logger.info("enter connectorServiceFeign cancelUseCoupon:result:{}", (Object)JSONObject.toJSONString((Object)result));
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != result.getCode().intValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(result.getMessage());
            return responseData;
        }
        this.cancelUseOnline(couponCode);
        return responseData;
    }

    public ResponseData<Object> cancelUseOnline(String couponCode) {
        logger.info("enter CouponServiceImpl cancelUseOnline method");
        ResponseData responseData = new ResponseData();
        ResponseData findCouponEntityResult = this.findCouponEntity(couponCode, null);
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != findCouponEntityResult.getCode()) {
            responseData.setCode(findCouponEntityResult.getCode());
            responseData.setMessage(findCouponEntityResult.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPO = (CouponEntityPO)findCouponEntityResult.getData();
        Date nowDate = new Date();
        couponEntityPO.setUseType(null);
        couponEntityPO.setCouponStatus(SystemConstants.COUPON_STATUS_UNUSED);
        couponEntityPO.setIsUse(SystemConstants.COUPON_USE_UNUSED);
        couponEntityPO.setUseTime(null);
        couponEntityPO.setUseBusinessCode(null);
        couponEntityPO.setUseStoreId(null);
        couponEntityPO.setModifiedDate(nowDate);
        couponEntityPO.setUseStoreId(null);
        couponEntityPO.setUseFrom(null);
        couponEntityPO.setUseBusinessAmount(null);
        Byte couponStatus = null;
        if (nowDate.before(couponEntityPO.getValidDateEnd())) {
            couponStatus = SystemConstants.COUPON_STATUS_UNUSED;
        } else {
            Date validDateEndNew;
            if (this.urSysCompanyId.equals(couponEntityPO.getSysCompanyId())) {
                return new ResponseData(101, "\u5238\u5df2\u5931\u6548");
            }
            couponStatus = SystemConstants.COUPON_STATUS_OVERDUE;
            CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPO.getCouponDefinitionId()));
            if (Byte.valueOf("1").equals(definitionPO.getChargeBack()) && Boolean.TRUE.equals(definitionPO.getProlongValidDate()) && nowDate.before(validDateEndNew = DateUtil.addDay((Date)couponEntityPO.getValidDateEnd(), (int)definitionPO.getProlongValidDateDay()))) {
                couponEntityPO.setValidDateEnd(validDateEndNew);
                couponStatus = SystemConstants.COUPON_STATUS_UNUSED;
            }
        }
        couponEntityPO.setCouponStatus(couponStatus);
        this.couponEntityPOMapper.updateByPrimaryKey(couponEntityPO);
        CouponStatusLogPO couponStatusLogPO = new CouponStatusLogPO();
        couponStatusLogPO.setCouponEntityId(couponEntityPO.getCouponEntityId());
        couponStatusLogPO.setCouponCode(couponCode);
        couponStatusLogPO.setBusinessType(SystemConstants.COUPON_STATUS_CHANGE_BUSINESS_TYPE_CANCEL_USE);
        couponStatusLogPO.setBusinessTime(new Date());
        couponStatusLogPO.setCreateDate(new Date());
        this.couponStatusLogPOMapper.insertSelective(couponStatusLogPO);
        try {
            AsynBO asynBO = new AsynBO(couponEntityPO.getSysCompanyId(), couponEntityPO.getSysBrandId(), "couponReversal", JSON.toJSONString((Object)couponEntityPO));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("saveErpSendCouponEntity thirdBusinessService.asyn e {}", (Throwable)e);
        }
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Object> cancelUseOnlineAndSyncOffline(String couponCode) {
        logger.info("enter CouponServiceImpl cancelUseOnlineAndSyncOffline method");
        ResponseData responseData = new ResponseData();
        ResponseData findCouponEntityResult = this.findCouponEntity(couponCode, null);
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != findCouponEntityResult.getCode()) {
            responseData.setCode(findCouponEntityResult.getCode());
            responseData.setMessage(findCouponEntityResult.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPO = (CouponEntityPO)findCouponEntityResult.getData();
        Date nowDate = new Date();
        couponEntityPO.setUseType(null);
        couponEntityPO.setIsUse(SystemConstants.COUPON_USE_UNUSED);
        couponEntityPO.setUseTime(null);
        couponEntityPO.setUseBusinessCode(null);
        couponEntityPO.setUseStoreId(null);
        couponEntityPO.setModifiedDate(nowDate);
        couponEntityPO.setUseStoreId(null);
        couponEntityPO.setUseFrom(null);
        couponEntityPO.setUseBusinessAmount(null);
        Byte couponStatus = null;
        if (nowDate.before(couponEntityPO.getValidDateEnd())) {
            couponStatus = SystemConstants.COUPON_STATUS_UNUSED;
        } else {
            Date validDateEndNew;
            if (this.urSysCompanyId.equals(couponEntityPO.getSysCompanyId())) {
                return new ResponseData(101, "\u5238\u5df2\u5931\u6548");
            }
            couponStatus = SystemConstants.COUPON_STATUS_OVERDUE;
            CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPO.getCouponDefinitionId()));
            if (Byte.valueOf("1").equals(definitionPO.getChargeBack()) && Boolean.TRUE.equals(definitionPO.getProlongValidDate()) && nowDate.before(validDateEndNew = DateUtil.addDay((Date)couponEntityPO.getValidDateEnd(), (int)definitionPO.getProlongValidDateDay()))) {
                couponEntityPO.setValidDateEnd(validDateEndNew);
                couponStatus = SystemConstants.COUPON_STATUS_UNUSED;
            }
        }
        couponEntityPO.setCouponStatus(couponStatus);
        this.couponEntityPOMapper.updateByPrimaryKey(couponEntityPO);
        CouponStatusLogPO couponStatusLogPO = new CouponStatusLogPO();
        couponStatusLogPO.setCouponEntityId(couponEntityPO.getCouponEntityId());
        couponStatusLogPO.setCouponCode(couponCode);
        couponStatusLogPO.setBusinessType(SystemConstants.COUPON_STATUS_CHANGE_BUSINESS_TYPE_CANCEL_USE);
        couponStatusLogPO.setBusinessTime(new Date());
        couponStatusLogPO.setCreateDate(new Date());
        this.couponStatusLogPOMapper.insertSelective(couponStatusLogPO);
        CouponCancelRequestVO couponCancelRequestVO = new CouponCancelRequestVO();
        couponCancelRequestVO.setBrandId(((CouponEntityPO)findCouponEntityResult.getData()).getSysBrandId());
        couponCancelRequestVO.setCouponCode(((CouponEntityPO)findCouponEntityResult.getData()).getCouponCode());
        couponCancelRequestVO.setMemberCode(((CouponEntityPO)findCouponEntityResult.getData()).getMemberCode());
        logger.info("enter connectorServiceFeign cancelUseCoupon:requestVO:{}", (Object)JSONObject.toJSONString((Object)couponCancelRequestVO));
        Result result = this.connectorServiceFeign.cancelUseCoupon(couponCancelRequestVO);
        logger.info("enter connectorServiceFeign cancelUseCoupon:result:{}", (Object)JSONObject.toJSONString((Object)result));
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != result.getCode().intValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(result.getMessage());
            return responseData;
        }
        try {
            AsynBO asynBO = new AsynBO(couponEntityPO.getSysCompanyId(), couponEntityPO.getSysBrandId(), "couponReversal", JSON.toJSONString((Object)couponEntityPO));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("saveErpSendCouponEntity thirdBusinessService.asyn e {}", (Throwable)e);
        }
        return responseData;
    }

    public ResponseData<Object> cancelUse(CouponCancelUseYzVo vo) {
        logger.info("enter CouponCancelUseYzVo cancelUse method");
        ResponseData responseData = new ResponseData();
        CouponEntityPO couponEntityPO = this.couponEntityPOMapper.selectByPrimaryKey(vo.getCouponId());
        CouponCancelRequestVO couponCancelRequestVO = new CouponCancelRequestVO();
        couponCancelRequestVO.setBrandId(couponEntityPO.getSysBrandId());
        couponCancelRequestVO.setCouponCode(couponEntityPO.getCouponCode());
        couponCancelRequestVO.setMemberCode(couponEntityPO.getMemberCode());
        logger.info("enter connectorServiceFeign cancelUseCoupon:requestVO:{}", (Object)JSONObject.toJSONString((Object)couponCancelRequestVO));
        Result result = this.connectorServiceFeign.cancelUseCoupon(couponCancelRequestVO);
        logger.info("enter connectorServiceFeign cancelUseCoupon:result:{}", (Object)JSONObject.toJSONString((Object)result));
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != result.getCode().intValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(result.getMessage());
            return responseData;
        }
        couponEntityPO.setUseType(null);
        couponEntityPO.setCouponStatus(SystemConstants.COUPON_STATUS_UNUSED);
        couponEntityPO.setIsUse(SystemConstants.COUPON_USE_UNUSED);
        couponEntityPO.setUseTime(null);
        couponEntityPO.setUseBusinessCode(null);
        couponEntityPO.setUseStoreId(null);
        couponEntityPO.setModifiedDate(new Date());
        couponEntityPO.setUseFrom(null);
        couponEntityPO.setUseBusinessAmount(null);
        couponEntityPO.setModifiedDate(new Date());
        this.couponEntityPOMapper.updateByPrimaryKey(couponEntityPO);
        CouponStatusLogPO couponStatusLogPO = new CouponStatusLogPO();
        couponStatusLogPO.setCouponEntityId(couponEntityPO.getCouponEntityId());
        couponStatusLogPO.setCouponCode(couponEntityPO.getCouponCode());
        couponStatusLogPO.setBusinessType(SystemConstants.COUPON_STATUS_CHANGE_BUSINESS_TYPE_CANCEL_USE);
        couponStatusLogPO.setBusinessTime(new Date());
        couponStatusLogPO.setCreateDate(new Date());
        this.couponStatusLogPOMapper.insertSelective(couponStatusLogPO);
        try {
            AsynBO asynBO = new AsynBO(couponEntityPO.getSysCompanyId(), couponEntityPO.getSysBrandId(), "couponReversal", JSON.toJSONString((Object)couponEntityPO));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("saveErpSendCouponEntity thirdBusinessService.asyn e {}", (Throwable)e);
        }
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<PageInfo<CouponEntityAndDefinitionVO>> getCouponListByMemeberCode(CouponListByMemberCodeRequestVO vo, PageFormUtil pageFormUtil) {
        logger.info("enter CouponServiceImpl getCouponListByMemeberCode method :{}", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData result = new ResponseData();
        PageHelper.startPage((int)pageFormUtil.getPageNumber(), (int)pageFormUtil.getPageSize());
        List list = new ArrayList();
        if (vo.getAppEdition() != null && SystemConstants.APP_EDITION_COUPON_BAG.equals(vo.getAppEdition())) {
            list = this.couponEntityPOMapper.getCouponListByMemeberCodeAndGive(vo);
            if (vo.getCouponStatus() == 40) {
                list.forEach(v -> {
                    CouponRecordPOExample example = new CouponRecordPOExample();
                    example.createCriteria().andSysCompanyIdEqualTo(vo.getSysCompanyId()).andTransferMemberEqualTo(vo.getMemberCode()).andTypeEqualTo(SystemConstants.TRANSFER_TYPE_GIVE).andCouponCodeEqualTo(v.getCouponCode()).andValidEqualTo(Boolean.valueOf(true));
                    example.setOrderByClause("create_date DESC");
                    List couponRecordPos = this.couponRecordPOMapper.selectByExample(example);
                    if (CollectionUtils.isNotEmpty((Collection)couponRecordPos)) {
                        v.setTransferDate(((CouponRecordPO)couponRecordPos.get(0)).getCreateDate());
                    }
                });
            }
        } else {
            list = this.couponEntityPOMapper.getCouponListByMemeberCode(vo);
        }
        PageInfo pageInfo = new PageInfo(list);
        result.setData((Object)pageInfo);
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList collect = new ArrayList();
            list.stream().forEach(couponEntityAndDefinitionVO -> {
                ResponseData sysStorePoRes;
                if (SystemConstants.COUPON_STATUS_USED.equals(couponEntityAndDefinitionVO.getCouponStatus()) && StringUtils.isNotBlank((CharSequence)couponEntityAndDefinitionVO.getUseStoreId()) && (sysStorePoRes = this.storeServiceRpc.getStoreByOfflineStoreId(couponEntityAndDefinitionVO.getUseStoreId(), couponEntityAndDefinitionVO.getSysBrandId(), couponEntityAndDefinitionVO.getSysCompanyId())) != null && sysStorePoRes.getData() != null) {
                    SysStorePo sysStorePo = (SysStorePo)sysStorePoRes.getData();
                    couponEntityAndDefinitionVO.setUseStoreCode(sysStorePo.getSysStoreOnlineCode());
                    couponEntityAndDefinitionVO.setUseStoreName(sysStorePo.getStoreName());
                }
                if (SendTypeEnum.SEND_COUPON_DIF.getCode().equals(couponEntityAndDefinitionVO.getSendType())) {
                    collect.add(couponEntityAndDefinitionVO);
                }
            });
            if (collect != null && !collect.isEmpty()) {
                List data;
                List collect1 = collect.stream().map(CouponEntityAndDefinitionVO::getSendBrandId).collect(Collectors.toList());
                SysBrandVo sysBrandVo = new SysBrandVo();
                sysBrandVo.setSysCompanyId(vo.getSysCompanyId());
                sysBrandVo.setSysBrandIdList(collect1);
                ResponseData barndListByBrandIds = this.brandServiceRpc.getBarndListByBrandIds(sysBrandVo);
                if (barndListByBrandIds != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == barndListByBrandIds.getCode() && (data = (List)barndListByBrandIds.getData()) != null && !data.isEmpty()) {
                    Map modelMap = data.stream().collect(Collectors.toMap(SysBrandPo::getSysBrandId, Function.identity(), (a, b) -> a));
                    list.forEach(t -> {
                        if (modelMap != null && modelMap.containsKey(t.getSendBrandId())) {
                            SysBrandPo SysBrandPo2 = (SysBrandPo)modelMap.get(t.getSendBrandId());
                            t.setSendBrandName(SysBrandPo2.getBrandName());
                            t.setIsDifindustryCoupon(Byte.valueOf((byte)1));
                        }
                    });
                }
            }
        }
        return result;
    }

    public ResponseData<CouponDetailModelVO> findCouponByCouponCode(String couponCode) {
        logger.info("enter CouponServiceImpl findCouponByCouponCode method");
        ResponseData responseData = new ResponseData();
        CouponEntityPOExample couponEntityPOExample = new CouponEntityPOExample();
        CouponEntityPOExample.Criteria criteria = couponEntityPOExample.createCriteria();
        criteria.andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        criteria.andCouponCodeEqualTo(couponCode);
        List list = this.couponEntityPOMapper.selectByExample(couponEntityPOExample);
        if (CollectionUtils.isEmpty((Collection)list)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
            return responseData;
        }
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(((CouponEntityPO)list.get(0)).getCouponDefinitionId())));
        CouponDetailModelVO modelVO = new CouponDetailModelVO();
        modelVO.setCouponDefinitionPO((CouponDefinitionPO)definitionPO);
        modelVO.setCouponEntityPO((CouponEntityPO)list.get(0));
        responseData.setData((Object)modelVO);
        return responseData;
    }

    public ResponseData<CouponEntityPO> findCouponEntity(String couponCode, String memberCode) {
        CouponEntityPOExample.Criteria criteria;
        logger.info("enter CouponServiceImpl findCouponEntity method param:CouponCode:{},memberCode:{}", (Object)couponCode, (Object)memberCode);
        ResponseData responseData = new ResponseData();
        CouponEntityPOExample couponEntityPOExample = new CouponEntityPOExample();
        if (StringUtils.isEmpty((CharSequence)memberCode)) {
            criteria = couponEntityPOExample.createCriteria();
            criteria.andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
            criteria.andCouponCodeEqualTo(couponCode);
        } else {
            criteria = couponEntityPOExample.createCriteria();
            criteria.andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
            criteria.andMemberCodeEqualTo(memberCode);
            criteria.andCouponCodeEqualTo(couponCode);
        }
        List list = this.couponEntityPOMapper.selectByExample(couponEntityPOExample);
        if (CollectionUtils.isEmpty((Collection)list)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        responseData.setData(list.get(0));
        return responseData;
    }

    public ResponseData<CouponFindCouponCountResponseVO> findCouponCountByMemberCode(String memberCode) {
        logger.info("enter CouponServiceImpl findCouponCountByMemberCode method");
        ResponseData responseData = new ResponseData();
        if (null == memberCode) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4f1a\u5458code\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        CouponFindCouponCountResponseVO vo = new CouponFindCouponCountResponseVO();
        CouponEntityPOExample couponEntityPOExample = new CouponEntityPOExample();
        CouponEntityPOExample.Criteria criteria = couponEntityPOExample.createCriteria();
        criteria.andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        criteria.andMemberCodeEqualTo(memberCode);
        List list = this.couponEntityPOMapper.selectByExample(couponEntityPOExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Long couponSum = 0L;
            Long couponUsedSum = 0L;
            Long couponUnusedSum = 0L;
            Long couponOverdueSum = 0L;
            for (CouponEntityPO couponEntityPO : list) {
                Long l;
                Long l2;
                Byte couponStatus = couponEntityPO.getCouponStatus();
                Boolean exist = Boolean.TRUE;
                if (SystemConstants.COUPON_STATUS_USED.equals(couponStatus)) {
                    l2 = couponUsedSum;
                    l = couponUsedSum = Long.valueOf(couponUsedSum + 1L);
                } else if (SystemConstants.COUPON_STATUS_UNUSED.equals(couponStatus)) {
                    l2 = couponUnusedSum;
                    l = couponUnusedSum = Long.valueOf(couponUnusedSum + 1L);
                } else if (SystemConstants.COUPON_STATUS_OVERDUE.equals(couponStatus)) {
                    l2 = couponOverdueSum;
                    l = couponOverdueSum = Long.valueOf(couponOverdueSum + 1L);
                } else {
                    exist = Boolean.FALSE;
                }
                if (!exist.booleanValue()) continue;
                l2 = couponSum;
                l = couponSum = Long.valueOf(couponSum + 1L);
            }
            vo.setCouponOverdueSum(couponOverdueSum);
            vo.setCouponSum(couponSum);
            vo.setCouponUnusedSum(couponUnusedSum);
            vo.setCouponUsedSum(couponUsedSum);
        }
        responseData.setData((Object)vo);
        return responseData;
    }

    public ResponseData<CouponFindCouponCountResponseVO> findCouponCountByDate(CouponEntityVO param) {
        logger.info("enter CouponServiceImpl findCouponCountByDate method");
        ResponseData responseData = new ResponseData();
        if (null == param.getSendBusinessId()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_SEND_BUSINESS_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == param.getSendType()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_SEND_TYPE_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == param.getSysBrandId()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponFindCouponCountResponseVO vo = new CouponFindCouponCountResponseVO();
        Long couponSum = this.couponEntityPOMapper.findCouponAllCount(param.getSendBusinessId(), param.getSendType(), param.getSysBrandId(), SystemConstants.COUPON_STATUS_UNUSED, SystemConstants.COUPON_STATUS_USED, SystemConstants.COUPON_STATUS_OVERDUE, param.getDtStart(), param.getDtEnd(), null);
        Long couponUnusedSum = this.couponEntityPOMapper.findCouponCount(param.getSendBusinessId(), param.getSendType(), param.getSysBrandId(), SystemConstants.COUPON_STATUS_UNUSED, param.getDtStart(), param.getDtEnd(), null);
        Long couponUsedSum = this.couponEntityPOMapper.findCouponCount(param.getSendBusinessId(), param.getSendType(), param.getSysBrandId(), SystemConstants.COUPON_STATUS_USED, param.getDtStart(), param.getDtEnd(), null);
        Long couponOverdueSum = this.couponEntityPOMapper.findCouponCount(param.getSendBusinessId(), param.getSendType(), param.getSysBrandId(), SystemConstants.COUPON_STATUS_OVERDUE, param.getDtStart(), param.getDtEnd(), null);
        BigDecimal money = this.couponEntityPOMapper.findUseBusinessAmountSum(param.getSendBusinessId(), param.getSendType(), param.getSysBrandId(), SystemConstants.COUPON_STATUS_USED, param.getDtStart(), param.getDtEnd(), null);
        vo.setCouponOverdueSum(couponOverdueSum);
        vo.setCouponSum(couponSum);
        vo.setCouponUnusedSum(couponUnusedSum);
        vo.setCouponUsedSum(couponUsedSum);
        vo.setMoney(money == null ? BigDecimal.ZERO : money);
        responseData.setData((Object)vo);
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<CouponFindCouponCountResponseVO> findCouponCountBySendBusinessId(Long sendBusinessId, String sendType, Long sysBrandId) {
        logger.info("enter CouponServiceImpl findCouponCountBySendBusinessId method");
        ResponseData responseData = new ResponseData();
        if (null == sendBusinessId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_SEND_BUSINESS_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)sendType)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_SEND_TYPE_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == sysBrandId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponStatusEntitySuccessVO successVO = new CouponStatusEntitySuccessVO();
        successVO.setCouponStatusUsed(SystemConstants.COUPON_STATUS_USED);
        successVO.setCouponStatusUnused(SystemConstants.COUPON_STATUS_UNUSED);
        successVO.setCouponStatusOverdue(SystemConstants.COUPON_STATUS_OVERDUE);
        CouponFindCouponCountResponseVO vo = null;
        vo = "55".equals(sendType) ? this.couponEntityPOMapper.findCouponCountByStatusAndTmall(sendBusinessId, sendType, sysBrandId, successVO) : this.couponEntityPOMapper.findCouponCountByStatus(sendBusinessId, sendType, sysBrandId, successVO);
        Long couponSum = vo.getCouponOverdueSum() + vo.getCouponUnusedSum() + vo.getCouponUsedSum();
        BigDecimal money = this.couponEntityPOMapper.findBusinessAmountSumUsed(sendBusinessId, sendType, sysBrandId, null, SystemConstants.COUPON_STATUS_USED);
        vo.setCouponSum(couponSum);
        vo.setMoney(money == null ? BigDecimal.ZERO : money);
        responseData.setData((Object)vo);
        return responseData;
    }

    public ResponseData<CouponFindCouponCountResponseVO> findCouponCountForMktScreen(Long sendBusinessId, Long sysBrandId, Long sysCompanyId, String strStartTime, String strEndTime) {
        logger.info("enter CouponServiceImpl findCouponCount method");
        ResponseData responseData = new ResponseData();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = format.parse(strStartTime);
            endTime = format.parse(strEndTime);
        }
        catch (ParseException e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
        }
        if (null == sysBrandId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponStatusEntitySuccessVO successVO = new CouponStatusEntitySuccessVO();
        successVO.setCouponStatusUsed(SystemConstants.COUPON_STATUS_USED);
        successVO.setCouponStatusUnused(SystemConstants.COUPON_STATUS_UNUSED);
        successVO.setCouponStatusOverdue(SystemConstants.COUPON_STATUS_OVERDUE);
        CouponFindCouponCountResponseVO vo = null;
        vo = this.couponEntityPOMapper.findCouponCountByBrandIdAndStatus(sendBusinessId, sysBrandId, successVO, sysCompanyId, startTime, endTime);
        Long couponSum = vo.getCouponOverdueSum() + vo.getCouponUnusedSum() + vo.getCouponUsedSum();
        CouponFindCouponCountResponseVO usedVo = this.couponEntityPOMapper.findBusinessAmountSumUsedByDate(sysBrandId, sysCompanyId, SystemConstants.COUPON_STATUS_USED, startTime, endTime);
        vo.setCouponSum(couponSum);
        vo.setMoney(usedVo.getMoney() == null ? BigDecimal.ZERO : usedVo.getMoney());
        vo.setCouponUsedSum(usedVo.getCouponUsedSum());
        responseData.setData((Object)vo);
        return responseData;
    }

    public ResponseData<List<CouponSevenDaysDataVO>> findCouponCountSevenForMktScreen(Long sysBrandId, Long sysCompanyId, String strStartTime, String strEndTime, String type) {
        logger.info("enter CouponServiceImpl findCouponCountSevenForMktScreen method");
        ResponseData responseData = new ResponseData();
        if (null == sysBrandId || sysCompanyId == null) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = format.parse(strStartTime);
            endTime = format.parse(strEndTime);
        }
        catch (ParseException e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
        }
        if ("total".equals(type)) {
            logger.info("findCouponCountSevenForMktScreen type total");
            List voTotalList = this.couponEntityPOMapper.findCouponCountSeven(sysBrandId, sysCompanyId, startTime, endTime);
            responseData.setData((Object)voTotalList);
        } else if ("used".equals(type)) {
            logger.info("findCouponCountSevenForMktScreen type used");
            List voUsedList = this.couponEntityPOMapper.findCouponUsedCountSeven(sysBrandId, sysCompanyId, startTime, endTime);
            responseData.setData((Object)voUsedList);
        } else if ("money".equals(type)) {
            logger.info("findCouponCountSevenForMktScreen type money");
            List moneyList = this.couponEntityPOMapper.findCouponMoneySeven(sysBrandId, sysCompanyId, startTime, endTime);
            Iterator iterator = moneyList.iterator();
            while (iterator.hasNext()) {
                CouponSevenDaysDataVO vo;
                vo.setMoney((vo = (CouponSevenDaysDataVO)iterator.next()).getMoney() == null ? BigDecimal.ZERO : vo.getMoney());
            }
            responseData.setData((Object)moneyList);
        }
        return responseData;
    }

    public CouponFindCouponCountResponseVO findCouponCountbatchSend(Long batchSendId, Long sendBusinessId, String sendType, Long sysBrandId) {
        logger.info("enter CouponServiceImpl findCouponCountBySendBusinessId method");
        CouponStatusEntitySuccessVO successVO = new CouponStatusEntitySuccessVO();
        successVO.setCouponStatusUsed(SystemConstants.COUPON_STATUS_USED);
        successVO.setCouponStatusUnused(SystemConstants.COUPON_STATUS_UNUSED);
        successVO.setCouponStatusOverdue(SystemConstants.COUPON_STATUS_OVERDUE);
        CouponFindCouponCountResponseVO vo = this.couponEntityPOMapper.findCouponCountbatchSend(batchSendId, sendBusinessId, sendType, sysBrandId, successVO);
        Long couponSum = vo.getCouponOverdueSum() + vo.getCouponUnusedSum() + vo.getCouponUsedSum();
        vo.setCouponSum(couponSum);
        vo.setCouponRate(BaseData.growthNot((String)(vo.getCouponUsedSum() + ""), (String)(couponSum + "")));
        return vo;
    }

    public ResponseData<Integer> givenCoupon(CouponEntityVO vo) {
        CouponEntityPO couponEntityPo;
        logger.info("enter CouponServiceImpl givenCoupon method param:CouponEntityVO:{}", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        if (null == vo) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return responseData;
        }
        Long sysCompanyId = vo.getSysCompanyId();
        Long sysBrandId = vo.getSysBrandId();
        String couponCode = vo.getCouponCode();
        String oldMemberCode = vo.getOldMemberCode();
        String newMemberCode = vo.getNewMemberCode();
        String useBusinessCode = vo.getUseBusinessCode();
        String description = vo.getDescription();
        Date transferDate = vo.getDtStart();
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)oldMemberCode) || StringUtils.isBlank((CharSequence)newMemberCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_MEMBER_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        ResponseData findCouponEntityResult = this.findCouponEntity(couponCode, oldMemberCode);
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != findCouponEntityResult.getCode()) {
            responseData.setCode(findCouponEntityResult.getCode());
            responseData.setMessage(findCouponEntityResult.getMessage());
            return responseData;
        }
        if (transferDate != null) {
            CouponRecordPOExample recordPoExample = new CouponRecordPOExample();
            recordPoExample.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId).andCouponCodeEqualTo(couponCode).andTransferMemberEqualTo(oldMemberCode).andTransferDateGreaterThan(transferDate).andValidEqualTo(Boolean.valueOf(true));
            List couponRecordPos = this.couponRecordPOMapper.selectByExample(recordPoExample);
            if (CollectionUtils.isNotEmpty((Collection)couponRecordPos)) {
                logger.info("\u8be5\u5238\u5df2\u6709\u65b0\u7684\u8f6c\u8d60\u8bb0\u5f55\u51fa\u73b0\u3002couponCode:{},transferDate:{}", (Object)couponCode, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transferDate));
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_HAVE_RECEIVE_OR_BACK.getMessage());
                return responseData;
            }
        }
        if (!(couponEntityPo = (CouponEntityPO)findCouponEntityResult.getData()).getGive().booleanValue()) {
            logger.info("\u8be5\u5238\u5df2\u88ab\u9886\u53d6\u6216\u64a4\u56de\u3002couponCode:{}", (Object)couponCode);
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_HAVE_RECEIVE_OR_BACK.getMessage());
            return responseData;
        }
        couponEntityPo.setMemberCode(newMemberCode);
        couponEntityPo.setTransferMemberCode(oldMemberCode);
        couponEntityPo.setModifiedDate(TimeUtils.getNowTime());
        couponEntityPo.setGive(SystemConstants.COUPON_UNGIVE);
        logger.info("enter semd getTransferSend" + couponEntityPo.getCouponCode() + JSONObject.toJSONString((Object)couponEntityPo));
        this.couponEntityPOMapper.updateByPrimaryKeySelective(couponEntityPo);
        CouponRecordPO couponRecordPo = new CouponRecordPO();
        couponRecordPo.setSysCompanyId(sysCompanyId);
        couponRecordPo.setSysBrandId(sysBrandId);
        couponRecordPo.setCouponCode(couponCode);
        couponRecordPo.setCouponName(couponEntityPo.getCouponName());
        couponRecordPo.setCouponDefinitionId(couponEntityPo.getCouponDefinitionId());
        couponRecordPo.setMemberCode(newMemberCode);
        MemberInfoModel model = MemberInfoModel.builder().sysCompanyId(sysCompanyId).brandId(sysBrandId).memberCode(newMemberCode).build();
        ResponseData memberInfoResponseData = this.memberInfoApiService.getMemberModel(model);
        if (memberInfoResponseData.getCode() == com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() && memberInfoResponseData.getData() != null) {
            couponRecordPo.setMemberPhone(((MemberInfoModel)memberInfoResponseData.getData()).getPhone());
        }
        couponRecordPo.setRecordNo(this.getSerialNumber());
        couponRecordPo.setType(SystemConstants.TRANSFER_TYPE_RECEIVE);
        CouponRecordPOExample recordPoExample = new CouponRecordPOExample();
        recordPoExample.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId).andCouponCodeEqualTo(couponCode).andMemberCodeEqualTo(oldMemberCode).andTypeEqualTo(SystemConstants.TRANSFER_TYPE_GIVE);
        recordPoExample.setOrderByClause("create_date DESC");
        List couponRecordPoList = this.couponRecordPOMapper.selectByExample(recordPoExample);
        if (CollectionUtil.isNotEmpty((Collection)couponRecordPoList)) {
            couponRecordPo.setTransferDate(((CouponRecordPO)couponRecordPoList.get(0)).getTransferDate());
        }
        couponRecordPo.setTransferMember(oldMemberCode);
        couponRecordPo.setCreateDate(new Date());
        couponRecordPo.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        this.couponRecordPOMapper.insertSelective(couponRecordPo);
        CouponStatusLogPO couponStatusLogPo = new CouponStatusLogPO();
        couponStatusLogPo.setCouponEntityId(couponEntityPo.getCouponEntityId());
        couponStatusLogPo.setCouponCode(couponCode);
        couponStatusLogPo.setBusinessCode(useBusinessCode);
        couponStatusLogPo.setBusinessType(Byte.valueOf((byte)Integer.parseInt(SendTypeEnum.SEND_COUPON_GIVE.getCode())));
        couponStatusLogPo.setBusinessTime(TimeUtils.getNowTime());
        couponStatusLogPo.setCreateDate(TimeUtils.getNowTime());
        this.couponStatusLogPOMapper.insertSelective(couponStatusLogPo);
        CouponDefinitionPOWithBLOBs definitionPOResult = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(couponEntityPo.getCouponDefinitionId())));
        CouponGiveRequestVO giveVO = new CouponGiveRequestVO();
        giveVO.setBrandId(couponEntityPo.getSysBrandId());
        giveVO.setCouponCode(couponCode);
        WxChannelInfoVo channelVO = new WxChannelInfoVo();
        channelVO.setMemberCode(oldMemberCode);
        channelVO.setBrandId(couponEntityPo.getSysBrandId());
        channelVO.setMiniProgram(Integer.valueOf(1));
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
        WxChannelInfoVo channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
        WxChannelInfoVo channelVOnew = new WxChannelInfoVo();
        channelVOnew.setMemberCode(newMemberCode);
        channelVOnew.setBrandId(couponEntityPo.getSysBrandId());
        channelVOnew.setMiniProgram(Integer.valueOf(1));
        ResponseData channelResultnew = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVOnew);
        WxChannelInfoVo channelResultnewVO = ((WxChannelAndMemberVo)channelResultnew.getData()).getWxChannelInfoVo();
        giveVO.setFromMemberCode(channelInfoVo.getOfflineCardNo());
        giveVO.setToMemberCode(channelResultnewVO.getOfflineCardNo());
        giveVO.setDescription(description);
        giveVO.setMoney(couponEntityPo.getMoney());
        giveVO.setPreferentialType(couponEntityPo.getPreferentialType());
        logger.info("enter semd getTransferSendGivecoupon" + couponEntityPo.getCouponCode() + JSONObject.toJSONString((Object)giveVO));
        Result result = this.connectorServiceFeign.givecoupon(giveVO);
        logger.info("out semd getTransferSendGivecoupon" + couponEntityPo.getCouponCode() + JSONObject.toJSONString((Object)result));
        if (this.mj2Config.isSyncMj(couponEntityPo.getSysCompanyId().longValue(), definitionPOResult.getUseChannel())) {
            String transferCardNo = ((GetMemberDeductionInfo)this.memberInfoApiService.getMemberDeductionInfo(couponEntityPo.getTransferMemberCode()).getData()).getCardNo();
            String doneeCardNo = ((GetMemberDeductionInfo)this.memberInfoApiService.getMemberDeductionInfo(couponEntityPo.getMemberCode()).getData()).getCardNo();
            MjCouponTransferRequestVo mjCouponTransferRequestVo = new MjCouponTransferRequestVo(couponEntityPo.getCouponCode(), transferCardNo, doneeCardNo, TimeUtils.getNowTime());
            logger.info("\u68a6\u6d01\u5238\u8f6c\u589e:{}" + JSON.toJSONString((Object)mjCouponTransferRequestVo));
            boolean syncResult = (Boolean)this.mjMemberServiceNewRpc.couponTransfer(mjCouponTransferRequestVo).getTData();
            logger.info("\u68a6\u6d01\u5238\u8f6c\u589e:" + syncResult);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.ledengSysBrandIdList) && this.ledengSysBrandIdList.contains(definitionPOResult.getSysBrandId())) {
            String ledengErpId = ((GetMemberDeductionInfo)this.memberInfoApiService.getMemberDeductionInfo(couponEntityPo.getMemberCode()).getData()).getErpId();
            LedengCouponTransferRequest ledengCouponSendRequest = new LedengCouponTransferRequest(couponCode, ledengErpId);
            boolean ledengSyncResult = (Boolean)this.ledengServiceRpc.couponTransfer(ledengCouponSendRequest).getTData();
            logger.info("\u4e50\u767b\u8f6c\u8d60\u5238\u540c\u6b65\u7ed3\u679c:" + ledengSyncResult);
        }
        try {
            AsynBO asynBO = new AsynBO(couponEntityPo.getSysCompanyId(), couponEntityPo.getSysBrandId(), "couponSend", JSON.toJSONString((Object)couponEntityPo));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("saveErpSendCouponEntity thirdBusinessService.asyn e {}", (Throwable)e);
        }
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode() != result.getCode().intValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(result.getMessage());
            return responseData;
        }
        return responseData;
    }

    public ResponseData<Object> lock(CouponEntityVO vo) {
        logger.info("enter CouponServiceImpl lock method");
        ResponseData responseData = new ResponseData();
        String couponCode = vo.getCouponCode();
        String memberCode = vo.getMemberCode();
        ResponseData findCouponEntityResult = this.findCouponEntity(couponCode, memberCode);
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != findCouponEntityResult.getCode()) {
            responseData.setCode(findCouponEntityResult.getCode());
            responseData.setMessage(findCouponEntityResult.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPO = (CouponEntityPO)findCouponEntityResult.getData();
        if (SystemConstants.COUPON_STATUS_CHANGE_IS_LOCK.equals(couponEntityPO.getIsLock())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5238\u5df2\u88ab\u9501\u5b9a");
            return responseData;
        }
        couponEntityPO.setIsLock(SystemConstants.COUPON_STATUS_CHANGE_IS_LOCK);
        couponEntityPO.setUseTime(TimeUtils.getNowTime());
        couponEntityPO.setModifiedDate(TimeUtils.getNowTime());
        logger.info("enter semd getTransferSend" + couponEntityPO.getCouponCode() + JSONObject.toJSONString((Object)couponEntityPO));
        this.couponEntityPOMapper.updateByPrimaryKeySelective(couponEntityPO);
        return responseData;
    }

    public ResponseData<Object> unlock(CouponEntityVO vo) {
        logger.info("enter CouponServiceImpl unlock method");
        ResponseData responseData = new ResponseData();
        String couponCode = vo.getCouponCode();
        String memberCode = vo.getMemberCode();
        ResponseData findCouponEntityResult = this.findCouponEntity(couponCode, memberCode);
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != findCouponEntityResult.getCode()) {
            responseData.setCode(findCouponEntityResult.getCode());
            responseData.setMessage(findCouponEntityResult.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPO = (CouponEntityPO)findCouponEntityResult.getData();
        couponEntityPO.setIsLock(SystemConstants.COUPON_STATUS_CHANGE_IS_UNLOCK);
        couponEntityPO.setUseTime(null);
        couponEntityPO.setModifiedDate(TimeUtils.getNowTime());
        logger.info("enter semd getTransferSend : " + couponEntityPO.getCouponCode() + JSONObject.toJSONString((Object)couponEntityPO));
        this.couponEntityPOMapper.updateLockByPrimaryKeySelective(couponEntityPO);
        return responseData;
    }

    public ResponseData<Object> couponExpire(CouponEntityVO vo) {
        logger.info("enter CouponServiceImpl couponExpire method");
        ResponseData responseData = new ResponseData();
        String couponCode = vo.getCouponCode();
        String memberCode = vo.getMemberCode();
        Long sysBrandId = vo.getSysBrandId();
        String useBusinessCode = vo.getUseBusinessCode();
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_MEMBER_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == sysBrandId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)useBusinessCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.USE_BUSINESS_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        ResponseData findCouponEntityResult = this.findCouponEntity(couponCode, memberCode);
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != findCouponEntityResult.getCode()) {
            responseData.setCode(findCouponEntityResult.getCode());
            responseData.setMessage(findCouponEntityResult.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPO = (CouponEntityPO)findCouponEntityResult.getData();
        couponEntityPO.setCouponStatus(SystemConstants.COUPON_STATUS_CHANGE_BUSINESS_TYPE_OVERDUE);
        couponEntityPO.setUseTime(TimeUtils.getNowTime());
        couponEntityPO.setModifiedDate(TimeUtils.getNowTime());
        logger.info("enter semd getTransferSend" + couponEntityPO.getCouponCode() + JSONObject.toJSONString((Object)couponEntityPO));
        this.couponEntityPOMapper.updateByPrimaryKeySelective(couponEntityPO);
        CouponStatusLogPO couponStatusLogPO = new CouponStatusLogPO();
        couponStatusLogPO.setCouponEntityId(couponEntityPO.getCouponEntityId());
        couponStatusLogPO.setCouponCode(couponCode);
        couponStatusLogPO.setBusinessCode(vo.getUseBusinessCode());
        couponStatusLogPO.setBusinessType(SystemConstants.COUPON_STATUS_CHANGE_BUSINESS_TYPE_OVERDUE);
        couponStatusLogPO.setBusinessTime(TimeUtils.getNowTime());
        couponStatusLogPO.setCreateDate(TimeUtils.getNowTime());
        this.couponStatusLogPOMapper.insertSelective(couponStatusLogPO);
        WxChannelInfoVo channelVO = new WxChannelInfoVo();
        channelVO.setMemberCode(vo.getMemberCode());
        channelVO.setBrandId(vo.getSysBrandId());
        channelVO.setMiniProgram(Integer.valueOf(1));
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
        WxChannelInfoVo channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
        CouponMessageVO messageVO = new CouponMessageVO();
        messageVO.setMemberCode(vo.getMemberCode());
        messageVO.setCouponCode(vo.getCouponCode());
        messageVO.setCouponName(couponEntityPO.getCouponName());
        messageVO.setPreferentialType(couponEntityPO.getPreferentialType() + "");
        messageVO.setDenomination(couponEntityPO.getMoney() + "");
        if (couponEntityPO.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_MONEY)) {
            messageVO.setDenomination(couponEntityPO.getMoney() + "");
        } else if (couponEntityPO.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_DISCOUNT)) {
            messageVO.setDenomination(couponEntityPO.getDiscount() + "");
        }
        messageVO.setValidDateStart(couponEntityPO.getValidDateStart());
        messageVO.setValidDateEnd(couponEntityPO.getValidDateEnd());
        messageVO.setOrderNo(vo.getUseBusinessCode());
        messageVO.setSysBrandId(vo.getSysBrandId());
        messageVO.setMemberName(channelInfoVo.getName());
        messageVO.setMemberPhone(channelInfoVo.getPhone());
        messageVO.setNickName(channelInfoVo.getWxNick());
        messageVO.setSysCompanyId(channelInfoVo.getSysCompanyId());
        if (couponEntityPO.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_MONEY)) {
            messageVO.setDenomination(couponEntityPO.getMoney() + "");
        } else if (couponEntityPO.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_DISCOUNT)) {
            messageVO.setDenomination(couponEntityPO.getDiscount() + "");
        }
        messageVO.setSendType(couponEntityPO.getSendType());
        messageVO.setSendBusinessId(couponEntityPO.getSendBusinessId());
        this.wechatCouponServiceFeign.couponExpire(messageVO);
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPO.getCouponDefinitionId()));
        ResponseData subscribeResp = this.couponMessageComponentService.couponExpire(messageVO, definitionPO);
        logger.info("CouponServiceImpl#CouponMessageComponentServiceImpl#couponExpire#subscribeResp:{}", (Object)JSON.toJSONString((Object)subscribeResp));
        return responseData;
    }

    public ResponseData<List<CouponEntityPO>> getCouponUnusedByMemberCode(String memberCode) {
        logger.info("enter CouponServiceImpl getCouponUnusedByMemberCode method");
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4f1a\u5458code\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        CouponEntityPOExample entityPOExample = new CouponEntityPOExample();
        entityPOExample.createCriteria().andMemberCodeEqualTo(memberCode).andCouponStatusEqualTo(SystemConstants.COUPON_STATUS_USED).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List entityPOList = this.couponEntityPOMapper.selectByExample(entityPOExample);
        responseData.setData((Object)entityPOList);
        return responseData;
    }

    public ResponseData<CouponFindCouponCountResponseVO> findCouponCountByList(CouponEntityVO vo) {
        logger.info("enter CouponServiceImpl findCouponCountByList method");
        ResponseData responseData = new ResponseData();
        if (CollectionUtils.isEmpty((Collection)vo.getSendIdList())) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        Integer sendCount = this.couponEntityPOMapper.getCountBySendBusinessId(vo.getSendIdList());
        CouponFindCouponCountResponseVO findVO = new CouponFindCouponCountResponseVO();
        findVO.setCouponSum(Long.valueOf(Long.parseLong(sendCount + "")));
        responseData.setData((Object)findVO);
        return responseData;
    }

    public ResponseData<CouponFindCouponCountResponseVO> getCountBySendType(String sendType, Long sysBrandId) {
        logger.info("enter CouponServiceImpl getCountBySendType method");
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)sendType)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_SEND_TYPE_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == sysBrandId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponStatusEntitySuccessVO successVO = new CouponStatusEntitySuccessVO();
        successVO.setCouponStatusUsed(SystemConstants.COUPON_STATUS_USED);
        successVO.setCouponStatusUnused(SystemConstants.COUPON_STATUS_UNUSED);
        successVO.setCouponStatusOverdue(SystemConstants.COUPON_STATUS_OVERDUE);
        CouponFindCouponCountResponseVO vo = null;
        vo = "55".equals(sendType) ? this.couponEntityPOMapper.findCouponCountBySendTypeAndTmall(sendType, sysBrandId, successVO, "") : this.couponEntityPOMapper.findCouponCountBySendType(sendType, sysBrandId, successVO, "");
        Long couponSum = vo.getCouponOverdueSum() + vo.getCouponUsedSum() + vo.getCouponUnusedSum();
        BigDecimal money = this.couponEntityPOMapper.findBusinessAmountSumUsedBySendType(sendType, sysBrandId, SystemConstants.COUPON_STATUS_USED, "");
        vo.setCouponSum(couponSum);
        vo.setMoney(money == null ? BigDecimal.ZERO : money);
        responseData.setData((Object)vo);
        return responseData;
    }

    public ResponseData<CouponFindCouponCountResponseVO> getCountBySendType(String sendType, Long sysBrandId, String organizationCode) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)sendType), (String)"sendType\u5b57\u6bb5\u672a\u4f20", (Object[])new Object[0]);
        Assert.isTrue((sysBrandId != null ? 1 : 0) != 0, (String)"sysBrandId\u5b57\u6bb5\u672a\u4f20", (Object[])new Object[0]);
        CouponStatusEntitySuccessVO successVO = new CouponStatusEntitySuccessVO();
        successVO.setCouponStatusUsed(SystemConstants.COUPON_STATUS_USED);
        successVO.setCouponStatusUnused(SystemConstants.COUPON_STATUS_UNUSED);
        successVO.setCouponStatusOverdue(SystemConstants.COUPON_STATUS_OVERDUE);
        CouponFindCouponCountResponseVO vo = null;
        vo = "55".equals(sendType) ? this.couponEntityPOMapper.findCouponCountBySendTypeAndTmall(sendType, sysBrandId, successVO, organizationCode) : this.couponEntityPOMapper.findCouponCountBySendType(sendType, sysBrandId, successVO, organizationCode);
        Long couponSum = vo.getCouponOverdueSum() + vo.getCouponUsedSum() + vo.getCouponUnusedSum();
        BigDecimal money = this.couponEntityPOMapper.findBusinessAmountSumUsedBySendType(sendType, sysBrandId, SystemConstants.COUPON_STATUS_USED, organizationCode);
        vo.setCouponSum(couponSum);
        vo.setMoney(money == null ? BigDecimal.ZERO : money);
        return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage(), (Object)vo);
    }

    public CouponEntityPO findCouponEntityPO(String couponCode) {
        logger.info("enter CouponServiceImpl findCouponEntityPO method");
        CouponEntityPOExample entityExample = new CouponEntityPOExample();
        entityExample.createCriteria().andCouponCodeEqualTo(couponCode).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List entityList = this.couponEntityPOMapper.selectByExample(entityExample);
        CouponEntityPO entityPO = null;
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityPO = (CouponEntityPO)entityList.get(0);
        }
        return entityPO;
    }

    public CouponEntityPO findCouponEntityByCompanyId(String couponCode, Long SysCompanyId) {
        logger.info("enter CouponServiceImpl findCouponEntityByCompanyId method");
        CouponEntityPOExample entityExample = new CouponEntityPOExample();
        entityExample.createCriteria().andCouponCodeEqualTo(couponCode).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andSysCompanyIdEqualTo(SysCompanyId);
        List entityList = this.couponEntityPOMapper.selectByExample(entityExample);
        CouponEntityPO entityPO = null;
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityPO = (CouponEntityPO)entityList.get(0);
        }
        return entityPO;
    }

    public ResponseData<CouponDetailResponseVO> findCouponDetailByCouponCode(String couponCode) {
        logger.info("enter CouponServiceImpl findCouponDetailByCouponCode method");
        ResponseData responseData = new ResponseData();
        CouponEntityPOExample entityExample = new CouponEntityPOExample();
        entityExample.createCriteria().andCouponCodeEqualTo(couponCode).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List entityList = this.couponEntityPOMapper.selectByExample(entityExample);
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(((CouponEntityPO)entityList.get(0)).getCouponDefinitionId())));
        CouponDetailResponseVO responseVO = new CouponDetailResponseVO();
        responseVO.setCouponDefinitionPO((CouponDefinitionPO)definitionPO);
        responseVO.setCouponEntityPO((CouponEntityPO)entityList.get(0));
        responseData.setData((Object)responseVO);
        return responseData;
    }

    public ResponseData<CouponDetailResponseVO> findCouponDetailByCouponCode(String couponCode, Long brandId) {
        logger.info("enter CouponServiceImpl findCouponDetailByCouponCode method");
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == brandId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPOExample entityExample = new CouponEntityPOExample();
        entityExample.createCriteria().andCouponCodeEqualTo(couponCode).andSysBrandIdEqualTo(brandId).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List entityList = this.couponEntityPOMapper.selectByExample(entityExample);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)((CouponEntityPO)entityList.get(0)).getBarcodeUrl())) {
            this.sendCouponService.updateBarcodeUrl((CouponEntityPO)entityList.get(0));
        }
        if (StringUtils.isBlank((CharSequence)((CouponEntityPO)entityList.get(0)).getQrcodeUrl())) {
            this.sendCouponService.updateQRcodeUrl((CouponEntityPO)entityList.get(0));
        }
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(((CouponEntityPO)entityList.get(0)).getCouponDefinitionId())));
        CouponDetailResponseVO responseVO = new CouponDetailResponseVO();
        responseVO.setCouponDefinitionPO((CouponDefinitionPO)definitionPO);
        responseVO.setCouponEntityPO((CouponEntityPO)entityList.get(0));
        responseData.setData((Object)responseVO);
        return responseData;
    }

    public ResponseData<WxChannelInfoVo> findTOMemberInfo(String fromOpenId, String couponCode, Long sysBrandId) {
        WxChannelInfoVo channelVO = new WxChannelInfoVo();
        channelVO.setWxOpenId(fromOpenId);
        channelVO.setBrandId(sysBrandId);
        channelVO.setMiniProgram(Integer.valueOf(1));
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
        ResponseData memberResult = new ResponseData();
        memberResult.setData((Object)((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo());
        return memberResult;
    }

    public ResponseData<CouponFindCouponCountResponseVO> findCountBySendType(String sendType, String createDate, Long sysBrandId) throws Exception {
        logger.info("enter CouponServiceImpl findCountBySendType method");
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)sendType)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_SEND_TYPE_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)createDate)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.DATE_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == sysBrandId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponFindCouponCountResponseVO vo = new CouponFindCouponCountResponseVO();
        Long couponSum = this.couponEntityPOMapper.findCouponAllCount(null, sendType, sysBrandId, SystemConstants.COUPON_STATUS_UNUSED, SystemConstants.COUPON_STATUS_USED, SystemConstants.COUPON_STATUS_OVERDUE, null, null, createDate);
        Long couponUnusedSum = this.couponEntityPOMapper.findCouponCount(null, sendType, sysBrandId, SystemConstants.COUPON_STATUS_UNUSED, null, null, createDate);
        Long couponUsedSum = this.couponEntityPOMapper.findCouponCount(null, sendType, sysBrandId, SystemConstants.COUPON_STATUS_USED, null, null, createDate);
        Long couponOverdueSum = this.couponEntityPOMapper.findCouponCount(null, sendType, sysBrandId, SystemConstants.COUPON_STATUS_OVERDUE, null, null, createDate);
        BigDecimal money = this.couponEntityPOMapper.findUseBusinessAmountSum(null, sendType, sysBrandId, SystemConstants.COUPON_STATUS_USED, null, null, createDate);
        vo.setCouponOverdueSum(couponOverdueSum);
        vo.setCouponSum(couponSum);
        vo.setCouponUnusedSum(couponUnusedSum);
        vo.setCouponUsedSum(couponUsedSum);
        vo.setMoney(money == null ? BigDecimal.ZERO : money);
        responseData.setData((Object)vo);
        return responseData;
    }

    public ResponseData<String> use(CouponUseVO requestVO) {
        logger.info("enter CouponServiceImpl use method ! param:requestVO:{}", (Object)JSONObject.toJSONString((Object)requestVO));
        ResponseData responseData = new ResponseData();
        String couponCode = requestVO.getCouponCode();
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPO = null;
        couponEntityPO = requestVO.getSysCompanyId() != null ? this.findCouponEntityByCompanyId(couponCode, requestVO.getSysCompanyId()) : this.findCouponEntityPO(couponCode);
        if (null == couponEntityPO) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(couponEntityPO.getCouponDefinitionId())));
        ResponseData couponUseResult = this.couponUse(couponEntityPO, definitionPO, requestVO);
        return couponUseResult;
    }

    public ResponseData<String> wechatEnterpriseUse(CouponUseVO requestVO) {
        ResponseData responseData = new ResponseData();
        String couponCode = requestVO.getCouponCode();
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPO = null;
        couponEntityPO = requestVO.getSysCompanyId() != null ? this.findCouponEntityByCompanyId(couponCode, requestVO.getSysCompanyId()) : this.findCouponEntityPO(couponCode);
        if (null == couponEntityPO) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(couponEntityPO.getCouponDefinitionId())));
        if (definitionPO.getUseChannel().equals(SystemConstants.USE_CHANNEL_ONLINE)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.WECHAT_ENTERPRISE_COUPON_ONLINE_NOT_USE.getMessage());
            return responseData;
        }
        ResponseData couponUseResult = this.couponUse(couponEntityPO, definitionPO, requestVO);
        return couponUseResult;
    }

    public ResponseData<String> couponUse(CouponEntityPO couponEntityPO, CouponDefinitionPOWithBLOBs couponDefinitionPO, CouponUseVO requestVO) {
        ResponseData responseData = new ResponseData();
        String couponCode = requestVO.getCouponCode();
        Long sysCompanyId = requestVO.getSysCompanyId();
        Long brandId = requestVO.getBrandId();
        Byte useFrom = requestVO.getUseFrom();
        String staffCode = requestVO.getStaffCode();
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_USED.getMessage());
            return responseData;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_OVERDUE)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_EXPIRED.getMessage());
            return responseData;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date validDateStart = couponEntityPO.getValidDateStart();
            Date startDate = format.parse(format.format(validDateStart));
            Date today = format.parse(format.format(new Date()));
            if (today.getTime() < startDate.getTime()) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_VALID.getMessage());
                return responseData;
            }
        }
        catch (Exception e) {
            logger.info("enter CouponServiceImpl use  method ! date format error");
        }
        Byte useChannel = couponDefinitionPO.getUseChannel();
        if (useChannel.equals(SystemConstants.USE_CHANNEL_ONLINE)) {
            CouponOnlineUseRequestVO couponOnlineUseRequestVO = new CouponOnlineUseRequestVO();
            couponOnlineUseRequestVO.setCouponCode(couponCode);
            couponOnlineUseRequestVO.setBrandId(brandId);
            couponOnlineUseRequestVO.setUseFrom(useFrom);
            couponOnlineUseRequestVO.setStaffCode(staffCode);
            couponOnlineUseRequestVO.setSysCompanyId(sysCompanyId);
            this.onlineUse(couponOnlineUseRequestVO);
        } else if (useChannel.equals(SystemConstants.USE_CHANNEL_OFFLINE)) {
            CouponOfflineUseRequestVO couponOfflineUseRequestVO = new CouponOfflineUseRequestVO();
            couponOfflineUseRequestVO.setCouponCode(couponCode);
            couponOfflineUseRequestVO.setSysBrandId(brandId);
            couponOfflineUseRequestVO.setIsMember(SystemConstants.IS_MEMBER);
            couponOfflineUseRequestVO.setUseFrom(useFrom);
            couponOfflineUseRequestVO.setStaffCode(staffCode);
            couponOfflineUseRequestVO.setSysCompanyId(sysCompanyId);
            couponOfflineUseRequestVO.setVerifyedStoreCode(requestVO.getVerifyedStoreCode());
            couponOfflineUseRequestVO.setUseStoreCode(requestVO.getVerifyedStoreCode());
            couponOfflineUseRequestVO.setVerifyedUser(requestVO.getVerifyedUser());
            this.offlineUse(couponOfflineUseRequestVO);
        } else {
            CouponAllUseRequestVO couponAllUseRequestVO = new CouponAllUseRequestVO();
            couponAllUseRequestVO.setCouponCode(couponCode);
            couponAllUseRequestVO.setBrandId(brandId);
            couponAllUseRequestVO.setSysCompanyId(sysCompanyId);
            couponAllUseRequestVO.setUseFrom(useFrom);
            couponAllUseRequestVO.setStaffCode(staffCode);
            couponAllUseRequestVO.setVerifyedStoreCode(requestVO.getVerifyedStoreCode());
            couponAllUseRequestVO.setVerifyedUser(requestVO.getVerifyedUser());
            couponAllUseRequestVO.setOfflinePrdCode(couponDefinitionPO.getOfflinePrdCode());
            couponAllUseRequestVO.setGoodsCondition(couponDefinitionPO.getGoodsCondition());
            this.allUse(couponAllUseRequestVO);
        }
        return responseData;
    }

    public ResponseData<CouponEntityPO> findCouponEntityByCouponCode(String couponCode, Long brandId) {
        logger.info("enter CouponServiceImpl findCouponEntityByCouponCode method");
        ResponseData responseData = new ResponseData();
        CouponEntityPOExample couponEntityPOExample = new CouponEntityPOExample();
        CouponEntityPOExample.Criteria criteria = couponEntityPOExample.createCriteria();
        criteria.andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        criteria.andCouponCodeEqualTo(couponCode);
        criteria.andSysBrandIdEqualTo(brandId);
        List list = this.couponEntityPOMapper.selectByExample(couponEntityPOExample);
        if (CollectionUtils.isEmpty((Collection)list)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
            return responseData;
        }
        responseData.setData(list.get(0));
        return responseData;
    }

    public ResponseData<List<CouponEntityAndDefinitionVO>> getMemberCoupon(CouponListByMemberCodeRequestVO vo) {
        logger.info("enter CouponServiceImpl getMemberCoupon method");
        ResponseData result = new ResponseData();
        if (StringUtils.isBlank((CharSequence)vo.getMemberCode())) {
            result.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            result.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_MEMBER_CODE_NOT_NULL.getMessage());
            return result;
        }
        if (null == vo.getCouponStatus()) {
            result.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            result.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_STATUS_NOT_NULL.getMessage());
            return result;
        }
        ArrayList list = this.couponEntityPOMapper.getCouponListByMemeberCode(vo);
        if (null == list) {
            list = new ArrayList();
        }
        list.stream().forEach(entity -> {
            int days = Period.between(LocalDate.now(), entity.getValidDateEnd().toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).getDays();
            entity.setRemainExpireDays(Integer.valueOf(days));
        });
        result.setData(list);
        return result;
    }

    public ResponseData<CouponFindCouponCountResponseVO> findCouponCount(List<String> sendBusinessId, Byte sendType, Long sysBrandId) {
        logger.info("enter CouponServiceImpl findCouponCount method");
        ResponseData responseData = new ResponseData();
        if (CollectionUtils.isEmpty(sendBusinessId)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_SEND_BUSINESS_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == sendType) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_SEND_TYPE_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == sysBrandId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponFindCouponCountResponseVO vo = new CouponFindCouponCountResponseVO();
        CouponStatusEntitySuccessVO successVO = new CouponStatusEntitySuccessVO();
        successVO.setCouponStatusUsed(SystemConstants.COUPON_STATUS_USED);
        successVO.setCouponStatusUnused(SystemConstants.COUPON_STATUS_UNUSED);
        successVO.setCouponStatusOverdue(SystemConstants.COUPON_STATUS_OVERDUE);
        Long couponSum = this.couponEntityPOMapper.findCouponAllCountBySendBusinessIdList(sendBusinessId, sendType, sysBrandId, successVO);
        Long couponUsedSum = this.couponEntityPOMapper.findCouponCountBySendBusinessIdList(sendBusinessId, sendType, sysBrandId, SystemConstants.COUPON_STATUS_USED);
        vo.setCouponSum(couponSum);
        vo.setCouponUsedSum(couponUsedSum);
        responseData.setData((Object)vo);
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<PageInfo<CouponEntityVO>> findQyCouponUseHistory(String staffCode, String searchValue, int pageNumber, int pageSize) {
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        Byte useFrom = SystemConstants.COUPON_USE_FROM_QY;
        Byte couponStatus = SystemConstants.COUPON_STATUS_USED;
        List couponEntityVOS = this.couponEntityPOMapper.findQyCouponUseHistory(staffCode, searchValue, useFrom, couponStatus);
        couponEntityVOS.forEach(entityVO -> entityVO.setModifiedUserName("4"));
        PageInfo pageInfo = new PageInfo(couponEntityVOS);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<PageInfo<CouponEntityVO>> findQyCouponUseHistoryNew(String staffCode, Long sysBrandId, String searchValue, int pageNumber, int pageSize) {
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        Byte useFrom = SystemConstants.COUPON_USE_FROM_QY;
        Byte couponStatus = SystemConstants.COUPON_STATUS_USED;
        List couponEntityVOS = this.couponEntityPOMapper.findQyCouponUseHistoryNew(staffCode, sysBrandId, searchValue, useFrom, couponStatus);
        couponEntityVOS.forEach(entityVO -> entityVO.setModifiedUserName("5"));
        PageInfo pageInfo = new PageInfo(couponEntityVOS);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData couponGiving(String couponCode, String memberCode, Long companyId, Long brandId, String transferDate) {
        logger.info("CouponServiceImpl couponGiving couponCode:{},memberCode:{},companyId:{},brandId:{},transferDate:{}", new Object[]{couponCode, memberCode, companyId, brandId, transferDate});
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPOExample entityPoExample = new CouponEntityPOExample();
        entityPoExample.createCriteria().andCouponCodeEqualTo(couponCode).andSysCompanyIdEqualTo(companyId).andSysBrandIdEqualTo(brandId).andValidEqualTo(Boolean.valueOf(true));
        List couponEntityPoList = this.couponEntityPOMapper.selectByExample(entityPoExample);
        if (CollectionUtils.isEmpty((Collection)couponEntityPoList)) {
            logger.info("CouponServiceImpl couponGiving \u6839\u636e\u5238\u53f7\u6ca1\u6709\u67e5\u5230\u5238\u5b9e\u4f8b\u4fe1\u606f\u3002coupon:{}", (Object)couponCode);
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_HAVE.getMessage());
            return responseData;
        }
        CouponEntityPO entityPo = (CouponEntityPO)couponEntityPoList.get(0);
        if (entityPo.getGive() != null && entityPo.getGive().booleanValue()) {
            logger.info("CouponServiceImpl couponGiving \u5238\u5df2\u88ab\u8f6c\u8d60\u3002coupon:{}", (Object)couponCode);
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_HAVE_TRANSFER.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPo = new CouponEntityPO();
        couponEntityPo.setGive(SystemConstants.COUPON_GIVING);
        couponEntityPo.setModifiedDate(new Date());
        this.couponEntityPOMapper.updateByExampleSelective(couponEntityPo, entityPoExample);
        CouponRecordPO couponRecordPo = new CouponRecordPO();
        couponRecordPo.setSysCompanyId(companyId);
        couponRecordPo.setSysBrandId(brandId);
        couponRecordPo.setCouponCode(couponCode);
        couponRecordPo.setCouponName(entityPo.getCouponName());
        couponRecordPo.setMemberCode(memberCode);
        MemberInfoModel model = MemberInfoModel.builder().sysCompanyId(companyId).brandId(brandId).memberCode(memberCode).build();
        ResponseData memberInfoResponseData = this.memberInfoApiService.getMemberModel(model);
        if (memberInfoResponseData.getCode() == com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() && memberInfoResponseData.getData() != null) {
            couponRecordPo.setMemberPhone(((MemberInfoModel)memberInfoResponseData.getData()).getPhone());
        }
        couponRecordPo.setTransferMember(memberCode);
        try {
            couponRecordPo.setTransferDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(transferDate));
        }
        catch (Exception e) {
            logger.info("\u5165\u53c2\u8f6c\u8d60\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3002transferDate:{}", (Object)transferDate);
            couponRecordPo.setTransferDate(new Date());
        }
        couponRecordPo.setCreateDate(new Date());
        couponRecordPo.setType(SystemConstants.TRANSFER_TYPE_GIVE);
        couponRecordPo.setRecordNo(this.getSerialNumber());
        couponRecordPo.setCouponDefinitionId(entityPo.getCouponDefinitionId());
        couponRecordPo.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        this.couponRecordPOMapper.insertSelective(couponRecordPo);
        return responseData;
    }

    public ResponseData transferCouponBack(String couponCode, String memberCode, Long companyId, Long brandId) {
        logger.info("CouponServiceImpl transferCouponBack couponCode:{},memberCode:{},companyId:{},brandId:{}", new Object[]{couponCode, memberCode, companyId, brandId});
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPOExample entityPoExample = new CouponEntityPOExample();
        entityPoExample.createCriteria().andCouponCodeEqualTo(couponCode).andSysCompanyIdEqualTo(companyId).andSysBrandIdEqualTo(brandId).andValidEqualTo(Boolean.valueOf(true));
        List couponEntityPoList = this.couponEntityPOMapper.selectByExample(entityPoExample);
        if (CollectionUtils.isEmpty((Collection)couponEntityPoList)) {
            logger.info("CouponServiceImpl transferCouponBack \u6839\u636e\u5238\u53f7\u6ca1\u6709\u67e5\u5230\u5238\u5b9e\u4f8b\u4fe1\u606f\u3002coupon:{}", (Object)couponCode);
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_HAVE.getMessage());
            return responseData;
        }
        CouponEntityPO entityPo = (CouponEntityPO)couponEntityPoList.get(0);
        if (!entityPo.getGive().booleanValue()) {
            logger.info("CouponServiceImpl transferCouponBack \u5238\u5df2\u662f\u672a\u8f6c\u8d60\u72b6\u6001\u3002coupon:{}", (Object)couponCode);
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_HAVE_RECEIVE_OR_BACK.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntityPo = new CouponEntityPO();
        couponEntityPo.setGive(SystemConstants.COUPON_UNGIVE);
        couponEntityPo.setModifiedDate(new Date());
        this.couponEntityPOMapper.updateByExampleSelective(couponEntityPo, entityPoExample);
        CouponRecordPOExample recordPoExample = new CouponRecordPOExample();
        recordPoExample.createCriteria().andSysCompanyIdEqualTo(companyId).andSysBrandIdEqualTo(brandId).andCouponCodeEqualTo(couponCode).andMemberCodeEqualTo(memberCode).andTypeEqualTo(SystemConstants.TRANSFER_TYPE_GIVE);
        recordPoExample.setOrderByClause("create_date DESC");
        List couponRecordPoList = this.couponRecordPOMapper.selectByExample(recordPoExample);
        CouponRecordPO couponRecordPo = new CouponRecordPO();
        if (CollectionUtil.isNotEmpty((Collection)couponRecordPoList)) {
            couponRecordPo.setTransferDate(((CouponRecordPO)couponRecordPoList.get(0)).getTransferDate());
        }
        couponRecordPo.setSysCompanyId(companyId);
        couponRecordPo.setSysBrandId(brandId);
        couponRecordPo.setCouponCode(couponCode);
        couponRecordPo.setCouponName(entityPo.getCouponName());
        couponRecordPo.setMemberCode(memberCode);
        MemberInfoModel model = MemberInfoModel.builder().sysCompanyId(companyId).brandId(brandId).memberCode(memberCode).build();
        ResponseData memberInfoResponseData = this.memberInfoApiService.getMemberModel(model);
        if (memberInfoResponseData.getCode() == com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() && memberInfoResponseData.getData() != null) {
            couponRecordPo.setMemberPhone(((MemberInfoModel)memberInfoResponseData.getData()).getPhone());
        }
        couponRecordPo.setTransferMember(memberCode);
        couponRecordPo.setCreateDate(new Date());
        couponRecordPo.setType(SystemConstants.TRANSFER_TYPE_GIVEBACK);
        couponRecordPo.setRecordNo(this.getSerialNumber());
        couponRecordPo.setCouponDefinitionId(entityPo.getCouponDefinitionId());
        couponRecordPo.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        this.couponRecordPOMapper.insertSelective(couponRecordPo);
        return responseData;
    }

    public ResponseData offlineSyncCoupon(CouponOfflineUseRequestVO param) {
        CouponEntityPO couponEntityPO;
        logger.info("enter CouponServiceImpl offlineUse method");
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)param.getCouponCode())) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isNotBlank((CharSequence)param.getUseStoreCode())) {
            ResponseData storeCodeResult = this.storeServiceRpc.getStoreOfflineIdByCode(param.getUseStoreCode());
            param.setUseStoreId((String)storeCodeResult.getData());
        }
        if (null == (couponEntityPO = this.findCouponEntityPO(param.getCouponCode()))) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_USED.getMessage());
            return responseData;
        }
        if (couponEntityPO.getCouponStatus().equals(SystemConstants.COUPON_STATUS_OVERDUE)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_EXPIRED.getMessage());
            return responseData;
        }
        if (this.checkCouponIfIntegralCoupon(couponEntityPO.getCouponDefinitionId()).booleanValue()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_TAIDI_ONLY.getMessage());
            return responseData;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date validDateStart = couponEntityPO.getValidDateStart();
            Date startDate = format.parse(format.format(validDateStart));
            Date today = format.parse(format.format(new Date()));
            if (today.getTime() < startDate.getTime()) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_VALID.getMessage());
                return responseData;
            }
        }
        catch (Exception e) {
            logger.info("enter CouponServiceImpl use  method ! date format error");
        }
        if (couponEntityPO.getSendType().equals(SendTypeEnum.SEND_COUPON_BATCH.getCode())) {
            this.couponManualService.updateCouponManualCount(couponEntityPO.getUseStoreId(), couponEntityPO.getSendBusinessId(), param.getProfitMoney(), param.getDiscountMoney());
        }
        couponEntityPO.setUseType(SystemConstants.COUPON_USE_TYPE_OFFLINE);
        couponEntityPO.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        if (StringUtil.isNotBlank((String)param.getUseTime())) {
            couponEntityPO.setUseTime(DateUtil.parse((String)param.getUseTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            couponEntityPO.setUseTime(TimeUtils.getNowTime());
        }
        couponEntityPO.setUseBusinessCode(param.getBusinessCode());
        couponEntityPO.setUseStoreId(param.getUseStoreId());
        couponEntityPO.setUseBusinessAmount(param.getProfitMoney());
        couponEntityPO.setModifiedDate(TimeUtils.getNowTime());
        couponEntityPO.setIsUse(SystemConstants.COUPON_DEFINITION_STATUS_USE);
        couponEntityPO.setUseFrom(param.getUseFrom());
        couponEntityPO.setStaffCode(param.getStaffCode());
        logger.info("enter semd getTransferSend" + couponEntityPO.getCouponCode() + JSONObject.toJSONString((Object)couponEntityPO));
        this.couponEntityPOMapper.updateByPrimaryKeySelective(couponEntityPO);
        if (couponEntityPO.getTransferSend() != null && couponEntityPO.getTransferSend().booleanValue()) {
            SendCouponSimpleRequestVO sendVO = new SendCouponSimpleRequestVO();
            sendVO.setMemberCode(couponEntityPO.getTransferMemberCode());
            sendVO.setCouponDefinitionId(couponEntityPO.getTransferCouponDefinitionId());
            sendVO.setSendType(couponEntityPO.getSendType());
            sendVO.setSendBussienId(couponEntityPO.getSendBusinessId());
            sendVO.setBusinessName(couponEntityPO.getBusinessName());
            sendVO.setBrandId(couponEntityPO.getSysBrandId());
            sendVO.setCompanyId(couponEntityPO.getSysCompanyId());
            sendVO.setBrandCode(couponEntityPO.getBrandCode());
            this.sendCouponService.simple(sendVO);
        }
        CouponStatusLogPO couponStatusLogPO = new CouponStatusLogPO();
        couponStatusLogPO.setCouponEntityId(couponEntityPO.getCouponEntityId());
        couponStatusLogPO.setCouponCode(param.getCouponCode());
        couponStatusLogPO.setBusinessType(SystemConstants.COUPON_STATUS_CHANGE_BUSINESS_TYPE_USE);
        couponStatusLogPO.setBusinessCode(param.getBusinessCode());
        couponStatusLogPO.setBusinessTime(TimeUtils.getNowTime());
        couponStatusLogPO.setCreateDate(TimeUtils.getNowTime());
        this.couponStatusLogPOMapper.insertSelective(couponStatusLogPO);
        return responseData;
    }

    public ResponseData<CouponInfoVo> findCouponInfoRpc(String couponCode, Long brandId) {
        logger.info("enter CouponServiceImpl findCouponInfoRpc method");
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == brandId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPOExample entityExample = new CouponEntityPOExample();
        entityExample.createCriteria().andCouponCodeEqualTo(couponCode).andSysBrandIdEqualTo(brandId).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List entityList = this.couponEntityPOMapper.selectByExample(entityExample);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(((CouponEntityPO)entityList.get(0)).getCouponDefinitionId()));
        CouponInfoVo responseVO = new CouponInfoVo();
        responseVO.setCouponDefinitionPOWithBLOBs(couponDefinitionPOWithBLOBs);
        responseVO.setCouponEntityPO((CouponEntityPO)entityList.get(0));
        responseData.setData((Object)responseVO);
        return responseData;
    }

    public ResponseData<CouponInfoVo> findCouponInfoByCompanyIdRpc(String couponCode, Long sysCompanyId) {
        logger.info("enter CouponServiceImpl findCouponInfoByCompanyIdRpc method");
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)couponCode)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == sysCompanyId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COMPANY_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPOExample entityExample = new CouponEntityPOExample();
        entityExample.createCriteria().andCouponCodeEqualTo(couponCode).andSysCompanyIdEqualTo(sysCompanyId).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List entityList = this.couponEntityPOMapper.selectByExample(entityExample);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(((CouponEntityPO)entityList.get(0)).getCouponDefinitionId()));
        CouponInfoVo responseVO = new CouponInfoVo();
        responseVO.setCouponDefinitionPOWithBLOBs(couponDefinitionPOWithBLOBs);
        responseVO.setCouponEntityPO((CouponEntityPO)entityList.get(0));
        responseData.setData((Object)responseVO);
        return responseData;
    }

    public ResponseData<PageInfo<CouponInfoVo>> pageListInfoByCondition(CouponEntityVO requestVO) {
        logger.info("CouponServiceImpl-pageListInfoByCondition-info,requestVO:{}", (Object)JSON.toJSONString((Object)requestVO));
        ResponseData responseData = new ResponseData();
        if (requestVO.getSysCompanyId() == null) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COMPANY_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPOExample entityExample = new CouponEntityPOExample();
        CouponEntityPOExample.Criteria couponCriteria = entityExample.createCriteria();
        couponCriteria.andSysCompanyIdEqualTo(requestVO.getSysCompanyId());
        if (requestVO.getStartTime() != null) {
            couponCriteria.andModifiedDateGreaterThanOrEqualTo(requestVO.getStartTime());
        }
        if (requestVO.getEndTime() != null) {
            couponCriteria.andModifiedDateLessThanOrEqualTo(requestVO.getEndTime());
        }
        if (CollectionUtils.isNotEmpty((Collection)requestVO.getCouponCodeList())) {
            couponCriteria.andCouponCodeIn(requestVO.getCouponCodeList());
        }
        entityExample.setOrderByClause(" modified_date desc ");
        PageHelper.startPage((int)requestVO.getPageNumber(), (int)requestVO.getPageSize());
        List entityList = this.couponEntityPOMapper.selectByExample(entityExample);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return new ResponseData((Object)new PageInfo(new ArrayList()));
        }
        PageInfo page = new PageInfo(entityList);
        PageInfo resultPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)page, (Object)resultPageInfo, (String[])new String[]{"list"});
        List couponDefinitionIdList = entityList.stream().map(CouponEntityPO::getCouponDefinitionId).map(Long::valueOf).collect(Collectors.toList());
        CouponDefinitionPOExample definitionExample = new CouponDefinitionPOExample();
        definitionExample.createCriteria().andCouponDefinitionIdIn(couponDefinitionIdList).andSysCompanyIdEqualTo(requestVO.getSysCompanyId());
        List couponDefinitionPOList = this.couponDefinitionPOMapper.selectByExampleWithBLOBs(definitionExample);
        Map definitionMap = couponDefinitionPOList.stream().collect(Collectors.toMap(CouponDefinitionPO::getCouponDefinitionId, Functions.identity(), (o1, o2) -> o1));
        List resultList = entityList.stream().map(po -> {
            CouponInfoVo resultVO = new CouponInfoVo();
            resultVO.setCouponEntityPO(po);
            resultVO.setCouponDefinitionPOWithBLOBs((CouponDefinitionPOWithBLOBs)definitionMap.get(Long.valueOf(po.getCouponDefinitionId())));
            return resultVO;
        }).collect(Collectors.toList());
        resultPageInfo.setList(resultList);
        responseData.setData((Object)resultPageInfo);
        logger.info("CouponServiceImpl-pageListInfoByCondition-info,responseData:{}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    public ResponseData<CouponInfoVo> findCouponInfoByCompanyIdRpc(String phone, Long kdtId, Long couponId) {
        logger.info("enter CouponServiceImpl findCouponInfoByCompanyIdRpc method");
        ResponseData responseData = new ResponseData();
        if (couponId == null) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5238ID\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        CouponEntityPO entityList = this.couponEntityPOMapper.findCouponDetailByphoneKdtIdDetail(kdtId, phone, couponId, SystemConstants.TABLE_VALID_EFFECTIVE);
        if (entityList == null) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(entityList.getCouponDefinitionId()));
        CouponInfoVo responseVO = new CouponInfoVo();
        responseVO.setCouponDefinitionPOWithBLOBs(couponDefinitionPOWithBLOBs);
        responseVO.setCouponEntityPO(entityList);
        responseData.setData((Object)responseVO);
        return responseData;
    }

    public ResponseData reversal(CouponReversalRequestVO vo) {
        logger.info("enter CouponServiceImpl reversal method param:{}", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        SysBrandPo brandPo = new SysBrandPo();
        brandPo.setBrandCode(vo.getBrandCode());
        ResponseData brandPoResponseData = this.brandServiceRpc.getBrandIdAndCompanyIdByCode(brandPo);
        if (brandPoResponseData.getCode() != com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() || brandPoResponseData.getData() == null) {
            logger.info("CouponServiceImpl reversal \u6839\u636e\u4f20\u5165\u7684brandCode:{}\u67e5\u8be2\u4e0d\u5230\u54c1\u724c\u4fe1\u606f", (Object)vo.getBrandCode());
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
            responseData.setMessage(brandPoResponseData.getMessage());
            return responseData;
        }
        brandPo = (SysBrandPo)brandPoResponseData.getData();
        CouponEntityPOExample example = new CouponEntityPOExample();
        example.createCriteria().andCouponCodeEqualTo(vo.getCouponCode()).andSysBrandIdEqualTo(brandPo.getSysBrandId());
        List couponEntityPOList = this.couponEntityPOMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)couponEntityPOList)) {
            logger.info("CouponServiceImpl reversal \u67e5\u8be2\u5238\u4fe1\u606f\u4e3a\u7a7a couponCode:{}", (Object)vo.getCouponCode());
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
            responseData.setMessage("\u67e5\u8be2\u5238\u4fe1\u606f\u4e0d\u5b58\u5728");
            return responseData;
        }
        CouponEntityPO couonEntity = (CouponEntityPO)couponEntityPOList.get(0);
        if (SendTypeEnum.SEND_ALIPAY_VOUCHER.getCode().equals(couonEntity.getSendType())) {
            logger.info("CouponServiceImpl reversal \u67e5\u8be2\u5238\u4fe1\u606f\u4e3a\u7a7a couponCode:{}", (Object)vo.getCouponCode());
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5546\u5bb6\u5238\u4e0d\u5141\u8bb8\u51b2\u6b63!");
            return responseData;
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getErpId())) {
            MemberInfoModel model = MemberInfoModel.builder().erpId(vo.getErpId()).sysCompanyId(((SysBrandPo)brandPoResponseData.getData()).getSysCompanyId()).brandId(((SysBrandPo)brandPoResponseData.getData()).getSysBrandId()).build();
            ResponseData memberInfoResponseData = this.memberInfoApiService.getMemberModel(model);
            if (memberInfoResponseData.getCode() != com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() || memberInfoResponseData.getData() == null) {
                logger.info("CouponServiceImpl reversal \u6839\u636e\u4f20\u5165\u7684erpId:{},brandCode:{}\u67e5\u8be2\u4e0d\u5230\u4f1a\u5458\u4fe1\u606f", (Object)vo.getErpId(), (Object)vo.getBrandCode());
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
                responseData.setMessage("\u4f1a\u5458\u4e0d\u5b58\u5728");
                return responseData;
            }
            MemberInfoModel memberInfoModel = (MemberInfoModel)memberInfoResponseData.getData();
            if (!memberInfoModel.getMemberCode().equals(couonEntity.getMemberCode())) {
                logger.info("CouponServiceImpl reversal \u4f20\u5165\u7684erpId\u4e0e\u5238\u7ed1\u5b9a\u7684\u4f1a\u5458\u4e0d\u5339\u914d,erpId:{},couponCode:{}", (Object)vo.getErpId(), (Object)vo.getCouponCode());
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
                responseData.setMessage("\u4f20\u5165\u7684erpId\u4e0e\u5238\u7ed1\u5b9a\u7684\u4f1a\u5458\u4e0d\u5339\u914d");
                return responseData;
            }
        }
        couonEntity.setCouponStatus(SystemConstants.COUPON_STATUS_UNUSED);
        couonEntity.setIsUse(SystemConstants.COUPON_USE_UNUSED);
        couonEntity.setModifiedDate(new Date());
        couonEntity.setUseSourceCode(null);
        couonEntity.setUseStoreName(null);
        couonEntity.setUseStoreCode(null);
        couonEntity.setUseTime(null);
        couonEntity.setUseBusinessAmount(null);
        couonEntity.setUseStoreId(null);
        couonEntity.setUseBusinessCode(null);
        couonEntity.setUseMemberCode(null);
        this.couponEntityPOMapper.updateByPrimaryKey(couonEntity);
        CouponReversqlRecordPO po = CouponReversqlRecordPO.builder().sysCompanyId(brandPo.getSysCompanyId()).sysBrandId(brandPo.getSysBrandId()).couponCode(vo.getCouponCode()).couponName(couonEntity.getCouponName()).couponDefinitionId(couonEntity.getCouponDefinitionId()).memberCode(couonEntity.getMemberCode()).orderNo(StringUtils.isNotEmpty((CharSequence)vo.getOrderNo()) ? vo.getOrderNo() : couonEntity.getUseBusinessCode()).storeCode(StringUtils.isNotEmpty((CharSequence)vo.getStoreCode()) ? vo.getStoreCode() : couonEntity.getUseStoreId()).useTime(couonEntity.getUseTime()).createDate(new Date()).valid(Boolean.valueOf(true)).build();
        this.couponReversqlRecordPOMapper.insertSelective(po);
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public void refund(CouponRefundRequestVO couponRefundRequestVO) {
        logger.info("\u9000\u5355\u7684\u9000\u5238\u64cd\u4f5c\u5165\u53e3,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)couponRefundRequestVO));
        Assert.isTrue((couponRefundRequestVO != null && couponRefundRequestVO.getSysCompanyId() != null && StringUtils.isNotBlank((CharSequence)couponRefundRequestVO.getBrandCode()) && CollectionUtils.isNotEmpty((Collection)couponRefundRequestVO.getCouponCodelist()) && StringUtils.isNotBlank((CharSequence)couponRefundRequestVO.getOrderNo()) && StringUtils.isNotBlank((CharSequence)couponRefundRequestVO.getStoreCode()) ? 1 : 0) != 0, (String)"\u53c2\u6570\u96c6\u5408\u5bf9\u8c61\u5c5e\u6027\u5b58\u5728\u4e3a\u7a7a", (Object[])new Object[0]);
        List couponCodelist = couponRefundRequestVO.getCouponCodelist();
        List couponEntityPOSList = this.couponEntityPOMapper.findByCouponCodeList(couponCodelist);
        if (CollectionUtils.isEmpty((Collection)couponEntityPOSList)) {
            logger.info("CouponServiceImpl-refund-info,\u9000\u5355\u9000\u5238\u64cd\u4f5c,\u6839\u636e\u5238Code\u672a\u67e5\u5230\u5238\u5b9e\u4f53,couponCodeList:{}", (Object)JacksonUtil.list2Json((List)couponCodelist));
            return;
        }
        List couponDefinitionIdList = couponEntityPOSList.stream().map(couponEntityPOS -> couponEntityPOS.getCouponDefinitionId()).collect(Collectors.toList());
        List couponDefinitionPOList = this.couponDefinitionPOMapper.findByCouponDefinitionIdList(couponRefundRequestVO.getSysCompanyId(), SystemConstants.COUPON_CHARGE_BACK_YES, couponDefinitionIdList);
        if (CollectionUtils.isEmpty((Collection)couponDefinitionPOList)) {
            logger.info("CouponServiceImpl-refund-info,\u9000\u5355\u9000\u5238\u64cd\u4f5c,\u6839\u636e\u5238\u5b9a\u4e49ID\u672a\u67e5\u5230\u5238\u5b9a\u4e49\u4fe1\u606f,couponCodeList:{},couponDefinitionIdList:{}", (Object)JacksonUtil.list2Json((List)couponCodelist), (Object)JacksonUtil.list2Json(couponDefinitionIdList));
            return;
        }
        List canUseCouponDefinitionIdList = couponDefinitionPOList.stream().map(couponDefinitionPO -> couponDefinitionPO.getCouponDefinitionId().toString()).collect(Collectors.toList());
        ArrayList<CouponReversqlRecordPO> couponReversqlRecordPOList = new ArrayList<CouponReversqlRecordPO>();
        ArrayList<CouponEntityPO> couponEntityPOSUpdateList = new ArrayList<CouponEntityPO>();
        for (CouponEntityPO couponEntityPO : couponEntityPOSList) {
            if (canUseCouponDefinitionIdList.contains(couponEntityPO.getCouponDefinitionId())) {
                CouponReversqlRecordPOExample countExample = new CouponReversqlRecordPOExample();
                countExample.createCriteria().andSysBrandIdEqualTo(couponEntityPO.getSysBrandId()).andCouponCodeEqualTo(couponEntityPO.getCouponCode()).andOrderNoEqualTo(couponRefundRequestVO.getOrderNo()).andValidEqualTo(Boolean.TRUE);
                if (this.couponReversqlRecordPOMapper.countByExample(countExample) > 0L) {
                    logger.info("\u9000\u5355\u7684\u9000\u5238\u64cd\u4f5c,\u4f7f\u7528\u7684\u5f53\u524d\u4f18\u60e0\u5238\u5df2\u6709\u76f8\u540c\u9000\u5355\u53f7\u7684\u51b2\u6b63\u8bb0\u5f55,\u4e0d\u9700\u8981\u518d\u9000\u5355\u9000\u5238,\u4f18\u60e0\u5238\u4fe1\u606f:{}", (Object)couponEntityPO.getCouponCode());
                    continue;
                }
                couponEntityPO.setCouponStatus(couponEntityPO.getValidDateEnd() != null && couponEntityPO.getValidDateEnd().before(new Date()) ? SystemConstants.COUPON_STATUS_OVERDUE : SystemConstants.COUPON_STATUS_UNUSED);
                couponEntityPOSUpdateList.add(couponEntityPO);
                couponReversqlRecordPOList.add(CouponReversqlRecordPO.builder().sysCompanyId(couponEntityPO.getSysCompanyId()).sysBrandId(couponEntityPO.getSysBrandId()).couponCode(couponEntityPO.getCouponCode()).couponName(couponEntityPO.getCouponName()).couponDefinitionId(couponEntityPO.getCouponDefinitionId()).memberCode(couponEntityPO.getMemberCode()).orderNo(couponRefundRequestVO.getOrderNo()).storeCode(couponRefundRequestVO.getStoreCode()).createDate(new Date()).valid(Boolean.valueOf(true)).build());
                continue;
            }
            logger.info("\u9000\u5355\u7684\u9000\u5238\u64cd\u4f5c,\u4f7f\u7528\u7684\u5f53\u524d\u4f18\u60e0\u5238\u4e0d\u80fd\u9000\u5355\u9000\u5238,\u4f18\u60e0\u5238\u4fe1\u606f:{}", (Object)couponEntityPO.getCouponCode());
        }
        logger.info("\u6570\u636e\u51c6\u5907\u5b8c\u6210,\u4fee\u6539\u8868t_coupon_entity,\u63d2\u5165t_coupon_reversal_record");
        couponEntityPOSUpdateList.stream().forEach(couponEntity -> this.couponEntityPOMapper.refundUpdateEntity(couponEntity));
        Assert.isTrue((this.couponReversqlRecordPOMapper.batchInsertEntity(couponReversqlRecordPOList) > 0 ? 1 : 0) != 0, (String)"\u6279\u91cf\u8868t_coupon_reversal_record\u5931\u8d25,\u6570\u636e\u5185\u5bb9:{}", (Object[])new Object[]{JSONObject.toJSONString(couponReversqlRecordPOList)});
    }

    public ResponseData selectActivityCoupon(Long sysBrandId, Integer page, Integer pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        List couponDefinitionPOList = this.couponDefinitionPOMapper.selectActivityCoupon(sysBrandId);
        PageInfo pageInfo = new PageInfo(couponDefinitionPOList);
        logger.info("coupon-parent_selectActivityCoupon{}", (Object)pageInfo);
        return new ResponseData((Object)pageInfo);
    }

    public ResponseData getCouponReceiveStatus(ReceiveCouponStatusVO receiveCouponStatusVO) {
        logger.info("coupon-parent_getCouponReceiveStatus{}", (Object)JSON.toJSONString((Object)receiveCouponStatusVO));
        String memberCode = receiveCouponStatusVO.getMemberCode();
        Long brandId = receiveCouponStatusVO.getBrandId();
        HashMap<Long, Boolean> couponStatusMap = new HashMap<Long, Boolean>();
        Long couponId = receiveCouponStatusVO.getCouponIds();
        CouponEntityPOExample couponEntityPOExample = new CouponEntityPOExample();
        couponEntityPOExample.createCriteria().andSysBrandIdEqualTo(brandId).andMemberCodeEqualTo(memberCode).andCouponEntityIdEqualTo(couponId);
        List couponEntityPOList = this.couponEntityPOMapper.selectByExample(couponEntityPOExample);
        if (CollectionUtil.isNotEmpty((Collection)couponEntityPOList)) {
            couponStatusMap.put(couponId, false);
        } else {
            couponStatusMap.put(couponId, true);
        }
        logger.info("\u4f18\u60e0\u5238\u67e5\u8be2\u7ed3\u679c{}", (Object)JSON.toJSONString(couponStatusMap));
        return new ResponseData(couponStatusMap);
    }

    public ResponseData<String> invalid(CouponInvalidRequestVO couponInvalidRequestVO) {
        List couponEntityIdList;
        logger.info("couponServiceImpl#invalid,couponInvalidRequestVO:{}", (Object)JSONObject.toJSONString((Object)couponInvalidRequestVO));
        if (couponInvalidRequestVO == null || couponInvalidRequestVO.getCompanyId() == null || StringUtils.isBlank((CharSequence)couponInvalidRequestVO.getMemberCode()) || StringUtils.isBlank((CharSequence)couponInvalidRequestVO.getSendType()) || CollectionUtils.isEmpty((Collection)couponInvalidRequestVO.getSendBussienIdList())) {
            logger.info("couponServiceImpl#invalid,\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7");
            return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7");
        }
        CouponEntityPOExample couponEntityPOExample = new CouponEntityPOExample();
        CouponEntityPOExample.Criteria Criteria2 = couponEntityPOExample.createCriteria().andSysCompanyIdEqualTo(couponInvalidRequestVO.getCompanyId()).andSysBrandIdEqualTo(couponInvalidRequestVO.getBrandId()).andMemberCodeEqualTo(couponInvalidRequestVO.getMemberCode()).andSendTypeEqualTo(couponInvalidRequestVO.getSendType()).andSendBusinessIdIn(couponInvalidRequestVO.getSendBussienIdList()).andIsUseEqualTo(Boolean.FALSE).andValidEqualTo(Boolean.TRUE);
        if (couponInvalidRequestVO.getSendTimeStartDate() != null) {
            Criteria2.andCreateDateBetween(couponInvalidRequestVO.getSendTimeStartDate(), new Date());
        }
        if (CollectionUtils.isEmpty((Collection)(couponEntityIdList = this.couponEntityPOMapper.selectPrimaryKeyListByExample(couponEntityPOExample)))) {
            logger.info("couponServiceImpl#invalid,memberCode:{},\u7b26\u5408\u9000\u5238\u8981\u6c42\u6570\u91cf\u4e3a0", (Object)couponInvalidRequestVO.getMemberCode());
            return new ResponseData();
        }
        logger.info("couponServiceImpl#invalid,memberCode:{},\u7b26\u5408\u9000\u5238\u8981\u6c42\u6570\u91cf\u4e3a:{},couponEntityIdList:{}", new Object[]{couponInvalidRequestVO.getMemberCode(), couponEntityIdList.size(), couponEntityIdList});
        CouponEntityPO couponEntityUpdatePO = CouponEntityPO.builder().couponStatus(SystemConstants.COUPON_STATUS_INVALID).valid(Boolean.FALSE).modifiedDate(new Date()).build();
        this.couponEntityPOMapper.updateByExampleSelective(couponEntityUpdatePO, couponEntityPOExample);
        return new ResponseData();
    }

    public ResponseData<PageInfo<CouponByTransferVO>> getCouponListByTransfer(CouponListByMemberCodeRequestVO vo) {
        logger.info("couponServiceImpl getCouponListByTransfer method!");
        ResponseData result = new ResponseData();
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        ArrayList couponByTransferVoList = new ArrayList();
        List couponRecordPoList = this.couponRecordPOMapper.selectByTypeAndTransfer(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getMemberCode(), SystemConstants.TRANSFER_TYPE_RECEIVE);
        if (CollectionUtils.isEmpty((Collection)couponRecordPoList)) {
            PageInfo pageInfo = new PageInfo(couponByTransferVoList);
            result.setData((Object)pageInfo);
            return result;
        }
        PageInfo recordPageInfo = new PageInfo(couponRecordPoList);
        Long recordCount = this.couponRecordPOMapper.selectByTypeAndTransferCount(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getMemberCode(), SystemConstants.TRANSFER_TYPE_RECEIVE);
        List couponCodes = couponRecordPoList.stream().map(CouponRecordPO::getCouponCode).collect(Collectors.toList());
        List list = this.couponEntityPOMapper.getCouponListByTransfer(couponCodes, vo.getSysCompanyId(), vo.getSysBrandId());
        Map couponEntityMap = list.stream().collect(Collectors.toMap(CouponEntityAndDefinitionVO::getCouponCode, Function.identity(), (key1, key2) -> key2));
        couponRecordPoList.forEach(v -> {
            CouponByTransferVO transferVo = new CouponByTransferVO();
            transferVo.setTransferPhone(v.getMemberPhone());
            CouponEntityAndDefinitionVO couonEntityVo = (CouponEntityAndDefinitionVO)couponEntityMap.get(v.getCouponCode());
            BeanUtil.copyProperties((Object)couonEntityVo, (Object)transferVo);
            couponByTransferVoList.add(transferVo);
        });
        PageInfo pageInfo = new PageInfo(couponByTransferVoList);
        pageInfo.setTotal(recordCount.longValue());
        pageInfo.setPages(recordPageInfo.getPages());
        result.setData((Object)pageInfo);
        return result;
    }

    public ResponseData<Boolean> getIsCouponRecordBack(CouponEntityVO vo) {
        logger.info("couponServiceImpl getIsCouponRecordBack method!");
        ResponseData responseData = new ResponseData();
        responseData.setData((Object)false);
        if (vo.getSysCompanyId() == null || vo.getSysBrandId() == null) {
            return responseData;
        }
        if (StringUtils.isEmpty((CharSequence)vo.getCouponCode()) || StringUtils.isEmpty((CharSequence)vo.getTransferMemberCode()) || vo.getDtStart() == null) {
            return responseData;
        }
        CouponRecordPOExample example = new CouponRecordPOExample();
        example.createCriteria().andSysCompanyIdEqualTo(vo.getSysCompanyId()).andSysBrandIdEqualTo(vo.getSysBrandId()).andTransferDateEqualTo(vo.getDtStart()).andTransferMemberEqualTo(vo.getTransferMemberCode()).andTypeEqualTo(Integer.valueOf(3)).andCouponCodeEqualTo(vo.getCouponCode()).andValidEqualTo(Boolean.valueOf(true));
        List couponRecordPos = this.couponRecordPOMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)couponRecordPos)) {
            responseData.setData((Object)true);
        }
        return responseData;
    }

    public ResponseData<PageInfo<CouponRecordTransferVO>> findCouponRecordList(CouponRecordTransferRequestVO vo) {
        logger.info("couponServiceImpl findCouponRecordList method!");
        ResponseData result = new ResponseData();
        ArrayList couponByTransferVoList = new ArrayList();
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        List couponRecordPoList = this.couponRecordPOMapper.getByTypeAndTransfer(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getMemberCode(), SystemConstants.TRANSFER_TYPE_RECEIVE);
        if (CollectionUtils.isEmpty((Collection)couponRecordPoList)) {
            PageInfo pageInfo = new PageInfo(couponByTransferVoList);
            result.setData((Object)pageInfo);
            return result;
        }
        Long byTypeAndTransferCount = this.couponRecordPOMapper.getByTypeAndTransferCount(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getMemberCode(), SystemConstants.TRANSFER_TYPE_RECEIVE);
        List couponCodes = couponRecordPoList.stream().map(CouponRecordPO::getCouponCode).collect(Collectors.toList());
        List byCouponCodeAndBrand = this.couponEntityPOMapper.findByCouponCodeAndBrand(couponCodes, vo.getSysCompanyId(), vo.getSysBrandId());
        Map couponEntityMap = byCouponCodeAndBrand.stream().collect(Collectors.toMap(CouponEntityPO::getCouponCode, Function.identity(), (key1, key2) -> key2));
        couponRecordPoList.forEach(record -> {
            CouponRecordTransferVO recordTransferVo = new CouponRecordTransferVO();
            CouponEntityPO couponEntityPo = (CouponEntityPO)couponEntityMap.get(record.getCouponCode());
            recordTransferVo.setCouponCode(record.getCouponCode());
            recordTransferVo.setCouponName(couponEntityPo.getCouponName());
            recordTransferVo.setPreferentialType(couponEntityPo.getPreferentialType());
            recordTransferVo.setGiveDate(record.getTransferDate());
            recordTransferVo.setReceiveDate(record.getCreateDate());
            recordTransferVo.setReceivePhone(record.getMemberPhone());
            recordTransferVo.setCouponEntityId(couponEntityPo.getCouponEntityId());
            recordTransferVo.setCouponDefinitionId(StringUtils.isNotBlank((CharSequence)couponEntityPo.getCouponDefinitionId()) ? Long.valueOf(couponEntityPo.getCouponDefinitionId()) : null);
            couponByTransferVoList.add(recordTransferVo);
        });
        PageInfo pageInfo = new PageInfo(couponByTransferVoList);
        pageInfo.setTotal(byTypeAndTransferCount.longValue());
        result.setData((Object)pageInfo);
        return result;
    }

    public ResponseData<PageInfo<CouponRecordResponseVO>> findCouponRecordPage(CouponRecordRequestVO vo, SysAccountPO accountPo) {
        logger.info("couponServiceImpl findCouponRecordPage method!");
        ResponseData result = new ResponseData();
        ArrayList couponByTransferVoList = new ArrayList();
        if (vo.getSysCompanyId() == null || vo.getSysBrandId() == null) {
            logger.info("couponServiceImpl findCouponRecordPage \u4f01\u4e1aid\u6216\u54c1\u724cid\u4e3a\u7a7a!");
            result.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            result.setMessage("\u4f01\u4e1aid\u6216\u54c1\u724cid\u4e3a\u7a7a");
            return result;
        }
        if (vo.getPageNumber() == null || vo.getPageSize() == null) {
            logger.info("couponServiceImpl findCouponRecordPage \u5206\u9875\u53c2\u6570\u4e3a\u7a7a!");
            result.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            result.setMessage("\u5206\u9875\u53c2\u6570\u4e3a\u7a7a");
            return result;
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getGivePhone())) {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setSysCompanyId(vo.getSysCompanyId());
            memberInfoModel.setBrandId(vo.getSysBrandId());
            memberInfoModel.setPhone(vo.getGivePhone());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (singleMemberModel.getCode() == com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() && singleMemberModel.getData() != null) {
                vo.setGiveMemberCode(((MemberInfoModel)singleMemberModel.getData()).getMemberCode());
            }
        }
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        List recordList = this.couponRecordPOMapper.getRecordList(vo);
        Long recordListCount = this.couponRecordPOMapper.getRecordListCount(vo);
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            List memberCodes = recordList.stream().filter(po -> StringUtils.isNotEmpty((CharSequence)po.getTransferMember())).map(CouponRecordPO::getTransferMember).collect(Collectors.toList());
            MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
            membersInfoSearchVo.setMemberCodeList(memberCodes);
            membersInfoSearchVo.setSysCompanyId(vo.getSysCompanyId());
            membersInfoSearchVo.setBrandId(vo.getSysBrandId());
            membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
            membersInfoSearchVo.setPageSize(vo.getPageSize());
            ResponseData pageInfoResponseData = this.membersAdvancedSearchApiService.advancedSearch(membersInfoSearchVo);
            Map<Object, Object> memberPhoneMap = new HashMap();
            if (pageInfoResponseData.getCode() == com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)((com.bizvane.utils.responseinfo.PageInfo)pageInfoResponseData.getData()).getList())) {
                memberPhoneMap = ((com.bizvane.utils.responseinfo.PageInfo)pageInfoResponseData.getData()).getList().stream().collect(Collectors.toMap(MembersInfoSearchPojo::getMemberCode, MembersInfoSearchPojo::getPhone, (key1, key2) -> key1));
            }
            HashMap finalMemberPhoneMap = memberPhoneMap;
            recordList.forEach(record -> {
                CouponRecordResponseVO couponRecordVo = new CouponRecordResponseVO();
                BeanUtil.copyProperties((Object)record, (Object)couponRecordVo);
                couponRecordVo.setTransferType(record.getType());
                couponRecordVo.setOperateDate(record.getCreateDate());
                couponRecordVo.setGivePhone((String)finalMemberPhoneMap.get(record.getTransferMember()));
                if (record.getType() == 2) {
                    couponRecordVo.setReceivePhone(record.getMemberPhone());
                }
                couponByTransferVoList.add(couponRecordVo);
            });
        }
        if (CollectionUtils.isNotEmpty(couponByTransferVoList) && this.couponEntityService.getMemberDataDesensitizeByAccountConfig(accountPo.getSysAccountId()).booleanValue()) {
            for (CouponRecordResponseVO couponRecordResponseVO : couponByTransferVoList) {
                couponRecordResponseVO.setReceivePhone(DesensitizeUtil.encrypt((String)couponRecordResponseVO.getReceivePhone()));
                couponRecordResponseVO.setGivePhone(DesensitizeUtil.encrypt((String)couponRecordResponseVO.getGivePhone()));
            }
        }
        PageInfo pageinfo = new PageInfo(couponByTransferVoList);
        pageinfo.setTotal(recordListCount.longValue());
        result.setData((Object)pageinfo);
        return result;
    }

    public List<CouponRecordResponseVO> findCouponRecordListByFromAndTo(CouponRecordRequestVO vo, Long from, Long to) {
        List recordList;
        logger.info("couponServiceImpl findCouponRecordList method!");
        ArrayList<CouponRecordResponseVO> result = new ArrayList<CouponRecordResponseVO>();
        if (StringUtils.isNotEmpty((CharSequence)vo.getGivePhone())) {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setSysCompanyId(vo.getSysCompanyId());
            memberInfoModel.setBrandId(vo.getSysBrandId());
            memberInfoModel.setPhone(vo.getGivePhone());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (singleMemberModel.getCode() == com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() && singleMemberModel.getData() != null) {
                vo.setGiveMemberCode(((MemberInfoModel)singleMemberModel.getData()).getMemberCode());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(recordList = this.couponRecordPOMapper.getRecordListByFromAndTo(vo, from, to)))) {
            List memberCodes = recordList.stream().filter(po -> StringUtils.isNotEmpty((CharSequence)po.getTransferMember())).map(CouponRecordPO::getTransferMember).collect(Collectors.toList());
            MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
            membersInfoSearchVo.setMemberCodeList(memberCodes);
            membersInfoSearchVo.setSysCompanyId(vo.getSysCompanyId());
            membersInfoSearchVo.setBrandId(vo.getSysBrandId());
            membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
            membersInfoSearchVo.setPageSize(Integer.valueOf(recordList.size()));
            ResponseData pageInfoResponseData = this.membersAdvancedSearchApiService.advancedSearch(membersInfoSearchVo);
            Map<Object, Object> memberPhoneMap = new HashMap();
            if (pageInfoResponseData.getCode() == com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)((com.bizvane.utils.responseinfo.PageInfo)pageInfoResponseData.getData()).getList())) {
                memberPhoneMap = ((com.bizvane.utils.responseinfo.PageInfo)pageInfoResponseData.getData()).getList().stream().collect(Collectors.toMap(MembersInfoSearchPojo::getMemberCode, MembersInfoSearchPojo::getPhone, (key1, key2) -> key1));
            }
            HashMap finalMemberPhoneMap = memberPhoneMap;
            recordList.forEach(record -> {
                CouponRecordResponseVO couponRecordVo = new CouponRecordResponseVO();
                BeanUtil.copyProperties((Object)record, (Object)couponRecordVo);
                couponRecordVo.setTransferType(record.getType());
                couponRecordVo.setOperateDate(record.getCreateDate());
                couponRecordVo.setGivePhone((String)finalMemberPhoneMap.get(record.getTransferMember()));
                if (record.getType() == 2) {
                    couponRecordVo.setReceivePhone(record.getMemberPhone());
                }
                result.add(couponRecordVo);
            });
        }
        return result;
    }

    public Boolean checkCouponIfIntegralCoupon(String couponDefinitionId) {
        logger.info("CouponServiceImpl#checkCouponIfIntegralCoupon#couponCode:{}", (Object)couponDefinitionId);
        if (StringUtils.isEmpty((CharSequence)couponDefinitionId)) {
            logger.info("CouponServiceImpl#checkCouponIfIntegralCoupon#\u5238\u5b9a\u4e49id \u4e3a\u7a7a");
            return true;
        }
        Long couponDefinitionIdInteger = Long.valueOf(couponDefinitionId);
        List couponDefinitionPOS = this.couponDefinitionPOMapper.selectByDefinitionId(couponDefinitionIdInteger);
        if (CollectionUtils.isEmpty((Collection)couponDefinitionPOS)) {
            logger.info("CouponServiceImpl#checkCouponIfIntegralCoupon#couponDefinitionPOS \u4e3a\u7a7a");
            return true;
        }
        if (couponDefinitionPOS.size() > 1) {
            logger.info("CouponServiceImpl#checkCouponIfIntegralCoupon#\u5238\u5b9a\u4e49\u8fc7\u591a couponDefinitionPOS :{}", (Object)JSON.toJSONString((Object)couponDefinitionPOS));
            return true;
        }
        CouponDefinitionPO couponDefinitionPO = (CouponDefinitionPO)couponDefinitionPOS.get(0);
        return this.checkCouponIfTaiDiSingle(couponDefinitionPO);
    }

    public ResponseData<Long> taiDiIntegralCouponUse(CouponIntegralCouponUseAllRequestVO vo) {
        logger.info("CouponServiceImpl#taiDiIntegralCouponUse#vo:{}", (Object)JSON.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        CouponEntityPOExample selectMembersCoupon = new CouponEntityPOExample();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        List<CouponEntityPO> couponEntityPOS = new ArrayList();
        try {
            Date today = format.parse(format.format(new Date()));
            selectMembersCoupon.createCriteria().andValidEqualTo(Boolean.TRUE).andCouponStatusEqualTo(SystemConstants.COUPON_STATUS_UNUSED).andIsUseEqualTo(Boolean.FALSE).andMemberCodeEqualTo(vo.getUseMemberCode());
            couponEntityPOS = this.couponEntityPOMapper.selectByExample(selectMembersCoupon);
            logger.info("CouponServiceImpl#taiDiIntegralCouponUse#couponEntityPOS:{}", (Object)JSON.toJSONString(couponEntityPOS));
            if (CollectionUtils.isEmpty(couponEntityPOS)) {
                return ResponseUtils.getFailedData((String)"\u8be5\u4f1a\u5458\u6ca1\u6709\u53ef\u7528\u5238");
            }
        }
        catch (Exception e) {
            logger.info("CouponServiceImpl#taiDiIntegralCouponUse#\u6821\u9a8c\u5151\u6362\u5238\u65f6\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            return ResponseUtils.getFailedData((String)"\u6821\u9a8c\u5151\u6362\u5238\u65f6\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
        couponEntityPOS.removeIf(checkPO -> this.checkCouponIfIntegralCoupon(checkPO.getCouponDefinitionId()) == false && this.checkCouponTime(checkPO, format) == false);
        logger.info("CouponServiceImpl#taiDiIntegralCouponUse#couponEntityPOS After Valid:{}", (Object)JSON.toJSONString(couponEntityPOS));
        long allIntegral = 0L;
        MemberInfoModel searchMember = new MemberInfoModel();
        searchMember.setMemberCode(vo.getUseMemberCode());
        MemberInfoModel memberInfo = (MemberInfoModel)this.memberInfoApiService.getMemberModelByES(searchMember).getData();
        if (CollectionUtils.isEmpty(couponEntityPOS)) {
            return ResponseUtils.getFailedData((String)"\u8be5\u4f1a\u5458\u6ca1\u6709\u53ef\u7528\u79ef\u5206\u5238");
        }
        for (CouponEntityPO useCoupon : couponEntityPOS) {
            if (useCoupon.getMoney().compareTo(BigDecimal.ZERO) < 1) continue;
            allIntegral += this.useTaiDiIntegralCouponSingle(memberInfo, useCoupon, vo.getBusinessCode()).longValue();
        }
        responseData.setData((Object)allIntegral);
        return responseData;
    }

    public ResponseData<PageInfo<CouponEntityAndDefinitionVO>> getOtherBrandDifindustryCoupon(CouponListByMemberCodeRequestVO vo) {
        ResponseData responseData = this.couponDifindustryService.getOtherBrandDifindustryCoupon(vo);
        return responseData;
    }

    public ResponseData<Boolean> registerSendDifindustryCoupon(CouponListByMemberCodeRequestVO vo) {
        ResponseData responseData = null;
        String memberCode = vo.getMemberCode();
        Long sysBrandId = vo.getSysBrandId();
        Long sysCompanyId = vo.getSysCompanyId();
        StringBuffer stringBufer = new StringBuffer("registerSendDifindustryCoupon:");
        stringBufer.append(sysCompanyId).append(":").append(sysBrandId).append(":").append(memberCode);
        String key = stringBufer.toString();
        stringBufer.append("redisLock");
        RLock lock = this.redissonClient.getLock(stringBufer.toString());
        try {
            boolean b = lock.tryLock();
            if (b) {
                String value = (String)this.redisTemplateService.stringGetStringByKey((Object)key);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    logger.info("enter registerSendDifindustryCoupon consumer method !" + JSONObject.toJSONString((Object)vo));
                    ResponseData responseData2 = ResponseUtils.getFailedData((String)"mq\u5df2\u7ecf\u6d88\u8d39");
                    return responseData2;
                }
                this.redisTemplateService.stringSetValueAndExpireTime((Object)key, (Object)"1", 259200000L);
                logger.info("enter registerSendDifindustryCoupon consumer method  \u5f00\u59cb\u5f02\u6b65\u53d1\u5f02\u4e1a\u5238" + JSONObject.toJSONString((Object)vo));
                responseData = this.couponDifindustryService.registerSendDifindustryCoupon(vo);
            }
        }
        catch (Exception e) {
            logger.info("enter registerSendDifindustryCoupon \u6d88\u8d39\u5f02\u5e38 :{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            this.redisTemplateService.deleteFromRedis((Object)key);
            throw new CouponException("\u6d88\u8d39\u5f02\u5e38");
        }
        finally {
            lock.unlock();
        }
        return responseData;
    }

    public ResponseData<List<CouponDefinitionVO>> getSurplusQuantityByList(List<CouponDefinitionVO> list) {
        ResponseData responseData = this.couponDifindustryQuantityRecordService.getSurplusQuantityByList(list);
        return responseData;
    }

    public ResponseData<CouponDefinitionPO> findBycouponDifindustrySendDetailId(Long couponDifindustrySendDetailId) {
        ResponseData responseData = this.couponDifindustryService.findBycouponDifindustrySendDetailId(couponDifindustrySendDetailId);
        return responseData;
    }

    public ResponseData<CouponDetailResponseVO> findCouponByDifindustrySendDetailId(Long couponDifindustrySendDetailId) {
        ResponseData responseData = this.couponDifindustryService.findCouponByDifindustrySendDetailId(couponDifindustrySendDetailId);
        return responseData;
    }

    public ResponseData<List<CouponDifindustryVO>> getDifindustryAnalysisByBusinessIdList(CouponDifindustryVO vo) {
        ResponseData responseData = this.couponDifindustryService.getDifindustryAnalysisByBusinessIdList(vo);
        return responseData;
    }

    public ResponseData<PageInfo<CouponSendMemberListResponseVO>> findCouponSendMemberList(CouponSendMemberListRequestVO requestVO) {
        ResponseData responseData = this.couponDifindustryService.findCouponSendMemberList(requestVO);
        return responseData;
    }

    public ResponseData exportCouponRecordList(CouponRecordRequestVO vo, SysAccountPO accountPo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)vo.getGivePhone())) {
                MemberInfoModel memberInfoModel = new MemberInfoModel();
                memberInfoModel.setSysCompanyId(vo.getSysCompanyId());
                memberInfoModel.setBrandId(vo.getSysBrandId());
                memberInfoModel.setPhone(vo.getGivePhone());
                ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                if (singleMemberModel.getCode() == com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() && singleMemberModel.getData() != null) {
                    vo.setGiveMemberCode(((MemberInfoModel)singleMemberModel.getData()).getMemberCode());
                }
            }
            Long count = this.couponRecordPOMapper.getRecordListCount(vo);
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = new FileTaskPo();
            fileTaskPo.setTaskId(taskId);
            fileTaskPo.setFileId(String.valueOf(taskId));
            fileTaskPo.setTaskTypeCode(count + "\u6761");
            fileTaskPo.setTaskName("\u5bfc\u51fa\u4f18\u60e0\u5238\u8f6c\u8d60\u6d41\u6c34");
            if (accountPo != null) {
                fileTaskPo.setSysBrandId(accountPo.getBrandId());
                fileTaskPo.setCreateUserId(accountPo.getSysAccountId());
                fileTaskPo.setCreateUserName(accountPo.getName());
            }
            fileTaskPo.setCreateDate(new Date());
            fileTaskPo.setFileStatus(Long.valueOf(0L));
            fileTaskPo.setFileType("EXPORT");
            fileTaskPo.setValid(Boolean.valueOf(true));
            this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(count);
            Boolean isDesensitize = this.couponEntityService.getMemberDataDesensitizeByAccountConfig(accountPo.getSysAccountId());
            new Thread(() -> {
                try {
                    exportExcelUtil.setExportProcessId((Object)taskId);
                    Method method = ReflectionUtils.findMethod(this.getClass(), (String)"findCouponRecordListByFromAndTo", (Class[])new Class[]{CouponRecordRequestVO.class, Long.class, Long.class});
                    exportExcelUtil.read("couponServiceImpl", method, (model, row) -> {
                        if (isDesensitize.booleanValue() && null != model) {
                            model.setGivePhone(DesensitizeUtil.encrypt((String)model.getGivePhone()));
                            model.setReceivePhone(DesensitizeUtil.encrypt((String)model.getReceivePhone()));
                        }
                        if (row.getRowNum() == 0) {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue("\u5238\u5b9a\u4e49ID");
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue("\u5238\u540d\u79f0");
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue("\u5238\u53f7");
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue("\u8f6c\u8d60\u4eba\u624b\u673a\u53f7");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue("\u8f6c\u8d60\u5238\u72b6\u6001");
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue("\u53d7\u8d60\u4eba\u624b\u673a\u53f7");
                            Cell cell6 = row.createCell(6);
                            cell6.setCellValue("\u64cd\u4f5c\u65f6\u95f4");
                        } else {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue(null != model.getCouponDefinitionId() ? (double)model.getCouponDefinitionId().longValue() : 0.0);
                            Cell cell1 = row.createCell(1);
                            if (StringUtils.isBlank((CharSequence)model.getCouponName())) {
                                model.setCouponName("");
                            }
                            cell1.setCellValue(model.getCouponName());
                            Cell cell2 = row.createCell(2);
                            if (StringUtils.isBlank((CharSequence)model.getCouponCode())) {
                                model.setCouponCode("");
                            }
                            cell2.setCellValue(model.getCouponCode());
                            Cell cell3 = row.createCell(3);
                            if (StringUtils.isBlank((CharSequence)model.getGivePhone())) {
                                model.setCouponCode("");
                            }
                            cell3.setCellValue(model.getGivePhone());
                            Cell cell4 = row.createCell(4);
                            if (null == model.getTransferType()) {
                                model.setCouponCode("");
                            } else if (model.getTransferType().equals(1)) {
                                model.setCouponCode("\u8f6c\u589e\u4e2d");
                            } else if (model.getTransferType().equals(2)) {
                                model.setCouponCode("\u8f6c\u8d60\u5b8c\u6210");
                            } else if (model.getTransferType().equals(3)) {
                                model.setCouponCode("\u8f6c\u8d60\u64a4\u56de");
                            }
                            cell4.setCellValue(model.getCouponCode());
                            Cell cell5 = row.createCell(5);
                            if (StringUtils.isBlank((CharSequence)model.getReceivePhone())) {
                                model.setCouponCode("");
                            }
                            cell5.setCellValue(model.getReceivePhone());
                            Cell cell6 = row.createCell(6);
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            String operateDate = "";
                            if (null != model.getOperateDate()) {
                                operateDate = dateFormat.format(model.getOperateDate());
                            }
                            cell6.setCellValue(operateDate);
                        }
                    }, new Object[]{vo});
                }
                catch (Exception e) {
                    logger.info("CouponServiceImpl#exportCouponRecordList#264#Exception e:{},:{}", (Object)e.getMessage(), (Object)e);
                }
            }).start();
            new Thread(() -> {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)("\u4f18\u60e0\u5238\u8f6c\u8d60\u6d41\u6c34\u5bfc\u51fa_" + format.format(new Date())));
            }).start();
        }
        catch (Exception e) {
            logger.info("CouponServiceImpl#exportCouponRecordList#275#Exception e:{},:{}", (Object)e.getMessage(), (Object)e);
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData<Long> couponSynchronization(CouponOfflineCreateResponseVO vo) {
        logger.info("CouponServiceImpl#couponSynchronization#vo:{}", (Object)JSON.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)vo.getBrandCode())) {
            logger.info("enter couponSynchronization consumer method ! brandCode is null!" + JSONObject.toJSONString((Object)vo));
            return ResponseUtils.getFailedData((String)"\u54c1\u724c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)vo.getCouponCode())) {
            logger.info("enter couponSynchronization consumer method ! couponCode is null!" + JSONObject.toJSONString((Object)vo));
            return ResponseUtils.getFailedData((String)"\u5238\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)vo.getCouponDefinitioncode())) {
            logger.info("enter couponSynchronization consumer method ! couponDefinitionCode is null!" + JSONObject.toJSONString((Object)vo));
            return ResponseUtils.getFailedData((String)"\u5238\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyCacheDto companyCache = this.iRedisCacheService.getCompanyCache(vo.getCompanyCode());
        if (companyCache == null) {
            logger.info("\u4f01\u4e1a\u7f16\u53f7\u4e0d\u5b58\u5728");
            throw new BizException(-1, "\u4f01\u4e1a\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        SysBrandPo brandPo = new SysBrandPo();
        brandPo.setBrandCode(vo.getBrandCode());
        brandPo.setSysCompanyId(companyCache.getCompanyId());
        ResponseData brandResult = this.brandServiceRpc.getBrandIdByCode(brandPo);
        Long brandId = (Long)brandResult.getData();
        if (brandId == null) {
            logger.info("\u54c1\u724c\u7f16\u53f7\u4e0d\u5b58\u5728");
            throw new BizException(-1, "\u54c1\u724c\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        CouponDefinitionPOExample example = new CouponDefinitionPOExample();
        example.createCriteria().andErpCouponDefinitionCodeEqualTo(vo.getCouponDefinitioncode()).andCouponDefinitionTypeEqualTo(Byte.valueOf((byte)2)).andSysBrandIdEqualTo(brandId).andStatusEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List couponDefinitionList = this.couponDefinitionPOMapper.selectByExample(example);
        CouponOfflineCreateResponseVO couponOfflineCreateResponseVO = new CouponOfflineCreateResponseVO();
        CouponDefinitionPO definitionPO = new CouponDefinitionPO();
        if (CollectionUtils.isEmpty((Collection)couponDefinitionList)) {
            logger.warn("enter couponSynchronization consumer method ! definitionList is null!" + vo.getCouponDefinitioncode());
            return ResponseUtils.getFailedData((String)"\u5238\u5b9a\u4e49\u4e0d\u5b58\u5728");
        }
        definitionPO = (CouponDefinitionPO)couponDefinitionList.get(0);
        couponOfflineCreateResponseVO.setBrandCode(vo.getBrandCode());
        couponOfflineCreateResponseVO.setCouponCode(vo.getCouponCode());
        couponOfflineCreateResponseVO.setCompanyCode(vo.getCompanyCode());
        couponOfflineCreateResponseVO.setCouponDefinitioncode(vo.getCouponDefinitioncode());
        couponOfflineCreateResponseVO.setUsePassWord(vo.getUsePassWord());
        couponOfflineCreateResponseVO.setCouponStartDate(vo.getCouponStartDate());
        couponOfflineCreateResponseVO.setCouponEndDate(vo.getCouponEndDate());
        couponOfflineCreateResponseVO.setOfflineUpdateDate(vo.getOfflineUpdateDate());
        CouponDefinitionCodePOExample couponExample = new CouponDefinitionCodePOExample();
        CouponDefinitionCodePOExample.Criteria criteria = couponExample.createCriteria();
        criteria.andCouponCodeEqualTo(couponOfflineCreateResponseVO.getCouponCode());
        List couponDefinitionCodePOList = this.couponDefinitionCodePOMapper.selectByExample(couponExample);
        if (CollectionUtils.isNotEmpty((Collection)couponDefinitionCodePOList)) {
            logger.warn("couponSynchronization selectByExample error ! " + couponOfflineCreateResponseVO.getCouponCode() + " already exists!");
            return ResponseUtils.getFailedData((String)"\u5238\u53f7\u5df2\u5b58\u5728");
        }
        SendResult send = this.rocketMQTemplate.send(Destination.builder().topic("COUPON_OFFLINE_CREATE").build(), (Object)JSONObject.toJSONString((Object)couponOfflineCreateResponseVO));
        logger.info("CouponServiceImpl couponSynchronization wmmq sendResult param:{}", (Object)send.toString());
        return responseData;
    }

    private Boolean checkCouponTime(CouponEntityPO checkPO, SimpleDateFormat format) {
        try {
            Date startDate = format.parse(format.format(checkPO.getValidDateStart()));
            Date today = format.parse(format.format(new Date()));
            Date endDate = format.parse(format.format(checkPO.getValidDateEnd()));
            if (today.getTime() >= startDate.getTime() && today.getTime() <= endDate.getTime()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (Exception e) {
            logger.info("CouponServiceImpl#checkCouponTime  date format error");
            return Boolean.FALSE;
        }
    }

    private Long useTaiDiIntegralCouponSingle(MemberInfoModel memberInfo, CouponEntityPO useCoupon, String useBusinessCode) {
        logger.info("CouponServiceImpl#useTaiDiIntegralCouponSingle#memberInfo:{},useCoupon:{}", (Object)JSON.toJSONString((Object)memberInfo), (Object)JSON.toJSONString((Object)useCoupon));
        long singleResult = this.doIntegralChangeResponseModel(useCoupon, memberInfo);
        if (singleResult == 0L) {
            return 0L;
        }
        CouponEntityPO usedUpdateCoupon = new CouponEntityPO();
        usedUpdateCoupon.setCouponEntityId(useCoupon.getCouponEntityId());
        usedUpdateCoupon.setUseBusinessCode(useBusinessCode);
        usedUpdateCoupon.setUseType(SystemConstants.COUPON_USE_TYPE_TAIDI);
        usedUpdateCoupon.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        usedUpdateCoupon.setUseTime(TimeUtils.getNowTime());
        usedUpdateCoupon.setModifiedDate(TimeUtils.getNowTime());
        usedUpdateCoupon.setIsUse(SystemConstants.COUPON_DEFINITION_STATUS_USE);
        usedUpdateCoupon.setUseFrom(SystemConstants.COUPON_USE_FROM_TAIDI);
        logger.info("enter semd getTransferSend" + usedUpdateCoupon.getCouponCode() + JSONObject.toJSONString((Object)usedUpdateCoupon));
        this.couponEntityPOMapper.updateByPrimaryKeySelective(usedUpdateCoupon);
        return singleResult;
    }

    private Long doIntegralChangeResponseModel(CouponEntityPO useCoupon, MemberInfoModel meberDetail) {
        IntegralChangeRequestModel integralRecordModel = new IntegralChangeRequestModel();
        IntegralChangeResponseModel integralChangeResponseModel = null;
        integralRecordModel.setSysCompanyId(meberDetail.getSysCompanyId());
        integralRecordModel.setBrandId(meberDetail.getBrandId());
        integralRecordModel.setMemberCode(meberDetail.getMemberCode());
        integralRecordModel.setBusinessType(BusinessTypeEnum.TAIDI_INTEGRALCOUPON_ADDPOINTS.getCode());
        integralRecordModel.setChangeType(IntegralChangeTypeEnum.INCOME.getCode());
        integralRecordModel.setChangeBills(useCoupon.getCouponCode());
        integralRecordModel.setChangeIntegral(Integer.valueOf(useCoupon.getMoney().intValue()));
        try {
            integralChangeResponseModel = this.integralChangeApiService.integralChangeOperate(integralRecordModel);
            logger.info("doIntegralChangeResponseModel----\u79ef\u5206----\u53c2\u6570--" + JSON.toJSONString((Object)integralRecordModel) + "----\u51fa\u53c2--" + JSON.toJSONString((Object)integralChangeResponseModel));
        }
        catch (Exception e) {
            logger.error("doIntegralChangeResponseModel\u5f02\u5e38:{}", (Object)JSON.toJSONString((Object)integralRecordModel), (Object)e);
            return 0L;
        }
        return useCoupon.getMoney().longValue();
    }

    private Boolean checkCouponIfTaiDiSingle(CouponDefinitionPO couponDefinitionPO) {
        return SystemConstants.PREFERENTIAL_TYPE_TAIDI_INTEGRAL.equals(couponDefinitionPO.getPreferentialType()) && SystemConstants.USE_CHANNEL_INTEGRAL.equals(couponDefinitionPO.getUseChannel());
    }

    private String getSerialNumber() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String nowTime = df.format(now);
        return "COUPON" + nowTime + UUIDUtil.getUUID();
    }

    public ResponseData<Long> findCountByMemberCodeAndStatus(Long sysBrandId, String memberCode, Byte couponStatus) {
        CouponEntityPOExample couponEntityPOExample = new CouponEntityPOExample();
        couponEntityPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andMemberCodeEqualTo(memberCode).andCouponStatusEqualTo(couponStatus).andValidEqualTo(Boolean.TRUE);
        long count = this.couponEntityPOMapper.countByExample(couponEntityPOExample);
        return new ResponseData((Object)count);
    }

    public ResponseData<String> onlineUse361(@RequestBody OnlineCouponUseEvent.OnlineCouponUseVO msgVO) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)msgVO.getCouponCode())) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponEntityPO couponEntity = this.couponEntityService.findCouponEntityByCouponCode(msgVO.getCouponCode(), msgVO.getSysCompanyId());
        if (couponEntity == null) {
            logger.info("\u6838\u9500\u5931\u8d25\uff0c\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_HAVE.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_CODE_NOT_HAVE.getMessage());
            return responseData;
        }
        if (couponEntity.getIsUse().booleanValue()) {
            logger.info("\u6838\u9500\u5931\u8d25\uff0c\u4f18\u60e0\u5238\u5df2\u7ecf\u6838\u9500");
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_USED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_USED.getMessage());
            return responseData;
        }
        CouponDefinitionPOWithBLOBs couponDefinitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(couponEntity.getCouponDefinitionId())));
        Date now = new Date();
        couponEntity.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        couponEntity.setIsUse(SystemConstants.COUPON_USE_USED);
        couponEntity.setUseStoreId(msgVO.getOfflineUseStoreId());
        couponEntity.setUseBusinessCode(msgVO.getUseBusinessCode());
        couponEntity.setUseBusinessAmount(msgVO.getUseBusinessAmount());
        couponEntity.setUseTime(msgVO.getUseTime() == null ? now : msgVO.getUseTime());
        couponEntity.setModifiedDate(now);
        couponEntity.setUseSourceCode(msgVO.getUseSourceCode());
        logger.info("\u6838\u9500\u5f00\u59cb:{}", (Object)JacksonUtil.bean2Json((Object)couponEntity));
        if (this.couponEntityService.updateCouponEntitySelective(couponEntity)) {
            logger.info("\u6838\u9500\u6210\u529f");
            try {
                if (this.wmCompanyId.equals(msgVO.getSysCompanyId()) && couponDefinitionPO != null && SystemConstants.USE_CHANNEL_ANY.equals(couponDefinitionPO.getUseChannel())) {
                    logger.info("361CouponUseConsumer useCoupon mq send param:{}", (Object)JSONObject.toJSONString((Object)couponEntity));
                    SendResult send = this.rocketMQTemplate.send(Destination.builder().topic("wm_topic_use_channel_coupon").build(), (Object)JSONObject.toJSONString((Object)couponEntity));
                    logger.info("361CouponUseConsumer useCoupon mq sendResult param:{}", (Object)send.toString());
                }
            }
            catch (Exception e) {
                logger.error("361CouponUseConsumer useCoupon send mq\uff0cerror:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        } else {
            responseData.setCode(-1);
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        }
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<PageInfo<CouponEntityAndDefinitionVO>> pageListByMemberCode(CouponListByMemberCodeRequestVO vo) {
        logger.info("[CouponServiceImpl-pageListByMemberCode-info-],request:{}", (Object)JSONObject.toJSONString((Object)vo));
        PageFormUtil pageFormUtil = new PageFormUtil();
        if (vo.getPageNumber() == null || vo.getPageSize() == null) {
            vo.setPageNumber(Integer.valueOf(1));
            vo.setPageSize(Integer.valueOf(20));
        }
        pageFormUtil.setPageNumber(vo.getPageNumber());
        pageFormUtil.setPageSize(vo.getPageSize());
        ResponseData result = new ResponseData();
        PageHelper.startPage((int)pageFormUtil.getPageNumber(), (int)pageFormUtil.getPageSize());
        if (StringUtils.isBlank((CharSequence)vo.getMemberCode())) {
            result.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            result.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_MEMBER_CODE_NOT_NULL.getMessage());
            return result;
        }
        if (null == vo.getCouponStatus()) {
            result.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            result.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_STATUS_NOT_NULL.getMessage());
            return result;
        }
        ArrayList list = this.couponEntityPOMapper.getCouponListByMemeberCode(vo);
        if (null == list) {
            list = new ArrayList();
        }
        list.stream().forEach(entity -> {
            int days = Period.between(LocalDate.now(), entity.getValidDateEnd().toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).getDays();
            entity.setRemainExpireDays(Integer.valueOf(days));
        });
        PageInfo pageInfo = new PageInfo(list);
        result.setData((Object)pageInfo);
        logger.info("[CouponServiceImpl-pageListByMemberCode-info-],result:{}", (Object)JSONObject.toJSONString((Object)result));
        return result;
    }

    public ResponseData<Boolean> exchangePreCoupon(String couponCode, String memberCode) {
        logger.info("enter CouponServiceImpl exchangePreCoupon method:{},{}", (Object)couponCode, (Object)memberCode);
        MemberInfoModel memberInfoModelParam = new MemberInfoModel();
        memberInfoModelParam.setMemberCode(memberCode);
        MemberInfoModel member = (MemberInfoModel)this.memberInfoApiService.getMemberModel(memberInfoModelParam).getData();
        CouponEntityPO po = this.findCouponEntityByCompanyId(couponCode, member.getSysCompanyId());
        if (null == po || Boolean.FALSE.equals(po.getValid())) {
            return new ResponseData(-1, "\u8f93\u5165\u5361\u5238\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (!StringUtils.isBlank((CharSequence)po.getMemberCode()) && !"1".equals(po.getMemberCode())) {
            return new ResponseData(-1, "\u8f93\u5165\u5361\u5238\u7f16\u53f7\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5151\u6362\u6216\u4f7f\u7528");
        }
        if (!SystemConstants.COUPON_STATUS_UNUSED.equals(po.getCouponStatus())) {
            return new ResponseData(-1, "\u8f93\u5165\u5361\u5238\u7f16\u53f7\u5df2\u8fc7\u671f");
        }
        CouponGiveRequestVO giveRequestVO = new CouponGiveRequestVO();
        giveRequestVO.setBrandId(member.getBrandId());
        giveRequestVO.setCouponCode(couponCode);
        giveRequestVO.setFromMemberCode("");
        giveRequestVO.setToMemberCode(member.getOfflineCardNo());
        Result offLineResult = this.connectorServiceFeign.givecoupon(giveRequestVO);
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != offLineResult.getCode().intValue()) {
            logger.error("\u540c\u6b65\u7ebf\u4e0b\u5931\u8d25:{}", (Object)JacksonUtil.bean2Json((Object)offLineResult));
            return new ResponseData(-1, "\u540c\u6b65\u7ebf\u4e0b\u5931\u8d25");
        }
        CouponEntityPO record = new CouponEntityPO();
        record.setCouponEntityId(po.getCouponEntityId());
        record.setMemberCode(memberCode);
        record.setModifiedDate(TimeUtils.getNowTime());
        record.setModifiedUserName("\u7528\u6237\u5151\u6362");
        this.couponEntityPOMapper.updateByPrimaryKeySelective(record);
        CouponStatusLogPO couponStatusLogPO = new CouponStatusLogPO();
        couponStatusLogPO.setSysCompanyId(member.getSysCompanyId());
        couponStatusLogPO.setSysBrandId(member.getBrandId());
        couponStatusLogPO.setCouponEntityId(po.getCouponEntityId());
        couponStatusLogPO.setCouponCode(couponCode);
        couponStatusLogPO.setBusinessType(SystemConstants.COUPON_STATUS_CHANGE_BUSINESS_TYPE_EXCHANGE);
        couponStatusLogPO.setBusinessTime(TimeUtils.getNowTime());
        couponStatusLogPO.setCreateDate(TimeUtils.getNowTime());
        this.couponStatusLogPOMapper.insertSelective(couponStatusLogPO);
        return new ResponseData();
    }
}

