/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponSendFailLogPO;
import com.bizvane.couponfacade.models.po.CouponSendFailLogPOExample;
import com.bizvane.couponfacade.utils.TimeUtils;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.mappers.CouponSendFailLogPOMapper;
import com.bizvane.couponservice.service.CouponSendFailLogService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponSendFailLogServiceImpl
implements CouponSendFailLogService {
    @Autowired
    private CouponSendFailLogPOMapper couponSendFailLogPoMapper;

    public void saveCouponSendFailLog(CouponDefinitionPO definitionPo, CouponEntityPO entityPo, String failDetail) {
        CouponSendFailLogPO failPo = new CouponSendFailLogPO();
        failPo.setSysBrandId(entityPo.getSysBrandId());
        failPo.setSysCompanyId(entityPo.getSysCompanyId());
        failPo.setBrandCode(entityPo.getBrandCode());
        failPo.setCouponDefinitionId(Long.valueOf(Long.parseLong(entityPo.getCouponDefinitionId())));
        failPo.setCouponEntityId(entityPo.getCouponEntityId());
        failPo.setCouponCode(entityPo.getCouponCode());
        failPo.setMemberCode(entityPo.getMemberCode());
        failPo.setCouponName(definitionPo.getCouponName());
        failPo.setMoney(entityPo.getMoney());
        failPo.setDiscount(entityPo.getDiscount());
        failPo.setImg(entityPo.getImg());
        failPo.setCouponType(definitionPo.getCouponDefinitionType() + "");
        failPo.setBizType(entityPo.getSendType());
        failPo.setBizCode(entityPo.getSendBusinessId() + "");
        failPo.setFailReason("1");
        failPo.setFailTimes(Integer.valueOf(0));
        failPo.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        failPo.setSendStatus(SystemConstants.COUPON_SEND_NO);
        failPo.setCreateDate(TimeUtils.getNowTime());
        failPo.setBusinessName(entityPo.getBusinessName());
        failPo.setFailDetail(failDetail);
        String success = "0";
        if (StringUtils.isBlank((CharSequence)entityPo.getCouponCode()) || success.equals(entityPo.getCouponCode()) || entityPo.getCouponCode().startsWith("false::")) {
            failPo.setFailReason("3");
        }
        this.couponSendFailLogPoMapper.insertSelective(failPo);
    }

    public void updateSendStatus(Byte sendStatus, String couponCode, String failDetail) {
        CouponSendFailLogPO failLogPo = new CouponSendFailLogPO();
        failLogPo.setSendStatus(sendStatus);
        failLogPo.setFailDetail(failDetail);
        CouponSendFailLogPOExample example = new CouponSendFailLogPOExample();
        example.createCriteria().andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andCouponCodeEqualTo(couponCode);
        this.couponSendFailLogPoMapper.updateByExampleSelective(failLogPo, example);
    }

    public void updateSendStatus(Byte sendStatus, Long couponEntityId, String failDetail) {
        CouponSendFailLogPO failLogPo = new CouponSendFailLogPO();
        failLogPo.setSendStatus(sendStatus);
        failLogPo.setFailDetail(failDetail);
        CouponSendFailLogPOExample example = new CouponSendFailLogPOExample();
        example.createCriteria().andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andCouponEntityIdEqualTo(couponEntityId);
        this.couponSendFailLogPoMapper.updateByExampleSelective(failLogPo, example);
    }

    public void updateSendStatusAndSendTimes(Byte sendStatus, Date sendDate, Long couponSendFailLogId) {
        this.couponSendFailLogPoMapper.updateSendStatusAndSendTimes(sendStatus, sendDate, couponSendFailLogId);
    }
}

