/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.bo.StaffSelectAddBO;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCacheServiceRpc;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponQuotaDetailPO;
import com.bizvane.couponfacade.models.po.CouponQuotaDetailPOExample;
import com.bizvane.couponfacade.models.po.CouponQuotaPO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDetailVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaVO;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponfacade.utils.TimeUtils;
import com.bizvane.couponservice.common.utils.ExportExcelUtil;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.common.utils.ResponseUtil;
import com.bizvane.couponservice.common.utils.StreamingExportExcelUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponQuotaDetailPOMapper;
import com.bizvane.couponservice.mappers.CouponQuotaPOMapper;
import com.bizvane.couponservice.rpc.CenterStageStaffRpc;
import com.bizvane.couponservice.service.CouponQuotaService;
import com.bizvane.couponservice.service.StreamingCallBack;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponQuotaServiceImpl
implements CouponQuotaService {
    private static Logger logger = LoggerFactory.getLogger(CouponQuotaServiceImpl.class);
    @Autowired
    private CouponQuotaDetailPOMapper couponQuotaDetailPoMapper;
    @Autowired
    private CouponQuotaPOMapper couponQuotaPoMapper;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPoMapper;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private SysCacheServiceRpc sysCacheServiceRpc;
    @Autowired
    private CenterStageStaffRpc centerStageStaffRpc;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;

    public ResponseData<String> updateBycouponQuotaId(CouponQuotaVO vo, SysAccountPo accountPo) {
        ResponseData responseData = new ResponseData();
        vo.setModifiedDate(new Date());
        this.couponQuotaPoMapper.updateByPrimaryKeySelective((CouponQuotaPO)vo);
        CouponQuotaDetailPO failLogPo = new CouponQuotaDetailPO();
        failLogPo.setValid(vo.getState());
        failLogPo.setModifiedDate(new Date());
        CouponQuotaDetailPOExample example = new CouponQuotaDetailPOExample();
        example.createCriteria().andCouponQuotaIdEqualTo(vo.getCouponQuotaId());
        int responseDatalong = this.couponQuotaDetailPoMapper.updateByExampleSelective(failLogPo, example);
        responseData.setData((Object)String.valueOf(responseDatalong));
        return responseData;
    }

    public ResponseData<Long> add(CouponQuotaVO vo, SysAccountPo accountPo) {
        logger.info("enter CouponQuotaServiceImpl add method" + JSONObject.toJSONString((Object)vo));
        this.dealGuide(vo);
        ArrayList<Object> staffCodeList = new ArrayList<Object>();
        if (vo.getSysStaffIds() != null) {
            for (Long staffId : vo.getSysStaffIds()) {
                ResponseData StaffCodeVo = this.staffServiceRpc.getStaffById(staffId);
                if (StaffCodeVo.getData() != null) {
                    staffCodeList.add(StaffCodeVo.getData());
                    continue;
                }
                logger.info("\u6839\u636eid\u6ca1\u6709\u67e5\u5230\u5bfc\u8d2d,staffId : " + staffId);
            }
        }
        vo.setStaffCodeList(staffCodeList);
        ResponseData responseData = new ResponseData();
        vo.setSysCompanyId(accountPo.getSysCompanyId());
        vo.setSysBrandId(accountPo.getBrandId());
        vo.setCreateUserId(accountPo.getSysAccountId());
        vo.setCreateUserName(accountPo.getName());
        vo.setCreateDate(TimeUtils.getNowTime());
        vo.setState(Boolean.valueOf(true));
        vo.setValid(Boolean.valueOf(true));
        vo.setQuotaType(Integer.valueOf(0));
        vo.setMemberCount(Integer.valueOf(vo.getStaffCodeList().size()));
        vo.setTotalNumber(Integer.valueOf(vo.getMemberCount() * vo.getMemberAverage() * vo.getCouponQuotaPOList().size()));
        vo.setSelectType(Integer.valueOf(vo.getCouponQuotaPOList().size() == 1 ? 1 : 2));
        if (vo.getGetCouponSwitch() == null) {
            vo.setGetCouponSwitch(Boolean.valueOf(true));
        }
        if (Boolean.FALSE.equals(vo.getGetCouponSwitch())) {
            vo.setGetCouponDayCount(null);
            if (vo.getCouponQuotaId() != null) {
                this.couponQuotaPoMapper.updateCouponDayCountNullById(vo.getCouponQuotaId());
            }
        }
        String couponQuotaId = null;
        if (vo.getCouponQuotaId() == null) {
            this.couponQuotaPoMapper.insertSelective((CouponQuotaPO)vo);
        } else {
            couponQuotaId = "notNull";
            this.couponQuotaPoMapper.updateByPrimaryKeySelective((CouponQuotaPO)vo);
        }
        List couponQuotaPOList = vo.getCouponQuotaPOList();
        for (CouponQuotaPO po : couponQuotaPOList) {
            CouponDefinitionPOWithBLOBs couponDefinitionPoWithBlobs = this.couponDefinitionPoMapper.selectByPrimaryKey(po.getCouponDefinitionId());
            logger.info("\u5238\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)couponDefinitionPoWithBlobs));
            vo.setCouponName(vo.getCouponName() == null ? couponDefinitionPoWithBlobs.getCouponName() : vo.getCouponName() + "\u3001" + couponDefinitionPoWithBlobs.getCouponName());
            HashMap<String, Integer> zhangshuMap = new HashMap<String, Integer>();
            if (couponQuotaId != null) {
                CouponQuotaDetailPOExample examplefind = new CouponQuotaDetailPOExample();
                examplefind.createCriteria().andCouponQuotaIdEqualTo(vo.getCouponQuotaId()).andCouponDefinitionIdEqualTo(po.getCouponDefinitionId());
                List selectByExamplelist = this.couponQuotaDetailPoMapper.selectByExample(examplefind);
                for (CouponQuotaDetailPO selectByExample : selectByExamplelist) {
                    Integer totalNumber = selectByExample.getTotalNumber();
                    Integer unuseNumber = selectByExample.getUnuseNumber();
                    Integer useNumber = totalNumber - unuseNumber;
                    zhangshuMap.put(selectByExample.getStaffCode(), useNumber);
                }
                CouponQuotaDetailPOExample example = new CouponQuotaDetailPOExample();
                example.createCriteria().andCouponQuotaIdEqualTo(vo.getCouponQuotaId()).andCouponDefinitionIdEqualTo(po.getCouponDefinitionId());
                this.couponQuotaDetailPoMapper.deleteByExample(example);
            }
            CouponQuotaDetailPO couponQuotaDetailPo = new CouponQuotaDetailPO();
            couponQuotaDetailPo.setSysCompanyId(accountPo.getSysCompanyId());
            couponQuotaDetailPo.setSysBrandId(accountPo.getBrandId());
            couponQuotaDetailPo.setCreateUserId(accountPo.getSysAccountId());
            couponQuotaDetailPo.setCreateUserName(accountPo.getName());
            couponQuotaDetailPo.setCreateDate(TimeUtils.getNowTime());
            couponQuotaDetailPo.setCouponQuotaId(vo.getCouponQuotaId());
            couponQuotaDetailPo.setQuotaTopic(vo.getQuotaTopic());
            couponQuotaDetailPo.setTotalNumber(vo.getMemberAverage());
            couponQuotaDetailPo.setUnuseNumber(vo.getMemberAverage());
            couponQuotaDetailPo.setCouponDefinitionCode(couponDefinitionPoWithBlobs.getCouponDefinitionCode());
            couponQuotaDetailPo.setCouponDefinitionId(po.getCouponDefinitionId());
            couponQuotaDetailPo.setPreferentialType(couponDefinitionPoWithBlobs.getPreferentialType());
            couponQuotaDetailPo.setCouponName(couponDefinitionPoWithBlobs.getCouponName());
            couponQuotaDetailPo.setMoney(couponDefinitionPoWithBlobs.getMoney());
            couponQuotaDetailPo.setDiscount(couponDefinitionPoWithBlobs.getDiscount());
            couponQuotaDetailPo.setStartDateStart(vo.getStartDate());
            couponQuotaDetailPo.setStartDateEnd(vo.getEndDate());
            couponQuotaDetailPo.setValidDateStart(couponDefinitionPoWithBlobs.getValidDateStart());
            couponQuotaDetailPo.setValidDateEnd(couponDefinitionPoWithBlobs.getValidDateEnd());
            couponQuotaDetailPo.setValidType(couponDefinitionPoWithBlobs.getValidType());
            couponQuotaDetailPo.setValidDay(couponDefinitionPoWithBlobs.getValidDay());
            couponQuotaDetailPo.setMinConsume(couponDefinitionPoWithBlobs.getMinConsume());
            couponQuotaDetailPo.setValid(Boolean.valueOf(true));
            String collect = vo.getStaffCodeList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getStaffCode())).map(SysStaffPo::getStaffCode).collect(Collectors.joining(","));
            ResponseData getStoreNamesMap = this.staffServiceRpc.getStoreNamesByStaffCodes(collect, accountPo.getSysCompanyId());
            if (getStoreNamesMap == null) {
                logger.info("staffServiceRpc#getStoreNamesByStaffCodes response is null");
                return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u67e5\u8be2\u5458\u5de5\u6240\u5c5e\u5e97\u94fa\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (getStoreNamesMap.getCode() != SysResponseEnum.SUCCESS.getCode() || getStoreNamesMap.getData() == null) {
                logger.info("staffServiceRpc#getStoreNamesByStaffCodes response:{}", (Object)JSONObject.toJSONString((Object)getStoreNamesMap));
                return new ResponseData(getStoreNamesMap.getCode(), getStoreNamesMap.getMessage());
            }
            if (couponQuotaId == null) {
                for (SysStaffPo staffCode : vo.getStaffCodeList()) {
                    couponQuotaDetailPo.setStaffCode(staffCode.getStaffCode());
                    couponQuotaDetailPo.setStaffName(staffCode.getStaffName());
                    couponQuotaDetailPo.setSysStaffId(staffCode.getSysStaffId());
                    couponQuotaDetailPo.setStoreName((String)((Map)getStoreNamesMap.getData()).get(staffCode.getStaffCode()));
                    this.couponQuotaDetailPoMapper.insertSelective(couponQuotaDetailPo);
                }
                continue;
            }
            for (SysStaffPo staffCode : vo.getStaffCodeList()) {
                couponQuotaDetailPo.setStaffCode(staffCode.getStaffCode());
                couponQuotaDetailPo.setStaffName(staffCode.getStaffName());
                couponQuotaDetailPo.setSysStaffId(staffCode.getSysStaffId());
                couponQuotaDetailPo.setStoreName((String)((Map)getStoreNamesMap.getData()).get(staffCode.getStaffCode()));
                if (zhangshuMap.get(staffCode.getStaffCode()) != null) {
                    Integer zhangshu = vo.getMemberAverage() - (Integer)zhangshuMap.get(staffCode.getStaffCode());
                    if (zhangshu > 0) {
                        couponQuotaDetailPo.setUnuseNumber(zhangshu);
                    } else {
                        couponQuotaDetailPo.setUnuseNumber(Integer.valueOf(0));
                    }
                } else {
                    couponQuotaDetailPo.setUnuseNumber(vo.getMemberAverage());
                }
                this.couponQuotaDetailPoMapper.insertSelective(couponQuotaDetailPo);
            }
        }
        if (couponQuotaId == null) {
            this.couponQuotaPoMapper.updateByPrimaryKeySelective((CouponQuotaPO)vo);
        }
        responseData.setData((Object)1L);
        return responseData;
    }

    public ResponseData<PageInfo<CouponQuotaPO>> getCouponQuotaList(CouponQuotaVO vo, SysAccountPo accountPo, PageFormUtil pageForm) {
        logger.info("enter CouponEntityServiceImpl getList method");
        ResponseData responseData = new ResponseData();
        vo.setSysBrandId(accountPo.getBrandId());
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize(), (boolean)true);
        vo.setQuotaType(Integer.valueOf(0));
        List entityVOList = this.couponQuotaPoMapper.findCouponEntityByConditions(vo);
        PageInfo pageInfo = new PageInfo(entityVOList);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<PageInfo<CouponQuotaDetailPO>> getCouponQuotaListDetail(CouponQuotaDetailVO vo, SysAccountPo accountPo, PageFormUtil pageForm) {
        logger.info("enter CouponEntityServiceImpl getList method");
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize(), (boolean)true);
        vo.setSysBrandId(accountPo.getBrandId());
        List entityVOList = this.listCouponQuotaDetailPO(vo, null, null);
        PageInfo pageInfo = new PageInfo(entityVOList);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public List<CouponQuotaDetailPO> listCouponQuotaDetailPO(CouponQuotaDetailVO vo, Long limit, Long to) {
        List entityVOList = this.couponQuotaDetailPoMapper.findCouponQuotaDetailPoByConditionsall(vo);
        return entityVOList;
    }

    public ResponseData<Boolean> exportCouponQuotaListDetail(CouponQuotaDetailVO vo, SysAccountPo accountPo) {
        logger.info("CouponQuotaServiceImpl-exportCouponQuotaListDetail-info,request:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        vo.setSysBrandId(accountPo.getBrandId());
        PageFormUtil pageFormUtil = new PageFormUtil();
        pageFormUtil.setPageNumber(Integer.valueOf(1));
        pageFormUtil.setPageSize(Integer.valueOf(1));
        ResponseData pageInfoRes = this.getCouponQuotaListDetail(vo, accountPo, pageFormUtil);
        if (pageInfoRes == null || pageInfoRes.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            throw new BizException(SysResponseEnum.FAILED.getCode(), "\u67e5\u8be2\u4f18\u60e0\u5238\u5206\u914d\u660e\u7ec6\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if (pageInfoRes.getData() == null || CollectionUtils.isEmpty((Collection)((PageInfo)pageInfoRes.getData()).getList())) {
            throw new BizException(SysResponseEnum.FAILED.getCode(), "\u67e5\u8be2\u4f18\u60e0\u5238\u5206\u914d\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff0c\u65e0\u4f18\u60e0\u5238\u5206\u914d\u660e\u7ec6\u53ef\u4f9b\u5bfc\u51fa");
        }
        if (((PageInfo)pageInfoRes.getData()).getTotal() > 500000L) {
            throw new BizException(SysResponseEnum.FAILED.getCode(), "\u5bfc\u51fa\u7ed3\u679c\u6761\u6570\u5927\u4e8e500000\uff0c\u8bf7\u6dfb\u52a0\u7b5b\u9009\u6761\u4ef6\u540e\u91cd\u65b0\u5bfc\u51fa");
        }
        try {
            long count = ((PageInfo)pageInfoRes.getData()).getTotal();
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = new FileTaskPo();
            fileTaskPo.setTaskId(taskId);
            fileTaskPo.setFileId(String.valueOf(taskId));
            fileTaskPo.setTaskTypeCode(count + "\u6761");
            fileTaskPo.setTaskName("\u4f18\u60e0\u5238\u5206\u914d\u660e\u7ec6\u5bfc\u51fa");
            if (accountPo != null) {
                fileTaskPo.setSysBrandId(accountPo.getBrandId());
                fileTaskPo.setCreateUserId(accountPo.getSysAccountId());
                fileTaskPo.setCreateUserName(accountPo.getName());
            }
            fileTaskPo.setCreateDate(new Date());
            fileTaskPo.setFileStatus(Long.valueOf(0L));
            fileTaskPo.setFileType("EXPORT");
            fileTaskPo.setValid(Boolean.TRUE);
            this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(count));
            new Thread(() -> {
                try {
                    exportExcelUtil.setExportProcessId((Object)taskId);
                    Method method = this.getClass().getMethod("listCouponQuotaDetailPO", CouponQuotaDetailVO.class, Long.class, Long.class);
                    exportExcelUtil.read("couponQuotaServiceImpl", method, (StreamingCallBack)new /* Unavailable Anonymous Inner Class!! */, new Object[]{vo});
                }
                catch (Exception e) {
                    logger.info("CouponQuotaServiceImpl-exportCouponQuotaListDetail-info, thread exception:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }).start();
            new Thread(() -> {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)("\u4f18\u60e0\u5238\u5206\u914d\u660e\u7ec6" + format.format(new Date())));
            }).start();
        }
        catch (Exception e) {
            logger.info("CouponQuotaServiceImpl-exportCouponQuotaListDetail-info, export exception:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setData((Object)Boolean.TRUE);
        return responseData;
    }

    public ResponseData<String> getCouponQuotaListDetailSelectedStaffKey(CouponQuotaDetailVO vo, SysAccountPo accountPo, PageFormUtil pageForm) {
        logger.info("enter getCouponQuotaListDetailSelectedStaffKey getList method");
        ResponseData responseData = new ResponseData();
        vo.setSysBrandId(accountPo.getBrandId());
        List entityVOList = this.couponQuotaDetailPoMapper.findCouponQuotaDetailPoByConditionsall(vo);
        logger.info("entityVOList: {}", (Object)JacksonUtil.list2Json((List)entityVOList));
        String selectedStaffKey = "";
        if (CollectionUtils.isNotEmpty((Collection)entityVOList)) {
            List sysStaffIdList = entityVOList.stream().map(entity -> entity.getSysStaffId()).collect(Collectors.toList());
            StaffSelectAddBO staffSelectAddBO = new StaffSelectAddBO();
            staffSelectAddBO.setList(sysStaffIdList);
            ResponseData selectedStaffKeyResponseData = this.centerStageStaffRpc.selectAdd(staffSelectAddBO);
            logger.info("selectedStaffKeyResponseData: {}", (Object)JacksonUtil.bean2Json((Object)selectedStaffKeyResponseData));
            selectedStaffKey = (String)selectedStaffKeyResponseData.getData();
            ResponseData confirmData = this.centerStageStaffRpc.confirm(selectedStaffKey);
            logger.info("confirmData: {}", (Object)JacksonUtil.bean2Json((Object)confirmData));
        }
        responseData.setData((Object)selectedStaffKey);
        return responseData;
    }

    public ResponseData<List<CouponQuotaDetailPO>> getCouponQuotaListDetailforupdate(CouponQuotaDetailVO vo, SysAccountPo accountPo) {
        logger.info("enter CouponEntityServiceImpl getList method");
        ResponseData responseData = new ResponseData();
        vo.setSysBrandId(accountPo.getBrandId());
        List entityVOList = this.couponQuotaDetailPoMapper.findCouponQuotaDetailPoByConditionsall(vo);
        responseData.setData((Object)entityVOList);
        return responseData;
    }

    public ResponseData<CouponQuotaVO> getCouponQuotaById(Long couponQuotaId) {
        CouponQuotaPO couponQuotaPO = this.couponQuotaPoMapper.selectByPrimaryKey(couponQuotaId);
        logger.info("couponQuotaPO: {}", (Object)JacksonUtil.bean2Json((Object)couponQuotaPO));
        CouponQuotaVO couponQuotaVO = (CouponQuotaVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)couponQuotaPO), CouponQuotaVO.class);
        ArrayList couponDefinitionIdList = Lists.newArrayList();
        Long couponDefinitionId = couponQuotaPO.getCouponDefinitionId();
        couponDefinitionIdList.add(couponDefinitionId);
        String couponDefinitionIdListStr = couponQuotaPO.getCouponDefinitionIdList();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{couponDefinitionIdListStr})) {
            List collect = Arrays.stream(couponDefinitionIdListStr.split(",")).filter(idStr -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{idStr})).map(idStr -> Long.valueOf(idStr)).collect(Collectors.toList());
            couponDefinitionIdList.addAll(collect);
        }
        CouponDefinitionPOExample couponDefinitionPOExample = new CouponDefinitionPOExample();
        couponDefinitionPOExample.createCriteria().andCouponDefinitionIdIn((List)couponDefinitionIdList);
        List couponDefinitionPOList = this.couponDefinitionPoMapper.selectByExample(couponDefinitionPOExample);
        logger.info("couponDefinitionPOList: {}", (Object)JacksonUtil.list2Json((List)couponDefinitionPOList));
        couponQuotaVO.setCouponDefinitionPOList(couponDefinitionPOList);
        return ResponseUtil.success((Object)couponQuotaVO);
    }

    private void dealGuide(CouponQuotaVO couponQuotaVO) {
        String selectedStaffKey = couponQuotaVO.getSelectedStaffKey();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{selectedStaffKey})) {
            List selectEdIdList = (List)this.sysCacheServiceRpc.getSelectEdIdList(selectedStaffKey).getData();
            logger.info("selectedStaffKey: {}, selectEdIdList: {}", (Object)selectedStaffKey, (Object)JacksonUtil.list2Json((List)selectEdIdList));
            couponQuotaVO.setSysStaffIds(selectEdIdList);
        }
    }
}

