/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.beust.jcommander.internal.Lists;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.OnlineOrgStoreInfoRequestVo;
import com.bizvane.centerstageservice.models.vo.OnlineOrgStoreInfoResponseVo;
import com.bizvane.centerstageservice.models.vo.StaffConditionVo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCacheServiceRpc;
import com.bizvane.centerstageservice.rpc.SysOnlineOrgServcieRpc;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponQuotaSendDetailPO;
import com.bizvane.couponfacade.models.po.CouponQuotaSendDetailPOExample;
import com.bizvane.couponfacade.models.vo.CouponQuotaSendDetailListRequestVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaSendDetailListResponseVO;
import com.bizvane.couponfacade.models.vo.StaffSendCouponCountResponseVO;
import com.bizvane.couponfacade.models.vo.StaffSendCouponListRequestVO;
import com.bizvane.couponfacade.models.vo.StaffSendCouponListResponseVO;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.utils.ExportExcelUtil;
import com.bizvane.couponservice.common.utils.ResponseUtil;
import com.bizvane.couponservice.common.utils.StreamingExportExcelUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.mappers.CouponQuotaSendDetailPOMapper;
import com.bizvane.couponservice.service.CouponQuotaSendDetailService;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.query.CouponMemberPo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.wechatenterprise.service.entity.vo.EsMbrFriendsResponseVO;
import com.bizvane.wechatenterprise.service.entity.vo.EsMbrFriendsVO;
import com.bizvane.wechatenterprise.service.rpc.EsMbrFriendsApiService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class CouponQuotaSendDetailServiceImpl
implements CouponQuotaSendDetailService {
    private static Logger logger = LoggerFactory.getLogger(CouponQuotaSendDetailServiceImpl.class);
    @Autowired
    private CouponQuotaSendDetailPOMapper couponQuotaSendDetailPOMapper;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private SysCacheServiceRpc sysCacheServiceRpc;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    @Autowired
    private SysOnlineOrgServcieRpc sysOnlineOrgServcieRpc;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Autowired
    private EsMbrFriendsApiService esMbrFriendsApiService;

    public ResponseData<PageInfo<CouponQuotaSendDetailListResponseVO>> pageList(CouponQuotaSendDetailListRequestVO reqVO) {
        List staffCodeList;
        logger.info("[CouponQuotaSendDetailPOMapper-pageList-input-]:{}", (Object)JacksonUtil.bean2Json((Object)reqVO));
        ResponseData responseData = new ResponseData();
        String onlineOrgCodes = reqVO.getOnlineOrgCodes();
        Long sysCompanyId = reqVO.getSysCompanyId();
        CouponQuotaSendDetailPOExample example = new CouponQuotaSendDetailPOExample();
        Long sysBrandId = reqVO.getSysBrandId();
        CouponQuotaSendDetailPOExample.Criteria criteria = example.createCriteria().andValidEqualTo(Boolean.TRUE);
        if (reqVO.getSysCompanyId() != null) {
            criteria.andSysCompanyIdEqualTo(sysCompanyId);
        }
        if (reqVO.getSysBrandId() != null) {
            criteria.andSysBrandIdEqualTo(sysBrandId);
        }
        criteria.andCouponChannelSourceEqualTo(Integer.valueOf(1));
        if (StringUtils.isNotBlank((String)reqVO.getCouponName())) {
            criteria.andCouponNameLike("%" + reqVO.getCouponName() + "%");
        }
        if (reqVO.getSendTimeStart() != null) {
            criteria.andCreateDateGreaterThanOrEqualTo(reqVO.getSendTimeStart());
        }
        if (reqVO.getSendTimeEnd() != null) {
            criteria.andCreateDateLessThanOrEqualTo(reqVO.getSendTimeEnd());
        }
        if (null != reqVO.getIsReceived()) {
            if (reqVO.getIsReceived() == 1) {
                criteria.andSendStatusEqualTo(Integer.valueOf(3));
            } else {
                criteria.andSendStatusEqualTo(Integer.valueOf(2));
            }
        }
        List sysStoreOnlineCodeList = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)reqVO.getSelectedStoreKey())) {
            sysStoreOnlineCodeList = this.listStoreCode(reqVO.getSelectedStoreKey(), sysCompanyId);
        }
        if (StringUtils.isNotBlank((String)onlineOrgCodes)) {
            List orgSysStoreOnlineCodeList = this.listSysStoreOnlineCode(onlineOrgCodes, sysCompanyId, sysCompanyId);
            if (CollectionUtils.isNotEmpty((Collection)sysStoreOnlineCodeList)) {
                List interStoreCodeList = sysStoreOnlineCodeList.stream().filter(orgSysStoreOnlineCodeList::contains).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(interStoreCodeList)) {
                    return ResponseUtil.success((Object)new PageInfo(new ArrayList()));
                }
                criteria.andSysStoreOnlineCodeIn(interStoreCodeList);
            } else {
                criteria.andSysStoreOnlineCodeIn(orgSysStoreOnlineCodeList);
            }
        } else if (CollectionUtils.isNotEmpty((Collection)sysStoreOnlineCodeList)) {
            criteria.andSysStoreOnlineCodeIn(sysStoreOnlineCodeList);
        }
        if (StringUtils.isNotBlank((String)reqVO.getSelectedStaffKey()) && CollectionUtils.isNotEmpty((Collection)(staffCodeList = this.listStaffCode(reqVO.getSelectedStaffKey(), sysCompanyId)))) {
            criteria.andStaffCodeIn(staffCodeList);
        }
        example.setOrderByClause("send_time DESC");
        PageHelper.startPage((int)reqVO.getPageNo(), (int)reqVO.getPageSize());
        List poList = this.couponQuotaSendDetailPOMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)poList)) {
            return ResponseUtil.success((Object)new PageInfo(new ArrayList()));
        }
        Map<Object, Object> memberInfoModelMap = new HashMap();
        List memberCodeList = poList.stream().filter(item -> StringUtils.isNotBlank((String)item.getMemberCodeList())).map(CouponQuotaSendDetailPO::getMemberCodeList).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(memberCodeList)) {
            CouponMemberPo couponMemberPo = new CouponMemberPo();
            couponMemberPo.setMemberCodeList(memberCodeList);
            couponMemberPo.setBrandId(reqVO.getSysBrandId());
            logger.info("[CouponQuotaSendDetailServiceImpl-exportList-info-],memberListReq:{}", (Object)JacksonUtil.bean2Json((Object)couponMemberPo));
            ResponseData memberListRes = this.memberInfoApiService.getMemberInfoByCodeList(couponMemberPo);
            logger.info("[CouponQuotaSendDetailServiceImpl-exportList-info-],memberListRes:{}", (Object)JacksonUtil.bean2Json((Object)memberListRes));
            if (memberListRes != null && memberListRes.getCode() == SysResponseEnum.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)memberListRes.getData()))) {
                memberInfoModelMap = ((List)memberListRes.getData()).stream().collect(Collectors.toMap(MemberInfoModel::getMemberCode, Function.identity(), (o1, o2) -> o1));
            }
        }
        List couponCodeList = poList.stream().map(CouponQuotaSendDetailPO::getCouponCode).collect(Collectors.toList());
        List couponEntityPOList = this.couponEntityPOMapper.findByCouponCodeList(couponCodeList);
        Map<Object, Object> couponPOMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)couponEntityPOList)) {
            couponPOMap = couponEntityPOList.stream().collect(Collectors.toMap(CouponEntityPO::getCouponCode, Function.identity(), (o1, o2) -> o1));
        }
        PageInfo poPageInfo = new PageInfo(poList);
        PageInfo voPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)poPageInfo, (Object)voPageInfo, (String[])new String[]{"list"});
        HashMap memberMap = memberInfoModelMap;
        Map<Object, Object> couponMap = couponPOMap;
        List voList = poList.stream().map(item -> {
            CouponQuotaSendDetailListResponseVO vo = CouponQuotaSendDetailListResponseVO.builder().sysCompanyId(item.getSysCompanyId()).sysBrandId(item.getSysBrandId()).storeName(item.getStoreName()).sysStoreOnlineCode(item.getSysStoreOnlineCode()).staffName(item.getStaffName()).staffCode(item.getStaffCode()).couponName(item.getCouponName()).couponCode(item.getCouponCode()).couponMoney(item.getMoney()).memberCode("").memberName("").memberPhone("").memberCardNo("").sendTime(item.getSendTime()).receiveTime(item.getReceiveTime()).build();
            if (reqVO.getIsReceived() == null || reqVO.getIsReceived() == 1) {
                CouponEntityPO couponEntityPO = (CouponEntityPO)couponMap.get(item.getCouponCode());
                if (couponEntityPO != null) {
                    if (couponEntityPO.getCouponStatus() != null && (couponEntityPO.getCouponStatus() == 25 || couponEntityPO.getCouponStatus() == 30)) {
                        vo.setCouponStatue(Integer.valueOf(couponEntityPO.getCouponStatus().byteValue()));
                    } else {
                        vo.setCouponStatue(Integer.valueOf(20));
                    }
                }
            } else if (reqVO.getIsReceived() == 0) {
                vo.setCouponStatue(Integer.valueOf(19));
            }
            if (!Objects.equals(item.getCouponChannelSource(), 1)) {
                vo.setIsReceived(Integer.valueOf(1));
            } else if (Objects.equals(item.getSendStatus(), 3)) {
                vo.setIsReceived(Integer.valueOf(1));
            } else {
                vo.setIsReceived(Integer.valueOf(0));
            }
            String memberCode = item.getMemberCodeList();
            if (StringUtils.isNotBlank((String)memberCode)) {
                vo.setMemberCode(memberMap.get(memberCode) == null ? "" : ((MemberInfoModel)memberMap.get(memberCode)).getMemberCode());
                vo.setMemberName(memberMap.get(memberCode) == null ? "" : ((MemberInfoModel)memberMap.get(memberCode)).getName());
                vo.setMemberPhone(memberMap.get(memberCode) == null ? "" : ((MemberInfoModel)memberMap.get(memberCode)).getPhone());
                vo.setMemberCardNo(memberMap.get(memberCode) == null ? "" : ((MemberInfoModel)memberMap.get(memberCode)).getCardNo());
            }
            return vo;
        }).collect(Collectors.toList());
        voPageInfo.setList(voList);
        responseData.setData((Object)voPageInfo);
        logger.info("[CouponQuotaSendDetailServiceImpl-pageList-output-]:{}", (Object)JacksonUtil.bean2Json((Object)responseData));
        return responseData;
    }

    public ResponseData exportSendCouponList(CouponQuotaSendDetailListRequestVO reqVO, SysAccountPO sysAccountPO) {
        ResponseData responseData = new ResponseData();
        try {
            List staffCodeList;
            String onlineOrgCodes = reqVO.getOnlineOrgCodes();
            Long sysCompanyId = reqVO.getSysCompanyId();
            CouponQuotaSendDetailPOExample example = new CouponQuotaSendDetailPOExample();
            CouponQuotaSendDetailPOExample.Criteria criteria = this.getCriteria(reqVO, example);
            List sysStoreOnlineCodeList = Lists.newArrayList();
            if (StringUtils.isNotBlank((String)reqVO.getSelectedStoreKey())) {
                sysStoreOnlineCodeList = this.listStoreCode(reqVO.getSelectedStoreKey(), sysCompanyId);
            }
            if (StringUtils.isNotBlank((String)onlineOrgCodes)) {
                List orgSysStoreOnlineCodeList = this.listSysStoreOnlineCode(onlineOrgCodes, sysCompanyId, sysCompanyId);
                if (CollectionUtils.isNotEmpty((Collection)sysStoreOnlineCodeList)) {
                    List interStoreCodeList = sysStoreOnlineCodeList.stream().filter(orgSysStoreOnlineCodeList::contains).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(interStoreCodeList)) {
                        return ResponseUtil.success();
                    }
                    criteria.andSysStoreOnlineCodeIn(interStoreCodeList);
                } else {
                    criteria.andSysStoreOnlineCodeIn(orgSysStoreOnlineCodeList);
                }
            } else if (CollectionUtils.isNotEmpty((Collection)sysStoreOnlineCodeList)) {
                criteria.andSysStoreOnlineCodeIn(sysStoreOnlineCodeList);
            }
            if (StringUtils.isNotBlank((String)reqVO.getSelectedStaffKey()) && CollectionUtils.isNotEmpty((Collection)(staffCodeList = this.listStaffCode(reqVO.getSelectedStaffKey(), sysCompanyId)))) {
                criteria.andStaffCodeIn(staffCodeList);
            }
            int count = this.couponQuotaSendDetailPOMapper.countByExample(example);
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = new FileTaskPo();
            fileTaskPo.setTaskId(taskId);
            fileTaskPo.setFileId(String.valueOf(taskId));
            fileTaskPo.setTaskTypeCode(count + "\u6761");
            fileTaskPo.setTaskName("\u4f01\u5fae\u5bfc\u8d2d\u4fa7\u8fb9\u680f\u9001\u5238\u5206\u6790\u5bfc\u51fa");
            if (sysAccountPO != null) {
                fileTaskPo.setSysBrandId(sysAccountPO.getBrandId());
                fileTaskPo.setCreateUserId(sysAccountPO.getSysAccountId());
                fileTaskPo.setCreateUserName(sysAccountPO.getName());
            }
            fileTaskPo.setCreateDate(new Date());
            fileTaskPo.setFileStatus(Long.valueOf(0L));
            fileTaskPo.setFileType("EXPORT");
            fileTaskPo.setValid(Boolean.TRUE);
            this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(count));
            new Thread(() -> {
                try {
                    exportExcelUtil.setExportProcessId((Object)taskId);
                    Method method = ReflectionUtils.findMethod(this.getClass(), (String)"exportList", (Class[])new Class[]{CouponQuotaSendDetailListRequestVO.class, Long.class, Long.class});
                    exportExcelUtil.read("couponQuotaSendDetailServiceImpl", method, (model, row) -> {
                        if (row.getRowNum() == 0) {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue("\u5e97\u94fa\u540d\u79f0");
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue("\u5e97\u94fa\u7f16\u53f7");
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue("\u5bfc\u8d2d\u7f16\u53f7");
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue("\u5bfc\u8d2d\u540d\u79f0");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue("\u4f18\u60e0\u5238\u540d\u79f0");
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue("\u5238\u9762\u989d");
                            Cell cell6 = row.createCell(6);
                            cell6.setCellValue("\u8d60\u9001\u65f6\u95f4");
                            Cell cell7 = row.createCell(7);
                            cell7.setCellValue("\u8d60\u9001\u4f1a\u5458");
                            Cell cell8 = row.createCell(8);
                            cell8.setCellValue("\u9886\u53d6\u65f6\u95f4");
                            Cell cell9 = row.createCell(9);
                            cell9.setCellValue("\u5238\u72b6\u6001");
                        } else {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue(model.getStoreName());
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue(model.getSysStoreOnlineCode());
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue(model.getStaffCode());
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue(model.getStaffName());
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue(model.getCouponName());
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue(model.getCouponMoney() == null ? "" : String.valueOf(model.getCouponMoney()));
                            Cell cell6 = row.createCell(6);
                            cell6.setCellValue(model.getSendTime() == null ? "" : DateUtils.dateFormatTime((Date)model.getSendTime()));
                            Cell cell7 = row.createCell(7);
                            cell7.setCellValue(model.getMemberName());
                            Cell cell8 = row.createCell(8);
                            cell8.setCellValue(model.getReceiveTime() == null ? "" : DateUtils.dateFormatTime((Date)model.getReceiveTime()));
                            Cell cell9 = row.createCell(9);
                            String couponStatusDesc = "";
                            if (model.getCouponStatue() != null) {
                                if (model.getCouponStatue() == 19) {
                                    couponStatusDesc = "\u5f85\u9886\u53d6";
                                } else if (model.getCouponStatue() == 20) {
                                    couponStatusDesc = "\u5f85\u4f7f\u7528";
                                } else if (model.getCouponStatue() == 25) {
                                    couponStatusDesc = "\u5df2\u8fc7\u671f";
                                } else if (model.getCouponStatue() == 30) {
                                    couponStatusDesc = "\u5df2\u6838\u9500";
                                }
                            }
                            cell9.setCellValue(couponStatusDesc);
                        }
                    }, new Object[]{reqVO});
                }
                catch (Exception e) {
                    logger.info("[CouponQuotaSendDetailServiceImpl-exportSendCouponList-error-] thread exception:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }).start();
            new Thread(() -> {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)("\u4f01\u5fae\u5bfc\u8d2d\u4fa7\u8fb9\u680f\u9001\u5238\u5206\u6790\u5bfc\u51fa_" + format.format(new Date())));
            }).start();
        }
        catch (Exception e) {
            logger.info("[CouponQuotaSendDetailServiceImpl-exportSendCouponList-error-] export exception:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData<PageInfo<StaffSendCouponListResponseVO>> pageListByStaffCode(StaffSendCouponListRequestVO reqVO) {
        ResponseData staffPoRes;
        logger.info("[CouponQuotaSendDetailPOMapper-pageListByStaffCode-input-]:{}", (Object)JacksonUtil.bean2Json((Object)reqVO));
        ResponseData responseData = new ResponseData();
        Long sysCompanyId = reqVO.getSysCompanyId();
        Long sysBrandId = reqVO.getSysBrandId();
        String staffCode = reqVO.getStaffCode();
        CouponQuotaSendDetailPOExample example = new CouponQuotaSendDetailPOExample();
        CouponQuotaSendDetailPOExample.Criteria criteria = example.createCriteria().andValidEqualTo(Boolean.TRUE);
        if (reqVO.getSysCompanyId() != null) {
            criteria.andSysCompanyIdEqualTo(sysCompanyId);
        }
        if (reqVO.getSysBrandId() != null) {
            criteria.andSysBrandIdEqualTo(sysBrandId);
        }
        if (reqVO.getCouponChannelSource() != null) {
            criteria.andCouponChannelSourceEqualTo(reqVO.getCouponChannelSource());
        }
        if (StringUtils.isNotBlank((String)reqVO.getStaffCode())) {
            criteria.andStaffCodeEqualTo(staffCode);
        }
        if (reqVO.getIsReceived() == null || reqVO.getIsReceived() == 1) {
            criteria.andSendStatusEqualTo(Integer.valueOf(3));
            example.setOrderByClause("receive_time DESC");
        } else {
            criteria.andSendStatusEqualTo(Integer.valueOf(2));
            example.setOrderByClause("send_time DESC");
        }
        PageHelper.startPage((int)reqVO.getPageNo(), (int)reqVO.getPageSize());
        List poList = this.couponQuotaSendDetailPOMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)poList)) {
            return ResponseUtil.success((Object)new PageInfo(new ArrayList()));
        }
        Map<Object, Object> memberInfoModelMap = new HashMap();
        List memberCodeList = poList.stream().filter(item -> StringUtils.isNotBlank((String)item.getMemberCodeList())).map(CouponQuotaSendDetailPO::getMemberCodeList).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(memberCodeList)) {
            CouponMemberPo couponMemberPo = new CouponMemberPo();
            couponMemberPo.setMemberCodeList(memberCodeList);
            couponMemberPo.setBrandId(reqVO.getSysBrandId());
            logger.info("[CouponQuotaSendDetailServiceImpl-pageListByStaffCode-info-],memberListReq:{}", (Object)JacksonUtil.bean2Json((Object)couponMemberPo));
            ResponseData memberListRes = this.memberInfoApiService.getMemberInfoByCodeList(couponMemberPo);
            logger.info("[CouponQuotaSendDetailServiceImpl-pageListByStaffCode-info-],memberListRes:{}", (Object)JacksonUtil.bean2Json((Object)memberListRes));
            if (memberListRes != null && memberListRes.getCode() == SysResponseEnum.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)memberListRes.getData()))) {
                memberInfoModelMap = ((List)memberListRes.getData()).stream().collect(Collectors.toMap(MemberInfoModel::getMemberCode, Function.identity(), (o1, o2) -> o1));
            }
        }
        List couponCodeList = poList.stream().map(CouponQuotaSendDetailPO::getCouponCode).collect(Collectors.toList());
        List couponEntityPOList = this.couponEntityPOMapper.findByCouponCodeList(couponCodeList);
        Map<Object, Object> couponPOMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)couponEntityPOList)) {
            couponPOMap = couponEntityPOList.stream().collect(Collectors.toMap(CouponEntityPO::getCouponCode, Function.identity(), (o1, o2) -> o1));
        }
        SysStaffPo sysStaffPO = (staffPoRes = this.staffServiceRpc.getStaffInfoByCode(staffCode, sysCompanyId)) != null && staffPoRes.getCode() == SysResponseEnum.SUCCESS.getCode() && staffPoRes.getData() != null ? (SysStaffPo)staffPoRes.getData() : null;
        PageInfo poPageInfo = new PageInfo(poList);
        PageInfo voPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)poPageInfo, (Object)voPageInfo, (String[])new String[]{"list"});
        Map<Object, Object> memberMap = memberInfoModelMap;
        Map<Object, Object> couponMap = couponPOMap;
        Set couponDefinitionIdList = poList.stream().map(CouponQuotaSendDetailPO::getCouponDefinitionId).collect(Collectors.toSet());
        CouponDefinitionPOExample couponDefinitionPOExample = new CouponDefinitionPOExample();
        couponDefinitionPOExample.createCriteria().andCouponDefinitionIdIn(new ArrayList(couponDefinitionIdList));
        List couponDefListByIds = this.couponDefinitionPOMapper.selectByExampleWithBLOBs(couponDefinitionPOExample);
        logger.info("[CouponQuotaSendDetailServiceImpl-pageListByStaffCode-info-],couponDefListByIds:{}", (Object)JacksonUtil.list2Json((List)couponDefListByIds));
        Map couponDefinitionMap = couponDefListByIds.stream().collect(Collectors.toMap(CouponDefinitionPO::getCouponDefinitionId, Function.identity()));
        List voList = poList.stream().map(item -> {
            StaffSendCouponListResponseVO vo = StaffSendCouponListResponseVO.builder().sysCompanyId(item.getSysCompanyId()).sysBrandId(item.getSysBrandId()).couponName(item.getCouponName()).couponMoney(item.getMoney()).sendTime(item.getSendTime()).memberCode("").memberName("").build();
            if (reqVO.getIsReceived() == null || reqVO.getIsReceived() == 1) {
                CouponEntityPO couponEntityPO = (CouponEntityPO)couponMap.get(item.getCouponCode());
                if (couponEntityPO != null) {
                    if (couponEntityPO.getCouponStatus() != null && (couponEntityPO.getCouponStatus() == 25 || couponEntityPO.getCouponStatus() == 30)) {
                        vo.setCouponStatue(Integer.valueOf(couponEntityPO.getCouponStatus().byteValue()));
                    } else {
                        vo.setCouponStatue(Integer.valueOf(20));
                    }
                }
            } else if (reqVO.getIsReceived() == 0) {
                vo.setCouponStatue(Integer.valueOf(19));
            }
            String memberCode = item.getMemberCodeList();
            if (StringUtils.isNotBlank((String)memberCode)) {
                MemberInfoModel model = (MemberInfoModel)memberMap.get(memberCode);
                if (model != null) {
                    vo.setMemberCode(memberCode);
                    String name = "";
                    if (StringUtils.isNotBlank((String)model.getMemberComment())) {
                        name = model.getMemberComment();
                    } else if (StringUtils.isNotBlank((String)model.getName())) {
                        name = model.getName();
                    } else if (StringUtils.isNotBlank((String)model.getPhone())) {
                        name = model.getPhone();
                    } else if (StringUtils.isNotBlank((String)model.getCardNo())) {
                        name = model.getCardNo();
                    }
                    vo.setMemberName(name);
                }
            } else if (StringUtils.isNotBlank((String)item.getExternalUserId())) {
                EsMbrFriendsVO friendsVo = new EsMbrFriendsVO();
                friendsVo.setSysCompanyId(sysCompanyId);
                friendsVo.setBrandId(sysBrandId);
                friendsVo.setExternalUserId(item.getExternalUserId());
                friendsVo.setGuideId(sysStaffPO != null ? sysStaffPO.getSysStaffId() : null);
                ResponseData friendRes = this.esMbrFriendsApiService.getWxQyFriendsModel(friendsVo);
                if (friendRes != null && friendRes.getCode() == SysResponseEnum.SUCCESS.getCode() && friendRes.getData() != null) {
                    vo.setEsMbrFriendsId(((EsMbrFriendsResponseVO)friendRes.getData()).getEsMbrFriendsId());
                    vo.setExternalName(((EsMbrFriendsResponseVO)friendRes.getData()).getExternalName());
                }
            }
            if (couponDefinitionMap.get(item.getCouponDefinitionId()) != null) {
                vo.setCouponDefinitionPO((CouponDefinitionPOWithBLOBs)couponDefinitionMap.get(item.getCouponDefinitionId()));
            }
            return vo;
        }).collect(Collectors.toList());
        voPageInfo.setList(voList);
        responseData.setData((Object)voPageInfo);
        logger.info("[CouponQuotaSendDetailServiceImpl-pageListByStaffCode-output-]:{}", (Object)JacksonUtil.bean2Json((Object)responseData));
        return responseData;
    }

    public ResponseData<StaffSendCouponCountResponseVO> countSendCoupon(StaffSendCouponListRequestVO reqVO) {
        logger.info("[CouponQuotaSendDetailPOMapper-countSendCoupon-input-]:{}", (Object)JacksonUtil.bean2Json((Object)reqVO));
        ResponseData responseData = new ResponseData();
        CouponQuotaSendDetailPOExample receivedExample = new CouponQuotaSendDetailPOExample();
        CouponQuotaSendDetailPOExample.Criteria receivedCriteria = this.getCriteria(reqVO, receivedExample);
        receivedCriteria.andSendStatusEqualTo(Integer.valueOf(3));
        int countReceived = this.couponQuotaSendDetailPOMapper.countByExample(receivedExample);
        CouponQuotaSendDetailPOExample unreceivedExample = new CouponQuotaSendDetailPOExample();
        CouponQuotaSendDetailPOExample.Criteria unreceivedCriteria = this.getCriteria(reqVO, unreceivedExample);
        unreceivedCriteria.andSendStatusEqualTo(Integer.valueOf(2));
        int countUnreceived = this.couponQuotaSendDetailPOMapper.countByExample(unreceivedExample);
        StaffSendCouponCountResponseVO vo = StaffSendCouponCountResponseVO.builder().countReceived(Long.valueOf(countReceived)).countUnreceived(Long.valueOf(countUnreceived)).build();
        responseData.setData((Object)vo);
        logger.info("[CouponQuotaSendDetailPOMapper-countSendCoupon-output-]:{}", (Object)JacksonUtil.bean2Json((Object)reqVO));
        return responseData;
    }

    public List<CouponQuotaSendDetailListResponseVO> exportList(CouponQuotaSendDetailListRequestVO reqVO, Long limit, Long to) {
        List staffCodeList;
        logger.info("[CouponQuotaSendDetailPOMapper-exportList-input-]:{}", (Object)JacksonUtil.bean2Json((Object)reqVO));
        String onlineOrgCodes = reqVO.getOnlineOrgCodes();
        Long sysCompanyId = reqVO.getSysCompanyId();
        CouponQuotaSendDetailPOExample example = new CouponQuotaSendDetailPOExample();
        CouponQuotaSendDetailPOExample.Criteria criteria = this.getCriteria(reqVO, example);
        List sysStoreOnlineCodeList = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)reqVO.getSelectedStoreKey())) {
            sysStoreOnlineCodeList = this.listStoreCode(reqVO.getSelectedStoreKey(), sysCompanyId);
        }
        if (StringUtils.isNotBlank((String)onlineOrgCodes)) {
            List orgSysStoreOnlineCodeList = this.listSysStoreOnlineCode(onlineOrgCodes, sysCompanyId, sysCompanyId);
            if (CollectionUtils.isNotEmpty((Collection)sysStoreOnlineCodeList)) {
                List interStoreCodeList = sysStoreOnlineCodeList.stream().filter(orgSysStoreOnlineCodeList::contains).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(interStoreCodeList)) {
                    return new ArrayList<CouponQuotaSendDetailListResponseVO>();
                }
                criteria.andSysStoreOnlineCodeIn(interStoreCodeList);
            } else {
                criteria.andSysStoreOnlineCodeIn(orgSysStoreOnlineCodeList);
            }
        } else if (CollectionUtils.isNotEmpty((Collection)sysStoreOnlineCodeList)) {
            criteria.andSysStoreOnlineCodeIn(sysStoreOnlineCodeList);
        }
        if (StringUtils.isNotBlank((String)reqVO.getSelectedStaffKey()) && CollectionUtils.isNotEmpty((Collection)(staffCodeList = this.listStaffCode(reqVO.getSelectedStaffKey(), sysCompanyId)))) {
            criteria.andStaffCodeIn(staffCodeList);
        }
        example.setOrderByClause("send_time DESC");
        List poList = this.couponQuotaSendDetailPOMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)poList)) {
            return new ArrayList<CouponQuotaSendDetailListResponseVO>();
        }
        Map<Object, Object> memberInfoModelMap = new HashMap();
        List memberCodeList = poList.stream().filter(item -> StringUtils.isNotBlank((String)item.getMemberCodeList())).map(CouponQuotaSendDetailPO::getMemberCodeList).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(memberCodeList)) {
            CouponMemberPo couponMemberPo = new CouponMemberPo();
            couponMemberPo.setMemberCodeList(memberCodeList);
            couponMemberPo.setBrandId(reqVO.getSysBrandId());
            logger.info("[CouponQuotaSendDetailServiceImpl-exportList-info-],memberListReq:{}", (Object)JacksonUtil.bean2Json((Object)couponMemberPo));
            ResponseData memberListRes = this.memberInfoApiService.getMemberInfoByCodeList(couponMemberPo);
            logger.info("[CouponQuotaSendDetailServiceImpl-exportList-info-],memberListRes:{}", (Object)JacksonUtil.bean2Json((Object)memberListRes));
            if (memberListRes != null && memberListRes.getCode() == SysResponseEnum.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)memberListRes.getData()))) {
                memberInfoModelMap = ((List)memberListRes.getData()).stream().collect(Collectors.toMap(MemberInfoModel::getMemberCode, Function.identity(), (o1, o2) -> o1));
            }
        }
        List couponCodeList = poList.stream().map(CouponQuotaSendDetailPO::getCouponCode).collect(Collectors.toList());
        List couponEntityPOList = this.couponEntityPOMapper.findByCouponCodeList(couponCodeList);
        Map<Object, Object> couponPOMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)couponEntityPOList)) {
            couponPOMap = couponEntityPOList.stream().collect(Collectors.toMap(CouponEntityPO::getCouponCode, Function.identity(), (o1, o2) -> o1));
        }
        HashMap memberMap = memberInfoModelMap;
        HashMap couponMap = couponPOMap;
        List<CouponQuotaSendDetailListResponseVO> voList = poList.stream().map(item -> {
            CouponQuotaSendDetailListResponseVO vo = CouponQuotaSendDetailListResponseVO.builder().sysCompanyId(item.getSysCompanyId()).sysBrandId(item.getSysBrandId()).storeName(item.getStoreName()).sysStoreOnlineCode(item.getSysStoreOnlineCode()).staffName(item.getStaffName()).staffCode(item.getStaffCode()).couponName(item.getCouponName()).couponCode(item.getCouponCode()).couponMoney(item.getMoney()).memberCode("").memberName("").memberPhone("").memberCardNo("").sendTime(item.getSendTime()).receiveTime(item.getReceiveTime()).build();
            if (reqVO.getIsReceived() == null || reqVO.getIsReceived() == 1) {
                CouponEntityPO couponEntityPO = (CouponEntityPO)couponMap.get(item.getCouponCode());
                if (couponEntityPO != null) {
                    if (couponEntityPO.getCouponStatus() != null && (couponEntityPO.getCouponStatus() == 25 || couponEntityPO.getCouponStatus() == 30)) {
                        vo.setCouponStatue(Integer.valueOf(couponEntityPO.getCouponStatus().byteValue()));
                    } else {
                        vo.setCouponStatue(Integer.valueOf(20));
                    }
                }
            } else if (reqVO.getIsReceived() == 0) {
                vo.setCouponStatue(Integer.valueOf(19));
            }
            String memberCode = item.getMemberCodeList();
            if (StringUtils.isNotBlank((String)memberCode)) {
                vo.setMemberCode(memberMap.get(memberCode) == null ? "" : ((MemberInfoModel)memberMap.get(memberCode)).getMemberCode());
                vo.setMemberName(memberMap.get(memberCode) == null ? "" : ((MemberInfoModel)memberMap.get(memberCode)).getName());
                vo.setMemberPhone(memberMap.get(memberCode) == null ? "" : ((MemberInfoModel)memberMap.get(memberCode)).getPhone());
                vo.setMemberCardNo(memberMap.get(memberCode) == null ? "" : ((MemberInfoModel)memberMap.get(memberCode)).getCardNo());
            }
            return vo;
        }).collect(Collectors.toList());
        logger.info("[CouponQuotaSendDetailServiceImpl-exportList-output-]:{}", (Object)JacksonUtil.bean2Json(voList));
        return voList;
    }

    private List<String> listStaffCode(String selectedStaffKey, Long sysCompanyId) {
        List staffCodeList = Lists.newArrayList();
        List staffIdList = (List)this.sysCacheServiceRpc.getSelectEdIdList(selectedStaffKey).getData();
        if (CollectionUtils.isNotEmpty((Collection)staffIdList)) {
            StaffConditionVo staffConditionVo = new StaffConditionVo();
            staffConditionVo.setSysCompanyId(sysCompanyId);
            staffConditionVo.setSysStaffIds(staffIdList);
            ResponseData staffVOResponse = this.staffServiceRpc.getEmpInfoByCondition(staffConditionVo);
            if (staffVOResponse != null && staffVOResponse.getCode() == SysResponseEnum.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)staffVOResponse.getData()))) {
                staffCodeList = ((List)staffVOResponse.getData()).stream().map(SysStaffPo::getStaffCode).collect(Collectors.toList());
            }
        }
        return staffCodeList;
    }

    private List<String> listStoreCode(String selectedStoreKey, Long sysCompanyId) {
        String sysStoreIdListStr;
        ResponseData storePOResponse;
        List storeCodeList = Lists.newArrayList();
        List sysStoredIdList = (List)this.sysCacheServiceRpc.getSelectEdIdList(selectedStoreKey).getData();
        if (CollectionUtils.isNotEmpty((Collection)sysStoredIdList) && (storePOResponse = this.storeServiceRpc.getIdStoreListsNew(sysStoreIdListStr = sysStoredIdList.stream().map(Object::toString).collect(Collectors.joining(",")))) != null && storePOResponse.getCode() == SysResponseEnum.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)storePOResponse.getData()))) {
            storeCodeList = ((List)storePOResponse.getData()).stream().map(SysStorePo::getSysStoreOnlineCode).collect(Collectors.toList());
        }
        return storeCodeList;
    }

    public List<String> listSysStoreOnlineCode(String onlineOrgCodes, Long sysCompanyId, Long sysBrandId) {
        List sysStoreOnlineCodeList = Lists.newArrayList();
        if (sysCompanyId == null || sysBrandId == null || StringUtils.isBlank((String)onlineOrgCodes)) {
            return sysStoreOnlineCodeList;
        }
        OnlineOrgStoreInfoRequestVo requestVo = new OnlineOrgStoreInfoRequestVo();
        requestVo.setSysCompanyId(sysCompanyId);
        requestVo.setBrandId(sysBrandId);
        requestVo.setOnlineOrgCode(onlineOrgCodes);
        requestVo.setPageNum(Integer.valueOf(1));
        requestVo.setPageSize(Integer.valueOf(10000));
        ResponseData result = this.sysOnlineOrgServcieRpc.getStoreListByOnlineOrgCodes(requestVo);
        logger.info("[CouponQuotaSendDetailServiceImpl-ListSysStoreIdByOnlineOrgCodes-info-],result:{}", (Object)JacksonUtil.bean2Json((Object)result));
        if (result != null && result.getCode() == SysResponseEnum.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)((com.bizvane.utils.responseinfo.PageInfo)result.getData()).getList())) {
            List storeList = ((com.bizvane.utils.responseinfo.PageInfo)result.getData()).getList();
            sysStoreOnlineCodeList = storeList.stream().map(OnlineOrgStoreInfoResponseVo::getSysStoreOnlineCode).collect(Collectors.toList());
        }
        return sysStoreOnlineCodeList;
    }

    private CouponQuotaSendDetailPOExample.Criteria getCriteria(CouponQuotaSendDetailListRequestVO reqVO, CouponQuotaSendDetailPOExample example) {
        Long sysCompanyId = reqVO.getSysCompanyId();
        Long sysBrandId = reqVO.getSysBrandId();
        CouponQuotaSendDetailPOExample.Criteria criteria = example.createCriteria().andValidEqualTo(Boolean.TRUE);
        if (reqVO.getSysCompanyId() != null) {
            criteria.andSysCompanyIdEqualTo(sysCompanyId);
        }
        if (reqVO.getSysBrandId() != null) {
            criteria.andSysBrandIdEqualTo(sysBrandId);
        }
        if (reqVO.getCouponChannelSource() != null) {
            criteria.andCouponChannelSourceEqualTo(reqVO.getCouponChannelSource());
        }
        if (StringUtils.isNotBlank((String)reqVO.getCouponName())) {
            criteria.andCouponNameLike("%" + reqVO.getCouponName() + "%");
        }
        if (reqVO.getSendTimeStart() != null) {
            criteria.andCreateDateGreaterThanOrEqualTo(reqVO.getSendTimeStart());
        }
        if (reqVO.getSendTimeEnd() != null) {
            criteria.andCreateDateLessThanOrEqualTo(reqVO.getSendTimeEnd());
        }
        if (reqVO.getIsReceived() == null || reqVO.getIsReceived() == 1) {
            criteria.andSendStatusEqualTo(Integer.valueOf(3));
        } else {
            criteria.andSendStatusEqualTo(Integer.valueOf(2));
        }
        return criteria;
    }

    private CouponQuotaSendDetailPOExample.Criteria getCriteria(StaffSendCouponListRequestVO reqVO, CouponQuotaSendDetailPOExample example) {
        Long sysCompanyId = reqVO.getSysCompanyId();
        Long sysBrandId = reqVO.getSysBrandId();
        String staffCode = reqVO.getStaffCode();
        CouponQuotaSendDetailPOExample.Criteria criteria = example.createCriteria().andValidEqualTo(Boolean.TRUE);
        if (reqVO.getSysCompanyId() != null) {
            criteria.andSysCompanyIdEqualTo(sysCompanyId);
        }
        if (reqVO.getSysBrandId() != null) {
            criteria.andSysBrandIdEqualTo(sysBrandId);
        }
        if (reqVO.getCouponChannelSource() != null) {
            criteria.andCouponChannelSourceEqualTo(reqVO.getCouponChannelSource());
        }
        if (StringUtils.isNotBlank((String)reqVO.getStaffCode())) {
            criteria.andStaffCodeEqualTo(staffCode);
        }
        return criteria;
    }
}

